import { Injectable } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import { concatMap, map } from 'rxjs';
import { API, FIXED_MODULE } from 'shared';
import { ExportJob } from './models/export-job';
import { ExportTemplate } from './models/export-template';
import { pollWhile } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class ExportConfigService {
    constructor(http) {
        this.http = http;
        this.OPTIONS_INTERVAL_SECONDS = 2;
        this.OPTIONS_TIMEOUT_SECONDS = 150; // 5 minutes
    }
    saveTemplate(template) {
        let observable$;
        if (template.uuid) {
            observable$ = this.http.put(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/' + template.uuid + '/', template);
        }
        else {
            observable$ = this.http.post(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/', template);
        }
        return observable$.pipe(map((response) => plainToInstance(ExportTemplate, response)));
    }
    runExport(template, fileName) {
        return this.http.put(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/' + template.uuid + '/trigger/', null, {
            params: {
                fileName: fileName,
                template: template.uuid || ''
            }
        }).pipe(concatMap((response) => {
            let exportJob = new ExportJob(response.export_id);
            return this.loadExportJob(exportJob.uuid)
                .pipe(pollWhile(this.OPTIONS_INTERVAL_SECONDS * 1000, (exportJob) => exportJob.status !== 'Complete' && exportJob.status !== 'Error', this.OPTIONS_TIMEOUT_SECONDS));
        }));
    }
    loadExportJob(exportJobUuid) {
        return this.http.get(API.PORTER + FIXED_MODULE.EXPORT_JOBS + '/' + exportJobUuid + '/').pipe(map((response) => plainToInstance(ExportJob, response)));
    }
    static { this.ɵfac = function ExportConfigService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ExportConfigService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ExportConfigService, factory: ExportConfigService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ExportConfigService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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