import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
export class AbstractImportFilterComponent {
    constructor() {
        this.dataChange = new EventEmitter();
        this.values = [];
        this.checkAlls = {
            include: false
        };
        this.sectionKey = '';
        this.configKey = '';
    }
    ngOnInit() {
        if (this.wizard.data.importJob && this.wizard.data.importJob.options[this.sectionKey]) {
            this.values = this.wizard.data.importJob.options[this.sectionKey][this.configKey] || [];
            this.checkAlls.include = !this.values.find((value) => !value.include);
        }
    }
    checkAllChanged(key = 'include') {
        this.values.forEach((option) => {
            option[key] = this.checkAlls[key];
        });
        this.onOptionsChange();
    }
    onOptionsChange() {
        if (!this.wizard.data.importJob) {
            return;
        }
        const includedOptions = this.values.filter((option) => option.include);
        this.checkAlls.include = includedOptions.length === this.values.length;
        this.wizard.data.importJob.options[this.sectionKey][this.configKey] = this.values;
        this.dataChange.emit();
    }
    buttonClicked(option, key = 'include') {
        option[key] = !option[key];
        this.onOptionsChange();
    }
    static { this.ɵfac = function AbstractImportFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractImportFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractImportFilterComponent, selectors: [["xf-abstract-filter-option"]], inputs: { wizard: "wizard" }, outputs: { dataChange: "dataChange" }, decls: 0, vars: 0, template: function AbstractImportFilterComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractImportFilterComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-filter-option',
                template: ''
            }]
    }], () => [], { wizard: [{
            type: Input
        }], dataChange: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractImportFilterComponent, { className: "AbstractImportFilterComponent", filePath: "src/import/abstract-import-filter.component.ts", lineNumber: 9 }); })();
//# sourceMappingURL=data:application/json;base64,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