import { Injectable } from '@angular/core';
import { catchError, forkJoin, from, map, of } from 'rxjs';
import { CheckboxField } from 'shared';
import { difference } from 'lodash-es';
import { loadRemoteModule } from '@angular-architects/native-federation';
import * as i0 from "@angular/core";
import * as i1 from "shared";
export class PortingService {
    constructor(manifestService, permissionService) {
        this.manifestService = manifestService;
        this.permissionService = permissionService;
    }
    getStatusColumn() {
        return (params) => {
            let className = params.data?.errorMessage ? 'text-danger' : (params.value === 'In progress' ? 'text-muted muted-40' : 'text-success');
            return `<i class="align-middle fa fa-circle fa-lg font-size-8px ${className}"></i>
              <span class="font-size-12px margin-left-8px muted-10">${params.value}
              ${params.data?.errorMessage ? '<i class="fa fa-duotone fa-info-circle"></i>' : ''}</span>`;
        };
    }
    getConfigs(type, localClassMap) {
        let manifests = this.manifestService.get();
        let configObservables$ = [];
        manifests.forEach((manifest) => {
            if (!manifest.views.portingConfigs) {
                return;
            }
            const flatPermissions = this.permissionService.getAllFlatPermissions();
            manifest.views.portingConfigs.forEach(config => {
                let observable$ = null;
                if (type === 'export') {
                    if (difference(config.permissions, flatPermissions).length === 0) {
                        observable$ = this.loadRemoteSection(manifest.remoteEntry, config.exportFilterComponent, localClassMap, 'AbstractExportFilterComponent').pipe(map((exportFilterComponent) => {
                            return {
                                exportFilterComponent: exportFilterComponent
                            };
                        }));
                    }
                }
                else {
                    observable$ = this.loadRemoteSection(manifest.remoteEntry, config.importFilterComponent, localClassMap, 'AbstractImportFilterComponent').pipe(map((importFilterComponent) => {
                        return {
                            importFilterComponent: importFilterComponent
                        };
                    }));
                }
                if (observable$ !== null) {
                    const portingConfigObservable$ = observable$.pipe(map((object) => {
                        let field = new CheckboxField(config.name);
                        field.viewMode = 'checkbox';
                        field.title = config.label;
                        let portingConfig = {
                            name: config.name,
                            label: config.label,
                            countLabel: config.countLabel,
                            field: field,
                            dataSource: config.dataSource,
                            service: config.service || manifest.name,
                            manifest: manifest.name,
                            ...object
                        };
                        return portingConfig;
                    }));
                    configObservables$.push(portingConfigObservable$);
                }
            });
        });
        return forkJoin(configObservables$);
    }
    loadRemoteSection(remoteEntry, className, localClassMap, type) {
        if (!remoteEntry) {
            return of(type === 'AbstractExportFilterComponent' ? localClassMap[className] : localClassMap[className]);
        }
        const options = {
            remoteEntry: remoteEntry,
            exposedModule: './' + className,
            className: className
        };
        return from(loadRemoteModule(options)).pipe(catchError((error) => {
            console.error(error, remoteEntry);
            return of({});
        }), map((exposedModules) => {
            return exposedModules[options.className];
        }));
    }
    static { this.ɵfac = function PortingService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PortingService)(i0.ɵɵinject(i1.ManifestService), i0.ɵɵinject(i1.PermissionService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PortingService, factory: PortingService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PortingService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.ManifestService }, { type: i1.PermissionService }], null); })();
//# sourceMappingURL=data:application/json;base64,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