import { Component, inject, Input } from '@angular/core';
import { NgbOffcanvas } from '@ng-bootstrap/ng-bootstrap';
import { PurgeNowComponent } from './purge-now/purge-now.component';
import { ManagePurge } from './manage-purge-model';
import { PurgeScheduleComponent } from './purge-schedule/purge-schedule.component';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
export class ManagePurgeComponent {
    constructor() {
        this.offcanvasService = inject(NgbOffcanvas);
        this.params = new ManagePurge();
    }
    ngOnInit() {
    }
    openPurgeNow() {
        this.offcanvasInstance = this.offcanvasService.open(PurgeNowComponent, {
            animation: true,
            position: 'end',
            panelClass: 'offcanvas-slide-left',
            scroll: false,
            backdrop: 'static'
        });
        this.offcanvasInstance.componentInstance.params = this.params.purgeNow;
    }
    openPurgeSchedule() {
        this.offcanvasInstance = this.offcanvasService.open(PurgeScheduleComponent, {
            animation: true,
            position: 'end',
            panelClass: 'offcanvas-slide-left',
            scroll: false,
            backdrop: 'static'
        });
        this.offcanvasInstance.componentInstance.params = this.params.schedulePurge;
        this.offcanvasInstance.componentInstance.scheduleClosed.subscribe((schedule) => {
            this.offcanvasInstance.componentInstance.scheduleMode = schedule.id ? 'edit' : 'new';
            this.offcanvasInstance.componentInstance.schedule = schedule;
        });
    }
    static { this.ɵfac = function ManagePurgeComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ManagePurgeComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ManagePurgeComponent, selectors: [["xf-manage-purge"]], inputs: { params: "params" }, decls: 11, vars: 10, consts: [["ngbDropdown", "", "container", "body", 1, "margin-right-20px", "ms-auto"], ["ngbDropdownToggle", "", "id", "playbook-purge-btn", "type", "button", 1, "dropdown-toggle", "btn", "btn-secondary", "btn-sm", 3, "title"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "mx-0", "border-0", "shadow"], ["ngbDropdownItem", "", "id", "purge-no-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false"], ["ngbDropdownItem", "", "id", "edit-schedule-btn", 1, "cursor-pointer", 3, "click"]], template: function ManagePurgeComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "button", 1);
            i0.ɵɵtext(2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "div", 2)(4, "li")(5, "a", 3);
            i0.ɵɵlistener("click", function ManagePurgeComponent_Template_a_click_5_listener() { return ctx.openPurgeNow(); });
            i0.ɵɵelement(6, "i", 4);
            i0.ɵɵtext(7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "a", 5);
            i0.ɵɵlistener("click", function ManagePurgeComponent_Template_a_click_8_listener() { return ctx.openPurgeSchedule(); });
            i0.ɵɵelement(9, "i", 4);
            i0.ɵɵtext(10);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵpropertyInterpolate("title", ctx.params.manageText);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.manageText, " ");
            i0.ɵɵadvance(4);
            i0.ɵɵclassMapInterpolate1("", ctx.params.purgeNowIcon, " margin-right-4px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.purgeNowText, " ");
            i0.ɵɵadvance(2);
            i0.ɵɵclassMapInterpolate1("", ctx.params.schedulePurgeIcon, " margin-right-4px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.schedulePurgeText, " ");
        } }, dependencies: [i1.NgbDropdown, i1.NgbDropdownToggle, i1.NgbDropdownMenu, i1.NgbDropdownItem] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ManagePurgeComponent, [{
        type: Component,
        args: [{ selector: 'xf-manage-purge', template: "<div ngbDropdown class=\"margin-right-20px ms-auto\" container=\"body\">\n    <button ngbDropdownToggle class=\"dropdown-toggle btn btn-secondary btn-sm\" id=\"playbook-purge-btn\"\n        type=\"button\" title=\"{{ params.manageText }}\">\n        {{ params.manageText }}\n    </button>\n    <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\">\n        <li>\n            <a ngbDropdownItem id=\"purge-no-btn\" (click)=\"openPurgeNow()\" class=\"cursor-pointer\">\n                <i class=\"{{ params.purgeNowIcon }} margin-right-4px\" aria-hidden=\"false\"></i> {{ params.purgeNowText }}\n            </a>\n            <a ngbDropdownItem id=\"edit-schedule-btn\" (click)=\"openPurgeSchedule()\" class=\"cursor-pointer\">\n                <i class=\"{{ params.schedulePurgeIcon }} margin-right-4px\" aria-hidden=\"false\"></i> {{ params.schedulePurgeText }}\n            </a>\n        </li>\n    </div>\n</div>\n" }]
    }], null, { params: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ManagePurgeComponent, { className: "ManagePurgeComponent", filePath: "src/manage-purge/manage-purge.component.ts", lineNumber: 12 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFuYWdlLXB1cmdlLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zY2hlZHVsZS9zcmMvbWFuYWdlLXB1cmdlL21hbmFnZS1wdXJnZS5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc2NoZWR1bGUvc3JjL21hbmFnZS1wdXJnZS9tYW5hZ2UtcHVyZ2UuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBQ2pFLE9BQU8sRUFBRSxZQUFZLEVBQW1CLE1BQU0sNEJBQTRCLENBQUM7QUFDM0UsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0saUNBQWlDLENBQUM7QUFDcEUsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLHNCQUFzQixDQUFDO0FBQ25ELE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxNQUFNLDJDQUEyQyxDQUFDOzs7QUFPbkYsTUFBTSxPQUFPLG9CQUFvQjtJQUxqQztRQU9FLHFCQUFnQixHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUMvQixXQUFNLEdBQWdCLElBQUksV0FBVyxFQUFFLENBQUM7S0FnQ2xEO0lBOUJDLFFBQVE7SUFFUixDQUFDO0lBRUQsWUFBWTtRQUNWLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixFQUFFO1lBQ3JFLFNBQVMsRUFBRSxJQUFJO1lBQ2YsUUFBUSxFQUFFLEtBQUs7WUFDZixVQUFVLEVBQUUsc0JBQXNCO1lBQ2xDLE1BQU0sRUFBRSxLQUFLO1lBQ2IsUUFBUSxFQUFFLFFBQVE7U0FDbkIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQztJQUN6RSxDQUFDO0lBRUQsaUJBQWlCO1FBQ2YsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsc0JBQXNCLEVBQUU7WUFDMUUsU0FBUyxFQUFFLElBQUk7WUFDZixRQUFRLEVBQUUsS0FBSztZQUNmLFVBQVUsRUFBRSxzQkFBc0I7WUFDbEMsTUFBTSxFQUFFLEtBQUs7WUFDYixRQUFRLEVBQUUsUUFBUTtTQUNuQixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzVFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLENBQUMsUUFBYSxFQUFDLEVBQUU7WUFDakYsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixDQUFDLFlBQVksR0FBRyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUEsQ0FBQyxDQUFDLEtBQUssQ0FBQztZQUNwRixJQUFJLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztRQUMvRCxDQUFDLENBQUMsQ0FBQTtJQUNKLENBQUM7cUhBakNVLG9CQUFvQjtvRUFBcEIsb0JBQW9CO1lDVjdCLEFBREosOEJBQW9FLGdCQUVkO1lBQzlDLFlBQ0o7WUFBQSxpQkFBUztZQUdELEFBREosQUFESiw4QkFBZ0UsU0FDeEQsV0FDcUY7WUFBaEQsNEZBQVMsa0JBQWMsSUFBQztZQUN6RCx1QkFBOEU7WUFBQyxZQUNuRjtZQUFBLGlCQUFJO1lBQ0osNEJBQStGO1lBQXJELDRGQUFTLHVCQUFtQixJQUFDO1lBQ25FLHVCQUFtRjtZQUFDLGFBQ3hGO1lBR1osQUFESSxBQURJLEFBREksaUJBQUksRUFDSCxFQUNILEVBQ0o7O1lBYmdCLGNBQStCO1lBQS9CLHdEQUErQjtZQUM3QyxjQUNKO1lBREksc0RBQ0o7WUFJZSxlQUFrRDtZQUFsRCwyRUFBa0Q7WUFBMEIsY0FDbkY7WUFEbUYsd0RBQ25GO1lBRU8sZUFBdUQ7WUFBdkQsZ0ZBQXVEO1lBQTBCLGNBQ3hGO1lBRHdGLDZEQUN4Rjs7O2lGRERDLG9CQUFvQjtjQUxoQyxTQUFTOzJCQUNFLGlCQUFpQjtnQkFPbEIsTUFBTTtrQkFBZCxLQUFLOztrRkFISyxvQkFBb0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIGluamVjdCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgTmdiT2ZmY2FudmFzLCBOZ2JPZmZjYW52YXNSZWYgfSBmcm9tICdAbmctYm9vdHN0cmFwL25nLWJvb3RzdHJhcCc7XG5pbXBvcnQgeyBQdXJnZU5vd0NvbXBvbmVudCB9IGZyb20gJy4vcHVyZ2Utbm93L3B1cmdlLW5vdy5jb21wb25lbnQnO1xuaW1wb3J0IHsgTWFuYWdlUHVyZ2UgfSBmcm9tICcuL21hbmFnZS1wdXJnZS1tb2RlbCc7XG5pbXBvcnQgeyBQdXJnZVNjaGVkdWxlQ29tcG9uZW50IH0gZnJvbSAnLi9wdXJnZS1zY2hlZHVsZS9wdXJnZS1zY2hlZHVsZS5jb21wb25lbnQnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICd4Zi1tYW5hZ2UtcHVyZ2UnLFxuICB0ZW1wbGF0ZVVybDogJy4vbWFuYWdlLXB1cmdlLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmw6ICcuL21hbmFnZS1wdXJnZS5jb21wb25lbnQuc2Nzcydcbn0pXG5leHBvcnQgY2xhc3MgTWFuYWdlUHVyZ2VDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuICBvZmZjYW52YXNJbnN0YW5jZSE6IE5nYk9mZmNhbnZhc1JlZjtcbiAgb2ZmY2FudmFzU2VydmljZSA9IGluamVjdChOZ2JPZmZjYW52YXMpO1xuICBASW5wdXQoKSBwYXJhbXM6IE1hbmFnZVB1cmdlID0gbmV3IE1hbmFnZVB1cmdlKCk7XG5cbiAgbmdPbkluaXQoKTogdm9pZCB7XG4gICAgXG4gIH0gXG5cbiAgb3BlblB1cmdlTm93KCkge1xuICAgIHRoaXMub2ZmY2FudmFzSW5zdGFuY2UgPSB0aGlzLm9mZmNhbnZhc1NlcnZpY2Uub3BlbihQdXJnZU5vd0NvbXBvbmVudCwge1xuICAgICAgYW5pbWF0aW9uOiB0cnVlLFxuICAgICAgcG9zaXRpb246ICdlbmQnLFxuICAgICAgcGFuZWxDbGFzczogJ29mZmNhbnZhcy1zbGlkZS1sZWZ0JyxcbiAgICAgIHNjcm9sbDogZmFsc2UsXG4gICAgICBiYWNrZHJvcDogJ3N0YXRpYydcbiAgICB9KTtcbiAgICB0aGlzLm9mZmNhbnZhc0luc3RhbmNlLmNvbXBvbmVudEluc3RhbmNlLnBhcmFtcyA9IHRoaXMucGFyYW1zLnB1cmdlTm93O1xuICB9XG5cbiAgb3BlblB1cmdlU2NoZWR1bGUoKXtcbiAgICB0aGlzLm9mZmNhbnZhc0luc3RhbmNlID0gdGhpcy5vZmZjYW52YXNTZXJ2aWNlLm9wZW4oUHVyZ2VTY2hlZHVsZUNvbXBvbmVudCwge1xuICAgICAgYW5pbWF0aW9uOiB0cnVlLFxuICAgICAgcG9zaXRpb246ICdlbmQnLFxuICAgICAgcGFuZWxDbGFzczogJ29mZmNhbnZhcy1zbGlkZS1sZWZ0JyxcbiAgICAgIHNjcm9sbDogZmFsc2UsXG4gICAgICBiYWNrZHJvcDogJ3N0YXRpYydcbiAgICB9KTtcbiAgICB0aGlzLm9mZmNhbnZhc0luc3RhbmNlLmNvbXBvbmVudEluc3RhbmNlLnBhcmFtcyA9IHRoaXMucGFyYW1zLnNjaGVkdWxlUHVyZ2U7XG4gICAgdGhpcy5vZmZjYW52YXNJbnN0YW5jZS5jb21wb25lbnRJbnN0YW5jZS5zY2hlZHVsZUNsb3NlZC5zdWJzY3JpYmUoKHNjaGVkdWxlOiBhbnkpPT4ge1xuICAgICAgdGhpcy5vZmZjYW52YXNJbnN0YW5jZS5jb21wb25lbnRJbnN0YW5jZS5zY2hlZHVsZU1vZGUgPSBzY2hlZHVsZS5pZCA/ICdlZGl0JzogJ25ldyc7XG4gICAgICB0aGlzLm9mZmNhbnZhc0luc3RhbmNlLmNvbXBvbmVudEluc3RhbmNlLnNjaGVkdWxlID0gc2NoZWR1bGU7XG4gICAgfSlcbiAgfVxuICBcbn1cbiIsIjxkaXYgbmdiRHJvcGRvd24gY2xhc3M9XCJtYXJnaW4tcmlnaHQtMjBweCBtcy1hdXRvXCIgY29udGFpbmVyPVwiYm9keVwiPlxuICAgIDxidXR0b24gbmdiRHJvcGRvd25Ub2dnbGUgY2xhc3M9XCJkcm9wZG93bi10b2dnbGUgYnRuIGJ0bi1zZWNvbmRhcnkgYnRuLXNtXCIgaWQ9XCJwbGF5Ym9vay1wdXJnZS1idG5cIlxuICAgICAgICB0eXBlPVwiYnV0dG9uXCIgdGl0bGU9XCJ7eyBwYXJhbXMubWFuYWdlVGV4dCB9fVwiPlxuICAgICAgICB7eyBwYXJhbXMubWFuYWdlVGV4dCB9fVxuICAgIDwvYnV0dG9uPlxuICAgIDxkaXYgbmdiRHJvcGRvd25NZW51IGNsYXNzPVwiZHJvcGRvd24tbWVudSBteC0wIGJvcmRlci0wIHNoYWRvd1wiPlxuICAgICAgICA8bGk+XG4gICAgICAgICAgICA8YSBuZ2JEcm9wZG93bkl0ZW0gaWQ9XCJwdXJnZS1uby1idG5cIiAoY2xpY2spPVwib3BlblB1cmdlTm93KClcIiBjbGFzcz1cImN1cnNvci1wb2ludGVyXCI+XG4gICAgICAgICAgICAgICAgPGkgY2xhc3M9XCJ7eyBwYXJhbXMucHVyZ2VOb3dJY29uIH19IG1hcmdpbi1yaWdodC00cHhcIiBhcmlhLWhpZGRlbj1cImZhbHNlXCI+PC9pPiB7eyBwYXJhbXMucHVyZ2VOb3dUZXh0IH19XG4gICAgICAgICAgICA8L2E+XG4gICAgICAgICAgICA8YSBuZ2JEcm9wZG93bkl0ZW0gaWQ9XCJlZGl0LXNjaGVkdWxlLWJ0blwiIChjbGljayk9XCJvcGVuUHVyZ2VTY2hlZHVsZSgpXCIgY2xhc3M9XCJjdXJzb3ItcG9pbnRlclwiPlxuICAgICAgICAgICAgICAgIDxpIGNsYXNzPVwie3sgcGFyYW1zLnNjaGVkdWxlUHVyZ2VJY29uIH19IG1hcmdpbi1yaWdodC00cHhcIiBhcmlhLWhpZGRlbj1cImZhbHNlXCI+PC9pPiB7eyBwYXJhbXMuc2NoZWR1bGVQdXJnZVRleHQgfX1cbiAgICAgICAgICAgIDwvYT5cbiAgICAgICAgPC9saT5cbiAgICA8L2Rpdj5cbjwvZGl2PlxuIl19