import { ChangeDetectionStrategy, Component, Input, ViewChildren } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import { cloneDeep, forEach, keys } from 'lodash-es';
import { map, of, switchMap, tap } from 'rxjs';
import { FIXED_MODULE, FormFieldComponent, PERMISSION, Query, Schedule, TimezoneSelectComponent } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "shared";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "@angular/common/http";
import * as i5 from "ngx-toastr";
import * as i6 from "@angular/common";
import * as i7 from "@jsverse/transloco";
function ScheduleDetailComponent_div_0_div_5_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-form-field", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.reference)("formControlName", ctx_r1.scheduleEntity.fields.reference.name)("autoFocus", true);
} }
function ScheduleDetailComponent_div_0_div_5_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 17);
    i0.ɵɵelement(1, "i", 25);
    i0.ɵɵelementStart(2, "small");
    i0.ɵɵtext(3, "The playbook referenced is inactive. The schedule will not run it until it is changed to active.");
    i0.ɵɵelementEnd()();
} }
function ScheduleDetailComponent_div_0_div_5_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "form", 9, 0);
    i0.ɵɵlistener("ngSubmit", function ScheduleDetailComponent_div_0_div_5_Template_form_ngSubmit_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelementStart(3, "div", 10)(4, "div", 11)(5, "div", 12)(6, "div", 13);
    i0.ɵɵelement(7, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(8, "div", 15);
    i0.ɵɵelement(9, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, ScheduleDetailComponent_div_0_div_5_div_10_Template, 2, 3, "div", 16)(11, ScheduleDetailComponent_div_0_div_5_Conditional_11_Template, 4, 0, "div", 17);
    i0.ɵɵelementStart(12, "div", 18)(13, "label", 19);
    i0.ɵɵtext(14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(15, "div", 20);
    i0.ɵɵelement(16, "xf-cron-editor", 21);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(17, "div", 15)(18, "label", 19);
    i0.ɵɵtext(19);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(20, "xf-timezone-select", 22);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(21, "div", 15);
    i0.ɵɵelement(22, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(23, "div", 23)(24, "div", 24);
    i0.ɵɵelement(25, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(26, "div", 24);
    i0.ɵɵelement(27, "xf-form-field", 14);
    i0.ɵɵelementEnd()()()()()()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance(6);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.name)("formControlName", ctx_r1.scheduleEntity.fields.name.name)("autoFocus", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.enabled)("formControlName", ctx_r1.scheduleEntity.fields.enabled.name)("autoFocus", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.playbookPermissions.includes(ctx_r1.permission.READ) && ctx_r1.showReference);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.showPBRefWarning ? 11 : -1);
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.labels.frequency"));
    i0.ɵɵadvance(5);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.labels.timezone"));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.exitRunningField)("formControlName", ctx_r1.scheduleEntity.fields.exit_if_running.name)("autoFocus", true);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.start_time)("formControlName", ctx_r1.scheduleEntity.fields.start_time.name)("autoFocus", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.expires)("formControlName", ctx_r1.scheduleEntity.fields.expires.name)("autoFocus", true);
} }
function ScheduleDetailComponent_div_0_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 26)(1, "div", 27)(2, "span", 28);
    i0.ɵɵtext(3, "Loading...");
    i0.ɵɵelementEnd()()();
} }
function ScheduleDetailComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 29)(1, "button", 30);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelement(2, "i", 31);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 32);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_div_7_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelement(5, "i", 33);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.save"), " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.cancel"), " ");
} }
function ScheduleDetailComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 2)(2, "h4", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 4);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, ScheduleDetailComponent_div_0_div_5_Template, 28, 20, "div", 5)(6, ScheduleDetailComponent_div_0_div_6_Template, 4, 0, "div", 6)(7, ScheduleDetailComponent_div_0_div_7_Template, 7, 2, "div", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r4 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.title"));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
} }
export class ScheduleDetailComponent {
    constructor(formBuilder, scheduleService, apiService, activeOffCanvas, timezoneService, changeDetectorRef, entityService, http, toaster, systemSettingsService, permissionService) {
        this.formBuilder = formBuilder;
        this.scheduleService = scheduleService;
        this.apiService = apiService;
        this.activeOffCanvas = activeOffCanvas;
        this.timezoneService = timezoneService;
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.http = http;
        this.toaster = toaster;
        this.systemSettingsService = systemSettingsService;
        this.permissionService = permissionService;
        this.mode = 'new';
        this.showReference = false;
        this.scheduleFormFields = {};
        this.savingSchedule = false;
        this.referenceList = [];
        this.loading = true;
        this.permission = PERMISSION;
        this.showPBRefWarning = false;
        this.excludeFormControl = [];
        this.playbookPermissions = this.permissionService.getPermission(FIXED_MODULE.PLAYBOOK);
    }
    ngOnInit() {
        if (!this.showReference) {
            this.excludeFormControl.push('reference');
        }
        this.systemSettings = this.systemSettingsService.get();
        this.entityService.build(FIXED_MODULE.SCHEDULES).pipe(switchMap((entity) => {
            this.scheduleEntity = cloneDeep(entity);
            this.exitRunningField = cloneDeep(this.scheduleEntity.fields.exit_if_running);
            this.exitRunningField.viewMode = 'checkbox';
            this.timezone = this.schedule.crontab.timezone ? this.timezoneService.getTimezoneByName(this.schedule.crontab.timezone) : undefined;
            this.timezone = this.timezone ?? this.timezoneService.getTimezoneByAbbr(this.systemSettings?.preferences.defaultTimezone || 'UTC');
            this.timezone = this.timezone ?? this.timezoneService.getTimezoneByAbbr('UTC');
            this.formGroup = this.formBuilder.group({
                crontab: [this.schedule.crontab],
                timezone: [this.timezone]
            });
            this.setFormGroupControls();
            if (this.mode === 'new') {
                this.formGroup.patchValue({
                    enabled: false,
                    reference: this.referenceData ?? null
                });
                this.loading = false;
                this.changeDetectorRef.detectChanges();
            }
            else if (this.mode === 'edit') {
                return this.loadSchedule();
            }
            return of('');
        }), tap(() => {
            this.loading = false;
            this.changeDetectorRef.detectChanges();
        }), switchMap(() => this.formGroup.valueChanges), tap((values) => {
            keys(values).forEach((key) => {
                let value = values[key];
                if (value && this.scheduleEntity.fields[key] && this.scheduleEntity.fields[key].formType === 'datetime') {
                    value = new Date(value).toISOString();
                }
                if (key === 'timezone') {
                    this.timezone = value;
                }
                else {
                    this.schedule[key] = value;
                }
            });
        })).subscribe();
        this.formGroup.valueChanges.subscribe((changes) => {
            if (changes.reference) {
                this.showPBRefWarning = !changes.reference.isActive;
                this.changeDetectorRef.detectChanges();
            }
        });
    }
    setFormGroupControls() {
        forEach(this.scheduleEntity.fields, (field) => {
            if (field.isFormField && this.excludeFormControl.indexOf(field.name) === -1) {
                let fieldCtrl = new FormControl(this.schedule[field.name] || null);
                if (field.validation.required) {
                    fieldCtrl.addValidators(Validators.required);
                }
                this.formGroup.addControl(field.name, fieldCtrl);
            }
        });
    }
    loadSchedule() {
        this.formGroup.patchValue({
            name: this.schedule.name,
            enabled: this.schedule.enabled,
            timezone: this.timezoneService.getTimezoneByName(this.schedule.kwargs.timezone),
            exit_if_running: this.schedule.kwargs.exit_if_running ?? false,
            start_time: Date.parse(this.schedule.start_time) ?? null,
            expires: Date.parse(this.schedule.expires) ?? null,
            crontab: this.schedule.crontab
        });
        if (!this.schedule.kwargs.wf_iri || !this.showReference) {
            return of(null);
        }
        return this.entityService.build(FIXED_MODULE.PLAYBOOK).pipe(switchMap((playbookEntity) => {
            const playbookUuid = this.schedule.kwargs.wf_iri.split('/')[4];
            const query = plainToInstance(Query, {
                filters: [{
                        field: 'uuid',
                        operator: 'eq',
                        value: playbookUuid
                    }]
            });
            return this.apiService.query(playbookEntity, query.getQueryObject(), {}, true).pipe(map((playbookResponse) => {
                if (playbookResponse['hydra:totalItems'] === 0) {
                    console.warn('Playbook not found (' + this.schedule.kwargs.wf_iri + ')');
                    return null;
                }
                return playbookResponse['hydra:member'][0];
            }), map((playbook) => {
                this.formGroup.patchValue({
                    reference: playbook
                });
            }));
        }));
    }
    save() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            for (let formField of [...this.timezoneSelectComponents, ...this.formFieldComponents]) {
                if (!formField.valid) {
                    formField.focus();
                    break;
                }
            }
            return;
        }
        this.savingSchedule = true;
        this.schedule.crontab.timezone = this.timezone?.value || '';
        let observable$;
        let toasterSuccessMessage; // i18n?
        this.schedule.crontab.hour = this.schedule.crontab.hour.toString();
        this.schedule.crontab.minute = this.schedule.crontab.minute.toString();
        let schedule = plainToInstance(Schedule, this.schedule);
        schedule.id = this.schedule.id;
        schedule.kwargs = this.schedule.kwargs;
        schedule.kwargs.exit_if_running = this.schedule.exit_if_running;
        schedule.kwargs.timezone = this.schedule.crontab.timezone;
        schedule.crontab = this.schedule.crontab;
        schedule.kwargs.utcOffset = this.timezone?.utcOffset;
        schedule.enabled = this.formGroup.value.enabled;
        if (this.schedule.reference && this.schedule.reference['@id']) {
            schedule.kwargs.wf_iri = this.schedule.reference['@id'];
        }
        if (this.mode === 'new') {
            observable$ = this.scheduleService.create(schedule);
            toasterSuccessMessage = 'Schedule Created';
        }
        else if (this.mode === 'edit') {
            // TODO : Is there a better way to do this
            observable$ = this.scheduleService.update(schedule);
            toasterSuccessMessage = 'Schedule Updated';
        }
        observable$.subscribe({
            next: ((response) => {
                this.toaster.success(toasterSuccessMessage, 'Success');
                this.activeOffCanvas.close(response);
            })
        });
    }
    cancel() {
        this.activeOffCanvas.close();
    }
    static { this.ɵfac = function ScheduleDetailComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleDetailComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2.ScheduleService), i0.ɵɵdirectiveInject(i2.ApiService), i0.ɵɵdirectiveInject(i3.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.TimezoneService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.EntityService), i0.ɵɵdirectiveInject(i4.HttpClient), i0.ɵɵdirectiveInject(i5.ToastrService), i0.ɵɵdirectiveInject(i2.SystemSettingsService), i0.ɵɵdirectiveInject(i2.PermissionService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ScheduleDetailComponent, selectors: [["xf-schedule-detail"]], viewQuery: function ScheduleDetailComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(TimezoneSelectComponent, 5);
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.timezoneSelectComponents = _t);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFieldComponents = _t);
        } }, inputs: { mode: "mode", schedule: "schedule", showReference: "showReference", referenceData: "referenceData" }, decls: 1, vars: 0, consts: [["addScheduleForm", "ngForm"], [4, "transloco"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "id", "close-btn", 1, "btn", "btn-close", 3, "click"], ["class", "modal-body", 4, "ngIf"], ["class", "d-flex justify-content-center align-items-center", 4, "ngIf"], ["class", "modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px", 4, "ngIf"], [1, "modal-body"], [1, "padding-top-20px", "padding-bottom-20px", 3, "ngSubmit", "formGroup"], [1, "row", "m-0"], [1, "col-md-12"], [1, "form-group"], [1, "margin-bottom-8px"], ["fieldClass", "form-control-sm margin-bottom-8px w-100", 3, "field", "formControlName", "autoFocus"], [1, "margin-bottom-12px"], [4, "ngIf"], [1, "text-warning", "content-font", "fw-medium", "line-height-15px", "margin-top-8px"], [1, "margin-bottom-12px", "margin-top-12px"], [1, "form-label", "mb-1"], [1, "mb-2"], ["formControlName", "crontab"], ["formControlName", "timezone"], [1, "margin-bottom-12px", "d-flex"], [1, "col-md-6"], [1, "fa", "fa-warning", "fa-regular", "margin-right-4px"], [1, "d-flex", "justify-content-center", "align-items-center"], ["role", "status", 1, "spinner-border"], [1, "visually-hidden"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-right-8px", 3, "click"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"]], template: function ScheduleDetailComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ScheduleDetailComponent_div_0_Template, 8, 4, "div", 1);
        } }, dependencies: [i6.NgIf, i1.ɵNgNoValidate, i1.NgControlStatus, i1.NgControlStatusGroup, i2.FormFieldComponent, i1.FormGroupDirective, i1.FormControlName, i2.CronEditorComponent, i2.TimezoneSelectComponent, i7.TranslocoDirective], styles: [".close-btn[_ngcontent-%COMP%]{left:-50px;position:absolute}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleDetailComponent, [{
        type: Component,
        args: [{ selector: 'xf-schedule-detail', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div *transloco=\"let t\">\n<!-- Header -->\n<div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n  <h4 class=\"page-title-font modal-title muted-10\">{{ t('components.schedule.title') }}</h4>\n  <button type=\"button\" id=\"close-btn\" (click)=\"cancel()\" class=\"btn btn-close\"></button>\n\n</div>\n<!-- Body -->\n<div *ngIf=\"!loading\" class=\"modal-body\">\n  <form #addScheduleForm=\"ngForm\" (ngSubmit)=\"save()\" [formGroup]=\"formGroup\" class=\"padding-top-20px padding-bottom-20px\">\n    <div class=\"row m-0\">\n      <div class=\"col-md-12\">\n        <div class=\"form-group\">\n          <div class=\"margin-bottom-8px\">\n            <xf-form-field [field]=\"scheduleEntity.fields.name\"\n              [formControlName]=\"scheduleEntity.fields.name.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <xf-form-field [field]=\"scheduleEntity.fields.enabled\"\n              [formControlName]=\"scheduleEntity.fields.enabled.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div *ngIf=\"playbookPermissions.includes(permission.READ) && showReference\">\n            <xf-form-field [field]=\"scheduleEntity.fields.reference\"\n              [formControlName]=\"scheduleEntity.fields.reference.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          @if (showPBRefWarning) {\n            <div class=\"text-warning content-font fw-medium line-height-15px margin-top-8px\">\n              <i class=\"fa fa-warning fa-regular margin-right-4px\"></i>\n              <small>The playbook referenced is inactive. The schedule will not run it until it is changed to active.</small>\n            </div>\n          }\n          <div class=\"margin-bottom-12px margin-top-12px\">\n            <label class=\"form-label mb-1\">{{ t('components.schedule.labels.frequency') }}</label>\n            <div class=\"mb-2\">\n              <xf-cron-editor formControlName=\"crontab\"></xf-cron-editor>\n            </div>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <label class=\"form-label mb-1\">{{ t('components.schedule.labels.timezone') }}</label>\n            <xf-timezone-select formControlName=\"timezone\"></xf-timezone-select>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <xf-form-field [field]=\"exitRunningField\"\n              [formControlName]=\"scheduleEntity.fields.exit_if_running.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div class=\"margin-bottom-12px d-flex\">\n            <div class=\"col-md-6\">\n              <xf-form-field [field]=\"scheduleEntity.fields.start_time\"\n                [formControlName]=\"scheduleEntity.fields.start_time.name\"\n                fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n\n            </div>\n            <div class=\"col-md-6\">\n              <xf-form-field [field]=\"scheduleEntity.fields.expires\"\n                [formControlName]=\"scheduleEntity.fields.expires.name\"\n                fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </form>\n</div>\n<div class=\"d-flex justify-content-center align-items-center\" *ngIf=\"loading\">\n  <div class=\"spinner-border\" role=\"status\">\n    <span class=\"visually-hidden\">Loading...</span>\n  </div>\n</div>\n<!-- Footer -->\n<div *ngIf=\"!loading\" class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n  <button type=\"button\" class=\"btn btn-primary btn-sm margin-right-8px\" (click)=\"save()\">\n    <i class=\"fa fa-check margin-right-4px\"></i>{{ t('buttons.save') }}\n  </button>\n  <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" (click)=\"cancel()\">\n    <i class=\"fa fa-times margin-right-4px\"></i>{{ t('buttons.cancel') }}\n  </button>\n</div>\n</div>\n", styles: [".close-btn{left:-50px;position:absolute}\n"] }]
    }], () => [{ type: i1.FormBuilder }, { type: i2.ScheduleService }, { type: i2.ApiService }, { type: i3.NgbActiveOffcanvas }, { type: i2.TimezoneService }, { type: i0.ChangeDetectorRef }, { type: i2.EntityService }, { type: i4.HttpClient }, { type: i5.ToastrService }, { type: i2.SystemSettingsService }, { type: i2.PermissionService }], { mode: [{
            type: Input
        }], schedule: [{
            type: Input
        }], showReference: [{
            type: Input
        }], referenceData: [{
            type: Input
        }], timezoneSelectComponents: [{
            type: ViewChildren,
            args: [TimezoneSelectComponent]
        }], formFieldComponents: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ScheduleDetailComponent, { className: "ScheduleDetailComponent", filePath: "src/schedule-detail/schedule-detail.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZWR1bGUtZGV0YWlsLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zY2hlZHVsZS9zcmMvc2NoZWR1bGUtZGV0YWlsL3NjaGVkdWxlLWRldGFpbC5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc2NoZWR1bGUvc3JjL3NjaGVkdWxlLWRldGFpbC9zY2hlZHVsZS1kZXRhaWwuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxFQUFFLHVCQUF1QixFQUFxQixTQUFTLEVBQUUsS0FBSyxFQUFxQixZQUFZLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDOUgsT0FBTyxFQUFlLFdBQVcsRUFBYSxVQUFVLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUVqRixPQUFPLEVBQUUsZUFBZSxFQUFFLE1BQU0sbUJBQW1CLENBQUM7QUFDcEQsT0FBTyxFQUFFLFNBQVMsRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBRXJELE9BQU8sRUFBMEIsR0FBRyxFQUFFLEVBQUUsRUFBRSxTQUFTLEVBQUUsR0FBRyxFQUFFLE1BQU0sTUFBTSxDQUFDO0FBQ3ZFLE9BQU8sRUFBcUMsWUFBWSxFQUFTLGtCQUFrQixFQUFnQyxVQUFVLEVBQXFCLEtBQUssRUFBRSxRQUFRLEVBQW9FLHVCQUF1QixFQUFnQyxNQUFNLFFBQVEsQ0FBQzs7Ozs7Ozs7OztJQ2VqUywyQkFBNEU7SUFDMUUsb0NBRTBGO0lBQzVGLGlCQUFNOzs7SUFIVyxjQUF5QztJQUVELEFBRHJELEFBRGEsOERBQXlDLGdFQUNFLG1CQUNlOzs7SUFHekUsK0JBQWlGO0lBQy9FLHdCQUF5RDtJQUN6RCw2QkFBTztJQUFBLGdIQUFnRztJQUN6RyxBQUR5RyxpQkFBUSxFQUMzRzs7OztJQXZCaEIsQUFERiw4QkFBeUMsaUJBQ2tGO0lBQXpGLDhMQUFZLGFBQU0sS0FBQztJQUkzQyxBQURGLEFBREYsQUFERiwrQkFBcUIsY0FDSSxjQUNHLGNBQ1M7SUFDN0Isb0NBRTBGO0lBQzVGLGlCQUFNO0lBQ04sK0JBQWdDO0lBQzlCLG9DQUUwRjtJQUM1RixpQkFBTTtJQU1OLEFBTEEsdUZBQTRFLGtGQUtwRDtJQU90QixBQURGLGdDQUFnRCxpQkFDZjtJQUFBLGFBQStDO0lBQUEsaUJBQVE7SUFDdEYsZ0NBQWtCO0lBQ2hCLHNDQUEyRDtJQUUvRCxBQURFLGlCQUFNLEVBQ0Y7SUFFSixBQURGLGdDQUFnQyxpQkFDQztJQUFBLGFBQThDO0lBQUEsaUJBQVE7SUFDckYsMENBQW9FO0lBQ3RFLGlCQUFNO0lBQ04sZ0NBQWdDO0lBQzlCLHFDQUUwRjtJQUM1RixpQkFBTTtJQUVKLEFBREYsZ0NBQXVDLGVBQ2Y7SUFDcEIscUNBRTBGO0lBRTVGLGlCQUFNO0lBQ04sZ0NBQXNCO0lBQ3BCLHFDQUUwRjtJQU94RyxBQURFLEFBREUsQUFERSxBQURFLEFBREUsQUFERSxpQkFBTSxFQUNGLEVBQ0YsRUFDRixFQUNGLEVBQ0QsRUFDSDs7OztJQXpEZ0QsY0FBdUI7SUFBdkIsNENBQXVCO0lBS2xELGVBQW9DO0lBRUksQUFEckQsQUFEYSx5REFBb0MsMkRBQ0UsbUJBQ29CO0lBRzFELGVBQXVDO0lBRUMsQUFEckQsQUFEYSw0REFBdUMsOERBQ0UsbUJBQ2lCO0lBRXJFLGNBQW9FO0lBQXBFLDBHQUFvRTtJQUsxRSxjQUtDO0lBTEQsbURBS0M7SUFFZ0MsZUFBK0M7SUFBL0Msa0VBQStDO0lBTS9DLGVBQThDO0lBQTlDLGlFQUE4QztJQUk5RCxlQUEwQjtJQUVjLEFBRHJELEFBRGEsK0NBQTBCLHNFQUN1QixtQkFDUztJQUl4RCxlQUEwQztJQUVGLEFBRHJELEFBRGEsK0RBQTBDLGlFQUNFLG1CQUNjO0lBSTFELGVBQXVDO0lBRUMsQUFEckQsQUFEYSw0REFBdUMsOERBQ0UsbUJBQ2lCOzs7SUFVbkYsQUFERixBQURGLCtCQUE4RSxjQUNsQyxlQUNWO0lBQUEsMEJBQVU7SUFFNUMsQUFERSxBQUQwQyxpQkFBTyxFQUMzQyxFQUNGOzs7O0lBR0osQUFERiwrQkFBbUgsaUJBQzFCO0lBQWpCLDBMQUFTLGFBQU0sS0FBQztJQUNwRix3QkFBNEM7SUFBQSxZQUM5QztJQUFBLGlCQUFTO0lBQ1Qsa0NBQStFO0lBQW5CLDBMQUFTLGVBQVEsS0FBQztJQUM1RSx3QkFBNEM7SUFBQSxZQUM5QztJQUNGLEFBREUsaUJBQVMsRUFDTDs7O0lBTDBDLGVBQzlDO0lBRDhDLG9EQUM5QztJQUU4QyxlQUM5QztJQUQ4QyxzREFDOUM7Ozs7SUE1RUEsQUFERixBQUZBLDJCQUF3QixhQUUyRixZQUNoRTtJQUFBLFlBQW9DO0lBQUEsaUJBQUs7SUFDMUYsaUNBQThFO0lBQXpDLG1MQUFTLGVBQVEsS0FBQztJQUV6RCxBQUZnRixpQkFBUyxFQUVuRjtJQW1FTixBQU5BLEFBM0RBLGdGQUF5QyxpRUEyRHFDLGlFQU1xQztJQVFuSCxpQkFBTTs7OztJQTlFNkMsZUFBb0M7SUFBcEMsdURBQW9DO0lBS2pGLGVBQWM7SUFBZCxzQ0FBYztJQTJEMkMsY0FBYTtJQUFiLHFDQUFhO0lBTXRFLGNBQWM7SUFBZCxzQ0FBYzs7QUR6RHBCLE1BQU0sT0FBTyx1QkFBdUI7SUF1QmxDLFlBQ1UsV0FBd0IsRUFDeEIsZUFBZ0MsRUFDaEMsVUFBc0IsRUFDdkIsZUFBbUMsRUFDbEMsZUFBZ0MsRUFDaEMsaUJBQW9DLEVBQ3BDLGFBQTRCLEVBQzVCLElBQWdCLEVBQ2hCLE9BQXNCLEVBQ3RCLHFCQUE0QyxFQUM1QyxpQkFBb0M7UUFWcEMsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFDeEIsb0JBQWUsR0FBZixlQUFlLENBQWlCO1FBQ2hDLGVBQVUsR0FBVixVQUFVLENBQVk7UUFDdkIsb0JBQWUsR0FBZixlQUFlLENBQW9CO1FBQ2xDLG9CQUFlLEdBQWYsZUFBZSxDQUFpQjtRQUNoQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQW1CO1FBQ3BDLGtCQUFhLEdBQWIsYUFBYSxDQUFlO1FBQzVCLFNBQUksR0FBSixJQUFJLENBQVk7UUFDaEIsWUFBTyxHQUFQLE9BQU8sQ0FBZTtRQUN0QiwwQkFBcUIsR0FBckIscUJBQXFCLENBQXVCO1FBQzVDLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBbUI7UUFqQ3JDLFNBQUksR0FBbUIsS0FBSyxDQUFDO1FBRTdCLGtCQUFhLEdBQVksS0FBSyxDQUFDO1FBT3hDLHVCQUFrQixHQUFRLEVBQUUsQ0FBQztRQUM3QixtQkFBYyxHQUFZLEtBQUssQ0FBQztRQUNoQyxrQkFBYSxHQUFlLEVBQUUsQ0FBQztRQUcvQixZQUFPLEdBQVksSUFBSSxDQUFDO1FBRXhCLGVBQVUsR0FBRyxVQUFVLENBQUM7UUFFeEIscUJBQWdCLEdBQVksS0FBSyxDQUFDO1FBRWxDLHVCQUFrQixHQUFhLEVBQUUsQ0FBQztRQWVoQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDekYsQ0FBQztJQUVELFFBQVE7UUFDTixJQUFHLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDNUMsQ0FBQztRQUNELElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQ3ZELElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQyxJQUFJLENBQ25ELFNBQVMsQ0FBQyxDQUFDLE1BQWMsRUFBRSxFQUFFO1lBQzNCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1lBQ3hDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUM7WUFDOUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFFBQVEsR0FBRyxVQUFVLENBQUM7WUFFNUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztZQUNwSSxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLGVBQWUsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsY0FBYyxFQUFFLFdBQVcsQ0FBQyxlQUFlLElBQUksS0FBSyxDQUFDLENBQUM7WUFDbkksSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLENBQUM7WUFFL0UsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQztnQkFDdEMsT0FBTyxFQUFFLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUM7Z0JBQ2hDLFFBQVEsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7YUFDMUIsQ0FBQyxDQUFDO1lBQ0gsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7WUFFNUIsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLEtBQUssRUFBRSxDQUFDO2dCQUN4QixJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQztvQkFDeEIsT0FBTyxFQUFFLEtBQUs7b0JBQ2QsU0FBUyxFQUFFLElBQUksQ0FBQyxhQUFhLElBQUksSUFBSTtpQkFDdEMsQ0FBQyxDQUFDO2dCQUNILElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO2dCQUNyQixJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7WUFDekMsQ0FBQztpQkFBTSxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssTUFBTSxFQUFFLENBQUM7Z0JBQ2hDLE9BQU8sSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1lBQzdCLENBQUM7WUFDRCxPQUFPLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUNoQixDQUFDLENBQUMsRUFDRixHQUFHLENBQUMsR0FBRyxFQUFFO1lBQ1AsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDckIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3pDLENBQUMsQ0FBQyxFQUNGLFNBQVMsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFlBQVksQ0FBQyxFQUM1QyxHQUFHLENBQUMsQ0FBQyxNQUEyQixFQUFFLEVBQUU7WUFDbEMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLEdBQVcsRUFBRSxFQUFFO2dCQUNuQyxJQUFJLEtBQUssR0FBRyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ3hCLElBQUksS0FBSyxJQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFFBQVEsS0FBSyxVQUFVLEVBQUUsQ0FBQztvQkFDeEcsS0FBSyxHQUFHLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLFdBQVcsRUFBRSxDQUFBO2dCQUN2QyxDQUFDO2dCQUNELElBQUksR0FBRyxLQUFLLFVBQVUsRUFBRSxDQUFDO29CQUN2QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztnQkFDeEIsQ0FBQztxQkFBTSxDQUFDO29CQUNOLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEdBQUcsS0FBSyxDQUFDO2dCQUM3QixDQUFDO1lBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDLENBQUMsQ0FDSCxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBRWQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUMsT0FBWSxFQUFFLEVBQUU7WUFDckQsSUFBSSxPQUFPLENBQUMsU0FBUyxFQUFFLENBQUM7Z0JBQ3RCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDO2dCQUNwRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7WUFDekMsQ0FBQztRQUNILENBQUMsQ0FBQyxDQUFBO0lBQ0osQ0FBQztJQUVPLG9CQUFvQjtRQUMxQixPQUFPLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxLQUFZLEVBQUUsRUFBRTtZQUNuRCxJQUFJLEtBQUssQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQztnQkFDNUUsSUFBSSxTQUFTLEdBQUcsSUFBSSxXQUFXLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLENBQUM7Z0JBQ25FLElBQUksS0FBSyxDQUFDLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztvQkFDOUIsU0FBUyxDQUFDLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUM7Z0JBQy9DLENBQUM7Z0JBQ0QsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxTQUFTLENBQUMsQ0FBQztZQUNuRCxDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8sWUFBWTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQztZQUN4QixJQUFJLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJO1lBQ3hCLE9BQU8sRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU87WUFDOUIsUUFBUSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDO1lBQy9FLGVBQWUsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxlQUFlLElBQUksS0FBSztZQUM5RCxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxJQUFJLElBQUk7WUFDeEQsT0FBTyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJO1lBQ2xELE9BQU8sRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU87U0FDL0IsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztZQUN4RCxPQUFPLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNsQixDQUFDO1FBQ0QsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUMsSUFBSSxDQUN6RCxTQUFTLENBQUMsQ0FBQyxjQUFzQixFQUFFLEVBQUU7WUFDbkMsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUMvRCxNQUFNLEtBQUssR0FBRyxlQUFlLENBQUMsS0FBSyxFQUFFO2dCQUNuQyxPQUFPLEVBQUUsQ0FBQzt3QkFDUixLQUFLLEVBQUUsTUFBTTt3QkFDYixRQUFRLEVBQUUsSUFBSTt3QkFDZCxLQUFLLEVBQUUsWUFBWTtxQkFDcEIsQ0FBQzthQUNILENBQUMsQ0FBQztZQUNILE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUNqRixHQUFHLENBQUMsQ0FBQyxnQkFBK0IsRUFBRSxFQUFFO2dCQUN0QyxJQUFJLGdCQUFnQixDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7b0JBQy9DLE9BQU8sQ0FBQyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsTUFBTSxHQUFHLEdBQUcsQ0FBQyxDQUFDO29CQUN6RSxPQUFPLElBQUksQ0FBQztnQkFDZCxDQUFDO2dCQUNELE9BQU8sZ0JBQWdCLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDN0MsQ0FBQyxDQUFDLEVBQ0YsR0FBRyxDQUFDLENBQUMsUUFBYSxFQUFFLEVBQUU7Z0JBQ3BCLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDO29CQUN4QixTQUFTLEVBQUUsUUFBUTtpQkFDcEIsQ0FBQyxDQUFDO1lBQ0wsQ0FBQyxDQUFDLENBQ0gsQ0FBQztRQUNKLENBQUMsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDO0lBRUQsSUFBSTtRQUNGLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUMzQixJQUFJLENBQUMsU0FBUyxDQUFDLGdCQUFnQixFQUFFLENBQUM7WUFDbEMsS0FBSyxJQUFJLFNBQVMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixFQUFFLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEVBQUUsQ0FBQztnQkFDdEYsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsQ0FBQztvQkFDckIsU0FBUyxDQUFDLEtBQUssRUFBRSxDQUFDO29CQUNsQixNQUFNO2dCQUNSLENBQUM7WUFDSCxDQUFDO1lBQ0QsT0FBTztRQUNULENBQUM7UUFDRCxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQztRQUMzQixJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsRUFBRSxLQUFLLElBQUksRUFBRSxDQUFDO1FBQzVELElBQUksV0FBNkIsQ0FBQztRQUNsQyxJQUFJLHFCQUF5QyxDQUFDLENBQUMsUUFBUTtRQUN2RCxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ25FLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDdkUsSUFBSSxRQUFRLEdBQUcsZUFBZSxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBa0IsQ0FBQyxDQUFDO1FBQ2xFLFFBQVEsQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUM7UUFDL0IsUUFBUSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQztRQUN2QyxRQUFRLENBQUMsTUFBTSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQztRQUNoRSxRQUFRLENBQUMsTUFBTSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUM7UUFDMUQsUUFBUSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQztRQUN6QyxRQUFRLENBQUMsTUFBTSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsUUFBUSxFQUFFLFNBQVMsQ0FBQztRQUNyRCxRQUFRLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUNoRCxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7WUFDOUQsUUFBUSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDMUQsQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxLQUFLLEVBQUUsQ0FBQztZQUN4QixXQUFXLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUM7WUFDcEQscUJBQXFCLEdBQUcsa0JBQWtCLENBQUM7UUFDN0MsQ0FBQzthQUFNLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxNQUFNLEVBQUUsQ0FBQztZQUNoQywwQ0FBMEM7WUFFMUMsV0FBVyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ3BELHFCQUFxQixHQUFHLGtCQUFrQixDQUFDO1FBQzdDLENBQUM7UUFFRCxXQUFXLENBQUMsU0FBUyxDQUFDO1lBQ3BCLElBQUksRUFBRSxDQUFDLENBQUMsUUFBYSxFQUFFLEVBQUU7Z0JBQ3ZCLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLHFCQUFxQixFQUFFLFNBQVMsQ0FBQyxDQUFDO2dCQUN2RCxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUN2QyxDQUFDLENBQUM7U0FDSCxDQUFDLENBQUM7SUFFTCxDQUFDO0lBRUQsTUFBTTtRQUNKLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDL0IsQ0FBQzt3SEEzTVUsdUJBQXVCO29FQUF2Qix1QkFBdUI7MkJBS3BCLHVCQUF1QjsyQkFDdkIsa0JBQWtCOzs7Ozs7WUN0QmxDLHdFQUF3Qjs7O2lGRGdCWCx1QkFBdUI7Y0FObkMsU0FBUzsyQkFDRSxvQkFBb0IsbUJBR2IsdUJBQXVCLENBQUMsTUFBTTt1VkFHdEMsSUFBSTtrQkFBWixLQUFLO1lBQ0csUUFBUTtrQkFBaEIsS0FBSztZQUNHLGFBQWE7a0JBQXJCLEtBQUs7WUFDRyxhQUFhO2tCQUFyQixLQUFLO1lBQ2lDLHdCQUF3QjtrQkFBOUQsWUFBWTttQkFBQyx1QkFBdUI7WUFDSCxtQkFBbUI7a0JBQXBELFlBQVk7bUJBQUMsa0JBQWtCOztrRkFOckIsdUJBQXVCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSHR0cENsaWVudCwgSHR0cENvbnRleHQgfSBmcm9tICdAYW5ndWxhci9jb21tb24vaHR0cCc7XG5pbXBvcnQgeyBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneSwgQ2hhbmdlRGV0ZWN0b3JSZWYsIENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCwgUXVlcnlMaXN0LCBWaWV3Q2hpbGRyZW4gfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEZvcm1CdWlsZGVyLCBGb3JtQ29udHJvbCwgRm9ybUdyb3VwLCBWYWxpZGF0b3JzIH0gZnJvbSAnQGFuZ3VsYXIvZm9ybXMnO1xuaW1wb3J0IHsgTmdiQWN0aXZlT2ZmY2FudmFzIH0gZnJvbSAnQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXAnO1xuaW1wb3J0IHsgcGxhaW5Ub0luc3RhbmNlIH0gZnJvbSAnY2xhc3MtdHJhbnNmb3JtZXInO1xuaW1wb3J0IHsgY2xvbmVEZWVwLCBmb3JFYWNoLCBrZXlzIH0gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IFRvYXN0clNlcnZpY2UgfSBmcm9tICduZ3gtdG9hc3RyJztcbmltcG9ydCB7IE9ic2VydmFibGUsIGNhdGNoRXJyb3IsIG1hcCwgb2YsIHN3aXRjaE1hcCwgdGFwIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBBcGlTZXJ2aWNlLCBFbnRpdHksIEVudGl0eVNlcnZpY2UsIEZJWEVEX01PRFVMRSwgRmllbGQsIEZvcm1GaWVsZENvbXBvbmVudCwgSHlkcmFSZXNwb25zZSwgSUdOT1JFX0VSUk9SUywgUEVSTUlTU0lPTiwgUGVybWlzc2lvblNlcnZpY2UsIFF1ZXJ5LCBTY2hlZHVsZSwgU2NoZWR1bGVTZXJ2aWNlLCBTeXN0ZW1TZXR0aW5ncywgU3lzdGVtU2V0dGluZ3NTZXJ2aWNlLCBUaW1lem9uZSwgVGltZXpvbmVTZWxlY3RDb21wb25lbnQsIFRpbWV6b25lU2VydmljZSwgVGltZXpvbmVVVEMgfSBmcm9tICdzaGFyZWQnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICd4Zi1zY2hlZHVsZS1kZXRhaWwnLFxuICB0ZW1wbGF0ZVVybDogJy4vc2NoZWR1bGUtZGV0YWlsLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vc2NoZWR1bGUtZGV0YWlsLmNvbXBvbmVudC5zY3NzJ10sXG4gIGNoYW5nZURldGVjdGlvbjogQ2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3kuT25QdXNoXG59KVxuZXhwb3J0IGNsYXNzIFNjaGVkdWxlRGV0YWlsQ29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0IHtcbiAgQElucHV0KCkgbW9kZTogJ25ldycgfCAnZWRpdCcgPSAnbmV3JztcbiAgQElucHV0KCkgc2NoZWR1bGUhOiBhbnk7IC8vVE9ETyA6IHNjaGVkdWxlIG1vZGVsIGluc3RlYWQgb2YgYW55XG4gIEBJbnB1dCgpIHNob3dSZWZlcmVuY2U6IGJvb2xlYW4gPSBmYWxzZTtcbiAgQElucHV0KCkgcmVmZXJlbmNlRGF0YSE6IGFueTtcbiAgQFZpZXdDaGlsZHJlbihUaW1lem9uZVNlbGVjdENvbXBvbmVudCkgdGltZXpvbmVTZWxlY3RDb21wb25lbnRzITogUXVlcnlMaXN0PFRpbWV6b25lU2VsZWN0Q29tcG9uZW50PjtcbiAgQFZpZXdDaGlsZHJlbihGb3JtRmllbGRDb21wb25lbnQpIGZvcm1GaWVsZENvbXBvbmVudHMhOiBRdWVyeUxpc3Q8Rm9ybUZpZWxkQ29tcG9uZW50PjtcblxuICBzY2hlZHVsZUVudGl0eSE6IEVudGl0eTtcbiAgZm9ybUdyb3VwITogRm9ybUdyb3VwO1xuICBzY2hlZHVsZUZvcm1GaWVsZHM6IGFueSA9IHt9O1xuICBzYXZpbmdTY2hlZHVsZTogYm9vbGVhbiA9IGZhbHNlO1xuICByZWZlcmVuY2VMaXN0OiBBcnJheTxhbnk+ID0gW107XG4gIGNyb25EZXNjcmliZXIhOiBzdHJpbmc7XG4gIHRpbWV6b25lITogVGltZXpvbmVVVEMgfCB1bmRlZmluZWQ7XG4gIGxvYWRpbmc6IGJvb2xlYW4gPSB0cnVlO1xuICBwbGF5Ym9va1Blcm1pc3Npb25zOiBzdHJpbmdbXTtcbiAgcGVybWlzc2lvbiA9IFBFUk1JU1NJT047XG4gIHN5c3RlbVNldHRpbmdzPzogU3lzdGVtU2V0dGluZ3M7XG4gIHNob3dQQlJlZldhcm5pbmc6IGJvb2xlYW4gPSBmYWxzZTtcbiAgZXhpdFJ1bm5pbmdGaWVsZDogYW55O1xuICBleGNsdWRlRm9ybUNvbnRyb2w6IHN0cmluZ1tdID0gW107XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSBmb3JtQnVpbGRlcjogRm9ybUJ1aWxkZXIsXG4gICAgcHJpdmF0ZSBzY2hlZHVsZVNlcnZpY2U6IFNjaGVkdWxlU2VydmljZSxcbiAgICBwcml2YXRlIGFwaVNlcnZpY2U6IEFwaVNlcnZpY2UsXG4gICAgcHVibGljIGFjdGl2ZU9mZkNhbnZhczogTmdiQWN0aXZlT2ZmY2FudmFzLFxuICAgIHByaXZhdGUgdGltZXpvbmVTZXJ2aWNlOiBUaW1lem9uZVNlcnZpY2UsXG4gICAgcHJpdmF0ZSBjaGFuZ2VEZXRlY3RvclJlZjogQ2hhbmdlRGV0ZWN0b3JSZWYsXG4gICAgcHJpdmF0ZSBlbnRpdHlTZXJ2aWNlOiBFbnRpdHlTZXJ2aWNlLFxuICAgIHByaXZhdGUgaHR0cDogSHR0cENsaWVudCxcbiAgICBwcml2YXRlIHRvYXN0ZXI6IFRvYXN0clNlcnZpY2UsXG4gICAgcHJpdmF0ZSBzeXN0ZW1TZXR0aW5nc1NlcnZpY2U6IFN5c3RlbVNldHRpbmdzU2VydmljZSxcbiAgICBwcml2YXRlIHBlcm1pc3Npb25TZXJ2aWNlOiBQZXJtaXNzaW9uU2VydmljZVxuICApIHtcbiAgICB0aGlzLnBsYXlib29rUGVybWlzc2lvbnMgPSB0aGlzLnBlcm1pc3Npb25TZXJ2aWNlLmdldFBlcm1pc3Npb24oRklYRURfTU9EVUxFLlBMQVlCT09LKTtcbiAgfVxuXG4gIG5nT25Jbml0KCk6IHZvaWQge1xuICAgIGlmKCF0aGlzLnNob3dSZWZlcmVuY2UpIHtcbiAgICAgIHRoaXMuZXhjbHVkZUZvcm1Db250cm9sLnB1c2goJ3JlZmVyZW5jZScpO1xuICAgIH1cbiAgICB0aGlzLnN5c3RlbVNldHRpbmdzID0gdGhpcy5zeXN0ZW1TZXR0aW5nc1NlcnZpY2UuZ2V0KCk7XG4gICAgdGhpcy5lbnRpdHlTZXJ2aWNlLmJ1aWxkKEZJWEVEX01PRFVMRS5TQ0hFRFVMRVMpLnBpcGUoXG4gICAgICBzd2l0Y2hNYXAoKGVudGl0eTogRW50aXR5KSA9PiB7XG4gICAgICAgIHRoaXMuc2NoZWR1bGVFbnRpdHkgPSBjbG9uZURlZXAoZW50aXR5KTtcbiAgICAgICAgdGhpcy5leGl0UnVubmluZ0ZpZWxkID0gY2xvbmVEZWVwKHRoaXMuc2NoZWR1bGVFbnRpdHkuZmllbGRzLmV4aXRfaWZfcnVubmluZyk7XG4gICAgICAgIHRoaXMuZXhpdFJ1bm5pbmdGaWVsZC52aWV3TW9kZSA9ICdjaGVja2JveCc7XG5cbiAgICAgICAgdGhpcy50aW1lem9uZSA9IHRoaXMuc2NoZWR1bGUuY3JvbnRhYi50aW1lem9uZSA/IHRoaXMudGltZXpvbmVTZXJ2aWNlLmdldFRpbWV6b25lQnlOYW1lKHRoaXMuc2NoZWR1bGUuY3JvbnRhYi50aW1lem9uZSkgOiB1bmRlZmluZWQ7XG4gICAgICAgIHRoaXMudGltZXpvbmUgPSB0aGlzLnRpbWV6b25lID8/IHRoaXMudGltZXpvbmVTZXJ2aWNlLmdldFRpbWV6b25lQnlBYmJyKHRoaXMuc3lzdGVtU2V0dGluZ3M/LnByZWZlcmVuY2VzLmRlZmF1bHRUaW1lem9uZSB8fCAnVVRDJyk7XG4gICAgICAgIHRoaXMudGltZXpvbmUgPSB0aGlzLnRpbWV6b25lID8/IHRoaXMudGltZXpvbmVTZXJ2aWNlLmdldFRpbWV6b25lQnlBYmJyKCdVVEMnKTtcblxuICAgICAgICB0aGlzLmZvcm1Hcm91cCA9IHRoaXMuZm9ybUJ1aWxkZXIuZ3JvdXAoe1xuICAgICAgICAgIGNyb250YWI6IFt0aGlzLnNjaGVkdWxlLmNyb250YWJdLFxuICAgICAgICAgIHRpbWV6b25lOiBbdGhpcy50aW1lem9uZV1cbiAgICAgICAgfSk7XG4gICAgICAgIHRoaXMuc2V0Rm9ybUdyb3VwQ29udHJvbHMoKTtcblxuICAgICAgICBpZiAodGhpcy5tb2RlID09PSAnbmV3Jykge1xuICAgICAgICAgIHRoaXMuZm9ybUdyb3VwLnBhdGNoVmFsdWUoe1xuICAgICAgICAgICAgZW5hYmxlZDogZmFsc2UsXG4gICAgICAgICAgICByZWZlcmVuY2U6IHRoaXMucmVmZXJlbmNlRGF0YSA/PyBudWxsXG4gICAgICAgICAgfSk7XG4gICAgICAgICAgdGhpcy5sb2FkaW5nID0gZmFsc2U7XG4gICAgICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgICAgIH0gZWxzZSBpZiAodGhpcy5tb2RlID09PSAnZWRpdCcpIHtcbiAgICAgICAgICByZXR1cm4gdGhpcy5sb2FkU2NoZWR1bGUoKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gb2YoJycpO1xuICAgICAgfSksXG4gICAgICB0YXAoKCkgPT4ge1xuICAgICAgICB0aGlzLmxvYWRpbmcgPSBmYWxzZTtcbiAgICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgICB9KSxcbiAgICAgIHN3aXRjaE1hcCgoKSA9PiB0aGlzLmZvcm1Hcm91cC52YWx1ZUNoYW5nZXMpLFxuICAgICAgdGFwKCh2YWx1ZXM6IFJlY29yZDxzdHJpbmcsIGFueT4pID0+IHtcbiAgICAgICAga2V5cyh2YWx1ZXMpLmZvckVhY2goKGtleTogc3RyaW5nKSA9PiB7XG4gICAgICAgICAgbGV0IHZhbHVlID0gdmFsdWVzW2tleV07XG4gICAgICAgICAgaWYgKHZhbHVlICYmIHRoaXMuc2NoZWR1bGVFbnRpdHkuZmllbGRzW2tleV0gJiYgdGhpcy5zY2hlZHVsZUVudGl0eS5maWVsZHNba2V5XS5mb3JtVHlwZSA9PT0gJ2RhdGV0aW1lJykge1xuICAgICAgICAgICAgdmFsdWUgPSBuZXcgRGF0ZSh2YWx1ZSkudG9JU09TdHJpbmcoKVxuICAgICAgICAgIH1cbiAgICAgICAgICBpZiAoa2V5ID09PSAndGltZXpvbmUnKSB7XG4gICAgICAgICAgICB0aGlzLnRpbWV6b25lID0gdmFsdWU7XG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMuc2NoZWR1bGVba2V5XSA9IHZhbHVlO1xuICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgICB9KVxuICAgICkuc3Vic2NyaWJlKCk7XG5cbiAgICB0aGlzLmZvcm1Hcm91cC52YWx1ZUNoYW5nZXMuc3Vic2NyaWJlKChjaGFuZ2VzOiBhbnkpID0+IHtcbiAgICAgIGlmIChjaGFuZ2VzLnJlZmVyZW5jZSkge1xuICAgICAgICB0aGlzLnNob3dQQlJlZldhcm5pbmcgPSAhY2hhbmdlcy5yZWZlcmVuY2UuaXNBY3RpdmU7XG4gICAgICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3JSZWYuZGV0ZWN0Q2hhbmdlcygpO1xuICAgICAgfVxuICAgIH0pXG4gIH1cblxuICBwcml2YXRlIHNldEZvcm1Hcm91cENvbnRyb2xzKCkge1xuICAgIGZvckVhY2godGhpcy5zY2hlZHVsZUVudGl0eS5maWVsZHMsIChmaWVsZDogRmllbGQpID0+IHtcbiAgICAgIGlmIChmaWVsZC5pc0Zvcm1GaWVsZCAmJiB0aGlzLmV4Y2x1ZGVGb3JtQ29udHJvbC5pbmRleE9mKGZpZWxkLm5hbWUpID09PSAtMSkge1xuICAgICAgICBsZXQgZmllbGRDdHJsID0gbmV3IEZvcm1Db250cm9sKHRoaXMuc2NoZWR1bGVbZmllbGQubmFtZV0gfHwgbnVsbCk7XG4gICAgICAgIGlmIChmaWVsZC52YWxpZGF0aW9uLnJlcXVpcmVkKSB7XG4gICAgICAgICAgZmllbGRDdHJsLmFkZFZhbGlkYXRvcnMoVmFsaWRhdG9ycy5yZXF1aXJlZCk7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5mb3JtR3JvdXAuYWRkQ29udHJvbChmaWVsZC5uYW1lLCBmaWVsZEN0cmwpO1xuICAgICAgfVxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBsb2FkU2NoZWR1bGUoKSB7XG4gICAgdGhpcy5mb3JtR3JvdXAucGF0Y2hWYWx1ZSh7XG4gICAgICBuYW1lOiB0aGlzLnNjaGVkdWxlLm5hbWUsXG4gICAgICBlbmFibGVkOiB0aGlzLnNjaGVkdWxlLmVuYWJsZWQsXG4gICAgICB0aW1lem9uZTogdGhpcy50aW1lem9uZVNlcnZpY2UuZ2V0VGltZXpvbmVCeU5hbWUodGhpcy5zY2hlZHVsZS5rd2FyZ3MudGltZXpvbmUpLFxuICAgICAgZXhpdF9pZl9ydW5uaW5nOiB0aGlzLnNjaGVkdWxlLmt3YXJncy5leGl0X2lmX3J1bm5pbmcgPz8gZmFsc2UsXG4gICAgICBzdGFydF90aW1lOiBEYXRlLnBhcnNlKHRoaXMuc2NoZWR1bGUuc3RhcnRfdGltZSkgPz8gbnVsbCxcbiAgICAgIGV4cGlyZXM6IERhdGUucGFyc2UodGhpcy5zY2hlZHVsZS5leHBpcmVzKSA/PyBudWxsLFxuICAgICAgY3JvbnRhYjogdGhpcy5zY2hlZHVsZS5jcm9udGFiXG4gICAgfSk7XG4gICAgaWYgKCF0aGlzLnNjaGVkdWxlLmt3YXJncy53Zl9pcmkgfHwgIXRoaXMuc2hvd1JlZmVyZW5jZSkge1xuICAgICAgcmV0dXJuIG9mKG51bGwpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5lbnRpdHlTZXJ2aWNlLmJ1aWxkKEZJWEVEX01PRFVMRS5QTEFZQk9PSykucGlwZShcbiAgICAgIHN3aXRjaE1hcCgocGxheWJvb2tFbnRpdHk6IEVudGl0eSkgPT4ge1xuICAgICAgICBjb25zdCBwbGF5Ym9va1V1aWQgPSB0aGlzLnNjaGVkdWxlLmt3YXJncy53Zl9pcmkuc3BsaXQoJy8nKVs0XTtcbiAgICAgICAgY29uc3QgcXVlcnkgPSBwbGFpblRvSW5zdGFuY2UoUXVlcnksIHtcbiAgICAgICAgICBmaWx0ZXJzOiBbe1xuICAgICAgICAgICAgZmllbGQ6ICd1dWlkJyxcbiAgICAgICAgICAgIG9wZXJhdG9yOiAnZXEnLFxuICAgICAgICAgICAgdmFsdWU6IHBsYXlib29rVXVpZFxuICAgICAgICAgIH1dXG4gICAgICAgIH0pO1xuICAgICAgICByZXR1cm4gdGhpcy5hcGlTZXJ2aWNlLnF1ZXJ5KHBsYXlib29rRW50aXR5LCBxdWVyeS5nZXRRdWVyeU9iamVjdCgpLCB7fSwgdHJ1ZSkucGlwZShcbiAgICAgICAgICBtYXAoKHBsYXlib29rUmVzcG9uc2U6IEh5ZHJhUmVzcG9uc2UpID0+IHtcbiAgICAgICAgICAgIGlmIChwbGF5Ym9va1Jlc3BvbnNlWydoeWRyYTp0b3RhbEl0ZW1zJ10gPT09IDApIHtcbiAgICAgICAgICAgICAgY29uc29sZS53YXJuKCdQbGF5Ym9vayBub3QgZm91bmQgKCcgKyB0aGlzLnNjaGVkdWxlLmt3YXJncy53Zl9pcmkgKyAnKScpO1xuICAgICAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBwbGF5Ym9va1Jlc3BvbnNlWydoeWRyYTptZW1iZXInXVswXTtcbiAgICAgICAgICB9KSxcbiAgICAgICAgICBtYXAoKHBsYXlib29rOiBhbnkpID0+IHtcbiAgICAgICAgICAgIHRoaXMuZm9ybUdyb3VwLnBhdGNoVmFsdWUoe1xuICAgICAgICAgICAgICByZWZlcmVuY2U6IHBsYXlib29rXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgICB9KVxuICAgICAgICApO1xuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgc2F2ZSgpIHtcbiAgICBpZiAodGhpcy5mb3JtR3JvdXAuaW52YWxpZCkge1xuICAgICAgdGhpcy5mb3JtR3JvdXAubWFya0FsbEFzVG91Y2hlZCgpO1xuICAgICAgZm9yIChsZXQgZm9ybUZpZWxkIG9mIFsuLi50aGlzLnRpbWV6b25lU2VsZWN0Q29tcG9uZW50cywgLi4udGhpcy5mb3JtRmllbGRDb21wb25lbnRzXSkge1xuICAgICAgICBpZiAoIWZvcm1GaWVsZC52YWxpZCkge1xuICAgICAgICAgIGZvcm1GaWVsZC5mb2N1cygpO1xuICAgICAgICAgIGJyZWFrO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIHRoaXMuc2F2aW5nU2NoZWR1bGUgPSB0cnVlO1xuICAgIHRoaXMuc2NoZWR1bGUuY3JvbnRhYi50aW1lem9uZSA9IHRoaXMudGltZXpvbmU/LnZhbHVlIHx8ICcnO1xuICAgIGxldCBvYnNlcnZhYmxlJCE6IE9ic2VydmFibGU8YW55PjtcbiAgICBsZXQgdG9hc3RlclN1Y2Nlc3NNZXNzYWdlOiBzdHJpbmcgfCB1bmRlZmluZWQ7IC8vIGkxOG4/XG4gICAgdGhpcy5zY2hlZHVsZS5jcm9udGFiLmhvdXIgPSB0aGlzLnNjaGVkdWxlLmNyb250YWIuaG91ci50b1N0cmluZygpO1xuICAgIHRoaXMuc2NoZWR1bGUuY3JvbnRhYi5taW51dGUgPSB0aGlzLnNjaGVkdWxlLmNyb250YWIubWludXRlLnRvU3RyaW5nKCk7XG4gICAgbGV0IHNjaGVkdWxlID0gcGxhaW5Ub0luc3RhbmNlKFNjaGVkdWxlLCB0aGlzLnNjaGVkdWxlIGFzIE9iamVjdCk7XG4gICAgc2NoZWR1bGUuaWQgPSB0aGlzLnNjaGVkdWxlLmlkO1xuICAgIHNjaGVkdWxlLmt3YXJncyA9IHRoaXMuc2NoZWR1bGUua3dhcmdzO1xuICAgIHNjaGVkdWxlLmt3YXJncy5leGl0X2lmX3J1bm5pbmcgPSB0aGlzLnNjaGVkdWxlLmV4aXRfaWZfcnVubmluZztcbiAgICBzY2hlZHVsZS5rd2FyZ3MudGltZXpvbmUgPSB0aGlzLnNjaGVkdWxlLmNyb250YWIudGltZXpvbmU7XG4gICAgc2NoZWR1bGUuY3JvbnRhYiA9IHRoaXMuc2NoZWR1bGUuY3JvbnRhYjtcbiAgICBzY2hlZHVsZS5rd2FyZ3MudXRjT2Zmc2V0ID0gdGhpcy50aW1lem9uZT8udXRjT2Zmc2V0O1xuICAgIHNjaGVkdWxlLmVuYWJsZWQgPSB0aGlzLmZvcm1Hcm91cC52YWx1ZS5lbmFibGVkO1xuICAgIGlmICh0aGlzLnNjaGVkdWxlLnJlZmVyZW5jZSAmJiB0aGlzLnNjaGVkdWxlLnJlZmVyZW5jZVsnQGlkJ10pIHtcbiAgICAgIHNjaGVkdWxlLmt3YXJncy53Zl9pcmkgPSB0aGlzLnNjaGVkdWxlLnJlZmVyZW5jZVsnQGlkJ107XG4gICAgfVxuXG4gICAgaWYgKHRoaXMubW9kZSA9PT0gJ25ldycpIHtcbiAgICAgIG9ic2VydmFibGUkID0gdGhpcy5zY2hlZHVsZVNlcnZpY2UuY3JlYXRlKHNjaGVkdWxlKTtcbiAgICAgIHRvYXN0ZXJTdWNjZXNzTWVzc2FnZSA9ICdTY2hlZHVsZSBDcmVhdGVkJztcbiAgICB9IGVsc2UgaWYgKHRoaXMubW9kZSA9PT0gJ2VkaXQnKSB7XG4gICAgICAvLyBUT0RPIDogSXMgdGhlcmUgYSBiZXR0ZXIgd2F5IHRvIGRvIHRoaXNcblxuICAgICAgb2JzZXJ2YWJsZSQgPSB0aGlzLnNjaGVkdWxlU2VydmljZS51cGRhdGUoc2NoZWR1bGUpO1xuICAgICAgdG9hc3RlclN1Y2Nlc3NNZXNzYWdlID0gJ1NjaGVkdWxlIFVwZGF0ZWQnO1xuICAgIH1cblxuICAgIG9ic2VydmFibGUkLnN1YnNjcmliZSh7XG4gICAgICBuZXh0OiAoKHJlc3BvbnNlOiBhbnkpID0+IHtcbiAgICAgICAgdGhpcy50b2FzdGVyLnN1Y2Nlc3ModG9hc3RlclN1Y2Nlc3NNZXNzYWdlLCAnU3VjY2VzcycpO1xuICAgICAgICB0aGlzLmFjdGl2ZU9mZkNhbnZhcy5jbG9zZShyZXNwb25zZSk7XG4gICAgICB9KVxuICAgIH0pO1xuXG4gIH1cblxuICBjYW5jZWwoKSB7XG4gICAgdGhpcy5hY3RpdmVPZmZDYW52YXMuY2xvc2UoKTtcbiAgfVxufVxuIiwiPGRpdiAqdHJhbnNsb2NvPVwibGV0IHRcIj5cbjwhLS0gSGVhZGVyIC0tPlxuPGRpdiBjbGFzcz1cIm1vZGFsLWhlYWRlciBwYWRkaW5nLWJvdHRvbS04cHggcGFkZGluZy1sZWZ0LTE2cHggcGFkZGluZy1yaWdodC0xNnB4IHBhZGRpbmctdG9wLThweCBtb2RhbC1jbG9zZS1sZWZ0XCI+XG4gIDxoNCBjbGFzcz1cInBhZ2UtdGl0bGUtZm9udCBtb2RhbC10aXRsZSBtdXRlZC0xMFwiPnt7IHQoJ2NvbXBvbmVudHMuc2NoZWR1bGUudGl0bGUnKSB9fTwvaDQ+XG4gIDxidXR0b24gdHlwZT1cImJ1dHRvblwiIGlkPVwiY2xvc2UtYnRuXCIgKGNsaWNrKT1cImNhbmNlbCgpXCIgY2xhc3M9XCJidG4gYnRuLWNsb3NlXCI+PC9idXR0b24+XG5cbjwvZGl2PlxuPCEtLSBCb2R5IC0tPlxuPGRpdiAqbmdJZj1cIiFsb2FkaW5nXCIgY2xhc3M9XCJtb2RhbC1ib2R5XCI+XG4gIDxmb3JtICNhZGRTY2hlZHVsZUZvcm09XCJuZ0Zvcm1cIiAobmdTdWJtaXQpPVwic2F2ZSgpXCIgW2Zvcm1Hcm91cF09XCJmb3JtR3JvdXBcIiBjbGFzcz1cInBhZGRpbmctdG9wLTIwcHggcGFkZGluZy1ib3R0b20tMjBweFwiPlxuICAgIDxkaXYgY2xhc3M9XCJyb3cgbS0wXCI+XG4gICAgICA8ZGl2IGNsYXNzPVwiY29sLW1kLTEyXCI+XG4gICAgICAgIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCI+XG4gICAgICAgICAgPGRpdiBjbGFzcz1cIm1hcmdpbi1ib3R0b20tOHB4XCI+XG4gICAgICAgICAgICA8eGYtZm9ybS1maWVsZCBbZmllbGRdPVwic2NoZWR1bGVFbnRpdHkuZmllbGRzLm5hbWVcIlxuICAgICAgICAgICAgICBbZm9ybUNvbnRyb2xOYW1lXT1cInNjaGVkdWxlRW50aXR5LmZpZWxkcy5uYW1lLm5hbWVcIlxuICAgICAgICAgICAgICBmaWVsZENsYXNzPVwiZm9ybS1jb250cm9sLXNtIG1hcmdpbi1ib3R0b20tOHB4IHctMTAwXCIgW2F1dG9Gb2N1c109XCJ0cnVlXCI+PC94Zi1mb3JtLWZpZWxkPlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJtYXJnaW4tYm90dG9tLTEycHhcIj5cbiAgICAgICAgICAgIDx4Zi1mb3JtLWZpZWxkIFtmaWVsZF09XCJzY2hlZHVsZUVudGl0eS5maWVsZHMuZW5hYmxlZFwiXG4gICAgICAgICAgICAgIFtmb3JtQ29udHJvbE5hbWVdPVwic2NoZWR1bGVFbnRpdHkuZmllbGRzLmVuYWJsZWQubmFtZVwiXG4gICAgICAgICAgICAgIGZpZWxkQ2xhc3M9XCJmb3JtLWNvbnRyb2wtc20gbWFyZ2luLWJvdHRvbS04cHggdy0xMDBcIiBbYXV0b0ZvY3VzXT1cInRydWVcIj48L3hmLWZvcm0tZmllbGQ+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPGRpdiAqbmdJZj1cInBsYXlib29rUGVybWlzc2lvbnMuaW5jbHVkZXMocGVybWlzc2lvbi5SRUFEKSAmJiBzaG93UmVmZXJlbmNlXCI+XG4gICAgICAgICAgICA8eGYtZm9ybS1maWVsZCBbZmllbGRdPVwic2NoZWR1bGVFbnRpdHkuZmllbGRzLnJlZmVyZW5jZVwiXG4gICAgICAgICAgICAgIFtmb3JtQ29udHJvbE5hbWVdPVwic2NoZWR1bGVFbnRpdHkuZmllbGRzLnJlZmVyZW5jZS5uYW1lXCJcbiAgICAgICAgICAgICAgZmllbGRDbGFzcz1cImZvcm0tY29udHJvbC1zbSBtYXJnaW4tYm90dG9tLThweCB3LTEwMFwiIFthdXRvRm9jdXNdPVwidHJ1ZVwiPjwveGYtZm9ybS1maWVsZD5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICBAaWYgKHNob3dQQlJlZldhcm5pbmcpIHtcbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJ0ZXh0LXdhcm5pbmcgY29udGVudC1mb250IGZ3LW1lZGl1bSBsaW5lLWhlaWdodC0xNXB4IG1hcmdpbi10b3AtOHB4XCI+XG4gICAgICAgICAgICAgIDxpIGNsYXNzPVwiZmEgZmEtd2FybmluZyBmYS1yZWd1bGFyIG1hcmdpbi1yaWdodC00cHhcIj48L2k+XG4gICAgICAgICAgICAgIDxzbWFsbD5UaGUgcGxheWJvb2sgcmVmZXJlbmNlZCBpcyBpbmFjdGl2ZS4gVGhlIHNjaGVkdWxlIHdpbGwgbm90IHJ1biBpdCB1bnRpbCBpdCBpcyBjaGFuZ2VkIHRvIGFjdGl2ZS48L3NtYWxsPlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgfVxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJtYXJnaW4tYm90dG9tLTEycHggbWFyZ2luLXRvcC0xMnB4XCI+XG4gICAgICAgICAgICA8bGFiZWwgY2xhc3M9XCJmb3JtLWxhYmVsIG1iLTFcIj57eyB0KCdjb21wb25lbnRzLnNjaGVkdWxlLmxhYmVscy5mcmVxdWVuY3knKSB9fTwvbGFiZWw+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwibWItMlwiPlxuICAgICAgICAgICAgICA8eGYtY3Jvbi1lZGl0b3IgZm9ybUNvbnRyb2xOYW1lPVwiY3JvbnRhYlwiPjwveGYtY3Jvbi1lZGl0b3I+XG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8ZGl2IGNsYXNzPVwibWFyZ2luLWJvdHRvbS0xMnB4XCI+XG4gICAgICAgICAgICA8bGFiZWwgY2xhc3M9XCJmb3JtLWxhYmVsIG1iLTFcIj57eyB0KCdjb21wb25lbnRzLnNjaGVkdWxlLmxhYmVscy50aW1lem9uZScpIH19PC9sYWJlbD5cbiAgICAgICAgICAgIDx4Zi10aW1lem9uZS1zZWxlY3QgZm9ybUNvbnRyb2xOYW1lPVwidGltZXpvbmVcIj48L3hmLXRpbWV6b25lLXNlbGVjdD5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8ZGl2IGNsYXNzPVwibWFyZ2luLWJvdHRvbS0xMnB4XCI+XG4gICAgICAgICAgICA8eGYtZm9ybS1maWVsZCBbZmllbGRdPVwiZXhpdFJ1bm5pbmdGaWVsZFwiXG4gICAgICAgICAgICAgIFtmb3JtQ29udHJvbE5hbWVdPVwic2NoZWR1bGVFbnRpdHkuZmllbGRzLmV4aXRfaWZfcnVubmluZy5uYW1lXCJcbiAgICAgICAgICAgICAgZmllbGRDbGFzcz1cImZvcm0tY29udHJvbC1zbSBtYXJnaW4tYm90dG9tLThweCB3LTEwMFwiIFthdXRvRm9jdXNdPVwidHJ1ZVwiPjwveGYtZm9ybS1maWVsZD5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8ZGl2IGNsYXNzPVwibWFyZ2luLWJvdHRvbS0xMnB4IGQtZmxleFwiPlxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImNvbC1tZC02XCI+XG4gICAgICAgICAgICAgIDx4Zi1mb3JtLWZpZWxkIFtmaWVsZF09XCJzY2hlZHVsZUVudGl0eS5maWVsZHMuc3RhcnRfdGltZVwiXG4gICAgICAgICAgICAgICAgW2Zvcm1Db250cm9sTmFtZV09XCJzY2hlZHVsZUVudGl0eS5maWVsZHMuc3RhcnRfdGltZS5uYW1lXCJcbiAgICAgICAgICAgICAgICBmaWVsZENsYXNzPVwiZm9ybS1jb250cm9sLXNtIG1hcmdpbi1ib3R0b20tOHB4IHctMTAwXCIgW2F1dG9Gb2N1c109XCJ0cnVlXCI+PC94Zi1mb3JtLWZpZWxkPlxuXG4gICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJjb2wtbWQtNlwiPlxuICAgICAgICAgICAgICA8eGYtZm9ybS1maWVsZCBbZmllbGRdPVwic2NoZWR1bGVFbnRpdHkuZmllbGRzLmV4cGlyZXNcIlxuICAgICAgICAgICAgICAgIFtmb3JtQ29udHJvbE5hbWVdPVwic2NoZWR1bGVFbnRpdHkuZmllbGRzLmV4cGlyZXMubmFtZVwiXG4gICAgICAgICAgICAgICAgZmllbGRDbGFzcz1cImZvcm0tY29udHJvbC1zbSBtYXJnaW4tYm90dG9tLThweCB3LTEwMFwiIFthdXRvRm9jdXNdPVwidHJ1ZVwiPjwveGYtZm9ybS1maWVsZD5cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgIDwvZGl2PlxuICA8L2Zvcm0+XG48L2Rpdj5cbjxkaXYgY2xhc3M9XCJkLWZsZXgganVzdGlmeS1jb250ZW50LWNlbnRlciBhbGlnbi1pdGVtcy1jZW50ZXJcIiAqbmdJZj1cImxvYWRpbmdcIj5cbiAgPGRpdiBjbGFzcz1cInNwaW5uZXItYm9yZGVyXCIgcm9sZT1cInN0YXR1c1wiPlxuICAgIDxzcGFuIGNsYXNzPVwidmlzdWFsbHktaGlkZGVuXCI+TG9hZGluZy4uLjwvc3Bhbj5cbiAgPC9kaXY+XG48L2Rpdj5cbjwhLS0gRm9vdGVyIC0tPlxuPGRpdiAqbmdJZj1cIiFsb2FkaW5nXCIgY2xhc3M9XCJtb2RhbC1mb290ZXIgcGFkZGluZy1ib3R0b20tOHB4IHBhZGRpbmctbGVmdC0xNnB4IHBhZGRpbmctcmlnaHQtMTZweCBwYWRkaW5nLXRvcC04cHhcIj5cbiAgPGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCIgY2xhc3M9XCJidG4gYnRuLXByaW1hcnkgYnRuLXNtIG1hcmdpbi1yaWdodC04cHhcIiAoY2xpY2spPVwic2F2ZSgpXCI+XG4gICAgPGkgY2xhc3M9XCJmYSBmYS1jaGVjayBtYXJnaW4tcmlnaHQtNHB4XCI+PC9pPnt7IHQoJ2J1dHRvbnMuc2F2ZScpIH19XG4gIDwvYnV0dG9uPlxuICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBjbGFzcz1cImJ0biBidG4tc2Vjb25kYXJ5IGJ0bi1zbSBtZS0yXCIgKGNsaWNrKT1cImNhbmNlbCgpXCI+XG4gICAgPGkgY2xhc3M9XCJmYSBmYS10aW1lcyBtYXJnaW4tcmlnaHQtNHB4XCI+PC9pPnt7IHQoJ2J1dHRvbnMuY2FuY2VsJykgfX1cbiAgPC9idXR0b24+XG48L2Rpdj5cbjwvZGl2PlxuIl19