import { Component, ViewChildren, inject } from "@angular/core";
import { Validators } from "@angular/forms";
import { concatMap, map, of, tap } from "rxjs";
import { FormFieldComponent } from "shared";
import { UniqueValidatorService } from "./unique.validator";
import { ViewTemplate } from "./models/view-template";
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/router";
import * as i3 from "./view-template/view-template.service";
import * as i4 from "shared";
import * as i5 from "@angular/forms";
export class AbstractViewTemplateComponent {
    constructor(offcanvasService, router, viewTemplateService, route, changeDetectorRef, spinnerService, modalService, formBuilder) {
        this.offcanvasService = offcanvasService;
        this.router = router;
        this.viewTemplateService = viewTemplateService;
        this.route = route;
        this.changeDetectorRef = changeDetectorRef;
        this.spinnerService = spinnerService;
        this.modalService = modalService;
        this.viewTemplates = [];
        this.types = ViewTemplate.Types;
        this.loading = true;
        this.loadMultipleViews = true;
        this.uniqueValidatorService = inject(UniqueValidatorService);
        this.headerButtons = [];
        this.formGroup = formBuilder.group({
            viewTemplateTitle: ['', Validators.required]
        });
    }
    ngOnInit() {
        this.route.queryParamMap.pipe(concatMap((params) => {
            this.mode = params.get('mode') || 'view';
            this.uuid = params.get('uuid');
            this.loading = true;
            this.changeDetectorRef.detectChanges();
            if (this.mode === 'new') {
                return this.loadViews().pipe(map(() => this.newViewTemplate()));
            }
            else if (this.loadMultipleViews) {
                return this.loadViews().pipe(tap(() => {
                    if (this.viewTemplates && this.viewTemplates?.length > 0) {
                        this.uuid = this.uuid ?? this.viewTemplates[0]?.uuid;
                        this.viewTemplate = this.viewTemplates.find((viewTemplate) => viewTemplate.uuid === this.uuid) || null;
                        this.updateHeaderButtons();
                    }
                    else {
                        this.mode == null;
                        this.uuid = null;
                        this.updateHeaderButtons();
                        this.navigate();
                    }
                    this.changeDetectorRef.detectChanges();
                }));
            }
            else if (this.mode === 'view' && this.uuid) {
                return this.loadView();
            }
            return of();
        })).subscribe();
    }
    ;
    onSaveTemplate() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            this.formFields.forEach((formField) => {
                if (!formField.valid) {
                    formField.focus();
                    return;
                }
            });
            this.changeDetectorRef.detectChanges();
            return;
        }
        let updateMode;
        this.viewTemplateService.save(this.viewTemplate).subscribe({
            next: (viewTemplate) => {
                updateMode = this.mode === 'new' ? 'new' : 'view';
                this.mode = 'view';
                this.uuid = viewTemplate.uuid;
                this.updateViews(updateMode, viewTemplate);
                this.updateHeaderButtons();
                this.navigate();
            },
            error: (error) => {
                console.log(error);
                this.formGroup.controls.viewTemplateTitle.setErrors({ unique: true });
                this.formGroup.controls.viewTemplateTitle.markAsTouched();
                return of();
            }
        });
    }
    onDuplicateTemplate() {
        if (!this.viewTemplate) {
            return;
        }
        if (!this.viewTemplate.uuid) {
            return;
        }
        this.spinnerService.start();
        return this.viewTemplateService.duplicate(this.viewTemplate.uuid).subscribe((viewTemplate) => {
            this.spinnerService.stop();
            this.uuid = viewTemplate.uuid;
            this.mode = 'edit';
            this.navigate();
        });
    }
    onDeleteTemplate() {
        if (!this.viewTemplate) {
            return;
        }
        else {
            const message = 'Are you sure you want to delete the current view?';
            this.modalService.confirm(message).pipe(concatMap(() => {
                if (!this.viewTemplate?.uuid) {
                    return of();
                }
                this.spinnerService.start();
                return this.viewTemplateService.delete(this.viewTemplate?.uuid);
            })).subscribe(() => {
                this.spinnerService.stop();
                this.updateViews(undefined, this.viewTemplate);
            });
        }
    }
    onCancel() {
        if (this.mode === 'edit') {
            if (!this.uuid) {
                this.viewTemplate = null;
            }
            this.mode = 'view';
            this.updateHeaderButtons();
            this.navigate();
        }
        else {
            this.viewTemplate = null;
            this.viewTemplateService.navigateToView(null, this.route);
        }
    }
    onEditTemplate() {
        if (this.uuid) {
            this.mode = 'edit';
            this.updateHeaderButtons();
            this.navigate();
        }
    }
    updateViews(mode, viewTemplate) {
        if (mode && viewTemplate) {
            if (mode === 'new') {
                this._updateOnNew(viewTemplate);
            }
            else if (mode === 'view') {
                this.viewTemplates.forEach((item) => {
                    if (item.uuid === viewTemplate.uuid) {
                        item.title = viewTemplate.title;
                    }
                });
            }
        }
        else if (!mode && viewTemplate) { // Delete Case
            this.viewTemplates = this.viewTemplates.filter(item => item.uuid !== viewTemplate.uuid);
            if (this.viewTemplates.length > 0) {
                this.uuid = this.viewTemplates[0].uuid;
                this.loading = true;
                this.loadView();
            }
            else {
                this.uuid = null;
            }
        }
        this.changeDetectorRef.detectChanges();
    }
    _updateOnNew(viewTemplate) {
        this.uuid = viewTemplate.uuid;
        this.viewTemplates.unshift(viewTemplate);
    }
    loadViews() {
        // Pick it from context
        this.viewTemplate = null;
        this.viewTemplates = [];
        const module = this.route.snapshot.paramMap.get('module');
        let filters = [{
                field: 'type',
                operator: 'eq',
                value: this.viewTemplateType
            }];
        if (module) {
            this.currentModule = module;
            filters.push({
                field: 'module',
                operator: 'eq',
                value: module
            });
        }
        return this.viewTemplateService.loadWithParams(filters).pipe(map((viewTemplates) => {
            if (viewTemplates && viewTemplates?.length > 0) {
                this.viewTemplates = viewTemplates;
                const viewTemplatesWithoutCurrent = this.viewTemplates.filter((viewTemplate) => viewTemplate.uuid !== this.uuid);
                this.formGroup.controls.viewTemplateTitle.addValidators(this.uniqueValidatorService.validate(viewTemplatesWithoutCurrent.map((viewTemplate) => viewTemplate.title)));
                this.formGroup.controls.viewTemplateTitle.updateValueAndValidity();
            }
            this.loading = false;
            this.changeDetectorRef.detectChanges();
        }));
    }
    loadView() {
        return this.viewTemplateService.loadByUuid(this.uuid).pipe(map((viewTemplate) => {
            this.viewTemplate = viewTemplate;
            this.loading = false;
            this.updateHeaderButtons();
            this.changeDetectorRef.detectChanges();
        }));
    }
    navigate() {
        let params = {
            mode: this.mode,
            uuid: this.uuid
        };
        // this.viewTemplateService.navigateToView(params, this.route);
        var url = this.router.createUrlTree([], { relativeTo: this.route, queryParams: params }).toString();
        this.router.navigateByUrl(url);
        // if (this.openedInPreview) {
        //   this.mode = this.params.mode;
        //   this.recordId = this.params.recordId;
        //   this.onAddViewTemplate.emit();
        // } else {
        //   this.viewTemplateService.navigateToView(this.params, this.route);
        // }
    }
    updateHeaderButtons() {
        const isSystem = this.viewTemplate?.system;
        this.headerButtons = [
            {
                id: 'actions',
                text: 'Actions',
                class: 'dropdown-toggle btn btn-primary btn-sm',
                visible: this.mode === 'view' && this.viewTemplate?.type !== 'dashboard',
                menuItems: [{
                        id: 'new',
                        text: 'New',
                        visible: true,
                        onClick: () => {
                            this.mode = 'new';
                            this.uuid = null;
                            this.navigate();
                        }
                    }, {
                        id: 'clone',
                        text: 'Clone & Edit',
                        visible: isSystem,
                        onClick: () => { this.onDuplicateTemplate(); }
                    }, {
                        id: 'edit',
                        text: 'Edit',
                        visible: !isSystem,
                        onClick: () => { this.onEditTemplate(); }
                    }, {
                        id: 'delete',
                        text: 'Delete',
                        visible: !isSystem,
                        onClick: () => { this.onDeleteTemplate(); }
                    }],
                onClick: () => null
            }, {
                id: 'cancel',
                text: 'Cancel',
                class: 'btn btn-secondary btn-sm me-2',
                visible: this.mode !== null && this.mode !== 'view',
                onClick: () => { this.onCancel(); }
            }, {
                id: 'save',
                text: 'Save and Publish',
                class: 'btn btn-primary btn-sm me-2',
                visible: this.mode !== null && this.mode !== 'view',
                onClick: () => { this.onSaveTemplate(); }
            }
        ];
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function AbstractViewTemplateComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractViewTemplateComponent)(i0.ɵɵdirectiveInject(i1.NgbOffcanvas), i0.ɵɵdirectiveInject(i2.Router), i0.ɵɵdirectiveInject(i3.ViewTemplateService), i0.ɵɵdirectiveInject(i2.ActivatedRoute), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i4.SpinnerService), i0.ɵɵdirectiveInject(i4.ModalService), i0.ɵɵdirectiveInject(i5.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractViewTemplateComponent, selectors: [["xf-abstract-view-template"]], viewQuery: function AbstractViewTemplateComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, decls: 0, vars: 0, template: function AbstractViewTemplateComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractViewTemplateComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-view-template',
                template: ''
            }]
    }], () => [{ type: i1.NgbOffcanvas }, { type: i2.Router }, { type: i3.ViewTemplateService }, { type: i2.ActivatedRoute }, { type: i0.ChangeDetectorRef }, { type: i4.SpinnerService }, { type: i4.ModalService }, { type: i5.FormBuilder }], { formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractViewTemplateComponent, { className: "AbstractViewTemplateComponent", filePath: "src/abstract-view-template.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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