import { __decorate } from "tslib";
import { Type } from "class-transformer";
import { ViewLayoutItem } from "./view-layout-item";
export class ViewTemplate {
    constructor(title, type) {
        this.title = title;
        this.type = type;
        this.layout = [];
        this.query = null;
        this.configuration = {};
        this.uuid = null;
        this.system = false;
    }
}
__decorate([
    Type(() => ViewLayoutItem, {
        discriminator: {
            property: 'type',
            subTypes: [
                { value: ViewLayoutItem.Widget, name: ViewLayoutItem.Types.WIDGET },
                { value: ViewLayoutItem.Container, name: ViewLayoutItem.Types.CONTAINER },
                { value: ViewLayoutItem.Tabs, name: ViewLayoutItem.Types.TABS },
                { value: ViewLayoutItem.Tab, name: ViewLayoutItem.Types.TAB }
            ],
        },
    })
], ViewTemplate.prototype, "layout", void 0);
(function (ViewTemplate) {
    let Types;
    (function (Types) {
        Types["DASHBOARD"] = "dashboard";
        Types["MODULE_VIEW"] = "module-view";
        Types["DETAIL_VIEW"] = "detail-view";
        Types["PREVIEW"] = "preview";
        Types["EMBED"] = "embed";
    })(Types = ViewTemplate.Types || (ViewTemplate.Types = {}));
})(ViewTemplate || (ViewTemplate = {}));
//# sourceMappingURL=data:application/json;base64,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