import { ChangeDetectionStrategy, Component, Input, ViewChild } from '@angular/core';
import { TextField } from "shared";
import { ViewContainerDirective } from 'shared';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "../../widgets/widget.service";
import * as i3 from "@angular/forms";
import * as i4 from "shared";
const _c0 = ["title"];
function AddWidgetComponent_ng_template_10_Template(rf, ctx) { }
export class AddWidgetComponent {
    constructor(activeModal, changeDetectorRef, widgetService, formBuilder, entityService) {
        this.activeModal = activeModal;
        this.changeDetectorRef = changeDetectorRef;
        this.widgetService = widgetService;
        this.entityService = entityService;
        this.titleField = new TextField('widget-title');
        this.titleField.validation.required = true;
        this.titleField.descriptions = {
            singular: 'Title'
        };
        this.widgetFormGroup = formBuilder.group({
            title: ['']
        });
    }
    ngOnInit() {
        this.widgetFormGroup.valueChanges.subscribe((values) => {
            if (!this.widgetConfig) {
                return;
            }
            this.widgetConfig.title = values.title;
            this.ngOnChanges();
        });
    }
    ngAfterViewInit() {
        this.loadWidget();
    }
    loadWidget() {
        this.widgetConfig.isNew = true;
        this.changeDetectorRef.detectChanges();
        const viewContainerRef = this.viewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.widgetConfig.editComponent);
        this.componentRef.instance.widgetConfig = this.widgetConfig;
        this.componentRef.instance.context = this.context;
        // this.titleFieldComponent.focus();
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    ngOnChanges() {
        if (this.componentRef && this.widgetConfig) {
            this.componentRef.instance.widgetConfig = this.widgetConfig;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
    }
    saveAndClose() {
        this.activeModal.close(this.widgetConfig);
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function AddWidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AddWidgetComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveModal), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.WidgetService), i0.ɵɵdirectiveInject(i3.FormBuilder), i0.ɵɵdirectiveInject(i4.EntityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AddWidgetComponent, selectors: [["ng-component"]], viewQuery: function AddWidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.titleFieldComponent = _t.first);
        } }, inputs: { context: "context", widgetConfig: "widgetConfig", widgetType: "widgetType" }, features: [i0.ɵɵNgOnChangesFeature], decls: 16, vars: 2, consts: [["title", ""], [3, "formGroup"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body"], [1, "p-3"], ["formControlName", "title", 3, "field"], [1, "hr", "mt-2", "mb-2"], ["xfViewContainer", ""], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-primary", 3, "click"]], template: function AddWidgetComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "form", 1)(1, "div", 2)(2, "h4", 3);
            i0.ɵɵtext(3, "Add a widget");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "button", 4);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.cancel()); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5)(6, "div", 6);
            i0.ɵɵelement(7, "xf-form-field", 7, 0)(9, "div", 8);
            i0.ɵɵtemplate(10, AddWidgetComponent_ng_template_10_Template, 0, 0, "ng-template", 9);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(11, "div", 10)(12, "button", 11);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_12_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.cancel()); });
            i0.ɵɵtext(13, "Cancel");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(14, "button", 12);
            i0.ɵɵlistener("click", function AddWidgetComponent_Template_button_click_14_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.saveAndClose()); });
            i0.ɵɵtext(15, "Save Widget");
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.widgetFormGroup);
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("field", ctx.titleField);
        } }, dependencies: [i3.ɵNgNoValidate, i3.NgControlStatus, i3.NgControlStatusGroup, i3.FormGroupDirective, i3.FormControlName, i4.FormFieldComponent, i4.ViewContainerDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AddWidgetComponent, [{
        type: Component,
        args: [{ changeDetection: ChangeDetectionStrategy.OnPush, template: "<form [formGroup]=\"widgetFormGroup\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Add a widget</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body\">\n    <div class=\"p-3\">\n      <xf-form-field [field]=\"titleField\" formControlName=\"title\" #title></xf-form-field>\n      <div class=\"hr mt-2 mb-2\"></div>\n      <ng-template xfViewContainer></ng-template>\n    </div>\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-primary\" (click)=\"saveAndClose()\">Save Widget</button>\n  </div>\n\n</form>" }]
    }], () => [{ type: i1.NgbActiveModal }, { type: i0.ChangeDetectorRef }, { type: i2.WidgetService }, { type: i3.FormBuilder }, { type: i4.EntityService }], { context: [{
            type: Input
        }], widgetConfig: [{
            type: Input
        }], widgetType: [{
            type: Input
        }], viewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }], titleFieldComponent: [{
            type: ViewChild,
            args: ['title', { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AddWidgetComponent, { className: "AddWidgetComponent", filePath: "src/view-template/add-widget/add-widget.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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