import { isArray } from "lodash-es";
import { WidgetConfig } from "../../models/widget-config";
import { PrimaryDetailEditComponent } from "./primary-detail-edit/primary-detail-edit.component";
import { PrimaryDetailViewComponent } from "./primary-detail-view/primary-detail-view.component";
export class PrimaryDetailConfig extends WidgetConfig {
    constructor(title, configuration) {
        super(title, configuration);
        this.title = title;
        this.configuration = configuration;
        this.type = 'primary-detail';
        this.configuration = configuration && !isArray(configuration) ? configuration : {};
        this.viewComponent = PrimaryDetailViewComponent;
        this.editComponent = PrimaryDetailEditComponent;
        this.showBorder = false;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJpbWFyeS1kZXRhaWwtY29uZmlnLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL3ZpZXctdGVtcGxhdGVzL3NyYy93aWRnZXRzL3ByaW1hcnktZGV0YWlsL3ByaW1hcnktZGV0YWlsLWNvbmZpZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ3BDLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQztBQUUxRCxPQUFPLEVBQUUsMEJBQTBCLEVBQUUsTUFBTSxxREFBcUQsQ0FBQztBQUNqRyxPQUFPLEVBQUUsMEJBQTBCLEVBQUUsTUFBTSxxREFBcUQsQ0FBQztBQUVqRyxNQUFNLE9BQU8sbUJBQW9CLFNBQVEsWUFBWTtJQUluRCxZQUNTLEtBQWEsRUFDYixhQUtOO1FBRUQsS0FBSyxDQUFDLEtBQUssRUFBRSxhQUFhLENBQUMsQ0FBQztRQVJyQixVQUFLLEdBQUwsS0FBSyxDQUFRO1FBQ2Isa0JBQWEsR0FBYixhQUFhLENBS25CO1FBVEksU0FBSSxHQUFHLGdCQUFnQixDQUFDO1FBWTdCLElBQUksQ0FBQyxhQUFhLEdBQUcsYUFBYSxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNuRixJQUFJLENBQUMsYUFBYSxHQUFHLDBCQUEwQixDQUFDO1FBQ2hELElBQUksQ0FBQyxhQUFhLEdBQUcsMEJBQTBCLENBQUM7UUFDaEQsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFFMUIsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgaXNBcnJheSB9IGZyb20gXCJsb2Rhc2gtZXNcIjtcbmltcG9ydCB7IFdpZGdldENvbmZpZyB9IGZyb20gXCIuLi8uLi9tb2RlbHMvd2lkZ2V0LWNvbmZpZ1wiO1xuaW1wb3J0IHsgRmllbGRSZW5kZXJlciB9IGZyb20gXCIuLi9maWVsZC1ncm91cC9maWVsZC1yZW5kZXJlclwiO1xuaW1wb3J0IHsgUHJpbWFyeURldGFpbEVkaXRDb21wb25lbnQgfSBmcm9tIFwiLi9wcmltYXJ5LWRldGFpbC1lZGl0L3ByaW1hcnktZGV0YWlsLWVkaXQuY29tcG9uZW50XCI7XG5pbXBvcnQgeyBQcmltYXJ5RGV0YWlsVmlld0NvbXBvbmVudCB9IGZyb20gXCIuL3ByaW1hcnktZGV0YWlsLXZpZXcvcHJpbWFyeS1kZXRhaWwtdmlldy5jb21wb25lbnRcIjtcblxuZXhwb3J0IGNsYXNzIFByaW1hcnlEZXRhaWxDb25maWcgZXh0ZW5kcyBXaWRnZXRDb25maWcge1xuXG4gIHB1YmxpYyB0eXBlID0gJ3ByaW1hcnktZGV0YWlsJztcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwdWJsaWMgdGl0bGU6IHN0cmluZyxcbiAgICBwdWJsaWMgY29uZmlndXJhdGlvbjoge1xuICAgICAgbmFtZUZpZWxkPzogc3RyaW5nLFxuICAgICAgZGF0ZUZpZWxkPzogc3RyaW5nLFxuICAgICAgcGlja2xpc3RGaWVsZD86IHN0cmluZyxcbiAgICAgIGNvbHM/OiBGaWVsZFJlbmRlcmVyW11bXSxcbiAgICB9XG4gICkge1xuICAgIHN1cGVyKHRpdGxlLCBjb25maWd1cmF0aW9uKTtcbiAgICB0aGlzLmNvbmZpZ3VyYXRpb24gPSBjb25maWd1cmF0aW9uICYmICFpc0FycmF5KGNvbmZpZ3VyYXRpb24pID8gY29uZmlndXJhdGlvbiA6IHt9O1xuICAgIHRoaXMudmlld0NvbXBvbmVudCA9IFByaW1hcnlEZXRhaWxWaWV3Q29tcG9uZW50O1xuICAgIHRoaXMuZWRpdENvbXBvbmVudCA9IFByaW1hcnlEZXRhaWxFZGl0Q29tcG9uZW50O1xuICAgIHRoaXMuc2hvd0JvcmRlciA9IGZhbHNlO1xuXG4gIH1cbn1cbiJdfQ==