import { ChangeDetectionStrategy, Component, EventEmitter, Input, Optional, Output, ViewChild, ViewContainerRef } from '@angular/core';
import { cloneDeep, isUndefined } from 'lodash-es';
import { DndDraggableDirective, DndHandleDirective } from 'ngx-drag-drop';
import { concatMap, filter, map, of, tap } from 'rxjs';
import { API, Entity, FIXED_MODULE } from "shared";
import { Query } from "shared";
import { EditWidgetComponent } from '../../view-template/edit-widget/edit-widget.component';
import { WidgetConfig } from '../../models/widget-config';
import * as i0 from "@angular/core";
import * as i1 from "../widget.service";
import * as i2 from "@angular/common/http";
import * as i3 from "shared";
import * as i4 from "@ng-bootstrap/ng-bootstrap";
import * as i5 from "ngx-drag-drop";
import * as i6 from "@angular/common";
const _c0 = ["widgetHolder"];
const _c1 = (a0, a1) => [a0, a1];
const _c2 = a0 => ({ "card-body p-0": a0 });
function WidgetComponent_div_0_div_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 13);
} }
function WidgetComponent_div_0_div_1_div_6_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 19);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r2.clone.emit(ctx_r2.widgetConfig)); });
    i0.ɵɵelement(1, "i", 20);
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_0_div_1_div_6_button_2_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 21);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_button_2_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r2.delete.emit(ctx_r2.widgetConfig)); });
    i0.ɵɵelement(1, "i", 22);
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_0_div_1_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 14);
    i0.ɵɵtemplate(1, WidgetComponent_div_0_div_1_div_6_button_1_Template, 2, 0, "button", 15)(2, WidgetComponent_div_0_div_1_div_6_button_2_Template, 2, 0, "button", 16);
    i0.ɵɵelementStart(3, "button", 17);
    i0.ɵɵlistener("click", function WidgetComponent_div_0_div_1_div_6_Template_button_click_3_listener() { i0.ɵɵrestoreView(_r1); const ctx_r2 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r2.openEditModal()); });
    i0.ɵɵelement(4, "i", 18);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.showLayoutControls);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.showLayoutControls);
} }
function WidgetComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 7)(1, "div", 8)(2, "div", 9);
    i0.ɵɵtemplate(3, WidgetComponent_div_0_div_1_span_3_Template, 1, 0, "span", 10);
    i0.ɵɵelementStart(4, "h5", 11);
    i0.ɵɵtext(5);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(6, WidgetComponent_div_0_div_1_div_6_Template, 5, 2, "div", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r2.mode === "edit" && ctx_r2.showLayoutControls);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.title);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.mode !== "view");
} }
function WidgetComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, WidgetComponent_div_0_div_1_Template, 7, 3, "div", 4);
    i0.ɵɵelementStart(2, "div", 5);
    i0.ɵɵelement(3, "div", 6)(4, "div", null, 0);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵclassMapInterpolate1("", ctx_r2.widgetClass, " transitions-bottom-linear widget");
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(6, _c1, (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder) || ctx_r2.mode !== "view" ? "card" : "no-border", ctx_r2.mode === "edit" ? "editing" : ""));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder) && (ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.title) !== "" || ctx_r2.mode === "edit");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(9, _c2, ctx_r2.widgetConfig == null ? null : ctx_r2.widgetConfig.showBorder));
} }
function WidgetComponent_div_1_a_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 27);
    i0.ɵɵlistener("click", function WidgetComponent_div_1_a_4_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.logExpanded = !ctx_r2.logExpanded); });
    i0.ɵɵtext(1, "Show Build Log");
    i0.ɵɵelementEnd();
} }
function WidgetComponent_div_1_pre_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "pre", 28);
    i0.ɵɵtext(1, "        ");
    i0.ɵɵelement(2, "div", 29);
    i0.ɵɵtext(3, "\n      ");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("innerHTML", ctx_r2.buildLogHtml, i0.ɵɵsanitizeHtml);
} }
function WidgetComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 7)(2, "div", 23);
    i0.ɵɵtext(3);
    i0.ɵɵtemplate(4, WidgetComponent_div_1_a_4_Template, 2, 0, "a", 24)(5, WidgetComponent_div_1_pre_5_Template, 4, 1, "pre", 25);
    i0.ɵɵelement(6, "i", 26);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1(" The widget \"", ctx_r2.widget == null ? null : ctx_r2.widget.name, "\" is publishing. ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.widgetPermission.indexOf("update") > -1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.widgetPermission.indexOf("update") > -1 && ctx_r2.logExpanded);
} }
function WidgetComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r6 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 7)(2, "div", 23);
    i0.ɵɵtext(3);
    i0.ɵɵelementStart(4, "a", 30);
    i0.ɵɵlistener("click", function WidgetComponent_div_2_Template_a_click_4_listener() { i0.ɵɵrestoreView(_r6); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.reload()); });
    i0.ɵɵtext(5, "Refresh page");
    i0.ɵɵelementEnd();
    i0.ɵɵtext(6, " to see changes. ");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1(" There is an updated version of the \"", ctx_r2.widget == null ? null : ctx_r2.widget.name, "\" widget available. ");
} }
export class WidgetComponent {
    constructor(widgetService, http, dataProvider, ngbModalService, permissionService, changeDetectorRef, entityService, apiService, parentDraggable, embedService) {
        this.widgetService = widgetService;
        this.http = http;
        this.dataProvider = dataProvider;
        this.ngbModalService = ngbModalService;
        this.permissionService = permissionService;
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.apiService = apiService;
        this.parentDraggable = parentDraggable;
        this.embedService = embedService;
        this.edit = new EventEmitter();
        this.clone = new EventEmitter();
        this.delete = new EventEmitter();
        this.showLayoutControls = false;
        this.showMenu = false;
        this.widgetPermission = [];
        this.logExpanded = false;
        this.buildLogHtml = '';
        this.reloadRequired = false;
    }
    ngOnInit() {
        this.widgetPermission = this.permissionService.getPermission(FIXED_MODULE.DYNAMIC_CONTENT);
    }
    ngAfterViewInit() {
        if (this.parentDraggable) {
            this.parentDraggable.registerDragHandle(this.dndHandle);
        }
    }
    ngOnChanges(changes) {
        if (changes.config && this.config) {
            this.subscription?.unsubscribe();
            this.setConfig().subscribe(() => {
                if (this.widgetConfig) {
                    this.componentRef.instance.widgetConfigChanged(this.widgetConfig);
                }
            });
        }
        else if (changes.mode && this.componentRef) {
            this.componentRef.instance.mode = this.mode;
            this.componentRef.instance.changeDetectorRef.detectChanges();
        }
        else if (changes.context) {
            this.componentRef.instance.contextChanged(changes.context.currentValue);
        }
    }
    createWidgetComponent(widgetConfig) {
        this.viewContainer.clear();
        this.componentRef = this.viewContainer.createComponent(widgetConfig.viewComponent);
        this.componentRef.instance.widgetConfig = widgetConfig;
        this.componentRef.instance.mode = this.mode;
        this.componentRef.instance.widgetId = this.widgetId;
        this.componentRef.instance.updateHeight = this.updateHeight;
        this.componentRef.instance.context = this.context;
        this.changeDetectorRef.detectChanges();
    }
    watchMetadataChanges(widgetUuid) {
        let query = new Query({
            selectedFields: ['buildLog', 'publishing']
        });
        return this.entityService.build(FIXED_MODULE.DYNAMIC_CONTENT).pipe(concatMap((entity) => {
            return this.dataProvider.observe(entity, widgetUuid, undefined, query).pipe(tap((entityChange) => {
                if (!this.widget) {
                    return;
                }
                this.widget.publishing = entityChange.entity.values.publishing;
                this.widget.buildLog = entityChange.entity.values.buildLog;
                if (this.widget.publishing) {
                    this.reloadRequired = true;
                }
                this.setBuildLogHtml();
                this.changeDetectorRef.detectChanges();
            }), filter((entityChange) => {
                return !isUndefined(entityChange.entity.values.publishing) && !entityChange.entity.values.publishing;
            }));
        }));
    }
    getConfig(configUuid) {
        // TODO: Add widget-configs mmd
        let widgetConfigEntity = new Entity(FIXED_MODULE.WIDGET_CONFIGS);
        widgetConfigEntity.baseUrl = API.API_APPMANAGER;
        return this.apiService.getRecord(widgetConfigEntity, configUuid, WidgetConfig);
    }
    setConfig() {
        let getWidgetConfig$;
        getWidgetConfig$ = of('');
        return getWidgetConfig$.pipe(concatMap(() => this.widgetService.castAsWidgetConfig(this.config, this.widgetData).pipe(map((widgetConfig) => {
            this.widgetConfig = widgetConfig;
            this.changeDetectorRef.detectChanges();
            return this.createWidgetComponent(widgetConfig);
        }))));
    }
    setBuildLogHtml() {
        this.buildLogHtml = this.widget?.buildLog?.replace(/\\n/g, '<br>') || '';
    }
    ngOnDestroy() {
        this.subscription?.unsubscribe();
    }
    openEditModal() {
        if (!this.widgetConfig) {
            return;
        }
        let modalRef = this.ngbModalService.open(EditWidgetComponent, {
            backdrop: 'static',
            windowClass: 'modal-xlarge'
        });
        modalRef.componentInstance.widgetConfig = cloneDeep(this.widgetConfig);
        modalRef.componentInstance.context = this.context;
        modalRef.closed.subscribe((widgetConfig) => {
            this.edit.emit(widgetConfig);
            this.widgetConfig = widgetConfig;
            this.componentRef.instance.widgetConfig = widgetConfig;
            this.componentRef.instance.widgetConfigChanged(widgetConfig);
        });
    }
    reload() {
        location.reload();
    }
    static { this.ɵfac = function WidgetComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || WidgetComponent)(i0.ɵɵdirectiveInject(i1.WidgetService), i0.ɵɵdirectiveInject(i2.HttpClient), i0.ɵɵdirectiveInject(i3.DataProviderService), i0.ɵɵdirectiveInject(i4.NgbModal), i0.ɵɵdirectiveInject(i3.PermissionService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.EntityService), i0.ɵɵdirectiveInject(i3.ApiService), i0.ɵɵdirectiveInject(i5.DndDraggableDirective, 8), i0.ɵɵdirectiveInject(i3.EmbedService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: WidgetComponent, selectors: [["xf-widget"]], viewQuery: function WidgetComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5, ViewContainerRef);
            i0.ɵɵviewQuery(DndHandleDirective, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.viewContainer = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dndHandle = _t.first);
        } }, inputs: { config: "config", widgetData: "widgetData", context: "context", mode: "mode", widgetClass: "widgetClass", showLayoutControls: "showLayoutControls", updateHeight: "updateHeight", widgetId: "widgetId" }, outputs: { edit: "edit", clone: "clone", delete: "delete" }, features: [i0.ɵɵProvidersFeature([DndDraggableDirective]), i0.ɵɵNgOnChangesFeature], decls: 3, vars: 3, consts: [["widgetHolder", ""], [3, "class", "ngClass", 4, "ngIf"], [4, "ngIf"], [3, "ngClass"], ["class", "card-header", 4, "ngIf"], [1, "", 3, "ngClass"], [1, "card-overlay"], [1, "card-header"], [1, "row"], [1, "col", "d-flex"], ["class", "fa fa-grip-horizontal fa-light align-self-center cursor-move margin-right-8px", "role", "grab", "dndHandle", "", 4, "ngIf"], [1, "pt-2", "pb-2", "mb-0", "container-title-font"], ["class", "col d-flex justify-content-end gap-2", 4, "ngIf"], ["role", "grab", "dndHandle", "", 1, "fa", "fa-grip-horizontal", "fa-light", "align-self-center", "cursor-move", "margin-right-8px"], [1, "col", "d-flex", "justify-content-end", "gap-2"], ["class", "btn btn-secondary btn-xs", 3, "click", 4, "ngIf"], ["type", "button", "class", "btn btn-danger btn-xs", 3, "click", 4, "ngIf"], ["type", "button", 1, "btn", "btn-primary", "btn-xs", 3, "click"], [1, "fa-light", "fa", "fa-pencil"], [1, "btn", "btn-secondary", "btn-xs", 3, "click"], [1, "fa", "fa-clone"], ["type", "button", 1, "btn", "btn-danger", "btn-xs", 3, "click"], [1, "fa-light", "fa", "fa-trash"], [1, "alert", "alert-warning"], ["class", "btn btn-link", 3, "click", 4, "ngIf"], ["class", "import-log", 4, "ngIf"], [1, "fa", "fa-spin", "fa-spinner"], [1, "btn", "btn-link", 3, "click"], [1, "import-log"], [3, "innerHTML"], ["href", ".", 1, "btn", "btn-link", "d-inline", 3, "click"]], template: function WidgetComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, WidgetComponent_div_0_Template, 6, 11, "div", 1)(1, WidgetComponent_div_1_Template, 7, 3, "div", 2)(2, WidgetComponent_div_2_Template, 7, 1, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", !(ctx.widget == null ? null : ctx.widget.publishing) && !ctx.reloadRequired);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.widget == null ? null : ctx.widget.publishing);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !(ctx.widget == null ? null : ctx.widget.publishing) && ctx.reloadRequired);
        } }, dependencies: [i6.NgClass, i6.NgIf, i5.DndHandleDirective], styles: [".widget[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]   .menu[_ngcontent-%COMP%]{visibility:hidden}.widget[_ngcontent-%COMP%]   .card[_ngcontent-%COMP%]:hover   .menu[_ngcontent-%COMP%]{visibility:visible}.widget[_ngcontent-%COMP%]   .editing[_ngcontent-%COMP%]   .card-body[_ngcontent-%COMP%]{max-height:200px;position:relative;overflow:hidden}.widget[_ngcontent-%COMP%]   .editing[_ngcontent-%COMP%]   .card-body[_ngcontent-%COMP%]   .card-overlay[_ngcontent-%COMP%]{position:absolute;top:0;left:0;width:100%;height:200px;z-index:2;background-color:#fff0;background-image:linear-gradient(rgba(255,255,255,0),rgba(255,255,255,0) 100px,var(--card-header-bg-color));background-repeat:no-repeat}.widget[_ngcontent-%COMP%]   .dropdown-toggle[_ngcontent-%COMP%]:after{display:none}.widget[_ngcontent-%COMP%]   pre[_ngcontent-%COMP%]{white-space:pre-wrap;max-width:500px}.no-border[_ngcontent-%COMP%]{background-color:var(--card-bg-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(WidgetComponent, [{
        type: Component,
        args: [{ selector: 'xf-widget', providers: [DndDraggableDirective], changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"{{widgetClass}} transitions-bottom-linear widget\"\n  [ngClass]=\"[(widgetConfig?.showBorder || mode !== 'view') ? 'card': 'no-border', mode === 'edit' ? 'editing': '']\"\n  *ngIf=\"!widget?.publishing && !reloadRequired\">\n  <div class=\"card-header\" *ngIf=\"(widgetConfig?.showBorder && widgetConfig?.title !== '') || mode === 'edit'\">\n    <div class=\"row\">\n      <div class=\"col d-flex\">\n        <span *ngIf=\"mode === 'edit' && showLayoutControls\"\n          class=\"fa fa-grip-horizontal fa-light align-self-center cursor-move margin-right-8px\" role=\"grab\"\n          dndHandle></span>\n        <h5 class=\"pt-2 pb-2 mb-0 container-title-font\">{{ widgetConfig?.title }}</h5>\n      </div>\n      <div class=\"col d-flex justify-content-end gap-2\" *ngIf=\"mode !== 'view'\">\n        <button class=\"btn btn-secondary btn-xs\" (click)=\"clone.emit(widgetConfig)\" *ngIf=\"showLayoutControls\">\n          <i class=\"fa fa-clone\"></i>\n        </button>\n        <button type=\"button\" class=\"btn btn-danger btn-xs\" *ngIf=\"showLayoutControls\"\n          (click)=\"delete.emit(widgetConfig)\">\n          <i class=\"fa-light fa fa-trash\"></i>\n        </button>\n        <button type=\"button\" class=\"btn btn-primary btn-xs\" (click)=\"openEditModal()\">\n          <i class=\"fa-light fa fa-pencil\"></i>\n        </button>\n      </div>\n    </div>\n  </div>\n  <div class=\"\" [ngClass]=\"{'card-body p-0': widgetConfig?.showBorder}\">\n    <div class=\"card-overlay\"></div>\n    <div #widgetHolder></div>\n  </div>\n</div>\n<div *ngIf=\"widget?.publishing\">\n  <div class=\"card-header\">\n    <div class=\"alert alert-warning\">\n      The widget \"{{ widget?.name }}\" is publishing.\n      <a class=\"btn btn-link\" (click)=\"logExpanded = !logExpanded\" *ngIf=\"widgetPermission.indexOf('update') > -1\">Show Build Log</a>\n      <pre class=\"import-log\" *ngIf=\"widgetPermission.indexOf('update') > -1 && logExpanded\">\n        <div [innerHTML]=\"buildLogHtml\"></div>\n      </pre>\n      <i class=\"fa fa-spin fa-spinner\"></i>\n    </div>\n  </div>\n</div>\n<div *ngIf=\"!widget?.publishing && reloadRequired\">\n  <div class=\"card-header\">\n    <div class=\"alert alert-warning\">\n      There is an updated version of the \"{{ widget?.name }}\" widget available.\n      <a (click)=\"reload()\" href=\".\" class=\"btn btn-link d-inline\">Refresh page</a> to see changes.\n    </div>\n  </div>\n</div>\n", styles: [".widget .card .menu{visibility:hidden}.widget .card:hover .menu{visibility:visible}.widget .editing .card-body{max-height:200px;position:relative;overflow:hidden}.widget .editing .card-body .card-overlay{position:absolute;top:0;left:0;width:100%;height:200px;z-index:2;background-color:#fff0;background-image:linear-gradient(rgba(255,255,255,0),rgba(255,255,255,0) 100px,var(--card-header-bg-color));background-repeat:no-repeat}.widget .dropdown-toggle:after{display:none}.widget pre{white-space:pre-wrap;max-width:500px}.no-border{background-color:var(--card-bg-color)}\n"] }]
    }], () => [{ type: i1.WidgetService }, { type: i2.HttpClient }, { type: i3.DataProviderService }, { type: i4.NgbModal }, { type: i3.PermissionService }, { type: i0.ChangeDetectorRef }, { type: i3.EntityService }, { type: i3.ApiService }, { type: i5.DndDraggableDirective, decorators: [{
                type: Optional
            }] }, { type: i3.EmbedService }], { config: [{
            type: Input
        }], widgetData: [{
            type: Input
        }], context: [{
            type: Input
        }], edit: [{
            type: Output
        }], clone: [{
            type: Output
        }], delete: [{
            type: Output
        }], mode: [{
            type: Input
        }], widgetClass: [{
            type: Input
        }], showLayoutControls: [{
            type: Input
        }], updateHeight: [{
            type: Input
        }], widgetId: [{
            type: Input
        }], viewContainer: [{
            type: ViewChild,
            args: ['widgetHolder', { read: ViewContainerRef }]
        }], dndHandle: [{
            type: ViewChild,
            args: [DndHandleDirective]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(WidgetComponent, { className: "WidgetComponent", filePath: "src/widgets/widget/widget.component.ts", lineNumber: 24 }); })();
//# sourceMappingURL=data:application/json;base64,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