import * as i0 from '@angular/core';
import { Injectable, inject, ChangeDetectorRef, Component, ChangeDetectionStrategy, Input, ViewChild, EventEmitter, Output, NgModule, forwardRef } from '@angular/core';
import { Subject, of, concatMap, map, isObservable, switchMap, first, catchError, forkJoin, combineLatest, throwError } from 'rxjs';
import * as _ from 'lodash-es';
import ___default, { keys, isBoolean, merge, difference, findIndex, isUndefined, values, isArray } from 'lodash-es';
import * as i1$1 from 'shared';
import { EntityService, Query, Filter, DEFAULT_GRID_ROWS, FilterGroup, OPERATOR_MAPPINGS, SystemSettingsService, ApiService, DatetimeGridFilterComponent, DatetimeFloatingFilterComponent, LookupGridFilterComponent, LookupFloatingFilterComponent, FIXED_MODULE, Tag, ALL_RECORDS_SIZE, ViewContainerDirective, ModalService, DEFAULT_CACHE_BLOCK_SIZE, ButtonGroupModule, UtilityModule, SORT_ORDER, Entity, SearchableItem, AddRecordComponent, API, PlaybookService, QueryFiltersModule, SearchableDropdownModule, VIEW_TEMPLATES } from 'shared';
import * as i1 from '@angular/common/http';
import * as i1$2 from '@angular/common';
import { DatePipe, CommonModule } from '@angular/common';
import { TranslocoService } from '@jsverse/transloco';
import * as i3 from 'ag-grid-angular';
import { AgGridAngular, AgGridModule } from 'ag-grid-angular';
import { ToastrService } from 'ngx-toastr';
import { LicenseManager } from 'ag-grid-enterprise';
import * as i2 from '@angular/forms';
import { NG_VALUE_ACCESSOR, Validators, FormControl, FormsModule, ReactiveFormsModule } from '@angular/forms';
import * as i4 from 'ngx-drag-drop';
import { DndModule } from 'ngx-drag-drop';
import { AbstractWidgetEditComponent, AbstractWidgetComponent, WidgetConfig } from 'shared/view-templates';
import { plainToInstance } from 'class-transformer';
import * as i4$1 from '@angular/router';
import { RouterModule } from '@angular/router';
import { map as map$1, catchError as catchError$1, concatMap as concatMap$1, toArray } from 'rxjs/operators';
import * as i2$1 from '@ng-bootstrap/ng-bootstrap';
import { NgbDropdownModule } from '@ng-bootstrap/ng-bootstrap';

class GridReferenceService {
    constructor() {
        this.refreshSub = new Subject();
        this.refresh$ = this.refreshSub.asObservable();
        this.setSelectedRowsSub = new Subject();
        this.setSelectedRows$ = this.setSelectedRowsSub.asObservable();
    }
    refresh() {
        this.refreshSub.next(true);
    }
    setSelectedRows(rows) {
        this.setSelectedRowsSub.next(rows);
    }
    static { this.ɵfac = function GridReferenceService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridReferenceService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GridReferenceService, factory: GridReferenceService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridReferenceService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();

class GridDataSourceService {
    constructor(http, apiService, dateService, getEndPathNamePipe) {
        this.http = http;
        this.apiService = apiService;
        this.dateService = dateService;
        this.getEndPathNamePipe = getEndPathNamePipe;
        this.entityService = inject(EntityService);
    }
    getDataSource(entity, baseQuery, dataInterceptor, alwaysIncludeColList = [], treeFilterField) {
        let subscription;
        return {
            getRows: (params) => {
                params.api.hideOverlay();
                const availableFieldNames = entity.attributes.filter((field) => field.gridColumn).map((field) => field.name);
                const visibleColIds = params.api.getAllDisplayedColumns().map((col) => col.getColId());
                const visibleColumnFields = availableFieldNames.filter((fieldName) => visibleColIds.indexOf(fieldName) > -1 || alwaysIncludeColList.indexOf(fieldName) > -1);
                let defaultQuery = ___default.cloneDeep(baseQuery);
                if (treeFilterField) { // for treedata
                    if (!defaultQuery) {
                        defaultQuery = new Query();
                    }
                    let parentId = null;
                    if (params.request.groupKeys.length > 0) {
                        parentId = this.getEndPathNamePipe.transform(params.request.groupKeys.slice(-1)[0]);
                    }
                    defaultQuery?.filters.push(new Filter(treeFilterField, 'eq', parentId));
                }
                subscription = this.loadRows(entity, params.request, defaultQuery, visibleColumnFields).subscribe((response) => {
                    let modifiedData = dataInterceptor ? dataInterceptor(response['hydra:member']) : response['hydra:member'];
                    params.success({
                        rowData: this.loadLookupData(modifiedData, entity),
                        rowCount: response['hydra:totalItems']
                    });
                    if (params.api.paginationGetRowCount() === 0) {
                        params.api.showNoRowsOverlay();
                    }
                });
            },
            selectedRows: [],
            destroy: () => {
                subscription?.unsubscribe();
            },
            entity: entity
        };
    }
    loadLookupData(rows, entity) {
        let lookupFields = entity.attributes.filter((field) => field.formType === 'lookup');
        rows.forEach((row) => {
            lookupFields.forEach((field) => {
                // convert lookups to observables
                const uuid = row[field.name];
                if (!uuid) {
                    row[field.name] = of(field.blankDisplay || '');
                    return;
                }
                row[field.name] = this.entityService.build(field.dataSource.model).pipe(concatMap((subEntity) => this.entityService.getRecordDisplay(subEntity, uuid)));
            });
        });
        // Free up memory
        this.entityService.clearDisplayCache(true);
        return rows;
    }
    getDatasourceByParams(entity, queryParams) {
        let subscription;
        return {
            getRows: (params) => {
                params.api.hideOverlay();
                subscription = this.apiService.getList(entity, undefined, queryParams)
                    .subscribe((rowData) => {
                    params.success({
                        rowData: rowData,
                        // rowCount: 50
                    });
                    if (rowData.length === 0) {
                        params.api.showNoRowsOverlay();
                    }
                });
            },
            selectedRows: [],
            destroy: () => {
                subscription?.unsubscribe();
            },
            entity: entity
        };
    }
    getDatasourceByCustomRequest(request = { url: '', type: 'GET', body: {} }, queryParams, entity, dataInterceptor) {
        let subscription;
        return {
            getRows: (params) => {
                let request$ = request.type === 'GET' ? this.http.get(request.url, { params: queryParams }) : this.http.post(request.url, request.body, { params: queryParams });
                subscription = request$.subscribe((response) => {
                    let modifiedData = dataInterceptor ? dataInterceptor(response['hydra:member']) : response['hydra:member'];
                    params.success({
                        rowData: modifiedData,
                        rowCount: response['hydra:totalItems']
                    });
                });
            },
            selectedRows: [],
            destroy: () => {
                subscription?.unsubscribe();
            },
            entity: entity
        };
    }
    loadRows(entity, request, baseQuery, availableFieldNames = []) {
        let queryParams = {};
        queryParams.offset = request.startRow || 0;
        queryParams.limit = (request.endRow || DEFAULT_GRID_ROWS) - queryParams.offset;
        const query = this.convertAgGridQueryToQueryApi(request.filterModel, request.sortModel, request.groupKeys);
        let fullQuery;
        if (baseQuery) {
            fullQuery = {
                filters: [],
                logic: 'AND'
            };
            if (query.filters.length > 0) {
                fullQuery.filters.push(query.getQueryObject());
            }
            if (baseQuery.filters.length > 0) {
                fullQuery.filters.push(baseQuery.getQueryObject());
            }
            if (query.sort.length) {
                fullQuery.sort = query.sort;
            }
        }
        else {
            fullQuery = query.getQueryObject();
        }
        if (availableFieldNames.length > 0) {
            // UUID is required
            availableFieldNames.push('uuid');
            availableFieldNames = ___default.uniq(availableFieldNames);
            fullQuery.fields = availableFieldNames;
        }
        if (!fullQuery.sort?.length && entity.defaultSort?.length) {
            fullQuery.sort = entity.defaultSort;
        }
        if (!fullQuery.sort?.length) {
            console.warn(`${entity.title} does not have a default sort specified - this could cause infinite loops.`);
        }
        return this.apiService.query(entity, fullQuery, queryParams).pipe(map((response) => {
            return response;
        }));
    }
    convertAgGridQueryToQueryApi(filterModel, sortModel, groupKeys) {
        let query = new Query();
        keys(filterModel).forEach((fieldName) => {
            let fieldValue = filterModel[fieldName];
            if (fieldName === 'ag-Grid-AutoColumn') {
                if (groupKeys.length > 0) {
                    return; // remove tree column filter while expanding any node.
                }
                fieldName = 'name'; //TODO: this was for the Tree node column filter. mostly it will be name. Handle this gracefully.
            }
            let filter;
            if (fieldValue.type === 'blank') {
                filter = new Filter(fieldName, 'isnull', true);
            }
            else if (fieldValue.type === 'notBlank') {
                filter = new Filter(fieldName, 'isnull', false);
            }
            else if (fieldValue.filterType === 'boolean') {
                // Special boolean case
                if (fieldValue.filter === 'any') {
                    return;
                }
                filter = new Filter(fieldName, 'eq', fieldValue.filter);
            }
            else if (fieldValue.filterType === 'date' && fieldValue.filter) {
                filter = this.dateService.buildDateFilterGroup(fieldValue.filter, fieldName);
            }
            else if (fieldValue.filterType === 'set') {
                if (isBoolean(fieldValue.values[0])) {
                    filter = new Filter(fieldName, 'eq', fieldValue.values[0]);
                }
                else {
                    filter = new Filter(fieldName, 'in', fieldValue.values);
                }
            }
            else if (fieldValue.type === 'inRange') {
                filter = new FilterGroup([
                    new Filter(fieldName, 'lte', fieldValue.filterTo),
                    new Filter(fieldName, 'gte', fieldValue.filter)
                ], 'AND');
            }
            else if (fieldValue.filter) {
                let operator = OPERATOR_MAPPINGS[fieldValue.type] || 'eq';
                filter = new Filter(fieldName, operator, fieldValue.filter);
            }
            else {
                return;
            }
            query.filters.push(filter);
        });
        sortModel.forEach((sortModelItem) => {
            let fieldName = sortModelItem.colId;
            if (fieldName === 'ag-Grid-AutoColumn') {
                if (groupKeys.length > 0) {
                    return; // remove tree column filter while expanding any node.
                }
                fieldName = 'name'; //TODO: this was for the Tree node column filter. mostly it will be name. Handle this gracefully.
            }
            query.sort.push({
                field: fieldName,
                direction: sortModelItem.sort === 'asc' ? 'ASC' : 'DESC'
            });
        });
        return query;
    }
    static { this.ɵfac = function GridDataSourceService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridDataSourceService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i1$1.ApiService), i0.ɵɵinject(i1$1.DateService), i0.ɵɵinject(i1$1.GetEndPathNamePipe)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GridDataSourceService, factory: GridDataSourceService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridDataSourceService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i1$1.ApiService }, { type: i1$1.DateService }, { type: i1$1.GetEndPathNamePipe }], null); })();

function TagsCellRendererComponent_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 2);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const tag_r1 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(tag_r1);
} }
class TagsCellRendererComponent {
    constructor() {
        this.changeDetectorRef = inject(ChangeDetectorRef);
        this.tagTooltip = '';
    }
    agInit(params) {
        this.params = params;
        this.tagTooltip = this.params.value.toString();
    }
    refresh(params) {
        this.agInit(params);
        return true;
    }
    ngOnDestroy() {
        this.subscription?.unsubscribe();
    }
    static { this.ɵfac = function TagsCellRendererComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TagsCellRendererComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TagsCellRendererComponent, selectors: [["tags-cell-renderer"]], decls: 2, vars: 2, consts: [[1, "lh-1", "my-1", "line-clamp-1", "mw-fit-content", 3, "title"], ["class", "tag-chip", 4, "ngFor", "ngForOf"], [1, "tag-chip"]], template: function TagsCellRendererComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, TagsCellRendererComponent_span_1_Template, 2, 1, "span", 1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("title", ctx.tagTooltip);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.params.value);
        } }, dependencies: [i1$2.NgForOf], encapsulation: 2, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TagsCellRendererComponent, [{
        type: Component,
        args: [{
                selector: 'tags-cell-renderer',
                template: '<div class="lh-1 my-1 line-clamp-1 mw-fit-content" [title]="tagTooltip"><span *ngFor="let tag of params.value" class="tag-chip">{{tag}}</span></div>',
                changeDetection: ChangeDetectionStrategy.OnPush,
            }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TagsCellRendererComponent, { className: "TagsCellRendererComponent", filePath: "src/cell-renderers/tags-cell-renderer.component.ts", lineNumber: 11 }); })();

class TextObservableCellRendererComponent {
    constructor() {
        this.value = '';
        this.changeDetectorRef = inject(ChangeDetectorRef);
    }
    agInit(params) {
        this.params = params;
        if (isObservable(params.value)) {
            this.subscription = params.value?.subscribe((value) => {
                this.value = value;
                this.changeDetectorRef.detectChanges();
            });
        }
        else {
            this.value = params.valueFormatted || params.value;
        }
    }
    refresh(params) {
        this.agInit(params);
        return true;
    }
    ngOnDestroy() {
        this.subscription?.unsubscribe();
    }
    static { this.ɵfac = function TextObservableCellRendererComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TextObservableCellRendererComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TextObservableCellRendererComponent, selectors: [["text-observable-cell-renderer"]], decls: 2, vars: 1, template: function TextObservableCellRendererComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "span");
            i0.ɵɵtext(1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.value);
        } }, encapsulation: 2, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextObservableCellRendererComponent, [{
        type: Component,
        args: [{
                selector: 'text-observable-cell-renderer',
                template: '<span>{{value}}</span>',
                changeDetection: ChangeDetectionStrategy.OnPush,
            }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TextObservableCellRendererComponent, { className: "TextObservableCellRendererComponent", filePath: "src/cell-renderers/text-observable-cell-renderer.component.ts", lineNumber: 11 }); })();

class GridColumnService {
    constructor() {
        this.systemSettingsService = inject(SystemSettingsService);
        this.entityService = inject(EntityService);
        this.apiService = inject(ApiService);
        this.datePipe = inject(DatePipe);
    }
    create(fields, query = new Query(), columns = [], useUserPrefColumns = true, customColDefs = [], defaultSort = []) {
        let columnDefinitions = [];
        let columnList = {};
        let columnOrder = [];
        _.forEach(columns, (column) => {
            let field = fields[column.name];
            let customColDef = customColDefs.find((colDef) => colDef.field === column.name);
            if ((field && !field.isRelationship) || customColDef) {
                columnOrder.push(column.name);
                let _columnDef = customColDef || this.getColumnDefinition(field, column);
                columnList[column.name] = _columnDef;
                columnDefinitions.push(_columnDef);
            }
        });
        // _.forEach(fields, (field: Field) => {
        //   let tempField = cloneDeep(field);
        //   if (tempField && !columnList[tempField.name] && !tempField.isRelationship && ((_.isUndefined(tempField.visibility) || tempField.visibility))) {
        //     if (useUserPrefColumns && columnOrder.length > 0) {
        //       tempField.gridColumn = false;
        //       let columnVisible = _.find(columnOrder, (columnName: string) => { return columnName === tempField.name })
        //       if (columnVisible) {
        //         tempField.gridColumn = true;
        //       }
        //     }
        //     columnDefinitions.push(
        //       this.getColumnDefinition(tempField, new GridColumn({ name: tempField.name }))
        //     );
        //   }
        // });
        columnOrder = _.compact(columnOrder.length > 0 ? columnOrder : _.map(columnDefinitions.filter((definition) => {
            return !definition.hide;
        }), 'field'));
        columnDefinitions = _.sortBy(columnDefinitions, 'title');
        if (query.sort.length > 0) {
            this.setSort(columnDefinitions, query.sort);
        }
        else if (defaultSort) {
            this.setSort(columnDefinitions, defaultSort);
        }
        let orderedColumns = this.orderColumns(columnDefinitions, columnOrder);
        //if (!skipCheckboxes) {
        // orderedColumns.unshift({
        //   headerName: '',
        //   field: 'checkbox',
        //   sortable: false,
        //   resizable: false,
        //   pinned: true,
        //   cellRendererParams: {
        //     suppressCellClick: true
        //   },
        //   suppressHeaderFilterButton: true,
        //   suppressHeaderMenuButton: true,
        //   suppressSizeToFit: true,
        //   floatingFilter: false,
        //   width: 40,
        //   suppressMovable: true,
        //   lockPosition: true,
        //   lockVisible: true,
        //   headerCheckboxSelection: true,
        //   checkboxSelection: true,
        //   showDisabledCheckboxes: true,
        // });
        //}
        return orderedColumns;
    }
    orderColumns(columnsToOrder, orderedColumnNames = []) {
        let sortedColumns = [];
        _.forEach(orderedColumnNames, (columnName) => {
            columnsToOrder.forEach((column) => {
                if (column.field === columnName) {
                    sortedColumns.push(column);
                }
            });
        });
        let extraColumns = _.difference(columnsToOrder, sortedColumns);
        extraColumns = _.sortBy(extraColumns, 'field');
        return _.concat(sortedColumns, extraColumns);
    }
    getColumnDefinition(field, column) {
        let _columnVisible = this.getColumnVisibility(field, column);
        const formTypeMap = {
            datetime: 'dateColumn',
            text: null,
            textarea: null,
            richtext: null,
            number: 'numberColumn',
            lookup: 'lookupColumn',
            select: 'selectColumn',
            tags: 'tagsColumn',
            checkbox: null
        };
        const cellDataTypeMap = {
            datetime: 'date',
            text: null,
            textarea: null,
            richtext: null,
            select: 'select',
            // lookup: 'lookup',
            checkbox: 'boolean'
        };
        const nonSortableTypes = ['tags'];
        let colDef = _.extend({
            hide: !_columnVisible,
            headerName: field.title,
            field: field.name,
            type: formTypeMap[field.formType],
            cellDataType: cellDataTypeMap[field.formType],
            editable: _.isUndefined(column.editable) ? false : column.editable,
            resizable: _.isUndefined(column.resizable) ? true : column.resizable,
            sortable: _.isUndefined(column.sortable) ? nonSortableTypes.indexOf(field.formType) === -1 : column.sortable,
            tooltipValueGetter: _.isUndefined(column.tooltipValueGetter) ? null : column.tooltipValueGetter,
            filterParams: _.isUndefined(column.filterParams) ? {} : column.filterParams,
            mainMenuItems: this.getMainMenuItems(column.sortable),
            suppressHeaderFilterButton: true,
            // refData: field.mapping,
            headerComponentParams: {
                field: field
            }
        }, field.defaultColDef || {});
        if (!_.isUndefined(column.cellRenderer)) {
            colDef.cellRenderer = column.cellRenderer;
        }
        if (!_.isUndefined(column.cellRendererParams)) {
            colDef.cellRendererParams = column.cellRendererParams;
        }
        if (field.formType === 'lookup') {
            colDef.cellRenderer = TextObservableCellRendererComponent;
        }
        if (field.formType === 'tags') {
            colDef.cellRenderer = TagsCellRendererComponent;
            colDef.wrapText = true;
            colDef.autoHeight = true;
        }
        if (colDef.sortable) {
            colDef.sort = _.isUndefined(column.sort) ? null : column.sort;
        }
        if (!_.isUndefined(column.width)) {
            colDef.width = column.width;
        }
        // if (_column.editable) {
        //   _column.cellEditRenderer = field.fieldComponent;
        // }
        // if (_column.enableFiltering) {
        //   let filterComponent = field.type === 'string' ? field.fieldComponent : InputFieldComponent;
        //   _column.filterCompoment = filterComponent;
        //   let _fieldOptions = new FieldOptions();
        //   _fieldOptions.showLabel = false;
        //   field.validation.required = false;
        //   _column.filterComponentParams = {
        //     field: field,
        //     fieldOptions: _fieldOptions,
        //     fieldClass: field.formType === 'picklist' ? 'form-select-xs grid-picklist' : 'form-control-xs'
        //   }
        // }
        return colDef;
    }
    setSort(columns, sort = []) {
        sort.forEach((sortItem) => {
            const _foundIndex = _.findIndex(columns, (column) => {
                return column.field === sortItem.field;
            });
            if (_foundIndex !== -1) {
                columns[_foundIndex].sort = sortItem.direction.toLowerCase();
            }
        });
    }
    getColumnVisibility(field, column) {
        if (_.isUndefined(column.visible)) {
            return field.gridColumn;
        }
        else {
            return column.visible;
        }
    }
    getMainMenuItems(sortable = true) {
        const sortMenuItems = sortable ? ['sortAscending', 'sortDescending', 'sortUnSort', 'separator'] : [];
        return [...sortMenuItems, 'columnChooser', 'separator', 'pinSubMenu', 'separator', 'autoSizeThis', 'autoSizeAll', 'separator', 'resetColumns'];
    }
    getColumns(columns, visibleColumns = []) {
        let gridColumns = [];
        columns.forEach((column) => {
            gridColumns.push(new GridColumn({
                name: column,
                visible: visibleColumns.length === 0 || visibleColumns.indexOf(column) > -1
            }));
        });
        return gridColumns;
    }
    getDefaultColumnTypes() {
        return {
            numberColumn: { width: 130, filter: 'agNumberColumnFilter' },
            dateColumn: {
                filter: DatetimeGridFilterComponent,
                filterParams: {},
                floatingFilterComponent: DatetimeFloatingFilterComponent,
                suppressFloatingFilterButton: true,
                suppressHeaderFilterButton: true
            },
            lookupColumn: {
                filter: LookupGridFilterComponent,
                filterParams: {},
                suppressFiltersToolPanel: true,
                floatingFilterComponent: LookupFloatingFilterComponent,
                suppressFloatingFilterButton: true,
                suppressHeaderFilterButton: true
            },
            selectColumn: {
                filter: 'agSetColumnFilter',
                filterParams: {
                    suppressMiniFilter: true,
                    keyCreator: (params) => params.value.value,
                    valueFormatter: (params) => params.value.label,
                    values: (params) => {
                        let options = params.colDef.headerComponentParams.field.dataSource.options || [];
                        params.success(options);
                    }
                }
            },
            tagsColumn: {
                filter: 'agSetColumnFilter',
                filterParams: {
                    values: (params) => {
                        let tagsBaseUrl = params.column.getColDef().headerComponentParams?.field.baseUrl;
                        this.entityService.build(FIXED_MODULE.TAGS).pipe(switchMap((tagsEntity) => {
                            tagsEntity.baseUrl = tagsBaseUrl;
                            return this.apiService.getList(tagsEntity, Tag, {
                                limit: ALL_RECORDS_SIZE
                            });
                        }), map((results) => {
                            let options = results.map((tag) => tag.name);
                            params.success(options);
                        })).subscribe();
                    }
                },
            }
        };
    }
    getDefaultDataTypeDefinitions() {
        let systemSettings = this.systemSettingsService.get();
        return {
            date: {
                baseDataType: 'date',
                extendsDataType: 'date',
                valueParser: params => {
                    if (!params.newValue) {
                        return null;
                    }
                    return new Date(params.newValue);
                },
                valueFormatter: (params) => {
                    if (!params.value) {
                        return '';
                    }
                    let date = new Date(params.value);
                    let dateString = this.datePipe.transform(date, systemSettings.preferences.dateTimeFormat);
                    return dateString || '';
                },
            },
            select: {
                baseDataType: 'text',
                extendsDataType: 'text',
                valueParser: params => {
                    return params.newValue;
                },
                valueFormatter: (params) => {
                    if (params.value && params.colDef.headerComponentParams.field) {
                        let foundValue = params.colDef.headerComponentParams.field.dataSource.options.find((option) => option.value === params.value);
                        return foundValue?.label || params.value;
                    }
                    return params.value;
                }
            }
        };
    }
    getDefaultColumnDef() {
        const loadingStateByEntry = new Map();
        const updateTableState = (params) => {
            loadingStateByEntry.set(params.value, false);
            setTimeout(() => {
                params.api.refreshCells({
                    suppressFlash: true,
                    rowNodes: [params.node],
                    columns: [params.column],
                });
            });
        };
        return {
            filter: 'agTextColumnFilter',
            menuTabs: ['generalMenuTab', 'columnsMenuTab'],
            filterParams: {
                maxNumConditions: 1
            },
            floatingFilter: true,
            cellRenderer: null,
            cellClassRules: {
                'grid-table-cell-loading': (params) => {
                    const mapEntry = loadingStateByEntry.get(params.value);
                    if (mapEntry !== undefined) {
                        return mapEntry;
                    }
                    if (isObservable(params.value)) {
                        loadingStateByEntry.set(params.value, true);
                        params.value.pipe(first()).subscribe({
                            next: () => updateTableState(params),
                            error: () => updateTableState(params),
                        });
                        return true;
                    }
                    return false;
                },
            },
        };
    }
    static { this.ɵfac = function GridColumnService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridColumnService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GridColumnService, factory: GridColumnService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridColumnService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
class GridColumn {
    constructor(params) {
        this.name = '';
        this.resizable = true;
        this.editable = false;
        _.extend(this, params);
    }
}

function LinkCellRendererComponent_button_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 2);
    i0.ɵɵlistener("click", function LinkCellRendererComponent_button_0_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.handleClickEvent()); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.params.value);
} }
function LinkCellRendererComponent_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 3);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.params.blankText);
} }
class LinkCellRendererComponent {
    agInit(params) {
        this.params = params;
    }
    refresh(params) {
        this.agInit(params);
        return true;
    }
    handleClickEvent() {
        this.params.clicked(this.params.data);
    }
    static { this.ɵfac = function LinkCellRendererComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LinkCellRendererComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LinkCellRendererComponent, selectors: [["btn-cell-renderer"]], decls: 2, vars: 2, consts: [["class", "btn btn-link btn-sm px-0", 3, "click", 4, "ngIf"], ["class", "font-size-12px", 4, "ngIf"], [1, "btn", "btn-link", "btn-sm", "px-0", 3, "click"], [1, "font-size-12px"]], template: function LinkCellRendererComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LinkCellRendererComponent_button_0_Template, 2, 1, "button", 0)(1, LinkCellRendererComponent_span_1_Template, 2, 1, "span", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.params.value);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.params.value);
        } }, dependencies: [i1$2.NgIf], encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LinkCellRendererComponent, [{
        type: Component,
        args: [{
                selector: 'btn-cell-renderer',
                template: `
    <button class="btn btn-link btn-sm px-0" (click)="handleClickEvent()" *ngIf="params.value">{{ params.value }}</button>
    <span *ngIf="!params.value" class="font-size-12px">{{ params.blankText }}</span>
  `,
            }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LinkCellRendererComponent, { className: "LinkCellRendererComponent", filePath: "src/cell-renderers/link-cell-renderer.component.ts", lineNumber: 12 }); })();

function CustomGridHeaderComponent_ng_template_0_Template(rf, ctx) { }
class CustomGridHeaderComponent {
    ngOnInit() {
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        this.componentRef = viewContainerRef.createComponent(this.component);
        this.updateComponentData();
    }
    updateComponentData() {
        this.componentRef.instance.componentData$ = this.componentData$;
    }
    static { this.ɵfac = function CustomGridHeaderComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CustomGridHeaderComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CustomGridHeaderComponent, selectors: [["lib-custom-grid-header"]], viewQuery: function CustomGridHeaderComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(ViewContainerDirective, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { component: "component", componentData$: "componentData$" }, decls: 1, vars: 0, consts: [["xfViewContainer", ""]], template: function CustomGridHeaderComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, CustomGridHeaderComponent_ng_template_0_Template, 0, 0, "ng-template", 0);
        } }, dependencies: [i1$1.ViewContainerDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CustomGridHeaderComponent, [{
        type: Component,
        args: [{ selector: 'lib-custom-grid-header', template: "<ng-template xfViewContainer></ng-template>\n" }]
    }], null, { component: [{
            type: Input
        }], componentData$: [{
            type: Input
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: true }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CustomGridHeaderComponent, { className: "CustomGridHeaderComponent", filePath: "src/custom-grid-header/custom-grid-header.component.ts", lineNumber: 11 }); })();

const _c0$2 = a0 => ({ "custom-grid-header": a0 });
const _c1 = () => [];
function GridComponent_div_0_lib_custom_grid_header_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "lib-custom-grid-header", 7);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("component", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent)("componentData$", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderData$);
} }
function GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "button", 10);
    i0.ɵɵlistener("click", function GridComponent_div_0_div_3_ng_container_1_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.refresh()); });
    i0.ɵɵelement(2, "i", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template, 1, 2, "xf-button-group", 12);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) && (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons == null ? null : ctx_r1.gridConfig.options.buttons.length));
} }
function GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", ctx_r1.selectButtons || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template, 1, 2, "xf-button-group", 12);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngIf", ctx_r1.selectButtons == null ? null : ctx_r1.selectButtons.length);
} }
function GridComponent_div_0_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8);
    i0.ɵɵtemplate(1, GridComponent_div_0_div_3_ng_container_1_Template, 4, 1, "ng-container", 9)(2, GridComponent_div_0_div_3_ng_template_2_Template, 1, 1, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const recordSelection_r4 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.selectedRows.length === 0)("ngIfElse", recordSelection_r4);
} }
function GridComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2)(1, "div", 3);
    i0.ɵɵtemplate(2, GridComponent_div_0_lib_custom_grid_header_2_Template, 1, 2, "lib-custom-grid-header", 4)(3, GridComponent_div_0_div_3_Template, 4, 2, "div", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "ag-grid-angular", 6);
    i0.ɵɵlistener("gridReady", function GridComponent_div_0_Template_ag_grid_angular_gridReady_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridReady($event)); })("firstDataRendered", function GridComponent_div_0_Template_ag_grid_angular_firstDataRendered_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onFirstDataRendered($event)); })("gridSizeChanged", function GridComponent_div_0_Template_ag_grid_angular_gridSizeChanged_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridSizeChanged($event)); })("rowDataUpdated", function GridComponent_div_0_Template_ag_grid_angular_rowDataUpdated_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onRowDataUpdated($event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(13, _c0$2, ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.enableSelectMenu);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("w-100 ", ctx_r1.gridClass, "");
    i0.ɵɵproperty("columnDefs", ctx_r1.columnDefs)("gridOptions", ctx_r1.gridOptions)("serverSideDatasource", ctx_r1.dataSource)("selectionColumnDef", ctx_r1.selectionColumnDef)("animateRows", true)("suppressContextMenu", ctx_r1.suppressContextMenu)("overlayNoRowsTemplate", ctx_r1.noRowsTemplate);
} }
class GridComponent {
    constructor(themeService, changeDetectorRef) {
        this.themeService = themeService;
        this.changeDetectorRef = changeDetectorRef;
        this.customColumnDefs = [];
        this.suppressContextMenu = false;
        this.rowSelectionChanged = new EventEmitter();
        this.gridQuery = new Query();
        this.gridColumnService = inject(GridColumnService);
        this.gridReferenceService = inject(GridReferenceService);
        this.modalService = inject(ModalService);
        this.apiService = inject(ApiService);
        this.toasterService = inject(ToastrService);
        this.translocoService = inject(TranslocoService);
        this.datePipe = inject(DatePipe);
        this.contextId = '';
        this.gridClass = 'ag-theme-alpine';
        this.selectedRows = [];
        this.selectButtons = [];
        this.selectionColumnDef = {
            suppressHeaderMenuButton: false,
            pinned: 'left',
        };
        this.columnDefs = [];
        this.currentRowHeight = 0;
        this.minRowHeight = 0;
        this.noRowsTemplate = '';
    }
    onGridReady(params) {
        this.contextId = this.gridConfig.uuid || this.dataSource.entity.type;
        this.gridApi = params.api;
        if (this.gridConfig.options?.onRegisterApi) {
            this.gridConfig.options?.onRegisterApi(this.gridApi);
        }
        this.minRowHeight = params.api.getSizesForCurrentTheme().rowHeight;
        this.currentRowHeight = this.minRowHeight;
        window.onresize = () => {
            this.gridApi.sizeColumnsToFit();
        };
        this.dataSource.selectedRows.forEach((uuid) => {
            const rowNode = this.gridApi.getRowNode(uuid);
            rowNode?.setSelected(true);
        });
        this.gridReferenceService.refresh$.subscribe(() => {
            this.refresh();
        });
    }
    onFirstDataRendered(params) {
        this.updateGridRowsHeight(params);
    }
    onGridSizeChanged(params) {
        this.updateGridRowsHeight(params);
    }
    onRowDataUpdated(params) {
        this.updateGridRowsHeight(params);
    }
    updateGridRowsHeight(params) {
        //Calculate the height of the grid and available parent height to fit all the grid rows scrollable
        if (this.gridConfig.options?.adjustGridRowHeight) {
            let pagingPanel = document.querySelector('.ag-paging-panel');
            let headerPanel = document.querySelector('.ag-header');
            let gridWrapper = document.querySelector('.grid-wrapper');
            let gridActionsContainer = document.querySelector('.grid-actions-container');
            let customGridHeight = 15; //Adjust the extra height
            if (!pagingPanel || !headerPanel || !gridWrapper || !gridActionsContainer) {
                return;
            }
            let gridHeight = gridWrapper.clientHeight - (gridActionsContainer.clientHeight + customGridHeight + pagingPanel.clientHeight + headerPanel.clientHeight);
            let renderedRowCount = params.api.getDisplayedRowCount();
            if (renderedRowCount * this.minRowHeight >= gridHeight) {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + gridHeight + 'px');
            }
            else {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + (renderedRowCount * this.minRowHeight) + 'px');
            }
        }
    }
    ngOnInit() {
        this.columnDefs = this.gridColumnService.create(this.dataSource.entity?.fields, this.gridConfig.configuration.query, this.gridConfig.configuration.columns, false, this.customColumnDefs, this.dataSource.entity.defaultSort);
        this.columnDefs = this.columnDefs.map((colDef) => {
            if (colDef.field === this.gridConfig.configuration.nameColumn) {
                colDef.pinned = 'left';
                colDef.suppressMovable = true;
                colDef.lockPosition = true;
                colDef.lockVisible = true;
            }
            return colDef;
        });
        this.gridOptions = this.mapGridOptions();
        let selectButtons = [];
        if (this.gridConfig.options?.selectButtons?.length) {
            selectButtons = this.gridConfig.options.selectButtons;
        }
        if (this.gridConfig.options?.allowDelete) {
            let deleteButton = this.createDeleteButton();
            selectButtons.push(deleteButton);
        }
        this.selectButtons = selectButtons;
        this.setTheme(this.themeService.getTheme());
        this.themeService.themeChanged.subscribe((theme) => this.setTheme(theme));
        this.noRowsTemplate = `<span>${this.translocoService.translate('errors.error_no_records')}</span>`;
    }
    createDeleteButton() {
        return {
            id: 'delete',
            text: '',
            tooltip: 'Delete',
            iconClass: 'fa fa-trash-can fa-light',
            onClick: () => { this.deleteSelected(); },
            class: 'btn btn-secondary',
            visible: true
        };
    }
    deleteSelected() {
        let entityName = this.selectedRows.length > 1 ? this.dataSource.entity.descriptions.plural : this.dataSource.entity.descriptions.singular;
        this.modalService.confirm(this.translocoService.translate('components.grid.deleteMessage', {
            entityName: `${this.dataSource.entity.descriptions.singular}(s)`
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            let uuids = this.selectedRows.map((row) => row.uuid);
            let observables$ = [];
            uuids.forEach((uuid) => {
                observables$.push(this.apiService.deleteRecord(this.dataSource.entity, uuid).pipe(catchError((error) => {
                    return of(error.error?.errors[0]?.detail);
                })));
            });
            return forkJoin(observables$);
        })).subscribe((responses) => {
            let successfulDeletions = responses.filter((error) => error === null).length;
            const deletionErrors = responses.length - successfulDeletions;
            if (deletionErrors > 0) {
                this.toasterService.warning(this.translocoService.translate('components.grid.partialDeletedToast', {
                    successful: successfulDeletions,
                    errors: deletionErrors,
                    length: this.selectedRows.length,
                    entityName: entityName
                }));
            }
            else {
                this.toasterService.success(this.translocoService.translate('components.grid.deletedToast', {
                    length: this.selectedRows.length, entityName: entityName
                }), 'Success');
            }
            this.gridApi.deselectAll();
            this.selectedRows = [];
            this.rowSelectionChanged.emit(this.selectedRows);
            this.refresh();
        });
    }
    setTheme(theme) {
        this.gridClass = theme === 'dark' ? 'ag-theme-alpine-dark' : 'ag-theme-alpine';
        this.changeDetectorRef.detectChanges();
    }
    mapGridOptions() {
        let columnTypes = this.gridColumnService.getDefaultColumnTypes();
        columnTypes = merge(columnTypes, this.gridConfig.options?.customColumnTypes || {});
        let dataTypeDefinitions = this.gridColumnService.getDefaultDataTypeDefinitions();
        dataTypeDefinitions = merge(dataTypeDefinitions, this.gridConfig.options?.customDataTypeDefinitions || {});
        let processCellCallback = (params) => this.processCellCallback(params);
        let gridOptions = {
            defaultColDef: this.gridColumnService.getDefaultColumnDef(),
            processCellForClipboard: processCellCallback,
            defaultCsvExportParams: {
                processCellCallback: processCellCallback,
            },
            defaultExcelExportParams: {
                processCellCallback: processCellCallback,
            },
            onCellClicked: (event) => {
                if (this.gridConfig.options?.onView && !event.colDef.cellRendererParams?.suppressCellClick) {
                    this.gridConfig.options.onView(event);
                }
            },
            onSelectionChanged: (event) => {
                const selectionState = event.api.getServerSideSelectionState();
                let uuids = [];
                if (selectionState.selectAll) {
                    const allNodes = event.api.getRenderedNodes().map((node) => node.data.uuid) || [];
                    uuids = difference(allNodes, selectionState.toggledNodes);
                }
                else {
                    uuids = selectionState.toggledNodes || [];
                }
                this.selectedRows = event.api.getRenderedNodes().filter((node) => uuids.indexOf(node.data.uuid) > -1).map((node) => node.data);
                this.rowSelectionChanged.emit(this.selectedRows);
                this.changeDetectorRef.detectChanges();
            },
            onDisplayedColumnsChanged: (event) => {
                event.api.refreshServerSide();
                event.api.sizeColumnsToFit();
            },
            rowSelection: {
                mode: 'multiRow',
                enableClickSelection: false,
                headerCheckbox: !this.gridConfig.options?.hideCheckboxes,
                checkboxes: !this.gridConfig.options?.hideCheckboxes,
                hideDisabledCheckboxes: true,
            },
            suppressCellFocus: true,
            suppressMenuHide: false,
            columnMenu: 'new',
            pagination: true,
            paginationPageSize: DEFAULT_GRID_ROWS,
            cacheBlockSize: DEFAULT_CACHE_BLOCK_SIZE,
            enableCellTextSelection: this.gridConfig.options?.enableCellTextSelection,
            columnTypes: columnTypes,
            dataTypeDefinitions: dataTypeDefinitions,
            paginationPageSizeSelector: [10, 20, 50, 100, 250],
            suppressServerSideFullWidthLoadingRow: true
        };
        if (this.gridConfig.options?.expandable) {
            gridOptions.masterDetail = true;
            gridOptions.detailCellRenderer = this.gridConfig.options?.detailCellRenderer;
        }
        if (!this.gridConfig.options?.skipRowId) {
            gridOptions.getRowId = (params) => params.data.uuid;
        }
        gridOptions.treeData = this.gridConfig.options?.treeData;
        gridOptions.isServerSideGroup = this.gridConfig.options?.isServerSideGroup;
        gridOptions.getServerSideGroupKey = this.gridConfig.options?.getServerSideGroupKey;
        gridOptions.autoGroupColumnDef = this.gridConfig.options?.autoGroupColumnDef;
        return gridOptions;
    }
    refresh() {
        this.gridApi.refreshServerSide({ route: [], purge: true });
    }
    processCellCallback(params) {
        if (isObservable(params.value)) {
            return getStoredResolvedObservableValue(params.value) || '';
        }
        return params.value;
    }
    static { this.ɵfac = function GridComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridComponent)(i0.ɵɵdirectiveInject(i1$1.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridComponent, selectors: [["xf-grid"]], viewQuery: function GridComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(AgGridAngular, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.agGrid = _t.first);
        } }, inputs: { dataSource: "dataSource", gridConfig: "gridConfig", customColumnDefs: "customColumnDefs", suppressContextMenu: "suppressContextMenu" }, outputs: { rowSelectionChanged: "rowSelectionChanged" }, features: [i0.ɵɵProvidersFeature([])], decls: 1, vars: 1, consts: [["recordSelection", ""], ["class", "grid-wrapper bg-secondary-panel h-100", 4, "ngIf"], [1, "grid-wrapper", "bg-secondary-panel", "h-100"], [1, "d-flex", "padding-top-16px", "grid-actions-container", "margin-bottom-4px", 3, "ngClass"], [3, "component", "componentData$", 4, "ngIf"], ["class", "grid-actions margin-right-16px ms-auto", 4, "ngIf"], ["rowModelType", "serverSide", 3, "gridReady", "firstDataRendered", "gridSizeChanged", "rowDataUpdated", "columnDefs", "gridOptions", "serverSideDatasource", "selectionColumnDef", "animateRows", "suppressContextMenu", "overlayNoRowsTemplate"], [3, "component", "componentData$"], [1, "grid-actions", "margin-right-16px", "ms-auto"], [4, "ngIf", "ngIfElse"], [1, "btn", "btn-sm", "btn-secondary", "mx-2", "float-end", 3, "click"], [1, "fa", "fa-refresh"], [3, "buttons", 4, "ngIf"], [3, "buttons"]], template: function GridComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, GridComponent_div_0_Template, 5, 15, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.columnDefs && ctx.gridOptions && ctx.dataSource);
        } }, dependencies: [i1$2.NgClass, i1$2.NgIf, i1$1.ButtonGroupComponent, i3.AgGridAngular, CustomGridHeaderComponent], styles: [".grid-expandable-wrapper[_ngcontent-%COMP%]{position:absolute;left:70px;right:0}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper[_ngcontent-%COMP%]   .custom-grid-header[_ngcontent-%COMP%]{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid', changeDetection: ChangeDetectionStrategy.OnPush, providers: [], template: "<div class=\"grid-wrapper bg-secondary-panel h-100\" *ngIf=\"columnDefs && gridOptions && dataSource\">\n  <div class=\"d-flex padding-top-16px grid-actions-container margin-bottom-4px\"\n    [ngClass]=\"{'custom-grid-header' : gridConfig.options?.customGridHeaderComponent}\">\n    <lib-custom-grid-header *ngIf=\"gridConfig.options?.customGridHeaderComponent\"\n      [component]=\"gridConfig.options?.customGridHeaderComponent\"\n      [componentData$]=\"gridConfig.options?.customGridHeaderData$\"></lib-custom-grid-header>\n    <div class=\"grid-actions margin-right-16px ms-auto\" *ngIf=\"gridConfig.options?.enableSelectMenu\">\n      <ng-container *ngIf=\"selectedRows.length === 0; else recordSelection\">\n        <button class=\"btn btn-sm btn-secondary mx-2 float-end\" (click)=\"refresh()\">\n          <i class=\"fa fa-refresh\"></i>\n        </button>\n        <xf-button-group *ngIf=\"gridConfig.options?.buttons && gridConfig.options?.buttons?.length\"\n          [buttons]=\"gridConfig.options?.buttons || []\"></xf-button-group>\n      </ng-container>\n      <ng-template #recordSelection>\n        <xf-button-group *ngIf=\"selectButtons?.length\" [buttons]=\"selectButtons || []\"></xf-button-group>\n      </ng-template>\n    </div>\n  </div>\n  <ag-grid-angular class=\"w-100 {{gridClass}}\" rowModelType=\"serverSide\" [columnDefs]=\"columnDefs\"\n    [gridOptions]=\"gridOptions\" [serverSideDatasource]=\"dataSource\" [selectionColumnDef]=\"selectionColumnDef\"\n    (gridReady)=\"onGridReady($event)\" [animateRows]=\"true\" [suppressContextMenu]=\"suppressContextMenu\"\n    (firstDataRendered)=\"onFirstDataRendered($event)\" (gridSizeChanged)=\"onGridSizeChanged($event)\"\n    (rowDataUpdated)=\"onRowDataUpdated($event)\" [overlayNoRowsTemplate]=\"noRowsTemplate\"></ag-grid-angular>\n</div>\n", styles: [".grid-expandable-wrapper{position:absolute;left:70px;right:0}.grid-wrapper .grid-actions ::ng-deep .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper .grid-actions ::ng-deep .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper .custom-grid-header{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}\n"] }]
    }], () => [{ type: i1$1.ThemeService }, { type: i0.ChangeDetectorRef }], { agGrid: [{
            type: ViewChild,
            args: [AgGridAngular]
        }], dataSource: [{
            type: Input
        }], gridConfig: [{
            type: Input
        }], customColumnDefs: [{
            type: Input
        }], suppressContextMenu: [{
            type: Input
        }], rowSelectionChanged: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridComponent, { className: "GridComponent", filePath: "src/grid.component.ts", lineNumber: 23 }); })();
const valueByObservable = new WeakMap();
function storeResolvedObservableValue(observable, value) {
    valueByObservable.set(observable, value);
}
function getStoredResolvedObservableValue(observable) {
    return valueByObservable.get(observable);
}

class AbstractGridHeaderComponent {
    static { this.ɵfac = function AbstractGridHeaderComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractGridHeaderComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractGridHeaderComponent, selectors: [["ng-component"]], inputs: { componentData$: "componentData$" }, decls: 0, vars: 0, template: function AbstractGridHeaderComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractGridHeaderComponent, [{
        type: Component,
        args: [{
                template: ''
            }]
    }], null, { componentData$: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractGridHeaderComponent, { className: "AbstractGridHeaderComponent", filePath: "src/custom-grid-header/abstract-grid-header.component.ts", lineNumber: 7 }); })();

LicenseManager.setLicenseKey('Using_this_{AG_Grid}_Enterprise_key_{AG-060453}_in_excess_of_the_licence_granted_is_not_permitted___Please_report_misuse_to_legal@ag-grid.com___For_help_with_changing_this_key_please_contact_info@ag-grid.com___{Fortinet,_Inc}_is_granted_a_{Single_Application}_Developer_License_for_the_application_{FortiSOAR}_only_for_{4}_Front-End_JavaScript_developers___All_Front-End_JavaScript_developers_working_on_{FortiSOAR}_need_to_be_licensed___{FortiSOAR}_has_been_granted_a_Deployment_License_Add-on_for_{1}_Production_Environment___This_key_works_with_{AG_Grid}_Enterprise_versions_released_before_{10_July_2025}____[v3]_[01]_MTc1MjEwMjAwMDAwMA==aeb496b95ee09c980700bb247076fcfb');
class GridModule {
    static { this.ɵfac = function GridModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: GridModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            ButtonGroupModule,
            AgGridModule,
            UtilityModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    GridComponent,
                    CustomGridHeaderComponent,
                    TextObservableCellRendererComponent,
                    TagsCellRendererComponent,
                    LinkCellRendererComponent,
                    AbstractGridHeaderComponent
                ],
                imports: [
                    CommonModule,
                    ButtonGroupModule,
                    AgGridModule,
                    UtilityModule,
                ],
                exports: [
                    GridComponent,
                    LinkCellRendererComponent,
                    AbstractGridHeaderComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(GridModule, { declarations: [GridComponent,
        CustomGridHeaderComponent,
        TextObservableCellRendererComponent,
        TagsCellRendererComponent,
        LinkCellRendererComponent,
        AbstractGridHeaderComponent], imports: [CommonModule,
        ButtonGroupModule,
        AgGridModule,
        UtilityModule], exports: [GridComponent,
        LinkCellRendererComponent,
        AbstractGridHeaderComponent] }); })();

const _c0$1 = ["entity", ""];
function GridColumnsEditorComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 5)(1, "div", 6)(2, "span", 7);
    i0.ɵɵelement(3, "i", 8);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "span", 9)(6, "span", 10)(7, "input", 11);
    i0.ɵɵlistener("change", function GridColumnsEditorComponent_div_1_Template_input_change_7_listener($event) { const column_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.changeEditable(column_r2, $event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(8, "i", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "span", 13)(10, "input", 14);
    i0.ɵɵlistener("change", function GridColumnsEditorComponent_div_1_Template_input_change_10_listener($event) { const column_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.changeResizable(column_r2, $event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(11, "i", 15);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(12, "i", 16);
    i0.ɵɵlistener("click", function GridColumnsEditorComponent_div_1_Template_i_click_12_listener() { const fieldIndex_r4 = i0.ɵɵrestoreView(_r1).index; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.removeField(fieldIndex_r4)); });
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const column_r2 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("dndDraggable", column_r2);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", ctx_r2.entity.fields[column_r2.name] ? ctx_r2.entity.fields[column_r2.name].title : column_r2.name, " ");
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("checked", column_r2.editable)("disabled", ctx_r2.entity.fields[column_r2.name] ? !ctx_r2.entity.fields[column_r2.name].writeable : false);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("checked", column_r2.resizable);
} }
class GridColumnsEditorComponent {
    constructor(utilityService, changeDetectorRef) {
        this.utilityService = utilityService;
        this.changeDetectorRef = changeDetectorRef;
        this.value = [];
        this.items = [];
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.column = null;
    }
    writeValue(value) {
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    onDrop(event) {
        const foundIndex = findIndex(this.value, {
            name: event.data.name
        });
        if (foundIndex > -1) {
            let dragColumn = this.value[foundIndex];
            this.value.splice(foundIndex, 1);
            if (dragColumn) {
                this.value.splice(event.index, 0, dragColumn);
            }
        }
    }
    changeResizable(column, event) {
        column.resizable = event.target.checked;
    }
    changeEditable(column, event) {
        column.editable = event.target.checked;
    }
    addField(event) {
        if (event) {
            this.value = isUndefined(this.value) ? [] : this.value;
            this.value?.push(new GridColumn({
                name: event.value.name,
                editable: false,
                resizable: true,
                sticky: 'NONE'
            }));
        }
    }
    removeField(fieldIndex) {
        this.value.splice(fieldIndex, 1);
    }
    filterFields(search) {
        const fieldsAlreadyAdded = this.value?.map((field) => field.name) || [];
        const fields = this.entity?.getFormFields() || this.entity.attributes;
        this.utilityService.filterFields(fields, search, fieldsAlreadyAdded).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function GridColumnsEditorComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridColumnsEditorComponent)(i0.ɵɵdirectiveInject(i1$1.UtilityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridColumnsEditorComponent, selectors: [["xf-grid-columns-editor", "entity", ""]], inputs: { entity: "entity" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => GridColumnsEditorComponent),
                    multi: true
                }])], attrs: _c0$1, decls: 5, vars: 5, consts: [["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card d-inline-block p-2 m-2", 3, "dndDraggable", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Add Column", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "items"], ["dndEffectAllowed", "move", 1, "card", "d-inline-block", "p-2", "m-2", 3, "dndDraggable"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], [1, "ms-3"], [1, "me-2", "p-1", "border-grey"], ["type", "checkbox", 1, "me-2", 3, "change", "checked", "disabled"], ["role", "button", 1, "fa", "fa-light", "fa-edit", "margin-top-4px"], [1, "p-1", "border-grey"], ["type", "checkbox", 1, "me-2", 3, "change", "checked"], ["role", "button", 1, "fa", "fa-light", "fa-left-right", "margin-top-4px"], ["role", "button", 1, "fa", "fa-light", "fa-close", "margin-top-4px", "text-danger", "ms-3", 3, "click"]], template: function GridColumnsEditorComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵlistener("dndDrop", function GridColumnsEditorComponent_Template_div_dndDrop_0_listener($event) { return ctx.onDrop($event); });
            i0.ɵɵtemplate(1, GridColumnsEditorComponent_div_1_Template, 13, 5, "div", 1);
            i0.ɵɵelement(2, "div", 2);
            i0.ɵɵelementStart(3, "div", 3)(4, "xf-searchable-dropdown", 4);
            i0.ɵɵlistener("ngModelChange", function GridColumnsEditorComponent_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { return ctx.addField($event); })("searchQueryChange", function GridColumnsEditorComponent_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { return ctx.filterFields($event); });
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("dndHorizontal", true);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.value);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngModel", ctx.column)("clearValueOnSelect", true)("items", ctx.items);
        } }, dependencies: [i1$2.NgForOf, i2.NgControlStatus, i2.NgModel, i1$1.SearchableDropdownComponent, i4.DndDraggableDirective, i4.DndDropzoneDirective, i4.DndHandleDirective, i4.DndPlaceholderRefDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridColumnsEditorComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-columns-editor[entity]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => GridColumnsEditorComponent),
                        multi: true
                    }], template: "<div class=\"col pb-2\" dndDropzone [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\" (dndDrop)=\"onDrop($event)\">\n  <div *ngFor=\"let column of value; let fieldIndex = index\" [dndDraggable]=\"column\" dndEffectAllowed=\"move\"\n    class=\"card d-inline-block p-2 m-2\">\n    <div class=\"card-title m-0 d-flex\">\n      <span class=\"flex-grow-1\">\n        <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ entity!.fields[column.name] ?\n        entity!.fields[column.name].title : column.name }}\n      </span>\n      <span class=\"ms-3\">\n        <!-- editable options -->\n        <span class=\"me-2 p-1 border-grey\">\n          <input type=\"checkbox\" class=\"me-2\" [checked]=\"column.editable\" (change)=\"changeEditable(column, $event)\"\n            [disabled]=\"entity!.fields[column.name] ? !entity!.fields[column.name].writeable : false\">\n          <i class=\"fa fa-light fa-edit margin-top-4px\" role=\"button\"></i>\n        </span>\n        <span class=\"p-1 border-grey\">\n          <input type=\"checkbox\" class=\"me-2\" [checked]=\"column.resizable\" (change)=\"changeResizable(column, $event)\">\n          <i class=\"fa fa-light fa-left-right margin-top-4px\" role=\"button\"></i>\n        </span>\n\n        <i class=\"fa fa-light fa-close margin-top-4px text-danger ms-3\" role=\"button\"\n          (click)=\"removeField(fieldIndex)\"></i>\n      </span>\n    </div>\n\n  </div>\n  <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n  <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n    <xf-searchable-dropdown (ngModelChange)=\"addField($event)\" [ngModel]=\"column\" [clearValueOnSelect]=\"true\"\n      [items]=\"items\" placeholder=\"+ Add Column\" (searchQueryChange)=\"filterFields($event)\">\n    </xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1$1.UtilityService }, { type: i0.ChangeDetectorRef }], { entity: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridColumnsEditorComponent, { className: "GridColumnsEditorComponent", filePath: "src/widgets/grid-widget/grid-columns-editor/grid-columns-editor.component.ts", lineNumber: 21 }); })();

function DefaultSortComponent_div_1_label_6_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "label", 13)(1, "input", 14);
    i0.ɵɵtwoWayListener("ngModelChange", function DefaultSortComponent_div_1_label_6_Template_input_ngModelChange_1_listener($event) { i0.ɵɵrestoreView(_r2); const sortField_r3 = i0.ɵɵnextContext().$implicit; i0.ɵɵtwoWayBindingSet(sortField_r3.direction, $event) || (sortField_r3.direction = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const order_r4 = ctx.$implicit;
    const ctx_r4 = i0.ɵɵnextContext();
    const sortField_r3 = ctx_r4.$implicit;
    const sortIndex_r6 = ctx_r4.index;
    i0.ɵɵadvance();
    i0.ɵɵpropertyInterpolate1("name", "sort-radio-", sortIndex_r6, "");
    i0.ɵɵtwoWayProperty("ngModel", sortField_r3.direction);
    i0.ɵɵproperty("value", order_r4.value);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("\u00A0", order_r4.label, " ");
} }
function DefaultSortComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 5)(1, "div", 6)(2, "span", 7);
    i0.ɵɵelement(3, "i", 8);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "span", 9);
    i0.ɵɵtemplate(6, DefaultSortComponent_div_1_label_6_Template, 3, 5, "label", 10);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(7, "span", 11)(8, "i", 12);
    i0.ɵɵlistener("click", function DefaultSortComponent_div_1_Template_i_click_8_listener() { const sortIndex_r6 = i0.ɵɵrestoreView(_r1).index; const ctx_r6 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r6.removeField(sortIndex_r6)); });
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const sortField_r3 = ctx.$implicit;
    const ctx_r6 = i0.ɵɵnextContext();
    i0.ɵɵproperty("dndDraggable", sortField_r3);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", ctx_r6.fields[sortField_r3.field].title, " ");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r6.SORT_ORDER);
} }
class DefaultSortComponent {
    constructor(utilityService) {
        this.utilityService = utilityService;
        this.query = new Query();
        this.fields = {};
        this.field = null;
        this.searchableFields = [];
        this.SORT_ORDER = SORT_ORDER;
    }
    ngOnInit() {
    }
    addField(event) {
        if (event !== null) {
            this.query.sort.push({
                direction: 'ASC',
                field: event.uuid
            });
        }
    }
    changed(event, field) {
    }
    onDrop(event) {
        console.log(event);
    }
    removeField(index) {
        this.query.sort.splice(index, 1);
    }
    filterFields(search) {
        const fieldAlreadyAdded = this.query.sort.map((sortOption) => sortOption.field);
        this.utilityService.filterFields(values(this.fields), search, fieldAlreadyAdded).subscribe((items) => {
            this.searchableFields = items;
        });
    }
    static { this.ɵfac = function DefaultSortComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DefaultSortComponent)(i0.ɵɵdirectiveInject(i1$1.UtilityService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DefaultSortComponent, selectors: [["xf-default-sort"]], inputs: { query: "query", fields: "fields" }, decls: 5, vars: 5, consts: [["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card p-2", 3, "dndDraggable", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ ADD SORTING PARAMETER", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "items"], ["dndEffectAllowed", "move", 1, "card", "p-2", 3, "dndDraggable"], [1, "card-title", "m-0", "d-flex"], [1, "col-5", "col-6", "overflow-hidden", "text-overflow"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], [1, "ms-2"], ["class", "me-3", 4, "ngFor", "ngForOf"], [1, "ms-auto"], ["role", "button", 1, "fa", "fa-light", "fa-close", "text-danger", "ms-3", "me-3", 3, "click"], [1, "me-3"], ["type", "radio", 3, "ngModelChange", "ngModel", "value", "name"]], template: function DefaultSortComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵlistener("dndDrop", function DefaultSortComponent_Template_div_dndDrop_0_listener($event) { return ctx.onDrop($event); });
            i0.ɵɵtemplate(1, DefaultSortComponent_div_1_Template, 9, 3, "div", 1);
            i0.ɵɵelement(2, "div", 2);
            i0.ɵɵelementStart(3, "div", 3)(4, "xf-searchable-dropdown", 4);
            i0.ɵɵlistener("ngModelChange", function DefaultSortComponent_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { return ctx.addField($event); })("searchQueryChange", function DefaultSortComponent_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { return ctx.filterFields($event); });
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("dndHorizontal", true);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.query.sort);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngModel", ctx.field)("clearValueOnSelect", true)("items", ctx.searchableFields);
        } }, dependencies: [i1$2.NgForOf, i2.DefaultValueAccessor, i2.RadioControlValueAccessor, i2.NgControlStatus, i2.NgModel, i1$1.SearchableDropdownComponent, i4.DndDraggableDirective, i4.DndDropzoneDirective, i4.DndHandleDirective, i4.DndPlaceholderRefDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DefaultSortComponent, [{
        type: Component,
        args: [{ selector: 'xf-default-sort', template: "<div class=\"col pb-2\" dndDropzone [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\" (dndDrop)=\"onDrop($event)\">\n  <div *ngFor=\"let sortField of query.sort; let sortIndex = index\" [dndDraggable]=\"sortField\" dndEffectAllowed=\"move\"\n    class=\"card p-2\">\n    <div class=\"card-title m-0 d-flex\">\n      <!-- Field title -->\n      <span class=\"col-5 col-6 overflow-hidden text-overflow\">\n        <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ fields[sortField.field].title }}\n      </span>\n      <!-- Order options -->\n      <span class=\"ms-2\">\n        <label class=\"me-3\" *ngFor=\"let order of SORT_ORDER\">\n          <input type=\"radio\" [(ngModel)]=\"sortField.direction\" [value]=\"order.value\" name=\"sort-radio-{{ sortIndex }}\"/>&nbsp;{{order.label}}\n        </label>\n      </span>\n      <!-- Remove  field-->\n      <span class=\"ms-auto\">\n        <i class=\"fa fa-light fa-close text-danger ms-3 me-3\" role=\"button\" (click)=\"removeField(sortIndex)\"></i>\n      </span>\n    </div>\n\n  </div>\n  <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n  <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n    <xf-searchable-dropdown (ngModelChange)=\"addField($event)\" [ngModel]=\"field\" [clearValueOnSelect]=\"true\"\n      [items]=\"searchableFields\" placeholder=\"+ ADD SORTING PARAMETER\" (searchQueryChange)=\"filterFields($event)\">\n    </xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1$1.UtilityService }], { query: [{
            type: Input
        }], fields: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DefaultSortComponent, { className: "DefaultSortComponent", filePath: "src/widgets/grid-widget/default-sort/default-sort.component.ts", lineNumber: 10 }); })();

function GridEditComponent_div_3_option_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 22);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const module_r1 = ctx.$implicit;
    i0.ɵɵproperty("value", module_r1.type);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(module_r1.descriptions.plural);
} }
function GridEditComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Data Source");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 19)(4, "option", 20);
    i0.ɵɵtext(5, "Select a module");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, GridEditComponent_div_3_option_6_Template, 2, 2, "option", 21);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngValue", null);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.formGroup.controls.onlyRelated.value ? ctx_r1.relatedModules : ctx_r1.modules);
} }
function GridEditComponent_div_4_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 23);
    i0.ɵɵtext(2, " Records to Include ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 24)(4, "option", 20);
    i0.ɵɵtext(5, "Related Records");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "option", 20);
    i0.ɵɵtext(7, "All Records");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngValue", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngValue", false);
} }
function GridEditComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, GridEditComponent_div_4_div_1_Template, 8, 2, "div", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.formGroup.controls.onlyRelated);
} }
function GridEditComponent_div_16_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Select Columns");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(3, "xf-grid-columns-editor", 25);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("entity", ctx_r1.selectedEntity);
} }
function GridEditComponent_div_18_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 31)(1, "div", 32)(2, "span", 33);
    i0.ɵɵelement(3, "i", 34);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "span", 35)(6, "i", 36);
    i0.ɵɵlistener("click", function GridEditComponent_div_18_div_6_Template_i_click_6_listener() { const pbIndex_r5 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.removeActionPlaybook(pbIndex_r5)); });
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const playbook_r6 = ctx.$implicit;
    i0.ɵɵproperty("dndDraggable", playbook_r6);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", playbook_r6.name, " ");
} }
function GridEditComponent_div_18_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Actions");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 26)(4, "xf-searchable-dropdown", 27);
    i0.ɵɵlistener("ngModelChange", function GridEditComponent_div_18_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.addActionPlaybook($event)); })("searchQueryChange", function GridEditComponent_div_18_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.filterActionPlaybooks($event)); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "div", 28);
    i0.ɵɵlistener("dndDrop", function GridEditComponent_div_18_Template_div_dndDrop_5_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onActionsDrop($event)); });
    i0.ɵɵtemplate(6, GridEditComponent_div_18_div_6_Template, 7, 2, "div", 29);
    i0.ɵɵelement(7, "div", 30);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngModel", ctx_r1.actionPlaybook)("clearValueOnSelect", true)("required", false)("items", ctx_r1.actionPlaybookList);
    i0.ɵɵadvance();
    i0.ɵɵproperty("dndHorizontal", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.widgetConfig.configuration.actionPlaybooks);
} }
function GridEditComponent_div_33_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "small", 37);
    i0.ɵɵtext(2, "Select a module above");
    i0.ɵɵelementEnd()();
} }
function GridEditComponent_div_34_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-filter-group", 38);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.selectedEntity);
} }
function GridEditComponent_div_35_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵelement(1, "xf-default-sort", 39);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("query", ctx_r1.widgetConfig.configuration.query)("fields", ctx_r1.fields);
} }
class GridEditComponent extends AbstractWidgetEditComponent {
    constructor(changeDetectorRef, entityService, modelMetadataService, formBuilder, playbookService, router, utilityService, gridColumnService) {
        super(changeDetectorRef, entityService, utilityService);
        this.modelMetadataService = modelMetadataService;
        this.playbookService = playbookService;
        this.router = router;
        this.gridColumnService = gridColumnService;
        this.modules = [];
        this.relatedModules = [];
        this.actionPlaybook = null;
        this.fields = {};
        this.actionPlaybookList = [];
        this.actionPBList = [];
        this.isDetailPage = false;
        this.formGroup = formBuilder.group({
            onlyRelated: [false, Validators.required],
            module: [null, Validators.required],
            onClickState: ['preview', Validators.required],
            rowExpandable: new FormControl(false),
            lightMode: new FormControl(false),
            query: new FormControl({}),
            gridConfig: [null]
        });
        this.isDetailPage = this.router.url.indexOf('/module/') !== -1;
    }
    ngOnInit() {
        this.formGroup.controls.gridConfig.setValue(this.widgetConfig.configuration.columns);
        this.modelMetadataService.getModuleList(false, false).pipe(concatMap((modules) => {
            this.modules = modules;
            if (this.context.module) {
                return this.entityService.build(this.context.module).pipe(concatMap((entity) => {
                    this.entity = entity;
                    return this.initWidgetConfig(this.entity);
                }));
            }
            else {
                return this.initWidgetConfig();
            }
        })).subscribe(() => this.changeDetectorRef.detectChanges());
    }
    moduleChanged(module) {
        this.widgetConfig.configuration.module = module;
        this.entityService.build(module).subscribe((entity) => {
            this.selectedEntity = entity;
            this.widgetConfig.configuration.columns = undefined;
            this.setFields();
            this.changeDetectorRef.detectChanges();
        });
    }
    queryChange(filterGroup) {
        if (!filterGroup) {
            return;
        }
        this.widgetConfig.configuration.query = filterGroup;
    }
    initWidgetConfig(entity) {
        this.widgetConfig.configuration.module = entity ? entity.type : this.widgetConfig.configuration.module;
        let observable$ = of(null);
        if (this.widgetConfig.configuration.module) {
            observable$ = this.entityService.build(this.widgetConfig.configuration.module).pipe(concatMap((entity) => {
                this.selectedEntity = entity;
                this.setFields();
                if (entity) {
                    let relatedModules$ = entity.relationships.map((field) => {
                        if (!field.model) {
                            let entity = new Entity(field.name);
                            entity.descriptions = {
                                singular: field.name,
                                plural: field.name
                            };
                            return of(entity);
                        }
                        return this.entityService.build(field.model);
                    });
                    return combineLatest(relatedModules$).pipe(map((entities) => {
                        this.relatedModules = entities;
                        this.changeDetectorRef.detectChanges();
                    }));
                }
                return of(null);
            }));
        }
        this.widgetConfig.configuration.onClickState = this.widgetConfig.configuration.onClickState || 'preview';
        this.widgetConfig.configuration.query = this.widgetConfig.configuration.query ? plainToInstance(Query, this.widgetConfig.configuration.query) : new Query();
        this.formGroup.controls.onlyRelated.setValue(this.widgetConfig.configuration.onlyRelated);
        this.formGroup.controls.module.setValue(this.widgetConfig.configuration.module || null);
        this.formGroup.controls.onClickState.setValue(this.widgetConfig.configuration.onClickState);
        this.formGroup.controls.query.setValue(this.widgetConfig.configuration.query);
        if (this.isDetailPage) {
            this.formGroup.controls.module.disable();
        }
        this.formGroup.controls.onlyRelated.valueChanges.subscribe((value) => {
            this.widgetConfig.configuration.onlyRelated = value;
            if (value) {
                const foundRelatedModule = this.relatedModules.find((relatedModule) => relatedModule.type === this.widgetConfig.configuration.module);
                if (this.formGroup.controls.module.value !== foundRelatedModule?.type) {
                    this.formGroup.controls.module.setValue(foundRelatedModule?.type || null);
                }
            }
        });
        this.formGroup.controls.module.valueChanges.subscribe((value) => {
            if (value === null) {
                this.selectedEntity = undefined;
            }
            else {
                this.moduleChanged(value);
            }
        });
        this.formGroup.controls.onClickState.valueChanges.subscribe((value) => {
            this.widgetConfig.configuration.onClickState = value;
        });
        this.formGroup.controls.query.valueChanges.subscribe((value) => this.queryChange(value));
        // this.changeDetectorRef.detectChanges();
        return observable$;
    }
    rowExpansionChange(event) {
        this.widgetConfig.configuration.rowExpandable = event.target.checked;
    }
    lightModeChange(event) {
        this.widgetConfig.configuration.lightMode = event.target.checked;
    }
    setFields() {
        let fields = this.selectedEntity?.getFormFields();
        this.fields = ___default.keyBy(fields, 'name');
        this.getActionPlaybooks();
        this.setColumns();
    }
    setColumns() {
        if (isUndefined(this.widgetConfig.configuration.columns) || this.widgetConfig.configuration.columns.length === 0) {
            const gridColumns = this.gridColumnService.create(this.fields, new Query());
            const visibleColumns = gridColumns.filter((column) => !column.hide);
            this.widgetConfig.configuration.columns = [];
            visibleColumns?.forEach((column) => {
                this.widgetConfig.configuration.columns?.push(new GridColumn({
                    name: column.field || '',
                    editable: false,
                    resizable: true,
                    sticky: 'NONE'
                }));
            });
        }
    }
    getActionPlaybooks() {
        this.playbookService.getActionPlaybooks(this.selectedEntity, false, []).subscribe((response) => {
            response.forEach((playbook) => {
                const searchablePB = new SearchableItem(playbook.actionTriggerName, playbook['@id'], playbook.uuid);
                this.actionPlaybookList.push(searchablePB);
                this.actionPBList.push(searchablePB);
            });
            this.widgetConfig.configuration.actionPlaybooks = this.widgetConfig.configuration.actionPlaybooks || [];
        });
    }
    onActionsDrop(event) {
        const foundIndex = findIndex(this.widgetConfig.configuration.actionPlaybooks, {
            name: event.data.name
        });
        if (foundIndex > -1) {
            let dragColumn = this.widgetConfig.configuration.actionPlaybooks[foundIndex];
            this.widgetConfig.configuration.actionPlaybooks.splice(foundIndex, 1);
            this.widgetConfig.configuration.actionPlaybooks.splice(event.index, 0, dragColumn);
        }
    }
    addActionPlaybook(event) {
        if (event !== null) {
            this.widgetConfig.configuration.actionPlaybooks?.push({
                name: event?.display,
                id: event?.value
            });
        }
    }
    removeActionPlaybook(index) {
        this.widgetConfig.configuration.actionPlaybooks?.splice(index, 1);
    }
    filterActionPlaybooks(search) {
        of(this.actionPBList).pipe(map((items) => {
            const pbs = this.widgetConfig.configuration.actionPlaybooks?.map(({ id }) => id);
            return items.filter((item) => {
                return pbs.indexOf(item.value) === -1;
            });
        }), map((items) => {
            return items.filter((item) => {
                return item.display.toLowerCase().indexOf(search.toLowerCase()) > -1;
            });
        })).subscribe((items) => {
            this.actionPlaybookList = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function GridEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridEditComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(i1$1.ModelMetadataService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i1$1.PlaybookService), i0.ɵɵdirectiveInject(i4$1.Router), i0.ɵɵdirectiveInject(i1$1.UtilityService), i0.ɵɵdirectiveInject(GridColumnService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridEditComponent, selectors: [["xf-grid-edit"]], inputs: { widgetConfig: "widgetConfig" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 36, vars: 10, consts: [[3, "formGroup"], [1, "row", "mt-3"], [1, "col-md-6"], ["class", "form-group", 4, "ngIf"], ["class", "col-md-6", 4, "ngIf"], [1, "form-group"], ["for", "onClickState", 1, "fw-bold", "col-form-label"], ["formControlName", "onClickState", "id", "onClickState", 1, "form-select"], ["value", "preview"], ["value", "module"], ["for", "row-expansion", 1, "fw-bold"], ["type", "checkbox", "name", "row-expansion", "id", "row-expansion", "formcontrolname", "rowExpandable", 1, "form-check-input", 3, "change", "checked"], [1, "form-check-label", "ps-2"], ["for", "light-mode", 1, "fw-bold"], ["type", "checkbox", "name", "light-mode", "id", "light-mode", "formcontrolname", "lightMode", 1, "form-check-input", 3, "change", "checked"], [1, "col-md-12"], [1, "fw-bold"], [4, "ngIf"], ["class", "row mt-3", 4, "ngIf"], ["formControlName", "module", 1, "form-select"], [3, "ngValue"], [3, "value", 4, "ngFor", "ngForOf"], [3, "value"], ["for", "onlyRelated", 1, "fw-bold"], ["formControlName", "onlyRelated", 1, "form-select"], ["formControlName", "gridConfig", 3, "entity"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Select a Manual Trigger Playbook", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "required", "items"], ["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card d-inline-block p-2 m-2", 3, "dndDraggable", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], ["dndEffectAllowed", "move", 1, "card", "d-inline-block", "p-2", "m-2", 3, "dndDraggable"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], [1, "ms-3"], ["role", "button", 1, "fa", "fa-light", "fa-close", "margin-top-4px", "text-danger", "ms-3", 3, "click"], [1, "font-italic"], ["formControlName", "query", 3, "entity"], [1, "col-lg-7", "col-md-8", "col-sm-12", 3, "query", "fields"]], template: function GridEditComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "div", 2);
            i0.ɵɵtemplate(3, GridEditComponent_div_3_Template, 7, 2, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(4, GridEditComponent_div_4_Template, 2, 1, "div", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "div", 1)(6, "div", 2)(7, "div", 5)(8, "label", 6);
            i0.ɵɵtext(9, "Click Action");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(10, "select", 7)(11, "option", 8);
            i0.ɵɵtext(12, "Open in Preview");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(13, "option", 9);
            i0.ɵɵtext(14, "Open in Detail View");
            i0.ɵɵelementEnd()()()()();
            i0.ɵɵelementStart(15, "div", 1);
            i0.ɵɵtemplate(16, GridEditComponent_div_16_Template, 4, 1, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "div", 1);
            i0.ɵɵtemplate(18, GridEditComponent_div_18_Template, 8, 6, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(19, "div", 1)(20, "label", 10)(21, "input", 11);
            i0.ɵɵlistener("change", function GridEditComponent_Template_input_change_21_listener($event) { return ctx.rowExpansionChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(22, "span", 12);
            i0.ɵɵtext(23, "Row Expandable");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(24, "div", 1)(25, "label", 13)(26, "input", 14);
            i0.ɵɵlistener("change", function GridEditComponent_Template_input_change_26_listener($event) { return ctx.lightModeChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(27, "span", 12);
            i0.ɵɵtext(28, "Enable light mode");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(29, "div", 1)(30, "div", 15)(31, "label", 16);
            i0.ɵɵtext(32, "Filters");
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(33, GridEditComponent_div_33_Template, 3, 0, "div", 17)(34, GridEditComponent_div_34_Template, 2, 1, "div", 17);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(35, GridEditComponent_div_35_Template, 2, 2, "div", 18);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.module);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.entity && !ctx.isDetailPage);
            i0.ɵɵadvance(12);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.gridConfig);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.module);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("checked", ctx.widgetConfig.configuration.rowExpandable);
            i0.ɵɵadvance(5);
            i0.ɵɵproperty("checked", ctx.widgetConfig.configuration.lightMode);
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("ngIf", !ctx.selectedEntity);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.selectedEntity);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fields);
        } }, dependencies: [i1$2.NgForOf, i1$2.NgIf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.RequiredValidator, i2.NgModel, i2.FormGroupDirective, i2.FormControlName, i1$1.FilterGroupComponent, i1$1.SearchableDropdownComponent, i4.DndDraggableDirective, i4.DndDropzoneDirective, i4.DndHandleDirective, i4.DndPlaceholderRefDirective, DefaultSortComponent, GridColumnsEditorComponent], styles: [".border-grey[_ngcontent-%COMP%]{border:1px solid var(--solid-border-secondary-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridEditComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-edit', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div [formGroup]=\"formGroup\">\n  <div class=\"row mt-3\">\n    <div class=\"col-md-6\">\n      <div class=\"form-group\" *ngIf=\"formGroup.controls.module\">\n        <label class=\"fw-bold\">Data Source</label>\n        <select class=\"form-select\" formControlName=\"module\">\n          <option [ngValue]=\"null\">Select a module</option>\n          <option *ngFor=\"let module of (formGroup.controls.onlyRelated.value ? relatedModules : modules)\"\n            [value]=\"module.type\">{{ module.descriptions.plural }}</option>\n        </select>\n      </div>\n    </div>\n    <div class=\"col-md-6\" *ngIf=\"entity && !isDetailPage\">\n      <div class=\"form-group\" *ngIf=\"formGroup.controls.onlyRelated\">\n        <label class=\"fw-bold\" for=\"onlyRelated\">\n          Records to Include\n        </label>\n        <select class=\"form-select\" formControlName=\"onlyRelated\">\n          <option [ngValue]=\"true\">Related Records</option>\n          <option [ngValue]=\"false\">All Records</option>\n        </select>\n      </div>\n    </div>\n  </div>\n  <div class=\"row mt-3\">\n    <div class=\"col-md-6\">\n      <div class=\"form-group\">\n        <label for=\"onClickState\" class=\"fw-bold col-form-label\">Click Action</label>\n        <select class=\"form-select\" formControlName=\"onClickState\" id=\"onClickState\">\n          <option value=\"preview\">Open in Preview</option>\n          <option value=\"module\">Open in Detail View</option>\n        </select>\n      </div>\n    </div>\n  </div>\n  <!-- Select fields -->\n  <div class=\"row mt-3\">\n    <div class=\"form-group\" *ngIf=\"formGroup.controls.gridConfig\">\n      <label class=\"fw-bold\">Select Columns</label>\n      <xf-grid-columns-editor [entity]=\"selectedEntity\" formControlName=\"gridConfig\"></xf-grid-columns-editor>\n    </div>\n  </div>\n\n  <!-- Select Action Playbooks -->\n  <div class=\"row mt-3\">\n    <div class=\"form-group\" *ngIf=\"formGroup.controls.module\">\n      <label class=\"fw-bold\">Actions</label>\n      <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n        <xf-searchable-dropdown (ngModelChange)=\"addActionPlaybook($event)\" [ngModel]=\"actionPlaybook\" [clearValueOnSelect]=\"true\"\n          [required]=\"false\" [items]=\"actionPlaybookList\" placeholder=\"+ Select a Manual Trigger Playbook\"\n          (searchQueryChange)=\"filterActionPlaybooks($event)\">\n        </xf-searchable-dropdown>\n      </div>\n      <div class=\"col pb-2\" dndDropzone [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\"\n        (dndDrop)=\"onActionsDrop($event)\">\n        <div *ngFor=\"let playbook of widgetConfig.configuration.actionPlaybooks; let pbIndex = index\"\n          [dndDraggable]=\"playbook\" dndEffectAllowed=\"move\" class=\"card d-inline-block p-2 m-2\">\n          <div class=\"card-title m-0 d-flex\">\n            <span class=\"flex-grow-1\">\n              <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ playbook.name }}\n            </span>\n            <span class=\"ms-3\">\n              <i class=\"fa fa-light fa-close margin-top-4px text-danger ms-3\" role=\"button\"\n                (click)=\"removeActionPlaybook(pbIndex)\"></i>\n            </span>\n          </div>\n\n        </div>\n        <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n      </div>\n    </div>\n  </div>\n\n  <!-- Row expansion -->\n  <div class=\"row mt-3\">\n    <label for=\"row-expansion\" class=\"fw-bold\">\n      <input type=\"checkbox\" name=\"row-expansion\" id=\"row-expansion\" formcontrolname=\"rowExpandable\"\n        class=\"form-check-input\" [checked]=\"widgetConfig.configuration.rowExpandable\"\n        (change)=\"rowExpansionChange($event)\">\n      <span class=\"form-check-label ps-2\">Row Expandable</span>\n    </label>\n  </div>\n\n  <!--  Light Mode -->\n  <div class=\"row mt-3\">\n    <label for=\"light-mode\" class=\"fw-bold\">\n      <input type=\"checkbox\" name=\"light-mode\" id=\"light-mode\" formcontrolname=\"lightMode\" class=\"form-check-input\"\n        [checked]=\"widgetConfig.configuration.lightMode\" (change)=\"lightModeChange($event)\">\n      <span class=\"form-check-label ps-2\">Enable light mode</span>\n    </label>\n  </div>\n\n  <!-- Filters -->\n  <div class=\"row mt-3\">\n    <div class=\"col-md-12\">\n      <label class=\"fw-bold\">Filters</label>\n      <div *ngIf=\"!selectedEntity\">\n        <small class=\"font-italic\">Select a module above</small>\n      </div>\n      <div *ngIf=\"selectedEntity\">\n        <xf-filter-group formControlName=\"query\" [entity]=\"selectedEntity\"></xf-filter-group>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"row mt-3\" *ngIf=\"fields\">\n    <xf-default-sort [query]=\"widgetConfig.configuration.query\" [fields]=\"fields!\" class=\"col-lg-7 col-md-8 col-sm-12\">\n    </xf-default-sort>\n  </div>\n\n</div>\n", styles: [".border-grey{border:1px solid var(--solid-border-secondary-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1$1.EntityService }, { type: i1$1.ModelMetadataService }, { type: i2.FormBuilder }, { type: i1$1.PlaybookService }, { type: i4$1.Router }, { type: i1$1.UtilityService }, { type: GridColumnService }], { widgetConfig: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridEditComponent, { className: "GridEditComponent", filePath: "src/widgets/grid-widget/grid-edit/grid-edit.component.ts", lineNumber: 21 }); })();

function GridViewComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 1);
    i0.ɵɵelement(2, "xf-grid", 2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("dataSource", ctx_r0.dataSource)("gridConfig", ctx_r0.gridConfig);
} }
class GridViewComponent extends AbstractWidgetComponent {
    constructor(http, offcanvasService, themeService, _changeDetectorRef, entityService, router, route, gridDataSourceService) {
        super(_changeDetectorRef);
        this.http = http;
        this.offcanvasService = offcanvasService;
        this.themeService = themeService;
        this._changeDetectorRef = _changeDetectorRef;
        this.entityService = entityService;
        this.router = router;
        this.route = route;
        this.gridDataSourceService = gridDataSourceService;
    }
    ngOnInit() {
        super.ngOnInit();
    }
    widgetConfigChanged(widgetConfig) {
        this.gridConfig = widgetConfig;
        this.title = widgetConfig.title;
        this.changeDetectorRef.detectChanges();
    }
    openRecord(event) {
        const module = event.data['@id'].split('/')[3];
        const onClickState = this.gridConfig.configuration.onClickState || 'module';
        if (onClickState === 'preview') {
            this.router.navigate(['.'], {
                relativeTo: this.route,
                queryParams: {
                    preview: true,
                    recordId: event.data.uuid
                },
                queryParamsHandling: 'merge'
            });
        }
        else {
            this.router.navigate([onClickState, module, 'detail'], {
                queryParams: {
                    recordId: event.data.uuid
                }
            });
        }
    }
    loadDatasource() {
        this.gridConfig.options = this.gridConfig.options || {};
        this.gridConfig.options.onView = (_event) => this.openRecord(_event);
        this.gridConfig.options.addText = 'Add';
        this.entityService.build(this.gridConfig.configuration.module).subscribe((entity) => {
            if (!this.context || !this.gridConfig) {
                return;
            }
            this.entity = entity;
            let relatedField;
            let relatedUuid;
            let primaryModule = this.gridConfig.configuration.module;
            if (this.gridConfig.configuration.onlyRelated && this.context.module && this.context.uuid) {
                relatedField = this.gridConfig.configuration.module;
                relatedUuid = this.context.uuid;
                primaryModule = this.context.module;
            }
            // TODO: Implement related records grid
            this.dataSource = this.gridDataSourceService.getDataSource(this.entity);
            // this.pagedCollection = new PagedCollection(primaryModule, this.entity, relatedField, relatedUuid);
            this.changeDetectorRef.detectChanges();
        });
    }
    addModule() {
        if (this.offcanvasInstance) {
            this.offcanvasInstance.close();
        }
        this.offcanvasInstance = this.offcanvasService.open(AddRecordComponent, {
            position: 'end',
            container: '.content'
        });
    }
    loadPicklistNames(picklistName) {
        return this.http
            .get(API.API_3_BASE + 'picklist_names', {
            params: {
                name: picklistName
            }
        })
            .pipe(map$1(response => response['hydra:member'][0]));
    }
    contextChanged(context) {
        this.context = context;
        this.loadDatasource();
    }
    static { this.ɵfac = function GridViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridViewComponent)(i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i2$1.NgbOffcanvas), i0.ɵɵdirectiveInject(i1$1.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1$1.EntityService), i0.ɵɵdirectiveInject(i4$1.Router), i0.ɵɵdirectiveInject(i4$1.ActivatedRoute), i0.ɵɵdirectiveInject(GridDataSourceService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridViewComponent, selectors: [["xf-grid-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [[4, "ngIf"], [1, "m-2", "ms-0"], [3, "dataSource", "gridConfig"]], template: function GridViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, GridViewComponent_div_0_Template, 3, 2, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.dataSource);
        } }, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div *ngIf=\"dataSource\">\n  <div class=\"m-2 ms-0\">\n    <!-- <button class=\"btn btn-primary btn-sm\" (click)=\"addModule()\">Add {{ entity?.descriptions?.singular }}</button> -->\n    <xf-grid [dataSource]=\"dataSource\" [gridConfig]=\"gridConfig\"></xf-grid>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1.HttpClient }, { type: i2$1.NgbOffcanvas }, { type: i1$1.ThemeService }, { type: i0.ChangeDetectorRef }, { type: i1$1.EntityService }, { type: i4$1.Router }, { type: i4$1.ActivatedRoute }, { type: GridDataSourceService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridViewComponent, { className: "GridViewComponent", filePath: "src/widgets/grid-widget/grid-view/grid-view.component.ts", lineNumber: 21 }); })();

class GridConfig extends WidgetConfig {
    constructor(title, configuration, options) {
        if (configuration && configuration.columns && configuration.columns[0] && typeof configuration.columns[0] === 'string') {
            let columns = [];
            let stringColumns = configuration.columns;
            stringColumns.forEach((columnName) => {
                columns.push(new GridColumn({ name: columnName }));
            });
            configuration.columns = columns;
        }
        super(title, configuration);
        this.title = title;
        this.options = options;
        this.type = 'grid';
        this._count = 0;
        this.configuration = configuration;
        this.viewComponent = GridViewComponent;
        this.editComponent = GridEditComponent;
    }
}

const _c0 = a0 => ({ "disabled": a0 });
function PaginationComponent_option_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 16);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const pageSize_r2 = ctx.$implicit;
    i0.ɵɵproperty("value", pageSize_r2);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(pageSize_r2);
} }
const FILTER_PAG_REGEX = /[^0-9]/g;
class PaginationComponent {
    set totalItems(value) {
        this._totalItems = value;
        this.calculatePaginationSize();
    }
    get totalItems() {
        return this._totalItems;
    }
    constructor() {
        //@Input() totalRecords: number = 0;
        this.itemsPerPage = 30;
        this.paginationSize = [5, 10, 30, 50, 100, 250];
        this.pageChanged = new EventEmitter();
        this.page = 1;
        this.noOfPages = 1;
        this._totalItems = 0;
    }
    ngOnInit() {
    }
    calculatePaginationSize() {
        this.noOfPages = Math.ceil(this._totalItems / this.itemsPerPage);
    }
    selectPage(page) {
        let _pageChange = parseInt(page) || 1;
        this.gotoPage(_pageChange, paginationEventType.directPage);
    }
    gotoPage(page, eventType) {
        if (page > this.noOfPages) {
            page = this.noOfPages;
        }
        else if (page < 0) {
            page = 1;
        }
        this.page = page;
        this.fireEvent(eventType);
    }
    formatInput(input) {
        input.value = input.value.replace(FILTER_PAG_REGEX, '');
    }
    recordsSizeChanged() {
        this.page = 1;
        this.calculatePaginationSize();
        this.fireEvent(paginationEventType.recordsPerPageChange);
    }
    fireEvent(eventType) {
        this.pageChanged.emit({
            currentPage: this.page,
            itemsPerPage: this.itemsPerPage,
            eventType: eventType
        });
    }
    firstPage() {
        this.gotoPage(1, paginationEventType.pageFirst);
    }
    previousPage() {
        this.gotoPage(this.page - 1, paginationEventType.pagePrevious);
    }
    nextPage() {
        this.gotoPage(this.page + 1, paginationEventType.pageNext);
    }
    lastPage() {
        this.gotoPage(this.noOfPages, paginationEventType.pageLast);
    }
    static { this.ɵfac = function PaginationComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PaginationComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PaginationComponent, selectors: [["xf-pagination"]], inputs: { itemsPerPage: "itemsPerPage", paginationSize: "paginationSize", totalItems: "totalItems" }, outputs: { pageChanged: "pageChanged" }, decls: 20, vars: 16, consts: [["pageInput", ""], [1, "pagination-wrapper", "d-flex", "justify-content-end"], [1, "align-items-center", "d-flex", "me-4"], ["for", "itemsPerPageDD", 1, "me-2", "ps-2", "content-font"], ["id", "itemsPerPageDD", "name", "itemsPerPageDD", 1, "form-select", "form-select-xs", "text-center", "w-auto", 3, "ngModelChange", "change", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], [1, "align-items-center", "d-flex"], [1, "btn", "btn-xs", "btn-secondary", 3, "click", "ngClass"], [1, "fa-light", "fa", "fa-chevron-double-left", "content-font"], [1, "btn", "btn-xs", "mx-1", "btn-secondary", 3, "click", "ngClass"], [1, "fa-light", "fa", "fa-chevron-left", "content-font"], ["type", "text", "pattern", "[0-9]*", "id", "paginationInput", "aria-labelledby", "paginationInputLabel paginationDescription", 1, "form-control", "form-control-xs", "mx-2", "text-center", 2, "width", "3.5rem", 3, "keyup.enter", "blur", "input", "value"], [1, "me-2", "content-font"], [1, "fa-light", "fa", "fa-chevron-right", "content-font"], [1, "fa-light", "fa", "fa-chevron-double-right", "content-font"], [1, "clearfix"], [3, "value"]], template: function PaginationComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2)(2, "label", 3);
            i0.ɵɵtext(3, "Items Per Page");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "select", 4);
            i0.ɵɵtwoWayListener("ngModelChange", function PaginationComponent_Template_select_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r1); i0.ɵɵtwoWayBindingSet(ctx.itemsPerPage, $event) || (ctx.itemsPerPage = $event); return i0.ɵɵresetView($event); });
            i0.ɵɵlistener("change", function PaginationComponent_Template_select_change_4_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.recordsSizeChanged()); });
            i0.ɵɵtemplate(5, PaginationComponent_option_5_Template, 2, 2, "option", 5);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(6, "div", 6)(7, "button", 7);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_7_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.firstPage()); });
            i0.ɵɵelement(8, "i", 8);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(9, "button", 9);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_9_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.previousPage()); });
            i0.ɵɵelement(10, "i", 10);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(11, "input", 11, 0);
            i0.ɵɵlistener("keyup.enter", function PaginationComponent_Template_input_keyup_enter_11_listener() { i0.ɵɵrestoreView(_r1); const pageInput_r3 = i0.ɵɵreference(12); return i0.ɵɵresetView(ctx.selectPage(pageInput_r3.value)); })("blur", function PaginationComponent_Template_input_blur_11_listener() { i0.ɵɵrestoreView(_r1); const pageInput_r3 = i0.ɵɵreference(12); return i0.ɵɵresetView(ctx.selectPage(pageInput_r3.value)); })("input", function PaginationComponent_Template_input_input_11_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.formatInput($event.target)); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(13, "label", 12);
            i0.ɵɵtext(14);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(15, "button", 9);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.nextPage()); });
            i0.ɵɵelement(16, "i", 13);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "button", 7);
            i0.ɵɵlistener("click", function PaginationComponent_Template_button_click_17_listener() { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.lastPage()); });
            i0.ɵɵelement(18, "i", 14);
            i0.ɵɵelementEnd()();
            i0.ɵɵelement(19, "div", 15);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.itemsPerPage);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.paginationSize);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(8, _c0, ctx.page === 1));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(10, _c0, ctx.page === 1));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("value", ctx.page);
            i0.ɵɵadvance(3);
            i0.ɵɵtextInterpolate1(" of ", ctx.noOfPages, "");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(12, _c0, ctx.page === ctx.noOfPages));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(14, _c0, ctx.page === ctx.noOfPages));
        } }, dependencies: [i1$2.NgClass, i1$2.NgForOf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgModel] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PaginationComponent, [{
        type: Component,
        args: [{ selector: 'xf-pagination', template: "<div class=\"pagination-wrapper d-flex justify-content-end\">\n    <div class=\"align-items-center d-flex me-4\">\n        <label for=\"itemsPerPageDD\" class=\"me-2 ps-2 content-font\">Items Per Page</label>\n        <select class=\"form-select form-select-xs text-center w-auto\" id=\"itemsPerPageDD\"\n            name=\"itemsPerPageDD\" [(ngModel)]=\"itemsPerPage\" (change)=\"recordsSizeChanged()\">\n            <option *ngFor=\"let pageSize of paginationSize\" [value]=\"pageSize\">{{ pageSize }}</option>\n        </select>\n    </div>\n    <div class=\"align-items-center d-flex\">\n        <button class=\"btn btn-xs btn-secondary\" [ngClass]=\"{'disabled': page === 1 }\" (click)=\"firstPage()\">\n            <i class=\"fa-light fa fa-chevron-double-left content-font\"></i>\n        </button>\n        <button class=\"btn btn-xs mx-1 btn-secondary\" [ngClass]=\"{'disabled': page === 1 }\" (click)=\"previousPage()\">\n            <i class=\"fa-light fa fa-chevron-left content-font\"></i>\n        </button>\n        <input #pageInput type=\"text\" pattern=\"[0-9]*\" class=\"form-control form-control-xs mx-2 text-center\"\n            id=\"paginationInput\" [value]=\"page\" (keyup.enter)=\"selectPage(pageInput.value)\"\n            (blur)=\"selectPage(pageInput.value)\" (input)=\"formatInput($any($event).target)\"\n            aria-labelledby=\"paginationInputLabel paginationDescription\" style=\"width: 3.5rem\" />\n        <label class=\"me-2 content-font\"> of {{ noOfPages }}</label>\n        <button class=\"btn btn-xs mx-1 btn-secondary\" [ngClass]=\"{'disabled': page === noOfPages }\" (click)=\"nextPage()\">\n            <i class=\"fa-light fa fa-chevron-right content-font\"></i>\n        </button>\n        <button class=\"btn btn-xs btn-secondary\" [ngClass]=\"{'disabled': page === noOfPages }\" (click)=\"lastPage()\">\n            <i class=\"fa-light fa fa-chevron-double-right content-font\"></i>\n        </button>\n    </div>\n    <div class=\"clearfix\"></div>\n</div>" }]
    }], () => [], { itemsPerPage: [{
            type: Input
        }], paginationSize: [{
            type: Input
        }], pageChanged: [{
            type: Output
        }], totalItems: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PaginationComponent, { className: "PaginationComponent", filePath: "src/widgets/grid-widget/pagination/pagination.component.ts", lineNumber: 9 }); })();
var paginationEventType;
(function (paginationEventType) {
    paginationEventType["pageFirst"] = "pageFirst";
    paginationEventType["pageLast"] = "pageLast";
    paginationEventType["pageNext"] = "pageNext";
    paginationEventType["pagePrevious"] = "pagePrevious";
    paginationEventType["recordsPerPageChange"] = "recordsPerPageChange";
    paginationEventType["directPage"] = "directPage";
})(paginationEventType || (paginationEventType = {}));

class GridWidgetModule {
    static { this.ɵfac = function GridWidgetModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridWidgetModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: GridWidgetModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ providers: [
            PlaybookService
        ], imports: [CommonModule,
            RouterModule,
            FormsModule,
            NgbDropdownModule,
            ReactiveFormsModule,
            QueryFiltersModule,
            SearchableDropdownModule,
            DndModule,
            ButtonGroupModule,
            GridModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridWidgetModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    GridViewComponent,
                    GridEditComponent,
                    PaginationComponent,
                    GridEditComponent,
                    DefaultSortComponent,
                    GridColumnsEditorComponent
                ],
                imports: [
                    CommonModule,
                    RouterModule,
                    FormsModule,
                    NgbDropdownModule,
                    ReactiveFormsModule,
                    QueryFiltersModule,
                    SearchableDropdownModule,
                    DndModule,
                    ButtonGroupModule,
                    GridModule
                ],
                exports: [
                    GridEditComponent,
                    GridViewComponent,
                    GridColumnsEditorComponent
                ],
                providers: [
                    PlaybookService
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(GridWidgetModule, { declarations: [GridViewComponent,
        GridEditComponent,
        PaginationComponent,
        GridEditComponent,
        DefaultSortComponent,
        GridColumnsEditorComponent], imports: [CommonModule,
        RouterModule,
        FormsModule,
        NgbDropdownModule,
        ReactiveFormsModule,
        QueryFiltersModule,
        SearchableDropdownModule,
        DndModule,
        ButtonGroupModule,
        GridModule], exports: [GridEditComponent,
        GridViewComponent,
        GridColumnsEditorComponent] }); })();
i0.ɵɵsetComponentScope(GridViewComponent, [i1$2.NgIf, GridComponent], []);

class GridService {
    constructor(filterCollectionService, http) {
        this.filterCollectionService = filterCollectionService;
        this.http = http;
    }
    loadUserPreferenceColumns() {
        return this.http.get(`${VIEW_TEMPLATES.VIEW_API_BASE}${VIEW_TEMPLATES.GRID_COLUMNS}`).pipe(map$1((result) => {
            result.config = isArray(result.config) ? {} : result.config;
            return result;
        }, catchError$1((error) => {
            return throwError(error);
        })));
    }
    saveUserPreferences(page, template) {
        return this.http.post(`${VIEW_TEMPLATES.VIEW_API_BASE}${VIEW_TEMPLATES.GRID_COLUMNS}`, template).pipe(map$1((result) => {
            return result;
        }));
    }
    loadColumnsJson(jsonURL) {
        return this.http.get(jsonURL).pipe(concatMap$1((response) => response.data.columns), map$1((column) => {
            return plainToInstance(GridColumn, column);
        }), toArray());
    }
    static { this.ɵfac = function GridService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridService)(i0.ɵɵinject(i1$1.FilterCollectionService), i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GridService, factory: GridService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.FilterCollectionService }, { type: i1.HttpClient }], null); })();

/**
 * Generated bundle index. Do not edit.
 */

export { AbstractGridHeaderComponent, GridColumn, GridColumnService, GridColumnsEditorComponent, GridComponent, GridConfig, GridDataSourceService, GridEditComponent, GridModule, GridReferenceService, GridService, GridViewComponent, GridWidgetModule, LinkCellRendererComponent, getStoredResolvedObservableValue, storeResolvedObservableValue };
//# sourceMappingURL=shared-grid.mjs.map
