import * as i0 from '@angular/core';
import { Injectable, EventEmitter, Component, Input, Output } from '@angular/core';
import { map, forkJoin, of, from, catchError, concatMap } from 'rxjs';
import * as i1 from 'shared';
import { CheckboxField, API, FIXED_MODULE, pollWhile } from 'shared';
import { difference } from 'lodash-es';
import { loadRemoteModule } from '@angular-architects/native-federation';
import { plainToInstance } from 'class-transformer';
import * as i1$1 from '@angular/common/http';

class PortingService {
    constructor(manifestService, permissionService) {
        this.manifestService = manifestService;
        this.permissionService = permissionService;
    }
    getStatusColumn() {
        return (params) => {
            let className = params.data?.errorMessage ? 'text-danger' : (params.value === 'In progress' ? 'text-muted muted-40' : 'text-success');
            return `<i class="align-middle fa fa-circle fa-lg font-size-8px ${className}"></i>
              <span class="font-size-12px margin-left-8px muted-10">${params.value}
              ${params.data?.errorMessage ? '<i class="fa fa-duotone fa-info-circle"></i>' : ''}</span>`;
        };
    }
    getConfigs(type, localClassMap) {
        let manifests = this.manifestService.get();
        let configObservables$ = [];
        manifests.forEach((manifest) => {
            if (!manifest.views.portingConfigs) {
                return;
            }
            const flatPermissions = this.permissionService.getAllFlatPermissions();
            manifest.views.portingConfigs.forEach(config => {
                let observable$ = null;
                if (type === 'export') {
                    if (difference(config.permissions, flatPermissions).length === 0) {
                        observable$ = this.loadRemoteSection(manifest.remoteEntry, config.exportFilterComponent, localClassMap, 'AbstractExportFilterComponent').pipe(map((exportFilterComponent) => {
                            return {
                                exportFilterComponent: exportFilterComponent
                            };
                        }));
                    }
                }
                else {
                    observable$ = this.loadRemoteSection(manifest.remoteEntry, config.importFilterComponent, localClassMap, 'AbstractImportFilterComponent').pipe(map((importFilterComponent) => {
                        return {
                            importFilterComponent: importFilterComponent
                        };
                    }));
                }
                if (observable$ !== null) {
                    const portingConfigObservable$ = observable$.pipe(map((object) => {
                        let field = new CheckboxField(config.name);
                        field.viewMode = 'checkbox';
                        field.title = config.label;
                        let portingConfig = {
                            name: config.name,
                            label: config.label,
                            countLabel: config.countLabel,
                            field: field,
                            dataSource: config.dataSource,
                            service: config.service || manifest.name,
                            manifest: manifest.name,
                            ...object
                        };
                        return portingConfig;
                    }));
                    configObservables$.push(portingConfigObservable$);
                }
            });
        });
        return forkJoin(configObservables$);
    }
    loadRemoteSection(remoteEntry, className, localClassMap, type) {
        if (!remoteEntry) {
            return of(type === 'AbstractExportFilterComponent' ? localClassMap[className] : localClassMap[className]);
        }
        const options = {
            remoteEntry: remoteEntry,
            exposedModule: './' + className,
            className: className
        };
        return from(loadRemoteModule(options)).pipe(catchError((error) => {
            console.error(error, remoteEntry);
            return of({});
        }), map((exposedModules) => {
            return exposedModules[options.className];
        }));
    }
    static { this.ɵfac = function PortingService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PortingService)(i0.ɵɵinject(i1.ManifestService), i0.ɵɵinject(i1.PermissionService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PortingService, factory: PortingService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PortingService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.ManifestService }, { type: i1.PermissionService }], null); })();

class ExportJob {
    constructor(uuid) {
        this.uuid = uuid;
        this.logMessages = [];
        this.progressPercent = 0;
    }
    get iri() {
        return API.PORTER + FIXED_MODULE.EXPORT_JOBS + '/' + this.uuid + '/';
    }
}

class ExportTemplate {
    constructor(name) {
        this.selections = {};
        this.type = 'Export Wizard';
        this.name = name;
    }
}

class ExportConfigService {
    constructor(http) {
        this.http = http;
        this.OPTIONS_INTERVAL_SECONDS = 2;
        this.OPTIONS_TIMEOUT_SECONDS = 150; // 5 minutes
    }
    saveTemplate(template) {
        let observable$;
        if (template.uuid) {
            observable$ = this.http.put(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/' + template.uuid + '/', template);
        }
        else {
            observable$ = this.http.post(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/', template);
        }
        return observable$.pipe(map((response) => plainToInstance(ExportTemplate, response)));
    }
    runExport(template, fileName) {
        return this.http.put(API.PORTER + FIXED_MODULE.EXPORT_TEMPLATES + '/' + template.uuid + '/trigger/', null, {
            params: {
                fileName: fileName,
                template: template.uuid || ''
            }
        }).pipe(concatMap((response) => {
            let exportJob = new ExportJob(response.export_id);
            return this.loadExportJob(exportJob.uuid)
                .pipe(pollWhile(this.OPTIONS_INTERVAL_SECONDS * 1000, (exportJob) => exportJob.status !== 'Complete' && exportJob.status !== 'Error', this.OPTIONS_TIMEOUT_SECONDS));
        }));
    }
    loadExportJob(exportJobUuid) {
        return this.http.get(API.PORTER + FIXED_MODULE.EXPORT_JOBS + '/' + exportJobUuid + '/').pipe(map((response) => plainToInstance(ExportJob, response)));
    }
    static { this.ɵfac = function ExportConfigService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ExportConfigService)(i0.ɵɵinject(i1$1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ExportConfigService, factory: ExportConfigService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ExportConfigService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1$1.HttpClient }], null); })();

class AbstractExportFilterComponent {
    constructor(exportService, changeDetectorRef) {
        this.exportService = exportService;
        this.changeDetectorRef = changeDetectorRef;
        this.dataChange = new EventEmitter();
        this.checkAlls = {
            include: false
        };
        this.options = [];
        this.configKey = '';
        this.serviceKey = '';
    }
    ngOnInit() {
        if (this.wizard.data.selectedConfigs) {
            this.config = this.wizard.data.selectedConfigs.find((config) => config.name === this.configKey);
            this.subscription = this.includeAll$.subscribe((includeAll) => {
                this.checkAlls.include = includeAll;
                this.checkAllChanged();
            });
        }
    }
    ngOnDestroy() {
        if (this.subscription) {
            this.subscription.unsubscribe();
        }
    }
    checkAllChanged(key = 'include') {
        this.options.forEach((option) => {
            option[key] = this.checkAlls[key];
        });
        this.onOptionsChange();
        this.changeDetectorRef.detectChanges();
    }
    onOptionsChange() {
        if (!this.wizard.data.exportTemplate) {
            return;
        }
        const includedOptions = this.options.filter((option) => option.include);
        this.checkAlls.include = includedOptions.length === this.options.length;
        this.wizard.data.exportTemplate.selections[this.serviceKey][this.configKey] = includedOptions.map((option) => option.asSaved());
        this.dataChange.emit();
    }
    buttonClicked(option, key = 'include') {
        option[key] = !option[key];
        this.onOptionsChange();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function AbstractExportFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractExportFilterComponent)(i0.ɵɵdirectiveInject(ExportConfigService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractExportFilterComponent, selectors: [["xf-abstract-section-config"]], inputs: { wizard: "wizard", includeAll$: "includeAll$" }, outputs: { dataChange: "dataChange" }, decls: 0, vars: 0, template: function AbstractExportFilterComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractExportFilterComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-section-config',
                template: ''
            }]
    }], () => [{ type: ExportConfigService }, { type: i0.ChangeDetectorRef }], { wizard: [{
            type: Input
        }], includeAll$: [{
            type: Input
        }], dataChange: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractExportFilterComponent, { className: "AbstractExportFilterComponent", filePath: "src/export/abstract-export-filter.component.ts", lineNumber: 12 }); })();

class ExportOption {
    constructor(savedOption) {
        this.include = true;
        Object.assign(this, savedOption);
    }
    asSaved() {
        return {
            value: this.value,
            label: this.label
        };
    }
}

class AbstractImportFilterComponent {
    constructor() {
        this.dataChange = new EventEmitter();
        this.values = [];
        this.checkAlls = {
            include: false
        };
        this.sectionKey = '';
        this.configKey = '';
    }
    ngOnInit() {
        if (this.wizard.data.importJob && this.wizard.data.importJob.options[this.sectionKey]) {
            this.values = this.wizard.data.importJob.options[this.sectionKey][this.configKey] || [];
            this.checkAlls.include = !this.values.find((value) => !value.include);
        }
    }
    checkAllChanged(key = 'include') {
        this.values.forEach((option) => {
            option[key] = this.checkAlls[key];
        });
        this.onOptionsChange();
    }
    onOptionsChange() {
        if (!this.wizard.data.importJob) {
            return;
        }
        const includedOptions = this.values.filter((option) => option.include);
        this.checkAlls.include = includedOptions.length === this.values.length;
        this.wizard.data.importJob.options[this.sectionKey][this.configKey] = this.values;
        this.dataChange.emit();
    }
    buttonClicked(option, key = 'include') {
        option[key] = !option[key];
        this.onOptionsChange();
    }
    static { this.ɵfac = function AbstractImportFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractImportFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractImportFilterComponent, selectors: [["xf-abstract-filter-option"]], inputs: { wizard: "wizard" }, outputs: { dataChange: "dataChange" }, decls: 0, vars: 0, template: function AbstractImportFilterComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractImportFilterComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-filter-option',
                template: ''
            }]
    }], () => [], { wizard: [{
            type: Input
        }], dataChange: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractImportFilterComponent, { className: "AbstractImportFilterComponent", filePath: "src/import/abstract-import-filter.component.ts", lineNumber: 9 }); })();

class ImportJob {
    constructor() {
        this.file = null;
        this.status = null;
        this.errorMessage = null;
        this.logMessages = [];
        this.progressPercent = 0;
        this.currentlyImporting = null;
        this.options = {};
        this.type = 'Import Wizard';
        this.solutionPack = null;
        this.uuid = null;
    }
    get iri() {
        return API.PORTER + FIXED_MODULE.IMPORT_JOBS + '/' + this.uuid + '/';
    }
}

// export * from './src/configs';

/**
 * Generated bundle index. Do not edit.
 */

export { AbstractExportFilterComponent, AbstractImportFilterComponent, ExportConfigService, ExportJob, ExportOption, ExportTemplate, ImportJob, PortingService };
//# sourceMappingURL=shared-porter.mjs.map
