import * as i0 from '@angular/core';
import { Component, ChangeDetectionStrategy, Input, ViewChildren, EventEmitter, Output, inject, NgModule } from '@angular/core';
import * as i1 from '@angular/forms';
import { FormControl, Validators, FormsModule, ReactiveFormsModule } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import { cloneDeep, keys, forEach } from 'lodash-es';
import { switchMap, of, tap, map, concatMap, forkJoin } from 'rxjs';
import * as i2 from 'shared';
import { PERMISSION, FIXED_MODULE, Query, Schedule, TimezoneSelectComponent, FormFieldComponent, Filter, FieldOptions, DatetimeField, CheckboxField, IntegerField, XFFormFieldsModule, CronEditorModule, TimezoneModule } from 'shared';
import * as i1$1 from '@ng-bootstrap/ng-bootstrap';
import { NgbOffcanvas, NgbDropdownModule } from '@ng-bootstrap/ng-bootstrap';
import * as i4 from '@angular/common/http';
import { HttpErrorResponse } from '@angular/common/http';
import * as i5 from 'ngx-toastr';
import * as i5$1 from '@angular/common';
import { CommonModule } from '@angular/common';
import * as i2$1 from '@jsverse/transloco';
import { TranslocoModule } from '@jsverse/transloco';
import * as i2$2 from 'shared/grid';
import { GridModule } from 'shared/grid';
import cronstrue from 'cronstrue';

function ScheduleDetailComponent_div_0_div_5_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-form-field", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.reference)("formControlName", ctx_r1.scheduleEntity.fields.reference.name)("autoFocus", true);
} }
function ScheduleDetailComponent_div_0_div_5_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 17);
    i0.ɵɵelement(1, "i", 25);
    i0.ɵɵelementStart(2, "small");
    i0.ɵɵtext(3, "The playbook referenced is inactive. The schedule will not run it until it is changed to active.");
    i0.ɵɵelementEnd()();
} }
function ScheduleDetailComponent_div_0_div_5_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "form", 9, 0);
    i0.ɵɵlistener("ngSubmit", function ScheduleDetailComponent_div_0_div_5_Template_form_ngSubmit_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelementStart(3, "div", 10)(4, "div", 11)(5, "div", 12)(6, "div", 13);
    i0.ɵɵelement(7, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(8, "div", 15);
    i0.ɵɵelement(9, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, ScheduleDetailComponent_div_0_div_5_div_10_Template, 2, 3, "div", 16)(11, ScheduleDetailComponent_div_0_div_5_Conditional_11_Template, 4, 0, "div", 17);
    i0.ɵɵelementStart(12, "div", 18)(13, "label", 19);
    i0.ɵɵtext(14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(15, "div", 20);
    i0.ɵɵelement(16, "xf-cron-editor", 21);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(17, "div", 15)(18, "label", 19);
    i0.ɵɵtext(19);
    i0.ɵɵelementEnd();
    i0.ɵɵelement(20, "xf-timezone-select", 22);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(21, "div", 15);
    i0.ɵɵelement(22, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(23, "div", 23)(24, "div", 24);
    i0.ɵɵelement(25, "xf-form-field", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(26, "div", 24);
    i0.ɵɵelement(27, "xf-form-field", 14);
    i0.ɵɵelementEnd()()()()()()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance(6);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.name)("formControlName", ctx_r1.scheduleEntity.fields.name.name)("autoFocus", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.enabled)("formControlName", ctx_r1.scheduleEntity.fields.enabled.name)("autoFocus", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.playbookPermissions.includes(ctx_r1.permission.READ) && ctx_r1.showReference);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.showPBRefWarning ? 11 : -1);
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.labels.frequency"));
    i0.ɵɵadvance(5);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.labels.timezone"));
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.exitRunningField)("formControlName", ctx_r1.scheduleEntity.fields.exit_if_running.name)("autoFocus", true);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.start_time)("formControlName", ctx_r1.scheduleEntity.fields.start_time.name)("autoFocus", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.scheduleEntity.fields.expires)("formControlName", ctx_r1.scheduleEntity.fields.expires.name)("autoFocus", true);
} }
function ScheduleDetailComponent_div_0_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 26)(1, "div", 27)(2, "span", 28);
    i0.ɵɵtext(3, "Loading...");
    i0.ɵɵelementEnd()()();
} }
function ScheduleDetailComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 29)(1, "button", 30);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelement(2, "i", 31);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 32);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_div_7_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelement(5, "i", 33);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.save"), " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.cancel"), " ");
} }
function ScheduleDetailComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 2)(2, "h4", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 4);
    i0.ɵɵlistener("click", function ScheduleDetailComponent_div_0_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, ScheduleDetailComponent_div_0_div_5_Template, 28, 20, "div", 5)(6, ScheduleDetailComponent_div_0_div_6_Template, 4, 0, "div", 6)(7, ScheduleDetailComponent_div_0_div_7_Template, 7, 2, "div", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r4 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("components.schedule.title"));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
} }
class ScheduleDetailComponent {
    constructor(formBuilder, scheduleService, apiService, activeOffCanvas, timezoneService, changeDetectorRef, entityService, http, toaster, systemSettingsService, permissionService) {
        this.formBuilder = formBuilder;
        this.scheduleService = scheduleService;
        this.apiService = apiService;
        this.activeOffCanvas = activeOffCanvas;
        this.timezoneService = timezoneService;
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.http = http;
        this.toaster = toaster;
        this.systemSettingsService = systemSettingsService;
        this.permissionService = permissionService;
        this.mode = 'new';
        this.showReference = false;
        this.scheduleFormFields = {};
        this.savingSchedule = false;
        this.referenceList = [];
        this.loading = true;
        this.permission = PERMISSION;
        this.showPBRefWarning = false;
        this.excludeFormControl = [];
        this.playbookPermissions = this.permissionService.getPermission(FIXED_MODULE.PLAYBOOK);
    }
    ngOnInit() {
        if (!this.showReference) {
            this.excludeFormControl.push('reference');
        }
        this.systemSettings = this.systemSettingsService.get();
        this.entityService.build(FIXED_MODULE.SCHEDULES).pipe(switchMap((entity) => {
            this.scheduleEntity = cloneDeep(entity);
            this.exitRunningField = cloneDeep(this.scheduleEntity.fields.exit_if_running);
            this.exitRunningField.viewMode = 'checkbox';
            this.timezone = this.schedule.crontab.timezone ? this.timezoneService.getTimezoneByName(this.schedule.crontab.timezone) : undefined;
            this.timezone = this.timezone ?? this.timezoneService.getTimezoneByAbbr(this.systemSettings?.preferences.defaultTimezone || 'UTC');
            this.timezone = this.timezone ?? this.timezoneService.getTimezoneByAbbr('UTC');
            this.formGroup = this.formBuilder.group({
                crontab: [this.schedule.crontab],
                timezone: [this.timezone]
            });
            this.setFormGroupControls();
            if (this.mode === 'new') {
                this.formGroup.patchValue({
                    enabled: false,
                    reference: this.referenceData ?? null
                });
                this.loading = false;
                this.changeDetectorRef.detectChanges();
            }
            else if (this.mode === 'edit') {
                return this.loadSchedule();
            }
            return of('');
        }), tap(() => {
            this.loading = false;
            this.changeDetectorRef.detectChanges();
        }), switchMap(() => this.formGroup.valueChanges), tap((values) => {
            keys(values).forEach((key) => {
                let value = values[key];
                if (value && this.scheduleEntity.fields[key] && this.scheduleEntity.fields[key].formType === 'datetime') {
                    value = new Date(value).toISOString();
                }
                if (key === 'timezone') {
                    this.timezone = value;
                }
                else {
                    this.schedule[key] = value;
                }
            });
        })).subscribe();
        this.formGroup.valueChanges.subscribe((changes) => {
            if (changes.reference) {
                this.showPBRefWarning = !changes.reference.isActive;
                this.changeDetectorRef.detectChanges();
            }
        });
    }
    setFormGroupControls() {
        forEach(this.scheduleEntity.fields, (field) => {
            if (field.isFormField && this.excludeFormControl.indexOf(field.name) === -1) {
                let fieldCtrl = new FormControl(this.schedule[field.name] || null);
                if (field.validation.required) {
                    fieldCtrl.addValidators(Validators.required);
                }
                this.formGroup.addControl(field.name, fieldCtrl);
            }
        });
    }
    loadSchedule() {
        this.formGroup.patchValue({
            name: this.schedule.name,
            enabled: this.schedule.enabled,
            timezone: this.timezoneService.getTimezoneByName(this.schedule.kwargs.timezone),
            exit_if_running: this.schedule.kwargs.exit_if_running ?? false,
            start_time: Date.parse(this.schedule.start_time) ?? null,
            expires: Date.parse(this.schedule.expires) ?? null,
            crontab: this.schedule.crontab
        });
        if (!this.schedule.kwargs.wf_iri || !this.showReference) {
            return of(null);
        }
        return this.entityService.build(FIXED_MODULE.PLAYBOOK).pipe(switchMap((playbookEntity) => {
            const playbookUuid = this.schedule.kwargs.wf_iri.split('/')[4];
            const query = plainToInstance(Query, {
                filters: [{
                        field: 'uuid',
                        operator: 'eq',
                        value: playbookUuid
                    }]
            });
            return this.apiService.query(playbookEntity, query.getQueryObject(), {}, true).pipe(map((playbookResponse) => {
                if (playbookResponse['hydra:totalItems'] === 0) {
                    console.warn('Playbook not found (' + this.schedule.kwargs.wf_iri + ')');
                    return null;
                }
                return playbookResponse['hydra:member'][0];
            }), map((playbook) => {
                this.formGroup.patchValue({
                    reference: playbook
                });
            }));
        }));
    }
    save() {
        if (this.formGroup.invalid) {
            this.formGroup.markAllAsTouched();
            for (let formField of [...this.timezoneSelectComponents, ...this.formFieldComponents]) {
                if (!formField.valid) {
                    formField.focus();
                    break;
                }
            }
            return;
        }
        this.savingSchedule = true;
        this.schedule.crontab.timezone = this.timezone?.value || '';
        let observable$;
        let toasterSuccessMessage; // i18n?
        this.schedule.crontab.hour = this.schedule.crontab.hour.toString();
        this.schedule.crontab.minute = this.schedule.crontab.minute.toString();
        let schedule = plainToInstance(Schedule, this.schedule);
        schedule.id = this.schedule.id;
        schedule.kwargs = this.schedule.kwargs;
        schedule.kwargs.exit_if_running = this.schedule.exit_if_running;
        schedule.kwargs.timezone = this.schedule.crontab.timezone;
        schedule.crontab = this.schedule.crontab;
        schedule.kwargs.utcOffset = this.timezone?.utcOffset;
        schedule.enabled = this.formGroup.value.enabled;
        if (this.schedule.reference && this.schedule.reference['@id']) {
            schedule.kwargs.wf_iri = this.schedule.reference['@id'];
        }
        if (this.mode === 'new') {
            observable$ = this.scheduleService.create(schedule);
            toasterSuccessMessage = 'Schedule Created';
        }
        else if (this.mode === 'edit') {
            // TODO : Is there a better way to do this
            observable$ = this.scheduleService.update(schedule);
            toasterSuccessMessage = 'Schedule Updated';
        }
        observable$.subscribe({
            next: ((response) => {
                this.toaster.success(toasterSuccessMessage, 'Success');
                this.activeOffCanvas.close(response);
            })
        });
    }
    cancel() {
        this.activeOffCanvas.close();
    }
    static { this.ɵfac = function ScheduleDetailComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleDetailComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2.ScheduleService), i0.ɵɵdirectiveInject(i2.ApiService), i0.ɵɵdirectiveInject(i1$1.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i2.TimezoneService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.EntityService), i0.ɵɵdirectiveInject(i4.HttpClient), i0.ɵɵdirectiveInject(i5.ToastrService), i0.ɵɵdirectiveInject(i2.SystemSettingsService), i0.ɵɵdirectiveInject(i2.PermissionService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ScheduleDetailComponent, selectors: [["xf-schedule-detail"]], viewQuery: function ScheduleDetailComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(TimezoneSelectComponent, 5);
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.timezoneSelectComponents = _t);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFieldComponents = _t);
        } }, inputs: { mode: "mode", schedule: "schedule", showReference: "showReference", referenceData: "referenceData" }, decls: 1, vars: 0, consts: [["addScheduleForm", "ngForm"], [4, "transloco"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10"], ["type", "button", "id", "close-btn", 1, "btn", "btn-close", 3, "click"], ["class", "modal-body", 4, "ngIf"], ["class", "d-flex justify-content-center align-items-center", 4, "ngIf"], ["class", "modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px", 4, "ngIf"], [1, "modal-body"], [1, "padding-top-20px", "padding-bottom-20px", 3, "ngSubmit", "formGroup"], [1, "row", "m-0"], [1, "col-md-12"], [1, "form-group"], [1, "margin-bottom-8px"], ["fieldClass", "form-control-sm margin-bottom-8px w-100", 3, "field", "formControlName", "autoFocus"], [1, "margin-bottom-12px"], [4, "ngIf"], [1, "text-warning", "content-font", "fw-medium", "line-height-15px", "margin-top-8px"], [1, "margin-bottom-12px", "margin-top-12px"], [1, "form-label", "mb-1"], [1, "mb-2"], ["formControlName", "crontab"], ["formControlName", "timezone"], [1, "margin-bottom-12px", "d-flex"], [1, "col-md-6"], [1, "fa", "fa-warning", "fa-regular", "margin-right-4px"], [1, "d-flex", "justify-content-center", "align-items-center"], ["role", "status", 1, "spinner-border"], [1, "visually-hidden"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-right-8px", 3, "click"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"]], template: function ScheduleDetailComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ScheduleDetailComponent_div_0_Template, 8, 4, "div", 1);
        } }, dependencies: [i5$1.NgIf, i1.ɵNgNoValidate, i1.NgControlStatus, i1.NgControlStatusGroup, i2.FormFieldComponent, i1.FormGroupDirective, i1.FormControlName, i2.CronEditorComponent, i2.TimezoneSelectComponent, i2$1.TranslocoDirective], styles: [".close-btn[_ngcontent-%COMP%]{left:-50px;position:absolute}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleDetailComponent, [{
        type: Component,
        args: [{ selector: 'xf-schedule-detail', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div *transloco=\"let t\">\n<!-- Header -->\n<div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n  <h4 class=\"page-title-font modal-title muted-10\">{{ t('components.schedule.title') }}</h4>\n  <button type=\"button\" id=\"close-btn\" (click)=\"cancel()\" class=\"btn btn-close\"></button>\n\n</div>\n<!-- Body -->\n<div *ngIf=\"!loading\" class=\"modal-body\">\n  <form #addScheduleForm=\"ngForm\" (ngSubmit)=\"save()\" [formGroup]=\"formGroup\" class=\"padding-top-20px padding-bottom-20px\">\n    <div class=\"row m-0\">\n      <div class=\"col-md-12\">\n        <div class=\"form-group\">\n          <div class=\"margin-bottom-8px\">\n            <xf-form-field [field]=\"scheduleEntity.fields.name\"\n              [formControlName]=\"scheduleEntity.fields.name.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <xf-form-field [field]=\"scheduleEntity.fields.enabled\"\n              [formControlName]=\"scheduleEntity.fields.enabled.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div *ngIf=\"playbookPermissions.includes(permission.READ) && showReference\">\n            <xf-form-field [field]=\"scheduleEntity.fields.reference\"\n              [formControlName]=\"scheduleEntity.fields.reference.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          @if (showPBRefWarning) {\n            <div class=\"text-warning content-font fw-medium line-height-15px margin-top-8px\">\n              <i class=\"fa fa-warning fa-regular margin-right-4px\"></i>\n              <small>The playbook referenced is inactive. The schedule will not run it until it is changed to active.</small>\n            </div>\n          }\n          <div class=\"margin-bottom-12px margin-top-12px\">\n            <label class=\"form-label mb-1\">{{ t('components.schedule.labels.frequency') }}</label>\n            <div class=\"mb-2\">\n              <xf-cron-editor formControlName=\"crontab\"></xf-cron-editor>\n            </div>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <label class=\"form-label mb-1\">{{ t('components.schedule.labels.timezone') }}</label>\n            <xf-timezone-select formControlName=\"timezone\"></xf-timezone-select>\n          </div>\n          <div class=\"margin-bottom-12px\">\n            <xf-form-field [field]=\"exitRunningField\"\n              [formControlName]=\"scheduleEntity.fields.exit_if_running.name\"\n              fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n          </div>\n          <div class=\"margin-bottom-12px d-flex\">\n            <div class=\"col-md-6\">\n              <xf-form-field [field]=\"scheduleEntity.fields.start_time\"\n                [formControlName]=\"scheduleEntity.fields.start_time.name\"\n                fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n\n            </div>\n            <div class=\"col-md-6\">\n              <xf-form-field [field]=\"scheduleEntity.fields.expires\"\n                [formControlName]=\"scheduleEntity.fields.expires.name\"\n                fieldClass=\"form-control-sm margin-bottom-8px w-100\" [autoFocus]=\"true\"></xf-form-field>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </form>\n</div>\n<div class=\"d-flex justify-content-center align-items-center\" *ngIf=\"loading\">\n  <div class=\"spinner-border\" role=\"status\">\n    <span class=\"visually-hidden\">Loading...</span>\n  </div>\n</div>\n<!-- Footer -->\n<div *ngIf=\"!loading\" class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\">\n  <button type=\"button\" class=\"btn btn-primary btn-sm margin-right-8px\" (click)=\"save()\">\n    <i class=\"fa fa-check margin-right-4px\"></i>{{ t('buttons.save') }}\n  </button>\n  <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" (click)=\"cancel()\">\n    <i class=\"fa fa-times margin-right-4px\"></i>{{ t('buttons.cancel') }}\n  </button>\n</div>\n</div>\n", styles: [".close-btn{left:-50px;position:absolute}\n"] }]
    }], () => [{ type: i1.FormBuilder }, { type: i2.ScheduleService }, { type: i2.ApiService }, { type: i1$1.NgbActiveOffcanvas }, { type: i2.TimezoneService }, { type: i0.ChangeDetectorRef }, { type: i2.EntityService }, { type: i4.HttpClient }, { type: i5.ToastrService }, { type: i2.SystemSettingsService }, { type: i2.PermissionService }], { mode: [{
            type: Input
        }], schedule: [{
            type: Input
        }], showReference: [{
            type: Input
        }], referenceData: [{
            type: Input
        }], timezoneSelectComponents: [{
            type: ViewChildren,
            args: [TimezoneSelectComponent]
        }], formFieldComponents: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ScheduleDetailComponent, { className: "ScheduleDetailComponent", filePath: "src/schedule-detail/schedule-detail.component.ts", lineNumber: 17 }); })();

function ScheduleListComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 6)(1, "button", 7);
    i0.ɵɵlistener("click", function ScheduleListComponent_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.createSchedule()); });
    i0.ɵɵelement(2, "i", 8);
    i0.ɵɵtext(3, "Create Schedule ");
    i0.ɵɵelementEnd()();
} }
class ScheduleListComponent {
    constructor(entityService, gridDataSourceService, modalService, apiService, translocoService, toasterService, offcanvasService, permissionService, licenseService) {
        this.entityService = entityService;
        this.gridDataSourceService = gridDataSourceService;
        this.modalService = modalService;
        this.apiService = apiService;
        this.translocoService = translocoService;
        this.toasterService = toasterService;
        this.offcanvasService = offcanvasService;
        this.permissionService = permissionService;
        this.licenseService = licenseService;
        this.processing = false;
        this.selectedRows = [];
        this.permission = PERMISSION;
        this.defaultCron = {
            "minute": "*/5",
            "hour": "*",
            "day_of_week": "*",
            "day_of_month": "*",
            "month_of_year": "*",
            "timezone": "UTC"
        };
        this.schedulePermissions = this.permissionService.getPermission(FIXED_MODULE.SCHEDULES);
        this.licenseService.getLicenseDetails().subscribe((result) => {
            this.defaultCron.minute = `*/${result.info.polling_frequency}`;
        });
    }
    ngOnInit() {
        this.entityService.build(FIXED_MODULE.SCHEDULES).subscribe((entity) => {
            this.scheduleEntity = cloneDeep(entity);
            const query = new Query();
            query.filters.push(new Filter('task', 'eq', 'workflow.tasks.periodic_task'));
            this.dataSource = this.gridDataSourceService.getDataSource(entity, query);
        });
        this.gridConfig.options.onRegisterApi = (gridApi) => {
            this.gridApi = gridApi;
        };
        if (!this.gridConfig.options?.allowDelete) {
            this.setBulkDeleteConfig();
        }
    }
    createSchedule() {
        let schedule = new Schedule('');
        schedule.kwargs = {
            inputParameters: { query: { qparam: {} } }
        };
        schedule.crontab = this.defaultCron;
        this.offcanvasInstanceSchedule = this.offcanvasService.open(ScheduleDetailComponent, {
            animation: true,
            position: 'end',
            panelClass: 'schedule-list-modal offcanvas-slide-left',
            scroll: false,
            backdrop: false
        });
        this.offcanvasInstanceSchedule.componentInstance.showReference = true;
        this.offcanvasInstanceSchedule.componentInstance.mode = 'new'; //TODO: Do we really need mode?
        this.offcanvasInstanceSchedule.componentInstance.schedule = schedule;
        this.offcanvasInstanceSchedule.closed.subscribe((result) => {
            if (result) {
                this.gridApi?.refreshServerSide();
            }
        });
    }
    setBulkDeleteConfig() {
        this.gridConfig.options?.onRegisterApi;
        this.gridConfig.options.selectButtons = [{
                id: 'btn-delete-playbook',
                tooltip: 'Delete Playbook',
                onClick: () => {
                    this.deleteSelected();
                },
                class: 'btn-secondary margin-right-4px',
                iconClass: 'fa fa-trash fa-light',
                visible: this.schedulePermissions.includes(PERMISSION.DELETE)
            }];
    }
    rowSelectionChanged(event) {
        this.selectedRows = event;
    }
    deleteSelected() {
        this.modalService.confirm(this.translocoService.translate('components.grid.deleteMessage', {
            length: this.selectedRows.length,
            entityName: 'Schedule(s)'
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            let uuids = this.selectedRows.map((row) => row.id);
            let observables$ = [];
            uuids.forEach((uuid) => {
                observables$.push(this.apiService.deleteRecord(this.dataSource.entity, uuid));
            });
            return forkJoin(observables$);
        })).subscribe(() => {
            this.toasterService.success(this.translocoService.translate('components.grid.deletedToast', {
                length: this.selectedRows.length,
                entityName: 'Schedule(s)'
            }), 'Success');
            this.gridApi.deselectAll();
            this.selectedRows = [];
            this.gridApi.refreshServerSide();
        });
    }
    static { this.ɵfac = function ScheduleListComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleListComponent)(i0.ɵɵdirectiveInject(i2.EntityService), i0.ɵɵdirectiveInject(i2$2.GridDataSourceService), i0.ɵɵdirectiveInject(i2.ModalService), i0.ɵɵdirectiveInject(i2.ApiService), i0.ɵɵdirectiveInject(i2$1.TranslocoService), i0.ɵɵdirectiveInject(i5.ToastrService), i0.ɵɵdirectiveInject(i1$1.NgbOffcanvas), i0.ɵɵdirectiveInject(i2.PermissionService), i0.ɵɵdirectiveInject(i2.LicenseService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ScheduleListComponent, selectors: [["xf-schedule-list"]], inputs: { gridConfig: "gridConfig", customColumnDefs: "customColumnDefs" }, decls: 10, vars: 5, consts: [[1, "align-items-center", "schedule-list-header", "d-flex", "justify-content-between", "padding-bottom-12px", "padding-left-16px", "padding-right-16px", "padding-top-12px", "ms-3", "me-3"], [1, "page-header-font", "margin-bottom-4px"], [1, "page-subheader-font"], ["class", "d-flex", 4, "ngIf"], [1, "m-3"], [3, "rowSelectionChanged", "dataSource", "gridConfig", "customColumnDefs", "suppressContextMenu"], [1, "d-flex"], ["id", "create-schedule-btn", "type", "button", "ngbTooltip", "Create Schedule", 1, "btn", "btn-sm", "btn-primary", "margin-right-8px", 3, "click"], ["aria-hidden", "true", 1, "fa", "fa-add", "margin-right-4px"]], template: function ScheduleListComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div")(1, "div", 0)(2, "div")(3, "h3", 1);
            i0.ɵɵtext(4, "Schedules");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "h5", 2);
            i0.ɵɵtext(6, "Utilize the Schedules module to set up and manage schedules for running playbooks at regular intervals");
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(7, ScheduleListComponent_div_7_Template, 4, 0, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "div", 4)(9, "xf-grid", 5);
            i0.ɵɵlistener("rowSelectionChanged", function ScheduleListComponent_Template_xf_grid_rowSelectionChanged_9_listener($event) { return ctx.rowSelectionChanged($event); });
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.CREATE));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("dataSource", ctx.dataSource)("gridConfig", ctx.gridConfig)("customColumnDefs", ctx.customColumnDefs)("suppressContextMenu", true);
        } }, dependencies: [i5$1.NgIf, i2$2.GridComponent], styles: [".schedule-list-header[_ngcontent-%COMP%]{background:var(--element-default-bg-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleListComponent, [{
        type: Component,
        args: [{ selector: 'xf-schedule-list', changeDetection: ChangeDetectionStrategy.Default, template: "<div>\n    <div\n        class=\"align-items-center schedule-list-header d-flex justify-content-between padding-bottom-12px padding-left-16px padding-right-16px padding-top-12px ms-3 me-3\">\n        <div>\n            <h3 class=\"page-header-font margin-bottom-4px\">Schedules</h3>\n            <h5 class=\"page-subheader-font\">Utilize the Schedules module to set up and manage schedules for running playbooks at regular intervals</h5>\n        </div>\n        <!-- <input type=\"text\" class=\"ms-auto margin-right-8px w-350px form-control form-control-sm\" name=\"search-schedule\"\n            id=\"search-schedule\" placeholder=\"Search by Name, Tags, Commands etc\" /> -->\n        <div class=\"d-flex\" *ngIf=\"schedulePermissions.includes(permission.CREATE)\">\n            <button class=\"btn btn-sm btn-primary margin-right-8px\" id=\"create-schedule-btn\" type=\"button\"\n                (click)=\"createSchedule()\" ngbTooltip=\"Create Schedule\">\n                <i class=\"fa fa-add margin-right-4px\" aria-hidden=\"true\"></i>Create Schedule\n            </button>\n        </div>\n    </div>\n    <div class=\"m-3\">\n        <xf-grid [dataSource]=\"dataSource\" [gridConfig]=\"gridConfig\" [customColumnDefs]=\"customColumnDefs\"\n    [suppressContextMenu]=\"true\" (rowSelectionChanged)=\"rowSelectionChanged($event)\"></xf-grid>\n    </div>\n</div>\n", styles: [".schedule-list-header{background:var(--element-default-bg-color)}\n"] }]
    }], () => [{ type: i2.EntityService }, { type: i2$2.GridDataSourceService }, { type: i2.ModalService }, { type: i2.ApiService }, { type: i2$1.TranslocoService }, { type: i5.ToastrService }, { type: i1$1.NgbOffcanvas }, { type: i2.PermissionService }, { type: i2.LicenseService }], { gridConfig: [{
            type: Input
        }], customColumnDefs: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ScheduleListComponent, { className: "ScheduleListComponent", filePath: "src/schedule-list/schedule-list.component.ts", lineNumber: 20 }); })();

function ActionsRenderer_div_1_i_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 13);
} }
function ActionsRenderer_div_1_i_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "i", 14);
} }
function ActionsRenderer_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "button", 10);
    i0.ɵɵlistener("click", function ActionsRenderer_div_1_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.startStop(ctx_r1.cellValue.enabled)); });
    i0.ɵɵtemplate(2, ActionsRenderer_div_1_i_2_Template, 1, 0, "i", 11)(3, ActionsRenderer_div_1_i_3_Template, 1, 0, "i", 12);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.cellValue.enabled);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.cellValue.enabled);
} }
function ActionsRenderer_a_7_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 15);
    i0.ɵɵlistener("click", function ActionsRenderer_a_7_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.triggerNow()); });
    i0.ɵɵelement(1, "i", 16);
    i0.ɵɵtext(2, " Trigger Now ");
    i0.ɵɵelementEnd();
} }
function ActionsRenderer_li_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "li", 17);
} }
function ActionsRenderer_a_10_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 18);
    i0.ɵɵlistener("click", function ActionsRenderer_a_10_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.edit()); });
    i0.ɵɵelement(1, "i", 19);
    i0.ɵɵtext(2, " Edit ");
    i0.ɵɵelementEnd();
} }
function ActionsRenderer_li_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "li", 17);
} }
function ActionsRenderer_a_13_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "a", 20);
    i0.ɵɵlistener("click", function ActionsRenderer_a_13_Template_a_click_0_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.deleteSchedule()); });
    i0.ɵɵelement(1, "i", 21);
    i0.ɵɵtext(2, " Delete ");
    i0.ɵɵelementEnd();
} }
class ActionsRenderer {
    constructor(offcanvasService, changeDetectorRef, scheduleService, toaster, permissionService, modalService, translocoService) {
        this.offcanvasService = offcanvasService;
        this.changeDetectorRef = changeDetectorRef;
        this.scheduleService = scheduleService;
        this.toaster = toaster;
        this.permissionService = permissionService;
        this.modalService = modalService;
        this.translocoService = translocoService;
        this.showDropdown = false;
        this.permission = PERMISSION;
        this.schedulePermissions = this.permissionService.getPermission(FIXED_MODULE.SCHEDULES);
    }
    // gets called once before the renderer is used
    agInit(params) {
        let value = this.getValueToDisplay(params);
        this.cellValue = value.data;
        this.param = params;
    }
    // gets called whenever the cell refreshes
    refresh(params) {
        // set value into cell again
        this.cellValue = this.getValueToDisplay(params);
        return true;
    }
    getValueToDisplay(params) {
        return params.valueFormatted ? params.valueFormatted : params;
    }
    edit() {
        this.offcanvasInstanceSchedule = this.offcanvasService.open(ScheduleDetailComponent, {
            animation: true,
            position: 'end',
            panelClass: 'schedule-list-modal offcanvas-slide-left',
            scroll: false,
            backdrop: false
        });
        this.offcanvasInstanceSchedule.componentInstance.showReference = true;
        this.offcanvasInstanceSchedule.componentInstance.mode = 'edit';
        this.offcanvasInstanceSchedule.componentInstance.schedule = this.cellValue.data ? this.cellValue.data : this.cellValue;
        this.offcanvasInstanceSchedule.closed.subscribe((result) => {
            if (result) {
                this.param.api.refreshServerSide();
            }
        });
    }
    deleteSchedule() {
        this.modalService.confirm(this.translocoService.translate('components.schedule.delete_confirmation', {
            scheduleName: this.cellValue.name
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            return this.scheduleService.delete(this.cellValue.id);
        })).subscribe({
            next: () => {
                this.toaster.success(this.translocoService.translate('components.schedule.delete_success', {
                    scheduleName: this.cellValue.name
                }), 'Success');
                this.param.api.refreshServerSide();
            }, error: (e) => {
                if (e instanceof HttpErrorResponse) {
                    this.toaster.error(this.translocoService.translate('components.schedule.delete_error', {
                        scheduleName: this.cellValue.name
                    }), 'Error');
                }
            }
        });
    }
    triggerNow() {
        this.scheduleService.trigger(this.cellValue.id).subscribe({
            next: (() => {
                this.toaster.success('Schedule Triggered', 'Success');
            }), error: (() => {
                this.toaster.error('Schedule Trigger Failed', 'Error');
            })
        });
    }
    showDropDown() {
        this.showDropdown = true;
    }
    startStop(startSchedule) {
        this.cellValue.enabled = !startSchedule;
        this.scheduleService.update(this.cellValue).subscribe(() => {
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function ActionsRenderer_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ActionsRenderer)(i0.ɵɵdirectiveInject(i1$1.NgbOffcanvas), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.ScheduleService), i0.ɵɵdirectiveInject(i5.ToastrService), i0.ɵɵdirectiveInject(i2.PermissionService), i0.ɵɵdirectiveInject(i2.ModalService), i0.ɵɵdirectiveInject(i2$1.TranslocoService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ActionsRenderer, selectors: [["ng-component"]], decls: 14, vars: 6, consts: [[1, "d-flex"], [4, "ngIf"], ["ngbDropdown", "", "container", "body", 1, "margin-right-8px"], ["ngbDropdownToggle", "", "id", "settings-schedule", "type", "button", "title", "Settings Schedule", 1, "dropdown-toggle", "btn", "btn-secondary", "btn-sm", "dropdown-caret-off"], [1, "fa-solid", "fa-ellipsis-stroke"], ["ngbDropdownMenu", "", "aria-labelledby", "scheduleActions", 1, "dropdown-menu", "mx-0", "border-0", "shadow"], ["ngbDropdownItem", "", "id", "trigger-schedule-btn", "class", "cursor-pointer", 3, "click", 4, "ngIf"], ["class", "dropdown-divider", 4, "ngIf"], ["ngbDropdownItem", "", "id", "edit-schedule-btn", "class", "cursor-pointer", 3, "click", 4, "ngIf"], ["ngbDropdownItem", "", "id", "delete-schedule-btn", "class", "cursor-pointer", 3, "click", 4, "ngIf"], ["id", "start-stop-schedule", "type", "button", "title", "Start Schedule", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], ["class", "fa fa-play", 4, "ngIf"], ["class", "fa fa-pause", 4, "ngIf"], [1, "fa", "fa-play"], [1, "fa", "fa-pause"], ["ngbDropdownItem", "", "id", "trigger-schedule-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false", 1, "fa", "fa-bolt", "margin-right-4px"], [1, "dropdown-divider"], ["ngbDropdownItem", "", "id", "edit-schedule-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false", 1, "fa", "fa-pencil", "margin-right-4px"], ["ngbDropdownItem", "", "id", "delete-schedule-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false", 1, "fa", "fa-trash", "margin-right-4px"]], template: function ActionsRenderer_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, ActionsRenderer_div_1_Template, 4, 2, "div", 1);
            i0.ɵɵelementStart(2, "div", 2)(3, "button", 3);
            i0.ɵɵelement(4, "i", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "div", 5)(6, "li");
            i0.ɵɵtemplate(7, ActionsRenderer_a_7_Template, 3, 0, "a", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(8, ActionsRenderer_li_8_Template, 1, 0, "li", 7);
            i0.ɵɵelementStart(9, "li");
            i0.ɵɵtemplate(10, ActionsRenderer_a_10_Template, 3, 0, "a", 8);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(11, ActionsRenderer_li_11_Template, 1, 0, "li", 7);
            i0.ɵɵelementStart(12, "li");
            i0.ɵɵtemplate(13, ActionsRenderer_a_13_Template, 3, 0, "a", 9);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.UPDATE));
            i0.ɵɵadvance(6);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.EXECUTE));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.EXECUTE));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.UPDATE));
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.UPDATE));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.schedulePermissions.includes(ctx.permission.DELETE));
        } }, dependencies: [i5$1.NgIf, i1$1.NgbDropdown, i1$1.NgbDropdownToggle, i1$1.NgbDropdownMenu, i1$1.NgbDropdownItem], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ActionsRenderer, [{
        type: Component,
        args: [{ changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"d-flex\">\n    <div *ngIf=\"schedulePermissions.includes(permission.UPDATE)\"><button class=\"btn btn-secondary btn-sm me-2\" id=\"start-stop-schedule\" type=\"button\" title=\"Start Schedule\" (click)=\"startStop(this.cellValue.enabled)\">\n        <i *ngIf=\"!this.cellValue.enabled\" class=\"fa fa-play\"></i>\n        <i *ngIf=\"this.cellValue.enabled\" class=\"fa fa-pause\"></i>\n    </button></div>\n    <div ngbDropdown class=\"margin-right-8px\" container=\"body\">\n        <button ngbDropdownToggle class=\"dropdown-toggle btn btn-secondary btn-sm dropdown-caret-off\" id=\"settings-schedule\" type=\"button\" title=\"Settings Schedule\">\n            <i class=\"fa-solid fa-ellipsis-stroke\"></i>\n        </button>\n        <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\" aria-labelledby=\"scheduleActions\">\n            <li>\n              <a ngbDropdownItem id=\"trigger-schedule-btn\" class=\"cursor-pointer\" (click)=\"triggerNow()\" *ngIf=\"schedulePermissions.includes(permission.EXECUTE)\">\n                  <i class=\"fa fa-bolt margin-right-4px\" aria-hidden=\"false\"></i> Trigger Now\n              </a>\n            </li>\n            <li class=\"dropdown-divider\" *ngIf=\"schedulePermissions.includes(permission.EXECUTE)\"></li>\n            <li>\n              <a ngbDropdownItem id=\"edit-schedule-btn\" class=\"cursor-pointer\" (click)=\"edit()\" *ngIf=\"schedulePermissions.includes(permission.UPDATE)\">\n                  <i class=\"fa fa-pencil margin-right-4px\" aria-hidden=\"false\"></i> Edit\n              </a>\n            </li>\n            <li class=\"dropdown-divider\" *ngIf=\"schedulePermissions.includes(permission.UPDATE)\"></li>\n            <li>\n              <a ngbDropdownItem id=\"delete-schedule-btn\" class=\"cursor-pointer\" (click)=\"deleteSchedule()\" *ngIf=\"schedulePermissions.includes(permission.DELETE)\">\n                <i class=\"fa fa-trash margin-right-4px\" aria-hidden=\"false\"></i> Delete\n              </a>\n            </li>\n        </div>\n    </div>\n\n</div>\n" }]
    }], () => [{ type: i1$1.NgbOffcanvas }, { type: i0.ChangeDetectorRef }, { type: i2.ScheduleService }, { type: i5.ToastrService }, { type: i2.PermissionService }, { type: i2.ModalService }, { type: i2$1.TranslocoService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ActionsRenderer, { className: "ActionsRenderer", filePath: "src/schedule-list/cell-renderers/actions/actions.component.ts", lineNumber: 17 }); })();

const _c0$1 = (a0, a1) => ({ "active": a0, "inactive": a1 });
class StatusRenderer {
    // gets called once before the renderer is used
    agInit(params) {
        this.cellValue = this.getValueToDisplay(params);
    }
    // gets called whenever the cell refreshes
    refresh(params) {
        // set value into cell again
        this.cellValue = this.getValueToDisplay(params);
        return true;
    }
    getValueToDisplay(params) {
        return params.valueFormatted ? params.valueFormatted : params.data;
    }
    static { this.ɵfac = function StatusRenderer_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || StatusRenderer)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: StatusRenderer, selectors: [["ng-component"]], decls: 5, vars: 5, consts: [[1, "fa-solid", "fa-circle", "me-2", 3, "ngClass"]], template: function StatusRenderer_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div")(1, "span");
            i0.ɵɵelement(2, "i", 0);
            i0.ɵɵelementStart(3, "span");
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(2, _c0$1, ctx.cellValue.enabled, !ctx.cellValue.enabled));
            i0.ɵɵadvance(2);
            i0.ɵɵtextInterpolate(ctx.cellValue.enabled ? " Active" : " Inactive");
        } }, dependencies: [i5$1.NgClass], styles: [".active[_ngcontent-%COMP%]{color:green}.inactive[_ngcontent-%COMP%]{color:red}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(StatusRenderer, [{
        type: Component,
        args: [{ template: "<div>\n    <span>\n        <i class=\"fa-solid fa-circle me-2\" [ngClass]=\"{'active': cellValue.enabled, 'inactive': !cellValue.enabled}\"></i>\n        <span>{{cellValue.enabled ? ' Active' : ' Inactive'}}</span>\n    </span>\n</div>", styles: [".active{color:green}.inactive{color:red}\n"] }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(StatusRenderer, { className: "StatusRenderer", filePath: "src/schedule-list/cell-renderers/status/status.component.ts", lineNumber: 9 }); })();

class ManagePurge {
    constructor() {
        this.manageText = 'Manage Purge';
        this.purgeNowText = 'Purge Now';
        this.purgeNowIcon = 'fa fa-light fa-trash';
        this.schedulePurgeText = 'Schedule Purge';
        this.schedulePurgeIcon = 'fa fa-light fa-watch';
        this.purgeNow = new PurgeNow();
        this.schedulePurge = new SchedulePurge();
    }
}
class PurgeNow {
    constructor() {
        this.metadata = {
            title: '',
            description: '',
        };
        this.extraFields = {
            onlyRead: false
        };
        this.dateFieldParams = {
            fieldTitle: 'Purge logs prior to',
        };
        this.save$ = () => {
            return of({});
        };
    }
}
class SchedulePurge {
    constructor() {
        this.metadata = {
            title: '',
            description: '',
        };
        this.scheduleDetailModalClass = '';
        this.getSetting$ = () => {
            return of({});
        };
        this.save$ = () => {
            return of({});
        };
    }
}

function PurgeNowComponent_ng_container_0_div_16_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 11)(1, "label", 19);
    i0.ɵɵtext(2, "Keep Unread");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(3, "xf-form-field", 20);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("field", ctx_r1.formFields.onlyRead)("fieldOptions", ctx_r1.fieldOptions);
} }
function PurgeNowComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "div", 2)(2, "h4", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 4);
    i0.ɵɵlistener("click", function PurgeNowComponent_ng_container_0_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "div", 5)(6, "form", 6, 0);
    i0.ɵɵlistener("ngSubmit", function PurgeNowComponent_ng_container_0_Template_form_ngSubmit_6_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.purge()); });
    i0.ɵɵelementStart(8, "div")(9, "label", 7);
    i0.ɵɵtext(10);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(11, "div", 8)(12, "div", 9)(13, "div", 10)(14, "div", 11);
    i0.ɵɵelement(15, "xf-form-field", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(16, PurgeNowComponent_ng_container_0_div_16_Template, 4, 2, "div", 13);
    i0.ɵɵelementEnd()()()()();
    i0.ɵɵelementStart(17, "div", 14)(18, "button", 15);
    i0.ɵɵlistener("click", function PurgeNowComponent_ng_container_0_Template_button_click_18_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.purge()); });
    i0.ɵɵelement(19, "i", 16);
    i0.ɵɵtext(20);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(21, "button", 17);
    i0.ɵɵlistener("click", function PurgeNowComponent_ng_container_0_Template_button_click_21_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelement(22, "i", 18);
    i0.ɵɵtext(23);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const t_r3 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.title);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.description);
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("field", ctx_r1.formFields.purgeLogsBefore)("fieldClass", "form-control-sm margin-bottom-8px w-100")("autoFocus", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.params.extraFields.onlyRead);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("disabled", ctx_r1.formGroup.invalid);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1("", t_r3("buttons.purge"), " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r3("buttons.cancel"), " ");
} }
class PurgeNowComponent {
    constructor(formBuilder, activeOffCanvas) {
        this.formBuilder = formBuilder;
        this.activeOffCanvas = activeOffCanvas;
        this.formFields = {};
        this.purgePayload = new Query();
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.params = new PurgeNow();
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({
            purgeLogsBefore: [new Date(), Validators.required],
            onlyRead: [false]
        });
        this.formFields.purgeLogsBefore = new DatetimeField(this.params.dateFieldParams.fieldTitle);
        this.formFields.purgeLogsBefore.validation = { required: true };
        this.formFields.onlyRead = new CheckboxField('Unread Only');
    }
    cancel() {
        this.activeOffCanvas.close();
    }
    purge() {
        let date = new Date(this.formGroup.value.purgeLogsBefore).toISOString();
        let data = {
            date: date,
            onlyRead: this.formGroup.value.onlyRead
        };
        this.params.save$(data).subscribe((options) => {
            if (options.closeAndRefresh) {
                this.activeOffCanvas.close('refresh');
            }
            else {
                this.activeOffCanvas.close();
            }
        });
    }
    static { this.ɵfac = function PurgeNowComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PurgeNowComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i1$1.NgbActiveOffcanvas)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PurgeNowComponent, selectors: [["xf-purge-now"]], inputs: { params: "params" }, decls: 1, vars: 0, consts: [["purgeNowForm", "ngForm"], [4, "transloco"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "font-size-16px", "fw-normal", "modal-title", "muted-10"], ["type", "button", "id", "close-btn-purge", 1, "btn", "btn-close", 3, "click"], [1, "margin-top-20px", "modal-body"], [1, "ms-2", 3, "ngSubmit", "formGroup"], [1, "form-check-label", "align-bottom", "margin-left-10px", "margin-bottom-10px", "label-font"], [1, "row", "m-0"], [1, "col-md-12"], [1, "form-group"], [1, "mb-1"], ["formControlName", "purgeLogsBefore", 3, "field", "fieldClass", "autoFocus"], ["class", "mb-1", 4, "ngIf"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "me-2"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-right-8px", 3, "click", "disabled"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"], ["for", "input-onlyRead", 1, "form-label", "mb-0"], ["fieldClass", "muted-40", "formControlName", "onlyRead", 3, "field", "fieldOptions"]], template: function PurgeNowComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PurgeNowComponent_ng_container_0_Template, 24, 10, "ng-container", 1);
        } }, dependencies: [i5$1.NgIf, i1.ɵNgNoValidate, i1.NgControlStatus, i1.NgControlStatusGroup, i2.FormFieldComponent, i1.FormGroupDirective, i1.FormControlName, i2$1.TranslocoDirective] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PurgeNowComponent, [{
        type: Component,
        args: [{ selector: 'xf-purge-now', template: "<ng-container *transloco=\"let t\">\n  <!-- Header -->\n  <div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n    <h4 class=\"font-size-16px fw-normal modal-title muted-10\">{{ params.metadata.title }}</h4>\n    <button type=\"button\" id=\"close-btn-purge\" (click)=\"cancel()\" class=\"btn btn-close\"></button>\n  </div>\n  <!-- Body -->\n  <div class=\"margin-top-20px modal-body\">\n    <form #purgeNowForm=\"ngForm\" (ngSubmit)=\"purge()\" [formGroup]=\"formGroup\" class=\"ms-2\">\n      <div>\n        <label class=\"form-check-label align-bottom margin-left-10px margin-bottom-10px label-font\">{{\n          params.metadata.description }}</label>\n      </div>\n      <div class=\"row m-0\">\n        <div class=\"col-md-12\">\n          <div class=\"form-group\">\n            <div class=\"mb-1\">\n              <xf-form-field [field]=\"formFields.purgeLogsBefore\" formControlName=\"purgeLogsBefore\"\n                [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\" [autoFocus]=\"true\"></xf-form-field>\n            </div>\n            <div class=\"mb-1\" *ngIf=\"params.extraFields.onlyRead\">\n              <label for=\"input-onlyRead\" class=\"form-label mb-0\">Keep Unread</label>\n              <xf-form-field [field]=\"formFields.onlyRead\" fieldClass=\"muted-40\" formControlName=\"onlyRead\" [fieldOptions]=\"fieldOptions\"></xf-form-field>\n            </div>\n          </div>\n        </div>\n      </div>\n    </form>\n  </div>\n  <!-- Footer -->\n  <div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px me-2\">\n    <button type=\"button\" class=\"btn btn-primary btn-sm margin-right-8px\" [disabled]=\"formGroup.invalid\"\n      (click)=\"purge()\">\n      <i class=\"fa fa-check margin-right-4px\"></i>{{ t('buttons.purge') }}\n    </button>\n    <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" (click)=\"cancel()\">\n      <i class=\"fa fa-times margin-right-4px\"></i>{{ t('buttons.cancel') }}\n    </button>\n  </div>\n</ng-container>\n" }]
    }], () => [{ type: i1.FormBuilder }, { type: i1$1.NgbActiveOffcanvas }], { params: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PurgeNowComponent, { className: "PurgeNowComponent", filePath: "src/manage-purge/purge-now/purge-now.component.ts", lineNumber: 12 }); })();

const _c0 = (a0, a1) => ({ "text-bg-success": a0, "text-bg-danger": a1 });
const _c1 = (a0, a1) => ({ "fa-check": a0, "fa-minus": a1 });
function PurgeScheduleComponent_div_0_div_5_div_8_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 25)(1, "div", 26)(2, "label", 27);
    i0.ɵɵtext(3, "Schedule Status");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "span", 28);
    i0.ɵɵelement(5, "span", 29);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c0, ctx_r1.schedule.enabled, !ctx_r1.schedule.enabled));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(6, _c1, ctx_r1.schedule.enabled, !ctx_r1.schedule.enabled));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r1.schedule.enabled ? "Active" : "Inactive", " ");
} }
function PurgeScheduleComponent_div_0_div_5_div_8_Conditional_3_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 30);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_div_5_div_8_Conditional_3_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(4); return i0.ɵɵresetView(ctx_r1.openSchedule()); });
    i0.ɵɵelementStart(1, "span");
    i0.ɵɵtext(2, "View Schedule");
    i0.ɵɵelementEnd()();
} }
function PurgeScheduleComponent_div_0_div_5_div_8_Conditional_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 20);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.cronDescriber);
} }
function PurgeScheduleComponent_div_0_div_5_div_8_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 21)(1, "label", 22);
    i0.ɵɵtext(2, "Last run at:");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "span", 23);
    i0.ɵɵtext(4);
    i0.ɵɵpipe(5, "date");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(i0.ɵɵpipeBind2(5, 1, ctx_r1.schedule.last_run_at, ctx_r1.systemSettings.preferences.dateTimeFormat));
} }
function PurgeScheduleComponent_div_0_div_5_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "div", 17);
    i0.ɵɵtemplate(2, PurgeScheduleComponent_div_0_div_5_div_8_div_2_Template, 7, 9, "div", 18)(3, PurgeScheduleComponent_div_0_div_5_div_8_Conditional_3_Template, 3, 0, "button", 19)(4, PurgeScheduleComponent_div_0_div_5_div_8_Conditional_4_Template, 2, 1, "span", 20);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "div", 21)(6, "label", 22);
    i0.ɵɵtext(7, "Frequency:");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(8, "span", 23);
    i0.ɵɵtext(9);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(10, PurgeScheduleComponent_div_0_div_5_div_8_div_10_Template, 6, 4, "div", 24);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r1.schedule);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.entitlementType !== "trial" ? 3 : -1);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.entitlementType === "trial" ? 4 : -1);
    i0.ɵɵadvance(5);
    i0.ɵɵtextInterpolate(ctx_r1.cronDescriber);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.schedule.last_run_at);
} }
function PurgeScheduleComponent_div_0_div_5_Conditional_9_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 14)(1, "p", 31);
    i0.ɵɵtext(2, "As per your entitlement, the schedule cannot be edited.");
    i0.ɵɵelementEnd()();
} }
function PurgeScheduleComponent_div_0_div_5_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 32);
    i0.ɵɵelement(1, "i", 33);
    i0.ɵɵelementStart(2, "small");
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext(2).$implicit;
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(t_r4("admin.auditLogs.schedulePurge.scheduleRequired"));
} }
function PurgeScheduleComponent_div_0_div_5_div_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 34)(1, "div", 35);
    i0.ɵɵelement(2, "xf-form-field", 36);
    i0.ɵɵelementStart(3, "span", 37);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
    i0.ɵɵelement(5, "xf-form-messages", 38)(6, "div", 39);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.fields.keepLogs)("fieldOptions", ctx_r1.keepLogsFieldOption);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(t_r4("admin.purgeLogs.schedule.primaryCriteriaLabels.days"));
    i0.ɵɵadvance();
    i0.ɵɵproperty("control", ctx_r1.formGroup.controls.keepLogs)("customErrorMessages", ctx_r1.keepLogsFieldOption.customErrorMessages);
} }
function PurgeScheduleComponent_div_0_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8)(1, "form", 9, 0)(3, "div")(4, "label", 10);
    i0.ɵɵtext(5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "div", 11);
    i0.ɵɵelement(7, "xf-form-field", 12);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(8, PurgeScheduleComponent_div_0_div_5_div_8_Template, 11, 5, "div", 13)(9, PurgeScheduleComponent_div_0_div_5_Conditional_9_Template, 3, 0, "div", 14)(10, PurgeScheduleComponent_div_0_div_5_div_10_Template, 4, 1, "div", 15)(11, PurgeScheduleComponent_div_0_div_5_div_11_Template, 7, 5, "div", 16);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    let tmp_10_0;
    let tmp_13_0;
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.description);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("field", ctx_r1.fields["enablePurge"])("formControlName", "enablePurge")("fieldClass", "form-control-sm margin-bottom-8px w-100")("autoFocus", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (tmp_10_0 = ctx_r1.formGroup.get("enablePurge")) == null ? null : tmp_10_0.value);
    i0.ɵɵadvance();
    i0.ɵɵconditional(ctx_r1.entitlementType === "trial" ? 9 : -1);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.showScheduleError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (tmp_13_0 = ctx_r1.formGroup.get("enablePurge")) == null ? null : tmp_13_0.value);
} }
function PurgeScheduleComponent_div_0_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 40);
    i0.ɵɵelement(1, "i", 41);
    i0.ɵɵelementEnd();
} }
function PurgeScheduleComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 42)(1, "button", 43);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_div_7_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.save()); });
    i0.ɵɵelement(2, "i", 44);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 45);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_div_7_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r5); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelement(5, "i", 46);
    i0.ɵɵtext(6);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r4 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.save"), " ");
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate1("", t_r4("buttons.cancel"), " ");
} }
function PurgeScheduleComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div")(1, "div", 2)(2, "h4", 3);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "button", 4);
    i0.ɵɵlistener("click", function PurgeScheduleComponent_div_0_Template_button_click_4_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, PurgeScheduleComponent_div_0_div_5_Template, 12, 10, "div", 5)(6, PurgeScheduleComponent_div_0_div_6_Template, 2, 0, "div", 6)(7, PurgeScheduleComponent_div_0_div_7_Template, 7, 2, "div", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵtextInterpolate(ctx_r1.params.metadata.title);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
} }
class PurgeScheduleComponent {
    constructor(formBuilder, translocoService, activeOffCanvas, offcanvasServicePurge, scheduleService, licenseService, systemSettingsService) {
        this.formBuilder = formBuilder;
        this.translocoService = translocoService;
        this.activeOffCanvas = activeOffCanvas;
        this.offcanvasServicePurge = offcanvasServicePurge;
        this.scheduleService = scheduleService;
        this.licenseService = licenseService;
        this.systemSettingsService = systemSettingsService;
        this.fields = {};
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.loading = true;
        this.scheduleClosed = new EventEmitter();
        this.showScheduleError = false;
        this.keepLogsFieldTooltip = '';
        this.systemSettings = this.systemSettingsService.get();
    }
    ngOnInit() {
        this.params.getSetting$().pipe(concatMap((result) => {
            this.settings = result;
            return this.getScheduleData();
        })).subscribe();
    }
    getScheduleData() {
        return this.scheduleService.getByTaskName(this.params.taskName).pipe(concatMap((result) => {
            if (result) {
                this.schedule = result;
                this.scheduleMode = 'edit';
            }
            return this.licenseService.getLicenseDetails().pipe(tap((licenseDetails) => {
                this.licenseDetails = licenseDetails;
                this.entitlementType = licenseDetails.type;
                this.cronDescriber = cronstrue.toString(`${this.schedule.crontab.minute} ${this.schedule.crontab.hour} ${this.schedule.crontab.day_of_month} ${this.schedule.crontab.month_of_year} ${this.schedule.crontab.day_of_week}`);
                this.loading = false;
                this.setForm();
            }));
        }));
    }
    setForm() {
        const warningMessage = this.translocoService.translate('admin.purgeLogs.DATA_RETENTION_POLICY_WARNING', { days: this.licenseDetails.info.data_retention_period });
        const defaultMessage = this.translocoService.translate('admin.purgeLogs.DEFAULT_ENTERPRISE_VALUE', { days: this.licenseDetails.info.data_retention_period });
        this.keepLogsFieldTooltip = this.entitlementType === 'trial' ? warningMessage : defaultMessage;
        this.formGroup = this.formBuilder.group({
            enablePurge: new FormControl(''),
            keepLogs: [this.licenseDetails.info.data_retention_period, Validators.required]
        });
        this.fields.keepLogs = new IntegerField('keepLogs');
        this.fields.keepLogs.title = 'Retain Logs For';
        this.fields.keepLogs.tooltip = this.keepLogsFieldTooltip;
        this.fields.keepLogs.validation.required = true;
        this.fields.keepLogs.validation.min = 1;
        this.fields.keepLogs.validation.max = 3650; // 10 years
        this.keepLogsFieldOption = new FieldOptions({
            showLabel: true,
            showError: false
        });
        if (this.entitlementType === 'trial') {
            this.formGroup.controls.keepLogs.disable();
        }
        this.fields.enablePurge = new CheckboxField('enablePurge');
        this.fields.enablePurge.title = 'Activate Log Purging';
        this.setFormValues();
    }
    setFormValues() {
        this.formGroup.patchValue({
            enablePurge: this.settings.data.enabled,
            keepLogs: this.entitlementType === 'trial' ? this.licenseDetails.info.data_retention_period : this.settings.data.ttl
        });
        this.loading = false;
        if (this.entitlementType === 'trial') {
            this.formGroup.get('enabledPurge')?.disable();
        }
    }
    openSchedule() {
        this.offcanvasInstancePurge = this.offcanvasServicePurge.open(ScheduleDetailComponent, {
            animation: true,
            position: 'end',
            panelClass: `offcanvas-slide-left ${this.params.scheduleDetailModalClass}`,
            scroll: false,
            backdrop: false
        });
        this.offcanvasInstancePurge.componentInstance.showReference = false;
        this.offcanvasInstancePurge.componentInstance.referenceData = null;
        this.offcanvasInstancePurge.componentInstance.mode = this.scheduleMode;
        this.offcanvasInstancePurge.componentInstance.schedule = this.schedule;
        this.offcanvasInstancePurge.closed.subscribe((result) => {
            if (result) {
                this.schedule = result;
                let cron = this.schedule.crontab;
                delete cron['timezone'];
                if (this.showScheduleError && result.id) {
                    this.showScheduleError = false;
                }
                this.cronDescriber = cronstrue.toString(`${this.schedule.crontab.minute} ${this.schedule.crontab.hour} ${this.schedule.crontab.day_of_month} ${this.schedule.crontab.month_of_year} ${this.schedule.crontab.day_of_week}`);
                this.setFormValues();
            }
            this.scheduleClosed.emit(this.schedule);
        });
    }
    cancel() {
        this.activeOffCanvas.close();
    }
    save() {
        if (this.formGroup.invalid) {
            this.focusOnFirstInvalidInput();
            return;
        }
        let schedule_config;
        let observable$ = of(null);
        // Update Scheudle and set data for settings
        if ('enablePurge' in this.formGroup.value && !this.formGroup.value.enablePurge) {
            schedule_config = {
                enabled: false
            };
            this.schedule.enabled = false;
            observable$ = this.scheduleService.update(this.schedule);
        }
        else {
            schedule_config = {
                ttl: parseInt(this.formGroup.value.keepLogs || this.licenseDetails.info.data_retention_period),
                scheduleId: this.schedule.id,
                enabled: true
            };
        }
        this.settings.data = schedule_config;
        observable$.pipe(concatMap(() => this.params.save$(this.settings))
        //this.auditService.updateSettings(this.settings))
        ).subscribe((result) => {
            if (result.close) {
                this.activeOffCanvas.close(result.data);
            }
        });
    }
    // Update Settings
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        for (let formField of this.formFields) {
            if (!formField.valid) {
                formField.focus();
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function PurgeScheduleComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PurgeScheduleComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2$1.TranslocoService), i0.ɵɵdirectiveInject(i1$1.NgbActiveOffcanvas), i0.ɵɵdirectiveInject(i1$1.NgbOffcanvas), i0.ɵɵdirectiveInject(i2.ScheduleService), i0.ɵɵdirectiveInject(i2.LicenseService), i0.ɵɵdirectiveInject(i2.SystemSettingsService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PurgeScheduleComponent, selectors: [["xf-purge-schedule"]], viewQuery: function PurgeScheduleComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, inputs: { schedule: "schedule", params: "params" }, outputs: { scheduleClosed: "scheduleClosed" }, decls: 1, vars: 0, consts: [["auditLogPurgeScheduleForm", "ngForm"], [4, "transloco"], [1, "modal-header", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px", "modal-close-left"], [1, "page-title-font", "modal-title", "muted-10", "font-size-16px"], ["type", "button", "id", "close-btn-schedule", 1, "btn", "btn-close", 3, "click"], ["class", "margin-top-20px modal-body", 4, "ngIf"], ["class", "margin-top-28px text-center", 4, "ngIf"], ["class", "modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px", 4, "ngIf"], [1, "margin-top-20px", "modal-body"], [1, "ms-2", 3, "formGroup"], [1, "form-check-label", "align-bottom", "margin-left-10px", "margin-bottom-10px", "label-font"], [1, "margin-left-10px"], [3, "field", "formControlName", "fieldClass", "autoFocus"], [4, "ngIf"], [1, "ps-1", "pt-1"], ["class", "text-danger content-font fw-medium line-height-15px margin-top-8px ms-2", 4, "ngIf"], ["class", "ms-2 margin-top-12px", 4, "ngIf"], [1, "align-items-center", "d-flex"], ["class", "schedule-status me-2 ms-2 content-font", 4, "ngIf"], ["title", "View Schedule", 1, "btn", "btn-secondary", "btn-sm"], [1, "cron-describer", "mt-2"], [1, "margin-left-10px", "margin-top-10px"], [1, "content-font"], [1, "cron-describer", "margin-left-16px", "muted-50"], ["class", "margin-left-10px margin-top-10px", 4, "ngIf"], [1, "schedule-status", "me-2", "ms-2", "content-font"], [1, "padding-10px"], [1, "me-2"], [1, "padding-bottom-4px", "padding-left-10px", "padding-right-10px", "padding-top-4px", "rounded-4px", "text-bg-success", "text-light", 3, "ngClass"], [1, "padding-right-4px", "fa", 3, "ngClass"], ["title", "View Schedule", 1, "btn", "btn-secondary", "btn-sm", 3, "click"], [1, "content-font", "margin-left-4px", "mb-0", "mb-1", "p-0", "text-warning"], [1, "text-danger", "content-font", "fw-medium", "line-height-15px", "margin-top-8px", "ms-2"], [1, "fa", "fa-exclamation-circle", "fa-regular", "margin-right-4px"], [1, "ms-2", "margin-top-12px"], [1, "d-flex", "content-font", "align-items-center"], ["formControlName", "keepLogs", "fieldClass", "form-control-sm w-150px", 3, "field", "fieldOptions"], [1, "padding-left-12px", "font-size-12px", "muted-40", "margin-top-20px"], [3, "control", "customErrorMessages"], [1, "clearfix"], [1, "margin-top-28px", "text-center"], [1, "fa", "fa-refresh", "fa-spinner", "margin-top-lg"], [1, "modal-footer", "padding-bottom-8px", "padding-left-16px", "padding-right-16px", "padding-top-8px"], ["type", "button", 1, "btn", "btn-primary", "btn-sm", "margin-right-8px", 3, "click"], [1, "fa", "fa-check", "margin-right-4px"], ["type", "button", 1, "btn", "btn-secondary", "btn-sm", "me-2", 3, "click"], [1, "fa", "fa-times", "margin-right-4px"]], template: function PurgeScheduleComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, PurgeScheduleComponent_div_0_Template, 8, 4, "div", 1);
        } }, dependencies: [i5$1.NgClass, i5$1.NgIf, i1.ɵNgNoValidate, i1.NgControlStatus, i1.NgControlStatusGroup, i2.FormFieldComponent, i2.FormMessagesComponent, i1.FormGroupDirective, i1.FormControlName, i2$1.TranslocoDirective, i5$1.DatePipe], styles: [".close-btn[_ngcontent-%COMP%]{left:-50px;position:absolute}.schedule-status[_ngcontent-%COMP%]{background:var(--element-primary-bg-color)}.cron-describer[_ngcontent-%COMP%]{font-size:.8em;font-style:italic}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PurgeScheduleComponent, [{
        type: Component,
        args: [{ selector: 'xf-purge-schedule', template: "<div *transloco=\"let t\">\n    <!-- Header -->\n    <div class=\"modal-header padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px modal-close-left\">\n        <h4 class=\"page-title-font modal-title muted-10 font-size-16px\">{{ params.metadata.title }}</h4>\n        <button type=\"button\" id=\"close-btn-schedule\" (click)=\"cancel()\" class=\"btn btn-close\"></button>\n    </div>\n    <!-- Body -->\n    <div class=\"margin-top-20px modal-body\" *ngIf=\"!loading\">\n        <form #auditLogPurgeScheduleForm=\"ngForm\" [formGroup]=\"formGroup\" class=\"ms-2\">\n            <div>\n                <label class=\"form-check-label align-bottom margin-left-10px margin-bottom-10px label-font\">{{\n                    params.metadata.description }}</label>\n                <div class=\"margin-left-10px\">\n                    <xf-form-field [field]=\"fields['enablePurge']\" [formControlName]=\"'enablePurge'\"\n                        [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\" [autoFocus]=\"true\"></xf-form-field>\n                </div>\n            </div>\n            <div *ngIf=\"formGroup.get('enablePurge')?.value\">\n                <div class=\"align-items-center d-flex\">\n                    <div *ngIf=\"schedule\" class=\"schedule-status me-2 ms-2 content-font\">\n                        <div class=\"padding-10px\">\n                            <label class=\"me-2\">Schedule Status</label>\n                            <span\n                                class=\"padding-bottom-4px padding-left-10px padding-right-10px padding-top-4px rounded-4px text-bg-success text-light\"\n                                [ngClass]=\"{'text-bg-success': schedule.enabled, 'text-bg-danger': !schedule.enabled}\">\n                                <span class=\"padding-right-4px fa\"\n                                    [ngClass]=\"{'fa-check': schedule.enabled, 'fa-minus': !schedule.enabled }\"></span>{{schedule.enabled\n                                ? 'Active' : 'Inactive' }}\n                            </span>\n                        </div>\n                    </div>\n                    @if (entitlementType !== 'trial') {\n                    <button class=\"btn btn-secondary btn-sm\" title=\"View Schedule\" (click)=\"openSchedule()\"><span>View\n                            Schedule</span></button>\n                    }\n                    @if (entitlementType === 'trial') {\n                    <span class=\"cron-describer mt-2\">{{cronDescriber}}</span>\n                    }\n                </div>\n                <div class=\"margin-left-10px margin-top-10px\">\n                    <label class=\"content-font\">Frequency:</label>\n                    <span class=\"cron-describer margin-left-16px muted-50\">{{cronDescriber}}</span>\n                </div>\n                <div class=\"margin-left-10px margin-top-10px\" *ngIf=\"schedule.last_run_at\">\n                    <label class=\"content-font\">Last run at:</label>\n                    <span class=\"cron-describer margin-left-16px muted-50\">{{schedule.last_run_at | date: systemSettings.preferences.dateTimeFormat }}</span>\n                </div>\n            </div>\n\n            @if (entitlementType === 'trial') {\n            <div class=\"ps-1 pt-1\">\n                <p class=\"content-font margin-left-4px mb-0 mb-1 p-0 text-warning\">As per your entitlement, the schedule\n                    cannot be edited.</p>\n            </div>\n            }\n            <div *ngIf=\"showScheduleError\"\n                class=\"text-danger content-font fw-medium line-height-15px margin-top-8px ms-2\">\n                <i class=\"fa fa-exclamation-circle fa-regular margin-right-4px\"></i>\n                <small>{{ t('admin.auditLogs.schedulePurge.scheduleRequired') }}</small>\n            </div>\n\n            <div class=\"ms-2 margin-top-12px\" *ngIf=\"formGroup.get('enablePurge')?.value\">\n                <div class=\"d-flex content-font align-items-center\">\n                    <!-- <label class=\"form-label padding-left-12px padding-right-12px\">{{\n                        t('admin.purgeLogs.schedule.primaryCriteriaLabels.keepLogs') }}</label> -->\n                    <xf-form-field [field]=\"fields.keepLogs\" formControlName=\"keepLogs\"\n                        [fieldOptions]=\"keepLogsFieldOption\"\n                        fieldClass=\"form-control-sm w-150px\"></xf-form-field>\n                      <span class=\"padding-left-12px font-size-12px muted-40 margin-top-20px\">{{\n                        t('admin.purgeLogs.schedule.primaryCriteriaLabels.days') }}</span>\n                </div>\n                <xf-form-messages [control]=\"formGroup.controls.keepLogs\" [customErrorMessages]=\"keepLogsFieldOption.customErrorMessages\"></xf-form-messages>\n                <div class=\"clearfix\"></div>\n            </div>\n        </form>\n    </div>\n    <div class=\"margin-top-28px text-center\" *ngIf=\"loading\">\n        <i class=\"fa fa-refresh fa-spinner margin-top-lg\"></i>\n    </div>\n    <!-- Footer -->\n    <div class=\"modal-footer padding-bottom-8px padding-left-16px padding-right-16px padding-top-8px\" *ngIf=\"!loading\">\n        <button type=\"button\" class=\"btn btn-primary btn-sm margin-right-8px\" (click)=\"save()\">\n            <i class=\"fa fa-check margin-right-4px\"></i>{{ t('buttons.save') }}\n        </button>\n        <button type=\"button\" class=\"btn btn-secondary btn-sm me-2\" (click)=\"cancel()\">\n            <i class=\"fa fa-times margin-right-4px\"></i>{{ t('buttons.cancel') }}\n        </button>\n    </div>\n</div>\n", styles: [".close-btn{left:-50px;position:absolute}.schedule-status{background:var(--element-primary-bg-color)}.cron-describer{font-size:.8em;font-style:italic}\n"] }]
    }], () => [{ type: i1.FormBuilder }, { type: i2$1.TranslocoService }, { type: i1$1.NgbActiveOffcanvas }, { type: i1$1.NgbOffcanvas }, { type: i2.ScheduleService }, { type: i2.LicenseService }, { type: i2.SystemSettingsService }], { schedule: [{
            type: Input
        }], params: [{
            type: Input,
            args: [{ required: true }]
        }], scheduleClosed: [{
            type: Output
        }], formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PurgeScheduleComponent, { className: "PurgeScheduleComponent", filePath: "src/manage-purge/purge-schedule/purge-schedule.component.ts", lineNumber: 16 }); })();

class ManagePurgeComponent {
    constructor() {
        this.offcanvasService = inject(NgbOffcanvas);
        this.params = new ManagePurge();
    }
    ngOnInit() {
    }
    openPurgeNow() {
        this.offcanvasInstance = this.offcanvasService.open(PurgeNowComponent, {
            animation: true,
            position: 'end',
            panelClass: 'offcanvas-slide-left',
            scroll: false,
            backdrop: 'static'
        });
        this.offcanvasInstance.componentInstance.params = this.params.purgeNow;
    }
    openPurgeSchedule() {
        this.offcanvasInstance = this.offcanvasService.open(PurgeScheduleComponent, {
            animation: true,
            position: 'end',
            panelClass: 'offcanvas-slide-left',
            scroll: false,
            backdrop: 'static'
        });
        this.offcanvasInstance.componentInstance.params = this.params.schedulePurge;
        this.offcanvasInstance.componentInstance.scheduleClosed.subscribe((schedule) => {
            this.offcanvasInstance.componentInstance.scheduleMode = schedule.id ? 'edit' : 'new';
            this.offcanvasInstance.componentInstance.schedule = schedule;
        });
    }
    static { this.ɵfac = function ManagePurgeComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ManagePurgeComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ManagePurgeComponent, selectors: [["xf-manage-purge"]], inputs: { params: "params" }, decls: 11, vars: 10, consts: [["ngbDropdown", "", "container", "body", 1, "margin-right-20px", "ms-auto"], ["ngbDropdownToggle", "", "id", "playbook-purge-btn", "type", "button", 1, "dropdown-toggle", "btn", "btn-secondary", "btn-sm", 3, "title"], ["ngbDropdownMenu", "", 1, "dropdown-menu", "mx-0", "border-0", "shadow"], ["ngbDropdownItem", "", "id", "purge-no-btn", 1, "cursor-pointer", 3, "click"], ["aria-hidden", "false"], ["ngbDropdownItem", "", "id", "edit-schedule-btn", 1, "cursor-pointer", 3, "click"]], template: function ManagePurgeComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "button", 1);
            i0.ɵɵtext(2);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "div", 2)(4, "li")(5, "a", 3);
            i0.ɵɵlistener("click", function ManagePurgeComponent_Template_a_click_5_listener() { return ctx.openPurgeNow(); });
            i0.ɵɵelement(6, "i", 4);
            i0.ɵɵtext(7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "a", 5);
            i0.ɵɵlistener("click", function ManagePurgeComponent_Template_a_click_8_listener() { return ctx.openPurgeSchedule(); });
            i0.ɵɵelement(9, "i", 4);
            i0.ɵɵtext(10);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵpropertyInterpolate("title", ctx.params.manageText);
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.manageText, " ");
            i0.ɵɵadvance(4);
            i0.ɵɵclassMapInterpolate1("", ctx.params.purgeNowIcon, " margin-right-4px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.purgeNowText, " ");
            i0.ɵɵadvance(2);
            i0.ɵɵclassMapInterpolate1("", ctx.params.schedulePurgeIcon, " margin-right-4px");
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate1(" ", ctx.params.schedulePurgeText, " ");
        } }, dependencies: [i1$1.NgbDropdown, i1$1.NgbDropdownToggle, i1$1.NgbDropdownMenu, i1$1.NgbDropdownItem] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ManagePurgeComponent, [{
        type: Component,
        args: [{ selector: 'xf-manage-purge', template: "<div ngbDropdown class=\"margin-right-20px ms-auto\" container=\"body\">\n    <button ngbDropdownToggle class=\"dropdown-toggle btn btn-secondary btn-sm\" id=\"playbook-purge-btn\"\n        type=\"button\" title=\"{{ params.manageText }}\">\n        {{ params.manageText }}\n    </button>\n    <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\">\n        <li>\n            <a ngbDropdownItem id=\"purge-no-btn\" (click)=\"openPurgeNow()\" class=\"cursor-pointer\">\n                <i class=\"{{ params.purgeNowIcon }} margin-right-4px\" aria-hidden=\"false\"></i> {{ params.purgeNowText }}\n            </a>\n            <a ngbDropdownItem id=\"edit-schedule-btn\" (click)=\"openPurgeSchedule()\" class=\"cursor-pointer\">\n                <i class=\"{{ params.schedulePurgeIcon }} margin-right-4px\" aria-hidden=\"false\"></i> {{ params.schedulePurgeText }}\n            </a>\n        </li>\n    </div>\n</div>\n" }]
    }], null, { params: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(ManagePurgeComponent, { className: "ManagePurgeComponent", filePath: "src/manage-purge/manage-purge.component.ts", lineNumber: 12 }); })();

class ScheduleModule {
    static { this.ɵfac = function ScheduleModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: ScheduleModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            FormsModule,
            XFFormFieldsModule,
            ReactiveFormsModule,
            NgbDropdownModule,
            CronEditorModule,
            TimezoneModule,
            NgbDropdownModule,
            GridModule,
            TranslocoModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    ScheduleListComponent,
                    ScheduleDetailComponent,
                    ActionsRenderer,
                    StatusRenderer,
                    ManagePurgeComponent,
                    PurgeNowComponent,
                    PurgeScheduleComponent
                ],
                exports: [
                    ScheduleDetailComponent,
                    ScheduleListComponent,
                    ManagePurgeComponent,
                    PurgeNowComponent,
                    PurgeScheduleComponent
                ],
                imports: [
                    CommonModule,
                    FormsModule,
                    XFFormFieldsModule,
                    ReactiveFormsModule,
                    NgbDropdownModule,
                    CronEditorModule,
                    TimezoneModule,
                    NgbDropdownModule,
                    GridModule,
                    TranslocoModule
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(ScheduleModule, { declarations: [ScheduleListComponent,
        ScheduleDetailComponent,
        ActionsRenderer,
        StatusRenderer,
        ManagePurgeComponent,
        PurgeNowComponent,
        PurgeScheduleComponent], imports: [CommonModule,
        FormsModule,
        XFFormFieldsModule,
        ReactiveFormsModule,
        NgbDropdownModule,
        CronEditorModule,
        TimezoneModule,
        NgbDropdownModule,
        GridModule,
        TranslocoModule], exports: [ScheduleDetailComponent,
        ScheduleListComponent,
        ManagePurgeComponent,
        PurgeNowComponent,
        PurgeScheduleComponent] }); })();

/**
 * Generated bundle index. Do not edit.
 */

export { ActionsRenderer, ManagePurge, ManagePurgeComponent, PurgeNow, PurgeNowComponent, PurgeScheduleComponent, ScheduleDetailComponent, ScheduleListComponent, ScheduleModule, SchedulePurge, StatusRenderer };
//# sourceMappingURL=shared-schedule.mjs.map
