import { EventEmitter, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { ModuleAttribute } from '../../core/models/attribute-map';
import { Entity } from '../../core/models/entity';
import { Field } from '../../core/models/field';
import { PicklistName } from '../../form-fields/field-renderers/built-ins/picklist/models/picklistName';
import { PicklistService } from '../../form-fields/field-renderers/built-ins/picklist/picklist.service';
import { GetEndPathNamePipe } from '../../utility/pipes/get-end-path-name.pipe';
import * as i0 from "@angular/core";
export declare class FieldSelectComponent implements OnInit, OnChanges {
    private picklistService;
    private getEndPathName;
    field: Field;
    modulesList: Entity[];
    entity: Entity;
    moduleFields: Entity.FieldMap;
    fieldTypes: {
        [attr: string]: ModuleAttribute;
    };
    primaryFields: ModuleAttribute[];
    private subTextFields;
    textFieldSubTypes: ModuleAttribute[];
    fieldCopy: Field;
    fieldTypechanged: EventEmitter<{
        moduleAttribute: ModuleAttribute;
        field?: Field;
    }>;
    picklists: PicklistName[];
    selectedField: Field;
    selectedAttribute: ModuleAttribute;
    constructor(picklistService: PicklistService, getEndPathName: GetEndPathNamePipe);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    private setFieldTypes;
    private loadPicklists;
    fieldTypeChanged(fieldType: 'mainField' | 'subField'): void;
    picklistSelected(): void;
    private validatePicklist;
    static ɵfac: i0.ɵɵFactoryDeclaration<FieldSelectComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<FieldSelectComponent, "xf-field-select", never, { "field": { "alias": "field"; "required": false; }; "modulesList": { "alias": "modulesList"; "required": false; }; "entity": { "alias": "entity"; "required": false; }; "moduleFields": { "alias": "moduleFields"; "required": false; }; "fieldTypes": { "alias": "fieldTypes"; "required": false; }; }, { "fieldTypechanged": "fieldTypechanged"; }, never, never, true, never>;
}
