import { ChangeDetectorRef, ElementRef, EventEmitter, QueryList } from '@angular/core';
import { AbstractControl, ControlValueAccessor, FormBuilder, FormControl, ValidationErrors, Validator } from '@angular/forms';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { Subscription } from 'rxjs';
import { SearchableItem } from './searchable-item';
import * as i0 from "@angular/core";
export declare class SearchableDropdownComponent implements ControlValueAccessor, Validator {
    private changeDetectorRef;
    private onChange;
    private onTouched;
    control?: FormControl;
    searchInput: ElementRef;
    inputField: ElementRef;
    dropdown: NgbDropdown;
    dropdownItems: QueryList<ElementRef>;
    value: SearchableItem | null;
    items: SearchableItem[];
    buttonStyle: 'select' | 'button';
    searchQueryChange: EventEmitter<string>;
    required: boolean;
    invalid: boolean;
    touched: boolean;
    clearValueOnSelect: boolean;
    placeholder: string;
    clearText: string;
    container: 'body' | null;
    disabled: boolean;
    searchText: string;
    loading: boolean;
    keyupSubscription?: Subscription;
    constructor(_formBuilder: FormBuilder, changeDetectorRef: ChangeDetectorRef);
    ngOnChanges(changes: any): void;
    ngDoCheck(): void;
    focusOnSearchInput(): void;
    focusOnItem(index: number): void;
    firstLoad(): void;
    selectItem(item: SearchableItem | null): void;
    open(): void;
    focus(): void;
    setTouched(): void;
    writeValue(value: SearchableItem | null): void;
    registerOnChange(fn: (value: SearchableItem | null) => void): void;
    registerOnTouched(fn: () => void): void;
    validate(control: AbstractControl<any, any>): ValidationErrors | null;
    static ɵfac: i0.ɵɵFactoryDeclaration<SearchableDropdownComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<SearchableDropdownComponent, "xf-searchable-dropdown", never, { "items": { "alias": "items"; "required": false; }; "buttonStyle": { "alias": "buttonStyle"; "required": false; }; "clearValueOnSelect": { "alias": "clearValueOnSelect"; "required": false; }; "placeholder": { "alias": "placeholder"; "required": false; }; "clearText": { "alias": "clearText"; "required": false; }; "container": { "alias": "container"; "required": false; }; "disabled": { "alias": "disabled"; "required": false; }; }, { "searchQueryChange": "searchQueryChange"; }, never, never, false, never>;
}
