import { HttpParams } from '@angular/common/http';
import { Observable } from 'rxjs';
import { Entity } from '../models/entity';
import { Field } from '../models/field';
import { ModelMetadataService } from './model-metadata.service';
import { PermissionService } from './permission.service';
import { Query } from '../../query-filters/models/query';
import { GetEndPathNamePipe } from '../../utility/pipes/get-end-path-name.pipe';
import { InterpolatePipe } from '../../utility/pipes/interpolate.pipe';
import { UnixToDatePipe } from '../../utility/pipes/unix-to-date.pipe';
import { UtilityService } from './utility.service';
import * as i0 from "@angular/core";
export declare class EntityService {
    private modelMetadataService;
    private permissionService;
    private utilityService;
    private getEndPathNamePipe;
    private interpolate;
    private unixToDatePipe;
    private apiService;
    private loading$;
    private displayNameMapping;
    constructor(modelMetadataService: ModelMetadataService, permissionService: PermissionService, utilityService: UtilityService, getEndPathNamePipe: GetEndPathNamePipe, interpolate: InterpolatePipe, unixToDatePipe: UnixToDatePipe);
    getEntities(): Observable<Record<string, Entity>>;
    getEntityList(): Observable<Entity[]>;
    private castEntities;
    build(type: string, mode?: 'add' | 'archived'): Observable<Entity>;
    hydrate(entity: Entity, fieldNames?: string[] | boolean, URLparams?: HttpParams): Observable<Entity>;
    getRecordDisplay(entity: Entity, uuid: string): Observable<string>;
    clearDisplayCache(uuid: string | boolean): void;
    save(entity: Entity, fieldNames: string[]): Observable<Entity>;
    private buildFields;
    private addTraitFields;
    setDisplayName(field: Field, entity: Entity): Field;
    getDisplayValue(entity: Entity, data: any): any;
    getDisplayFields(entity: Entity): string[];
    applyValues(entity: Entity, fields: Entity.FieldMap, data: any): Entity.FieldMap;
    private traitFields;
    buildSearchQuery(fields: string[], search: string): Query;
    buildSearchQueryFromDisplayName(entity: Entity, search: string): Query;
    createEntityFromData(inputData?: any, name?: string): Entity;
    static ɵfac: i0.ɵɵFactoryDeclaration<EntityService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<EntityService>;
}
