import { ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, QueryList, SimpleChanges } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { ConnectorActionRendererField, ConnectorFieldRendererParameter } from '../../core/models/connector-field-renderer-parameter';
import { Field } from '../../core/models/field';
import { FormFieldComponent } from '../field-renderers/built-ins/form-field/form-field.component';
import * as i0 from "@angular/core";
export declare class FieldRendererComponent implements OnInit, OnChanges, OnDestroy {
    private changeDetectorRef;
    fieldValues: Record<string, any>;
    parameters: ConnectorFieldRendererParameter[];
    formMode: 'add' | 'edit';
    ignoreRequired: boolean;
    enableJinja: boolean;
    enableRecordFields: any;
    onFieldChange: EventEmitter<any>;
    formFields: QueryList<FormFieldComponent>;
    connectorFormGroup: FormGroup;
    actionFields: ConnectorFieldRendererParameter[];
    actionFieldsToRender: ConnectorActionRendererField[];
    readonly checkbox = Field.BuiltInType.SELECT;
    deletedParams: string[];
    emitted: boolean;
    error: boolean;
    formControlNames: string[];
    constructor(changeDetectorRef: ChangeDetectorRef);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    private transformFields;
    private fetchOperationData;
    private processOnApiChangeData;
    createField(action: ConnectorFieldRendererParameter): Field;
    private setOnValuechanges;
    private deleteFieldParameters;
    private removeExistingFormControls;
    focusOnFirstInvalidInput(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<FieldRendererComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<FieldRendererComponent, "xf-field-renderer", never, { "fieldValues": { "alias": "fieldValues"; "required": false; }; "parameters": { "alias": "parameters"; "required": false; }; "formMode": { "alias": "formMode"; "required": false; }; "ignoreRequired": { "alias": "ignoreRequired"; "required": false; }; "enableJinja": { "alias": "enableJinja"; "required": false; }; "enableRecordFields": { "alias": "enableRecordFields"; "required": false; }; "connectorFormGroup": { "alias": "connectorFormGroup"; "required": false; }; }, { "onFieldChange": "onFieldChange"; }, never, never, false, never>;
}
