import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { EntityService } from '../../../../core/services/entity.service';
import { StorageService } from '../../../../core/services/storage.service';
import { PicklistField } from '../../../field-types/picklist';
import { Picklist } from './models/picklist';
import { PicklistName } from './models/picklistName';
import * as i0 from "@angular/core";
export declare class PicklistService {
    private http;
    private storage;
    private entityService;
    picklists: Record<string, Picklist> | null;
    constructor(http: HttpClient, storage: StorageService, entityService: EntityService);
    loadPicklistName(picklistName: string): Observable<PicklistName>;
    getPicklistByIri(iri: string): Observable<PicklistName>;
    getPicklistByUUID(uuid: string): Observable<any | undefined>;
    removeFromCache(picklist: any): void;
    loadAllPicklists(useExport?: boolean): Observable<any>;
    loadPicklists(field: PicklistField, metadata?: any): Observable<any>;
    loadPicklistsByParams(itemVal: string, itemKey: string): Observable<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PicklistService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<PicklistService>;
}
