import { PlatformLocation } from '@angular/common';
import { AfterViewInit, ElementRef, NgZone, OnDestroy, InjectionToken, ChangeDetectorRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { Events } from './Events';
import { Editor as TinyMCEEditor, TinyMCE } from 'tinymce';
import * as i0 from "@angular/core";
type EditorOptions = Parameters<TinyMCE['init']>[0];
export declare const TINYMCE_SCRIPT_SRC: InjectionToken<string>;
export type Version = `${'4' | '5' | '6' | '7'}${'' | '-dev' | '-testing' | `.${number}` | `.${number}.${number}`}`;
export declare class HtmlEditorComponent extends Events implements AfterViewInit, ControlValueAccessor, OnDestroy {
    private cdRef;
    private platformId;
    private platformLocation;
    private tinymceScriptSrc?;
    cloudChannel: Version;
    apiKey: string;
    licenseKey?: string;
    init?: EditorOptions;
    id: string;
    initialValue?: string;
    outputFormat?: 'html' | 'text';
    inline?: boolean;
    tagName?: string;
    plugins?: string;
    toolbar?: string | string[];
    modelEvents: string;
    allowedEvents?: string | string[];
    ignoreEvents?: string | string[];
    set disabled(val: boolean | undefined);
    get disabled(): boolean | undefined;
    get editor(): TinyMCEEditor | undefined;
    ngZone: NgZone;
    private _elementRef;
    private _element?;
    private _disabled?;
    private _editor?;
    private onTouchedCallback;
    private onChangeCallback;
    private destroy$;
    constructor(elementRef: ElementRef, ngZone: NgZone, cdRef: ChangeDetectorRef, platformId: Object, platformLocation: PlatformLocation, tinymceScriptSrc?: string | undefined);
    writeValue(value: string | null): void;
    registerOnChange(fn: (_: any) => void): void;
    registerOnTouched(fn: any): void;
    setDisabledState(isDisabled: boolean): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    createElement(): void;
    initialise: () => void;
    private initEditor;
    private emitOnChange;
    static ɵfac: i0.ɵɵFactoryDeclaration<HtmlEditorComponent, [null, null, null, null, null, { optional: true; }]>;
    static ɵcmp: i0.ɵɵComponentDeclaration<HtmlEditorComponent, "editor", never, { "cloudChannel": { "alias": "cloudChannel"; "required": false; }; "apiKey": { "alias": "apiKey"; "required": false; }; "licenseKey": { "alias": "licenseKey"; "required": false; }; "init": { "alias": "init"; "required": false; }; "id": { "alias": "id"; "required": false; }; "initialValue": { "alias": "initialValue"; "required": false; }; "outputFormat": { "alias": "outputFormat"; "required": false; }; "inline": { "alias": "inline"; "required": false; }; "tagName": { "alias": "tagName"; "required": false; }; "plugins": { "alias": "plugins"; "required": false; }; "toolbar": { "alias": "toolbar"; "required": false; }; "modelEvents": { "alias": "modelEvents"; "required": false; }; "allowedEvents": { "alias": "allowedEvents"; "required": false; }; "ignoreEvents": { "alias": "ignoreEvents"; "required": false; }; "disabled": { "alias": "disabled"; "required": false; }; }, {}, never, never, true, never>;
}
export {};
