import { Entity } from "../../core/models/entity";
import { Filter } from "./filter";
import { FilterGroup } from "./filter-group";
export declare class Query {
    limit: number;
    search: string;
    logic: 'AND' | 'OR';
    page: number;
    relationships: boolean;
    selectedFields: string[];
    module: string;
    filters: (Filter | FilterGroup)[];
    sort: QuerySort[];
    aggregates: any[];
    showDeleted: boolean;
    ignoreFields: string[];
    queryParams?: any;
    constructor(query?: object);
    getURLParameters(): any;
    mergeQueries(queries: Query[]): void;
    getQueryObject(useValue?: boolean): any;
    transformFilters(filters: (Filter | FilterGroup)[], useValue: boolean): any;
    getURLQuery(entity: Entity): any;
    asFilterGroup(): FilterGroup;
}
export interface QuerySort {
    field: string;
    direction: 'ASC' | 'DESC' | '';
    _fieldName?: string;
}
