import { ChangeDetectorRef, EventEmitter, OnInit } from '@angular/core';
import { FormGroup, FormGroupDirective } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { BehaviorSubject } from 'rxjs';
import { FieldOptions, ModalService, SpinnerService, TextField, UtilityService } from 'shared';
import { ViewLayoutItem } from '../models/view-layout-item';
import { ViewTemplate } from '../models/view-template';
import { ViewTemplateContext } from '../models/view-template-context';
import { Widget } from '../models/widget';
import { ViewTemplateService } from './view-template.service';
import * as i0 from "@angular/core";
export declare class ViewTemplateComponent implements OnInit {
    private rootFormGroup;
    private utilityService;
    private changeDetectorRef;
    protected route: ActivatedRoute;
    private viewTemplateService;
    private spinnerService;
    private modalService;
    private router;
    mode: string | null;
    uuid: string | null;
    recordId: string | null | undefined;
    viewTemplate: ViewTemplate | null | undefined;
    context: ViewTemplateContext;
    openedInPreview: boolean;
    loading: boolean;
    onAddViewTemplate: EventEmitter<void>;
    selectedWidget: Widget;
    navigationCollapsed: boolean;
    widgetLibraryCollapsed: boolean;
    widgetSelection$: BehaviorSubject<Widget | ViewLayoutItem.Tabs>;
    viewTemplateForm?: FormGroup;
    titleField: TextField;
    titleFieldOptions: FieldOptions;
    params: any;
    constructor(rootFormGroup: FormGroupDirective, utilityService: UtilityService, changeDetectorRef: ChangeDetectorRef, route: ActivatedRoute, viewTemplateService: ViewTemplateService, spinnerService: SpinnerService, modalService: ModalService, router: Router);
    ngOnInit(): void;
    onLayoutItemChange(layoutItem: ViewLayoutItem): void;
    setSelectedWidget(widget: Widget): void;
    widgetLibraryCollapsible(value: boolean): void;
    addContainer(): void;
    getWidth(): "all-collapsed" | "navigation-collapsed" | "widget-library-collapsed" | "none-collapsed" | "all-collapsed-view-mode" | "widget-library-collapsed-view-mode";
    onWidgetDrop(event: any): void;
    newViewTemplate(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ViewTemplateComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ViewTemplateComponent, "xf-view-template", never, { "mode": { "alias": "mode"; "required": false; }; "uuid": { "alias": "uuid"; "required": false; }; "recordId": { "alias": "recordId"; "required": false; }; "viewTemplate": { "alias": "viewTemplate"; "required": false; }; "context": { "alias": "context"; "required": false; }; "openedInPreview": { "alias": "openedInPreview"; "required": false; }; "loading": { "alias": "loading"; "required": false; }; }, { "onAddViewTemplate": "onAddViewTemplate"; }, never, never, false, never>;
}
