/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, ChangeDetectorRef, Component, inject } from '@angular/core';
import { isObservable } from 'rxjs';
import * as i0 from "@angular/core";
export class TextObservableCellRendererComponent {
    constructor() {
        this.value = '';
        this.changeDetectorRef = inject(ChangeDetectorRef);
    }
    agInit(params) {
        this.params = params;
        if (isObservable(params.value)) {
            this.subscription = params.value?.subscribe((value) => {
                this.value = value;
                this.changeDetectorRef.detectChanges();
            });
        }
        else {
            this.value = params.valueFormatted || params.value;
        }
    }
    refresh(params) {
        this.agInit(params);
        return true;
    }
    ngOnDestroy() {
        this.subscription?.unsubscribe();
    }
    static { this.ɵfac = function TextObservableCellRendererComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TextObservableCellRendererComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TextObservableCellRendererComponent, selectors: [["text-observable-cell-renderer"]], decls: 2, vars: 1, template: function TextObservableCellRendererComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "span");
            i0.ɵɵtext(1);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵtextInterpolate(ctx.value);
        } }, encapsulation: 2, changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TextObservableCellRendererComponent, [{
        type: Component,
        args: [{
                selector: 'text-observable-cell-renderer',
                template: '<span>{{value}}</span>',
                changeDetection: ChangeDetectionStrategy.OnPush,
            }]
    }], null, null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TextObservableCellRendererComponent, { className: "TextObservableCellRendererComponent", filePath: "src/cell-renderers/text-observable-cell-renderer.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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