/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { DatePipe } from '@angular/common';
import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, ViewChild, inject } from '@angular/core';
import { TranslocoService } from '@jsverse/transloco';
import { AgGridAngular } from 'ag-grid-angular';
import { difference, isUndefined, merge } from 'lodash-es';
import { ToastrService } from 'ngx-toastr';
import { catchError, concatMap, forkJoin, isObservable, of } from 'rxjs';
import { ApiService, DEFAULT_CACHE_BLOCK_SIZE, DEFAULT_GRID_ROWS, ModalService, Query } from "shared";
import { GridColumnService } from './services/grid-column.service';
import { GridReferenceService } from './services/grid-reference.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common";
import * as i3 from "ag-grid-angular";
import * as i4 from "./custom-grid-header/custom-grid-header.component";
const _c0 = a0 => ({ "custom-grid-header": a0 });
const _c1 = () => [];
function GridComponent_div_0_lib_custom_grid_header_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "lib-custom-grid-header", 7);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("component", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent)("componentData$", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderData$);
} }
function GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "button", 10);
    i0.ɵɵlistener("click", function GridComponent_div_0_div_3_ng_container_1_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.refresh()); });
    i0.ɵɵelement(2, "i", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template, 1, 2, "xf-button-group", 12);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) && (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons == null ? null : ctx_r1.gridConfig.options.buttons.length));
} }
function GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", ctx_r1.selectButtons || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template, 1, 2, "xf-button-group", 12);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngIf", ctx_r1.selectButtons == null ? null : ctx_r1.selectButtons.length);
} }
function GridComponent_div_0_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8);
    i0.ɵɵtemplate(1, GridComponent_div_0_div_3_ng_container_1_Template, 4, 1, "ng-container", 9)(2, GridComponent_div_0_div_3_ng_template_2_Template, 1, 1, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const recordSelection_r4 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.selectedRows.length === 0)("ngIfElse", recordSelection_r4);
} }
function GridComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2)(1, "div", 3);
    i0.ɵɵtemplate(2, GridComponent_div_0_lib_custom_grid_header_2_Template, 1, 2, "lib-custom-grid-header", 4)(3, GridComponent_div_0_div_3_Template, 4, 2, "div", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "ag-grid-angular", 6);
    i0.ɵɵlistener("gridReady", function GridComponent_div_0_Template_ag_grid_angular_gridReady_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridReady($event)); })("firstDataRendered", function GridComponent_div_0_Template_ag_grid_angular_firstDataRendered_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onFirstDataRendered($event)); })("gridSizeChanged", function GridComponent_div_0_Template_ag_grid_angular_gridSizeChanged_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridSizeChanged($event)); })("rowDataUpdated", function GridComponent_div_0_Template_ag_grid_angular_rowDataUpdated_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onRowDataUpdated($event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(13, _c0, ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.enableSelectMenu);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("w-100 ", ctx_r1.gridClass, "");
    i0.ɵɵproperty("columnDefs", ctx_r1.columnDefs)("gridOptions", ctx_r1.gridOptions)("serverSideDatasource", ctx_r1.dataSource)("selectionColumnDef", ctx_r1.selectionColumnDef)("animateRows", true)("suppressContextMenu", ctx_r1.suppressContextMenu)("overlayNoRowsTemplate", ctx_r1.noRowsTemplate);
} }
export class GridComponent {
    constructor(themeService, changeDetectorRef) {
        this.themeService = themeService;
        this.changeDetectorRef = changeDetectorRef;
        this.customColumnDefs = [];
        this.suppressContextMenu = false;
        this.rowSelectionChanged = new EventEmitter();
        this.gridQuery = new Query();
        this.gridColumnService = inject(GridColumnService);
        this.gridReferenceService = inject(GridReferenceService);
        this.modalService = inject(ModalService);
        this.apiService = inject(ApiService);
        this.toasterService = inject(ToastrService);
        this.translocoService = inject(TranslocoService);
        this.datePipe = inject(DatePipe);
        this.contextId = '';
        this.gridClass = 'ag-theme-alpine';
        this.selectedRows = [];
        this.selectButtons = [];
        this.selectionColumnDef = {
            suppressHeaderMenuButton: false,
            pinned: 'left',
        };
        this.columnDefs = [];
        this.currentRowHeight = 0;
        this.minRowHeight = 0;
        this.noRowsTemplate = '';
    }
    onGridReady(params) {
        this.contextId = this.gridConfig.uuid || this.dataSource.entity.type;
        this.gridApi = params.api;
        if (this.gridConfig.options?.onRegisterApi) {
            this.gridConfig.options?.onRegisterApi(this.gridApi);
        }
        this.minRowHeight = params.api.getSizesForCurrentTheme().rowHeight;
        this.currentRowHeight = this.minRowHeight;
        window.onresize = () => {
            this.gridApi.sizeColumnsToFit();
        };
        this.dataSource.selectedRows.forEach((uuid) => {
            const rowNode = this.gridApi.getRowNode(uuid);
            rowNode?.setSelected(true);
        });
        this.gridReferenceService.refresh$.subscribe((options) => {
            this.refresh(options);
        });
    }
    onFirstDataRendered(params) {
        this.updateGridRowsHeight(params);
    }
    onGridSizeChanged(params) {
        this.updateGridRowsHeight(params);
    }
    onRowDataUpdated(params) {
        this.updateGridRowsHeight(params);
    }
    updateGridRowsHeight(params) {
        //Calculate the height of the grid and available parent height to fit all the grid rows scrollable
        if (this.gridConfig.options?.adjustGridRowHeight) {
            let pagingPanel = document.querySelector('.ag-paging-panel');
            let headerPanel = document.querySelector('.ag-header');
            let gridWrapper = document.querySelector('.grid-wrapper');
            let gridActionsContainer = document.querySelector('.grid-actions-container');
            let customGridHeight = 15; //Adjust the extra height
            if (!pagingPanel || !headerPanel || !gridWrapper || !gridActionsContainer) {
                return;
            }
            let gridHeight = gridWrapper.clientHeight - (gridActionsContainer.clientHeight + customGridHeight + pagingPanel.clientHeight + headerPanel.clientHeight);
            let renderedRowCount = params.api.getDisplayedRowCount();
            if (renderedRowCount * this.minRowHeight >= gridHeight) {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + gridHeight + 'px');
            }
            else {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + (renderedRowCount * this.minRowHeight) + 'px');
            }
        }
    }
    ngOnInit() {
        this.columnDefs = this.gridColumnService.create(this.dataSource.entity?.fields, this.gridConfig.configuration.query, this.gridConfig.configuration.columns, false, this.customColumnDefs, this.dataSource.entity.defaultSort);
        this.columnDefs = this.columnDefs.map((colDef) => {
            if (colDef.field === this.gridConfig.configuration.nameColumn) {
                colDef.pinned = 'left';
                colDef.suppressMovable = true;
                colDef.lockPosition = true;
                colDef.lockVisible = true;
            }
            return colDef;
        });
        this.gridOptions = this.mapGridOptions();
        let selectButtons = [];
        if (this.gridConfig.options?.selectButtons?.length) {
            selectButtons = this.gridConfig.options.selectButtons;
        }
        if (this.gridConfig.options?.allowDelete) {
            let deleteButton = this.createDeleteButton();
            selectButtons.push(deleteButton);
        }
        this.selectButtons = selectButtons;
        this.setTheme(this.themeService.getTheme());
        this.themeService.themeChanged.subscribe((theme) => this.setTheme(theme));
        this.noRowsTemplate = `<span>${this.translocoService.translate('errors.error_no_records')}</span>`;
    }
    createDeleteButton() {
        return {
            id: 'delete',
            text: '',
            tooltip: 'Delete',
            iconClass: 'fa fa-trash-can fa-light',
            onClick: () => { this.deleteSelected(); },
            class: 'btn btn-secondary',
            visible: true
        };
    }
    deleteSelected() {
        let entityName = this.selectedRows.length > 1 ? this.dataSource.entity.descriptions.plural : this.dataSource.entity.descriptions.singular;
        this.modalService.confirm(this.translocoService.translate('components.grid.deleteMessage', {
            entityName: `${this.dataSource.entity.descriptions.singular}(s)`
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            let uuids = this.selectedRows.map((row) => row.uuid);
            let observables$ = [];
            uuids.forEach((uuid) => {
                observables$.push(this.apiService.deleteRecord(this.dataSource.entity, uuid).pipe(catchError((error) => {
                    return of(error.error?.errors[0]?.detail);
                })));
            });
            return forkJoin(observables$);
        })).subscribe((responses) => {
            let successfulDeletions = responses.filter((error) => error === null).length;
            const deletionErrors = responses.length - successfulDeletions;
            if (deletionErrors > 0) {
                this.toasterService.warning(this.translocoService.translate('components.grid.partialDeletedToast', {
                    successful: successfulDeletions,
                    errors: deletionErrors,
                    length: this.selectedRows.length,
                    entityName: entityName
                }));
            }
            else {
                this.toasterService.success(this.translocoService.translate('components.grid.deletedToast', {
                    length: this.selectedRows.length, entityName: entityName
                }), 'Success');
            }
            this.gridApi.deselectAll();
            this.selectedRows = [];
            this.rowSelectionChanged.emit(this.selectedRows);
            this.refresh();
        });
    }
    setTheme(theme) {
        this.gridClass = theme === 'dark' ? 'ag-theme-alpine-dark' : 'ag-theme-alpine';
        this.changeDetectorRef.detectChanges();
    }
    mapGridOptions() {
        let columnTypes = this.gridColumnService.getDefaultColumnTypes();
        columnTypes = merge(columnTypes, this.gridConfig.options?.customColumnTypes || {});
        let dataTypeDefinitions = this.gridColumnService.getDefaultDataTypeDefinitions();
        dataTypeDefinitions = merge(dataTypeDefinitions, this.gridConfig.options?.customDataTypeDefinitions || {});
        let processCellCallback = (params) => this.processCellCallback(params);
        let gridOptions = {
            defaultColDef: this.gridColumnService.getDefaultColumnDef(),
            processCellForClipboard: processCellCallback,
            defaultCsvExportParams: {
                processCellCallback: processCellCallback,
            },
            defaultExcelExportParams: {
                processCellCallback: processCellCallback,
            },
            onCellClicked: (event) => {
                if (this.gridConfig.options?.onView && !event.colDef.cellRendererParams?.suppressCellClick) {
                    this.gridConfig.options.onView(event);
                }
            },
            onSelectionChanged: (event) => {
                const selectionState = event.api.getServerSideSelectionState();
                let uuids = [];
                if (selectionState.selectAll) {
                    const allNodes = event.api.getRenderedNodes().map((node) => node.data.uuid) || [];
                    uuids = difference(allNodes, selectionState.toggledNodes);
                }
                else {
                    uuids = selectionState.toggledNodes || [];
                }
                this.selectedRows = event.api.getRenderedNodes().filter((node) => uuids.indexOf(node.data.uuid) > -1).map((node) => node.data);
                this.rowSelectionChanged.emit(this.selectedRows);
                this.changeDetectorRef.detectChanges();
            },
            onDisplayedColumnsChanged: (event) => {
                event.api.refreshServerSide();
                event.api.sizeColumnsToFit();
            },
            rowSelection: {
                mode: 'multiRow',
                enableClickSelection: false,
                headerCheckbox: !this.gridConfig.options?.hideCheckboxes,
                checkboxes: !this.gridConfig.options?.hideCheckboxes,
                hideDisabledCheckboxes: true,
            },
            suppressCellFocus: true,
            suppressMenuHide: false,
            columnMenu: 'new',
            pagination: true,
            paginationPageSize: DEFAULT_GRID_ROWS,
            cacheBlockSize: DEFAULT_CACHE_BLOCK_SIZE,
            enableCellTextSelection: this.gridConfig.options?.enableCellTextSelection,
            columnTypes: columnTypes,
            dataTypeDefinitions: dataTypeDefinitions,
            paginationPageSizeSelector: [10, 20, 50, 100, 250],
            suppressServerSideFullWidthLoadingRow: true,
            tooltipShowDelay: 500
        };
        if (this.gridConfig.options?.expandable) {
            gridOptions.masterDetail = true;
            gridOptions.detailCellRenderer = this.gridConfig.options?.detailCellRenderer;
        }
        if (!this.gridConfig.options?.skipRowId) {
            gridOptions.getRowId = (params) => params.data.uuid;
        }
        gridOptions.treeData = this.gridConfig.options?.treeData;
        gridOptions.isServerSideGroup = this.gridConfig.options?.isServerSideGroup;
        gridOptions.getServerSideGroupKey = this.gridConfig.options?.getServerSideGroupKey;
        gridOptions.autoGroupColumnDef = this.gridConfig.options?.autoGroupColumnDef;
        gridOptions.suppressCsvExport = true;
        gridOptions.suppressExcelExport = true;
        return gridOptions;
    }
    refresh(params = {}) {
        const purge = isUndefined(params.purge) ? true : params.purge;
        this.gridApi.refreshServerSide({ route: [], purge: purge });
    }
    processCellCallback(params) {
        if (isObservable(params.value)) {
            return getStoredResolvedObservableValue(params.value) || '';
        }
        return params.value;
    }
    static { this.ɵfac = function GridComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridComponent)(i0.ɵɵdirectiveInject(i1.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridComponent, selectors: [["xf-grid"]], viewQuery: function GridComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(AgGridAngular, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.agGrid = _t.first);
        } }, inputs: { dataSource: "dataSource", gridConfig: "gridConfig", customColumnDefs: "customColumnDefs", suppressContextMenu: "suppressContextMenu" }, outputs: { rowSelectionChanged: "rowSelectionChanged" }, features: [i0.ɵɵProvidersFeature([])], decls: 1, vars: 1, consts: [["recordSelection", ""], ["class", "grid-wrapper bg-secondary-panel h-100", 4, "ngIf"], [1, "grid-wrapper", "bg-secondary-panel", "h-100"], [1, "d-flex", "padding-top-16px", "grid-actions-container", "margin-bottom-4px", 3, "ngClass"], ["class", "mw-60", 3, "component", "componentData$", 4, "ngIf"], ["class", "grid-actions margin-right-16px ms-auto", 4, "ngIf"], ["rowModelType", "serverSide", 3, "gridReady", "firstDataRendered", "gridSizeChanged", "rowDataUpdated", "columnDefs", "gridOptions", "serverSideDatasource", "selectionColumnDef", "animateRows", "suppressContextMenu", "overlayNoRowsTemplate"], [1, "mw-60", 3, "component", "componentData$"], [1, "grid-actions", "margin-right-16px", "ms-auto"], [4, "ngIf", "ngIfElse"], ["title", "Refresh", 1, "btn", "btn-sm", "btn-secondary", "mx-2", "float-end", 3, "click"], [1, "fa", "fa-refresh"], [3, "buttons", 4, "ngIf"], [3, "buttons"]], template: function GridComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, GridComponent_div_0_Template, 5, 15, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.columnDefs && ctx.gridOptions && ctx.dataSource);
        } }, dependencies: [i2.NgClass, i2.NgIf, i1.ButtonGroupComponent, i3.AgGridAngular, i4.CustomGridHeaderComponent], styles: [".grid-expandable-wrapper[_ngcontent-%COMP%]{position:absolute;left:70px;right:0}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper[_ngcontent-%COMP%]   .custom-grid-header[_ngcontent-%COMP%]{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid', changeDetection: ChangeDetectionStrategy.OnPush, providers: [], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"grid-wrapper bg-secondary-panel h-100\" *ngIf=\"columnDefs && gridOptions && dataSource\">\n  <div class=\"d-flex padding-top-16px grid-actions-container margin-bottom-4px\"\n    [ngClass]=\"{'custom-grid-header' : gridConfig.options?.customGridHeaderComponent}\">\n    <lib-custom-grid-header *ngIf=\"gridConfig.options?.customGridHeaderComponent\"\n      [component]=\"gridConfig.options?.customGridHeaderComponent\"\n      [componentData$]=\"gridConfig.options?.customGridHeaderData$\" class=\"mw-60\"></lib-custom-grid-header>\n    <div class=\"grid-actions margin-right-16px ms-auto\" *ngIf=\"gridConfig.options?.enableSelectMenu\">\n      <ng-container *ngIf=\"selectedRows.length === 0; else recordSelection\">\n        <button class=\"btn btn-sm btn-secondary mx-2 float-end\" title=\"Refresh\" (click)=\"refresh()\">\n          <i class=\"fa fa-refresh\"></i>\n        </button>\n        <xf-button-group *ngIf=\"gridConfig.options?.buttons && gridConfig.options?.buttons?.length\"\n          [buttons]=\"gridConfig.options?.buttons || []\"></xf-button-group>\n      </ng-container>\n      <ng-template #recordSelection>\n        <xf-button-group *ngIf=\"selectButtons?.length\" [buttons]=\"selectButtons || []\"></xf-button-group>\n      </ng-template>\n    </div>\n  </div>\n  <ag-grid-angular class=\"w-100 {{gridClass}}\" rowModelType=\"serverSide\" [columnDefs]=\"columnDefs\"\n    [gridOptions]=\"gridOptions\" [serverSideDatasource]=\"dataSource\" [selectionColumnDef]=\"selectionColumnDef\"\n    (gridReady)=\"onGridReady($event)\" [animateRows]=\"true\" [suppressContextMenu]=\"suppressContextMenu\"\n    (firstDataRendered)=\"onFirstDataRendered($event)\" (gridSizeChanged)=\"onGridSizeChanged($event)\"\n    (rowDataUpdated)=\"onRowDataUpdated($event)\" [overlayNoRowsTemplate]=\"noRowsTemplate\"></ag-grid-angular>\n</div>\n", styles: [".grid-expandable-wrapper{position:absolute;left:70px;right:0}.grid-wrapper .grid-actions ::ng-deep .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper .grid-actions ::ng-deep .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper .custom-grid-header{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}\n"] }]
    }], () => [{ type: i1.ThemeService }, { type: i0.ChangeDetectorRef }], { agGrid: [{
            type: ViewChild,
            args: [AgGridAngular]
        }], dataSource: [{
            type: Input
        }], gridConfig: [{
            type: Input
        }], customColumnDefs: [{
            type: Input
        }], suppressContextMenu: [{
            type: Input
        }], rowSelectionChanged: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridComponent, { className: "GridComponent", filePath: "src/grid.component.ts", lineNumber: 28 }); })();
const valueByObservable = new WeakMap();
export function storeResolvedObservableValue(observable, value) {
    valueByObservable.set(observable, value);
}
export function getStoredResolvedObservableValue(observable) {
    return valueByObservable.get(observable);
}
//# sourceMappingURL=data:application/json;base64,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