/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { DatePipe } from '@angular/common';
import { Injectable, inject } from '@angular/core';
import * as _ from 'lodash-es';
import { first, isObservable, map, switchMap } from 'rxjs';
import { ALL_RECORDS_SIZE, ApiService, DatetimeFloatingFilterComponent, DatetimeGridFilterComponent, EntityService, FIXED_MODULE, LookupFloatingFilterComponent, LookupGridFilterComponent, Query, SystemSettingsService, Tag } from "shared";
import { TagsCellRendererComponent } from '../cell-renderers/tags-cell-renderer.component';
import { TextObservableCellRendererComponent } from '../cell-renderers/text-observable-cell-renderer.component';
import * as i0 from "@angular/core";
export class GridColumnService {
    constructor() {
        this.systemSettingsService = inject(SystemSettingsService);
        this.entityService = inject(EntityService);
        this.apiService = inject(ApiService);
        this.datePipe = inject(DatePipe);
    }
    create(fields, query = new Query(), columns = [], useUserPrefColumns = true, customColDefs = [], defaultSort = []) {
        let columnDefinitions = [];
        let columnList = {};
        let columnOrder = [];
        _.forEach(columns, (column) => {
            let field = fields[column.name];
            let customColDef = customColDefs.find((colDef) => colDef.field === column.name);
            if ((field && !field.isRelationship) || customColDef) {
                columnOrder.push(column.name);
                let _columnDef = customColDef || this.getColumnDefinition(field, column);
                columnList[column.name] = _columnDef;
                columnDefinitions.push(_columnDef);
            }
        });
        // _.forEach(fields, (field: Field) => {
        //   let tempField = cloneDeep(field);
        //   if (tempField && !columnList[tempField.name] && !tempField.isRelationship && ((_.isUndefined(tempField.visibility) || tempField.visibility))) {
        //     if (useUserPrefColumns && columnOrder.length > 0) {
        //       tempField.gridColumn = false;
        //       let columnVisible = _.find(columnOrder, (columnName: string) => { return columnName === tempField.name })
        //       if (columnVisible) {
        //         tempField.gridColumn = true;
        //       }
        //     }
        //     columnDefinitions.push(
        //       this.getColumnDefinition(tempField, new GridColumn({ name: tempField.name }))
        //     );
        //   }
        // });
        columnOrder = _.compact(columnOrder.length > 0 ? columnOrder : _.map(columnDefinitions.filter((definition) => {
            return !definition.hide;
        }), 'field'));
        columnDefinitions = _.sortBy(columnDefinitions, 'title');
        if (query.sort.length > 0) {
            this.setSort(columnDefinitions, query.sort);
        }
        else if (defaultSort) {
            this.setSort(columnDefinitions, defaultSort);
        }
        let orderedColumns = this.orderColumns(columnDefinitions, columnOrder);
        //if (!skipCheckboxes) {
        // orderedColumns.unshift({
        //   headerName: '',
        //   field: 'checkbox',
        //   sortable: false,
        //   resizable: false,
        //   pinned: true,
        //   cellRendererParams: {
        //     suppressCellClick: true
        //   },
        //   suppressHeaderFilterButton: true,
        //   suppressHeaderMenuButton: true,
        //   suppressSizeToFit: true,
        //   floatingFilter: false,
        //   width: 40,
        //   suppressMovable: true,
        //   lockPosition: true,
        //   lockVisible: true,
        //   headerCheckboxSelection: true,
        //   checkboxSelection: true,
        //   showDisabledCheckboxes: true,
        // });
        //}
        return orderedColumns;
    }
    orderColumns(columnsToOrder, orderedColumnNames = []) {
        let sortedColumns = [];
        _.forEach(orderedColumnNames, (columnName) => {
            columnsToOrder.forEach((column) => {
                if (column.field === columnName) {
                    sortedColumns.push(column);
                }
            });
        });
        let extraColumns = _.difference(columnsToOrder, sortedColumns);
        extraColumns = _.sortBy(extraColumns, 'field');
        return _.concat(sortedColumns, extraColumns);
    }
    getColumnDefinition(field, column) {
        let _columnVisible = this.getColumnVisibility(field, column);
        let systemSettings = this.systemSettingsService.get();
        const formTypeMap = {
            datetime: 'dateColumn',
            text: null,
            textarea: null,
            richtext: null,
            number: 'numberColumn',
            lookup: 'lookupColumn',
            select: 'selectColumn',
            tags: 'tagsColumn',
            checkbox: null
        };
        const cellDataTypeMap = {
            datetime: 'date',
            text: null,
            textarea: null,
            richtext: null,
            select: 'select',
            // lookup: 'lookup',
            checkbox: 'boolean'
        };
        const nonSortableTypes = ['tags'];
        let colDef = _.extend({
            hide: !_columnVisible,
            headerName: field.title,
            headerTooltip: field.title,
            field: field.name,
            type: formTypeMap[field.formType],
            cellDataType: cellDataTypeMap[field.formType],
            editable: _.isUndefined(column.editable) ? false : column.editable,
            resizable: _.isUndefined(column.resizable) ? true : column.resizable,
            sortable: _.isUndefined(column.sortable) ? nonSortableTypes.indexOf(field.formType) === -1 : column.sortable,
            tooltipValueGetter: _.isUndefined(column.tooltipValueGetter) ? (params) => {
                if ('tags' === field.name) {
                    return params.valueFormatted ? params.valueFormatted : '';
                }
                return 'users' !== field.type ? (cellDataTypeMap[field.formType] === 'date' ? (params.value ? this.datePipe.transform(params.value, systemSettings.preferences.dateTimeFormat) : '') : params.value) : '';
            } : column.tooltipValueGetter,
            filterParams: _.isUndefined(column.filterParams) ? {} : column.filterParams,
            mainMenuItems: this.getMainMenuItems(column.sortable),
            suppressHeaderFilterButton: true,
            // refData: field.mapping,
            headerComponentParams: {
                field: field
            }
        }, field.defaultColDef || {});
        if (!_.isUndefined(column.cellRenderer)) {
            colDef.cellRenderer = column.cellRenderer;
        }
        if (!_.isUndefined(column.cellRendererParams)) {
            colDef.cellRendererParams = column.cellRendererParams;
        }
        if (field.formType === 'lookup') {
            colDef.cellRenderer = TextObservableCellRendererComponent;
        }
        if (field.formType === 'tags') {
            colDef.cellRenderer = TagsCellRendererComponent;
            colDef.wrapText = true;
            colDef.autoHeight = true;
        }
        if (colDef.sortable) {
            colDef.sort = _.isUndefined(column.sort) ? null : column.sort;
        }
        if (!_.isUndefined(column.width)) {
            colDef.width = column.width;
        }
        // if (_column.editable) {
        //   _column.cellEditRenderer = field.fieldComponent;
        // }
        // if (_column.enableFiltering) {
        //   let filterComponent = field.type === 'string' ? field.fieldComponent : InputFieldComponent;
        //   _column.filterCompoment = filterComponent;
        //   let _fieldOptions = new FieldOptions();
        //   _fieldOptions.showLabel = false;
        //   field.validation.required = false;
        //   _column.filterComponentParams = {
        //     field: field,
        //     fieldOptions: _fieldOptions,
        //     fieldClass: field.formType === 'picklist' ? 'form-select-xs grid-picklist' : 'form-control-xs'
        //   }
        // }
        return colDef;
    }
    setSort(columns, sort = []) {
        sort.forEach((sortItem) => {
            const _foundIndex = _.findIndex(columns, (column) => {
                return column.field === sortItem.field;
            });
            if (_foundIndex !== -1) {
                columns[_foundIndex].sort = sortItem.direction.toLowerCase();
            }
        });
    }
    getColumnVisibility(field, column) {
        if (_.isUndefined(column.visible)) {
            return field.gridColumn;
        }
        else {
            return column.visible;
        }
    }
    getMainMenuItems(sortable = true) {
        const sortMenuItems = sortable ? ['sortAscending', 'sortDescending', 'sortUnSort', 'separator'] : [];
        return [...sortMenuItems, 'columnChooser', 'separator', 'pinSubMenu', 'separator', 'autoSizeThis', 'autoSizeAll', 'separator', 'resetColumns'];
    }
    getColumns(columns, visibleColumns = []) {
        let gridColumns = [];
        columns.forEach((column) => {
            gridColumns.push(new GridColumn({
                name: column,
                visible: visibleColumns.length === 0 || visibleColumns.indexOf(column) > -1
            }));
        });
        return gridColumns;
    }
    getDefaultColumnTypes() {
        return {
            numberColumn: { width: 130, filter: 'agNumberColumnFilter' },
            dateColumn: {
                filter: DatetimeGridFilterComponent,
                filterParams: {},
                floatingFilterComponent: DatetimeFloatingFilterComponent,
                suppressFloatingFilterButton: true,
                suppressHeaderFilterButton: true
            },
            lookupColumn: {
                filter: LookupGridFilterComponent,
                filterParams: {},
                suppressFiltersToolPanel: true,
                floatingFilterComponent: LookupFloatingFilterComponent,
                suppressFloatingFilterButton: true,
                suppressHeaderFilterButton: true
            },
            selectColumn: {
                filter: 'agSetColumnFilter',
                filterParams: {
                    suppressMiniFilter: true,
                    keyCreator: (params) => params.value.value,
                    valueFormatter: (params) => params.value.label,
                    values: (params) => {
                        let options = params.colDef.headerComponentParams.field.dataSource.options || [];
                        params.success(options);
                    }
                }
            },
            tagsColumn: {
                filter: 'agSetColumnFilter',
                filterParams: {
                    values: (params) => {
                        let tagsBaseUrl = params.column.getColDef().headerComponentParams?.field.baseUrl;
                        this.entityService.build(FIXED_MODULE.TAGS).pipe(switchMap((tagsEntity) => {
                            tagsEntity.baseUrl = tagsBaseUrl;
                            return this.apiService.getList(tagsEntity, Tag, {
                                limit: ALL_RECORDS_SIZE
                            });
                        }), map((results) => {
                            let options = results.map((tag) => tag.name);
                            params.success(options);
                        })).subscribe();
                    }
                },
            }
        };
    }
    getDefaultDataTypeDefinitions() {
        let systemSettings = this.systemSettingsService.get();
        return {
            date: {
                baseDataType: 'date',
                extendsDataType: 'date',
                valueParser: params => {
                    if (!params.newValue) {
                        return null;
                    }
                    return new Date(params.newValue);
                },
                valueFormatter: (params) => {
                    if (!params.value) {
                        return '';
                    }
                    let date = new Date(params.value);
                    let dateString = this.datePipe.transform(date, systemSettings.preferences.dateTimeFormat);
                    return dateString || '';
                },
            },
            select: {
                baseDataType: 'text',
                extendsDataType: 'text',
                valueParser: params => {
                    return params.newValue;
                },
                valueFormatter: (params) => {
                    if (params.value && params.colDef.headerComponentParams.field) {
                        let foundValue = params.colDef.headerComponentParams.field.dataSource.options.find((option) => option.value === params.value);
                        return foundValue?.label || params.value;
                    }
                    return params.value;
                }
            }
        };
    }
    getDefaultColumnDef() {
        const loadingStateByEntry = new Map();
        const updateTableState = (params) => {
            loadingStateByEntry.set(params.value, false);
            setTimeout(() => {
                params.api.refreshCells({
                    suppressFlash: true,
                    rowNodes: [params.node],
                    columns: [params.column],
                });
            });
        };
        return {
            filter: 'agTextColumnFilter',
            menuTabs: ['generalMenuTab', 'columnsMenuTab'],
            filterParams: {
                maxNumConditions: 1
            },
            floatingFilter: true,
            cellRenderer: null,
            cellClassRules: {
                'grid-table-cell-loading': (params) => {
                    const mapEntry = loadingStateByEntry.get(params.value);
                    if (mapEntry !== undefined) {
                        return mapEntry;
                    }
                    if (isObservable(params.value)) {
                        loadingStateByEntry.set(params.value, true);
                        params.value.pipe(first()).subscribe({
                            next: () => updateTableState(params),
                            error: () => updateTableState(params),
                        });
                        return true;
                    }
                    return false;
                },
            },
        };
    }
    static { this.ɵfac = function GridColumnService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridColumnService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GridColumnService, factory: GridColumnService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridColumnService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
export class GridColumn {
    constructor(params) {
        this.name = '';
        this.resizable = true;
        this.editable = false;
        _.extend(this, params);
    }
}
//# sourceMappingURL=data:application/json;base64,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