/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, forwardRef, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { findIndex, isUndefined } from 'lodash-es';
import { GridColumn } from '../../../services/grid-column.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "ngx-drag-drop";
const _c0 = ["entity", ""];
function GridColumnsEditorComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 5)(1, "div", 6)(2, "span", 7);
    i0.ɵɵelement(3, "i", 8);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "span", 9)(6, "span", 10)(7, "input", 11);
    i0.ɵɵlistener("change", function GridColumnsEditorComponent_div_1_Template_input_change_7_listener($event) { const column_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.changeEditable(column_r2, $event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(8, "i", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "span", 13)(10, "input", 14);
    i0.ɵɵlistener("change", function GridColumnsEditorComponent_div_1_Template_input_change_10_listener($event) { const column_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.changeResizable(column_r2, $event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(11, "i", 15);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(12, "i", 16);
    i0.ɵɵlistener("click", function GridColumnsEditorComponent_div_1_Template_i_click_12_listener() { const fieldIndex_r4 = i0.ɵɵrestoreView(_r1).index; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.removeField(fieldIndex_r4)); });
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const column_r2 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("dndDraggable", column_r2);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", ctx_r2.entity.fields[column_r2.name] ? ctx_r2.entity.fields[column_r2.name].title : column_r2.name, " ");
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("checked", column_r2.editable)("disabled", ctx_r2.entity.fields[column_r2.name] ? !ctx_r2.entity.fields[column_r2.name].writeable : false);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("checked", column_r2.resizable);
} }
export class GridColumnsEditorComponent {
    constructor(utilityService, changeDetectorRef) {
        this.utilityService = utilityService;
        this.changeDetectorRef = changeDetectorRef;
        this.value = [];
        this.items = [];
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.column = null;
    }
    writeValue(value) {
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    onDrop(event) {
        const foundIndex = findIndex(this.value, {
            name: event.data.name
        });
        if (foundIndex > -1) {
            let dragColumn = this.value[foundIndex];
            this.value.splice(foundIndex, 1);
            if (dragColumn) {
                this.value.splice(event.index, 0, dragColumn);
            }
        }
    }
    changeResizable(column, event) {
        column.resizable = event.target.checked;
    }
    changeEditable(column, event) {
        column.editable = event.target.checked;
    }
    addField(event) {
        if (event) {
            this.value = isUndefined(this.value) ? [] : this.value;
            this.value?.push(new GridColumn({
                name: event.value.name,
                editable: false,
                resizable: true,
                sticky: 'NONE'
            }));
        }
    }
    removeField(fieldIndex) {
        this.value.splice(fieldIndex, 1);
    }
    filterFields(search) {
        const fieldsAlreadyAdded = this.value?.map((field) => field.name) || [];
        const fields = this.entity?.getFormFields() || this.entity.attributes;
        this.utilityService.filterFields(fields, search, fieldsAlreadyAdded).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function GridColumnsEditorComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridColumnsEditorComponent)(i0.ɵɵdirectiveInject(i1.UtilityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridColumnsEditorComponent, selectors: [["xf-grid-columns-editor", "entity", ""]], inputs: { entity: "entity" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => GridColumnsEditorComponent),
                    multi: true
                }])], attrs: _c0, decls: 5, vars: 5, consts: [["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card d-inline-block p-2 m-2", 3, "dndDraggable", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Add Column", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "items"], ["dndEffectAllowed", "move", 1, "card", "d-inline-block", "p-2", "m-2", 3, "dndDraggable"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], [1, "ms-3"], [1, "me-2", "p-1", "border-grey"], ["type", "checkbox", 1, "me-2", 3, "change", "checked", "disabled"], ["role", "button", 1, "fa", "fa-light", "fa-edit", "margin-top-4px"], [1, "p-1", "border-grey"], ["type", "checkbox", 1, "me-2", 3, "change", "checked"], ["role", "button", 1, "fa", "fa-light", "fa-left-right", "margin-top-4px"], ["role", "button", 1, "fa", "fa-light", "fa-close", "margin-top-4px", "text-danger", "ms-3", 3, "click"]], template: function GridColumnsEditorComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵlistener("dndDrop", function GridColumnsEditorComponent_Template_div_dndDrop_0_listener($event) { return ctx.onDrop($event); });
            i0.ɵɵtemplate(1, GridColumnsEditorComponent_div_1_Template, 13, 5, "div", 1);
            i0.ɵɵelement(2, "div", 2);
            i0.ɵɵelementStart(3, "div", 3)(4, "xf-searchable-dropdown", 4);
            i0.ɵɵlistener("ngModelChange", function GridColumnsEditorComponent_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { return ctx.addField($event); })("searchQueryChange", function GridColumnsEditorComponent_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { return ctx.filterFields($event); });
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("dndHorizontal", true);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.value);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngModel", ctx.column)("clearValueOnSelect", true)("items", ctx.items);
        } }, dependencies: [i2.NgForOf, i3.NgControlStatus, i3.NgModel, i1.SearchableDropdownComponent, i4.DndDraggableDirective, i4.DndDropzoneDirective, i4.DndHandleDirective, i4.DndPlaceholderRefDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridColumnsEditorComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-columns-editor[entity]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => GridColumnsEditorComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"col pb-2\" dndDropzone [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\" (dndDrop)=\"onDrop($event)\">\n  <div *ngFor=\"let column of value; let fieldIndex = index\" [dndDraggable]=\"column\" dndEffectAllowed=\"move\"\n    class=\"card d-inline-block p-2 m-2\">\n    <div class=\"card-title m-0 d-flex\">\n      <span class=\"flex-grow-1\">\n        <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ entity!.fields[column.name] ?\n        entity!.fields[column.name].title : column.name }}\n      </span>\n      <span class=\"ms-3\">\n        <!-- editable options -->\n        <span class=\"me-2 p-1 border-grey\">\n          <input type=\"checkbox\" class=\"me-2\" [checked]=\"column.editable\" (change)=\"changeEditable(column, $event)\"\n            [disabled]=\"entity!.fields[column.name] ? !entity!.fields[column.name].writeable : false\">\n          <i class=\"fa fa-light fa-edit margin-top-4px\" role=\"button\"></i>\n        </span>\n        <span class=\"p-1 border-grey\">\n          <input type=\"checkbox\" class=\"me-2\" [checked]=\"column.resizable\" (change)=\"changeResizable(column, $event)\">\n          <i class=\"fa fa-light fa-left-right margin-top-4px\" role=\"button\"></i>\n        </span>\n\n        <i class=\"fa fa-light fa-close margin-top-4px text-danger ms-3\" role=\"button\"\n          (click)=\"removeField(fieldIndex)\"></i>\n      </span>\n    </div>\n\n  </div>\n  <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n  <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n    <xf-searchable-dropdown (ngModelChange)=\"addField($event)\" [ngModel]=\"column\" [clearValueOnSelect]=\"true\"\n      [items]=\"items\" placeholder=\"+ Add Column\" (searchQueryChange)=\"filterFields($event)\">\n    </xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1.UtilityService }, { type: i0.ChangeDetectorRef }], { entity: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridColumnsEditorComponent, { className: "GridColumnsEditorComponent", filePath: "src/widgets/grid-widget/grid-columns-editor/grid-columns-editor.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ3JpZC1jb2x1bW5zLWVkaXRvci5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvZ3JpZC9zcmMvd2lkZ2V0cy9ncmlkLXdpZGdldC9ncmlkLWNvbHVtbnMtZWRpdG9yL2dyaWQtY29sdW1ucy1lZGl0b3IuY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL2dyaWQvc3JjL3dpZGdldHMvZ3JpZC13aWRnZXQvZ3JpZC1jb2x1bW5zLWVkaXRvci9ncmlkLWNvbHVtbnMtZWRpdG9yLmNvbXBvbmVudC5odG1sIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7O2tCQUlrQjtBQUNsQixPQUFPLEVBQUUsdUJBQXVCLEVBQXFCLFNBQVMsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQ3pHLE9BQU8sRUFBd0IsaUJBQWlCLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUN6RSxPQUFPLEVBQUUsU0FBUyxFQUFFLFdBQVcsRUFBRSxNQUFNLFdBQVcsQ0FBQztBQUtuRCxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sdUNBQXVDLENBQUM7Ozs7Ozs7OztJQ0g3RCxBQURGLEFBRkYsOEJBQ3NDLGFBQ0QsY0FDUDtJQUN4Qix1QkFBb0U7SUFBQSxZQUV0RTtJQUFBLGlCQUFPO0lBSUgsQUFERixBQUZGLCtCQUFtQixlQUVrQixnQkFFMkQ7SUFENUIseU5BQVUsd0NBQThCLEtBQUM7SUFBekcsaUJBQzRGO0lBQzVGLHdCQUFnRTtJQUNsRSxpQkFBTztJQUVMLEFBREYsZ0NBQThCLGlCQUNnRjtJQUEzQywwTkFBVSx5Q0FBK0IsS0FBQztJQUEzRyxpQkFBNEc7SUFDNUcseUJBQXNFO0lBQ3hFLGlCQUFPO0lBRVAsOEJBQ29DO0lBQWxDLDhNQUFTLGlDQUF1QixLQUFDO0lBSXpDLEFBRkUsQUFERSxBQURzQyxpQkFBSSxFQUNuQyxFQUNILEVBRUY7Ozs7SUF4Qm9ELHdDQUF1QjtJQUlQLGVBRXRFO0lBRnNFLGtJQUV0RTtJQUl3QyxlQUEyQjtJQUM3RCxBQURrQyw0Q0FBMkIsNEdBQzRCO0lBSXZELGVBQTRCO0lBQTVCLDZDQUE0Qjs7QURJMUUsTUFBTSxPQUFPLDBCQUEwQjtJQVVyQyxZQUNVLGNBQThCLEVBQzlCLGlCQUFvQztRQURwQyxtQkFBYyxHQUFkLGNBQWMsQ0FBZ0I7UUFDOUIsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtRQVY5QyxVQUFLLEdBQWlCLEVBQUUsQ0FBQztRQUV6QixVQUFLLEdBQXFCLEVBQUUsQ0FBQztRQUM3QixhQUFRLEdBQUcsQ0FBQyxDQUFNLEVBQUUsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUMzQixjQUFTLEdBQUcsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3RCLFdBQU0sR0FBMEIsSUFBSSxDQUFDO0lBUXJDLENBQUM7SUFHTSxVQUFVLENBQUMsS0FBbUI7UUFDbkMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3pDLENBQUM7SUFHTSxnQkFBZ0IsQ0FBQyxFQUEyQjtRQUNqRCxJQUFJLENBQUMsUUFBUSxHQUFHLEVBQUUsQ0FBQztJQUNyQixDQUFDO0lBRU0saUJBQWlCLENBQUMsRUFBYztRQUNyQyxJQUFJLENBQUMsU0FBUyxHQUFHLEVBQUUsQ0FBQztJQUN0QixDQUFDO0lBRUQsTUFBTSxDQUFDLEtBQW1CO1FBQ3hCLE1BQU0sVUFBVSxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ3ZDLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUk7U0FDdEIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxVQUFVLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQztZQUNwQixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsS0FBTSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ3pDLElBQUksQ0FBQyxLQUFNLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUNsQyxJQUFJLFVBQVUsRUFBRSxDQUFDO2dCQUNmLElBQUksQ0FBQyxLQUFNLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxLQUFNLEVBQUUsQ0FBQyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1lBQ2xELENBQUM7UUFDSCxDQUFDO0lBQ0gsQ0FBQztJQUVELGVBQWUsQ0FBQyxNQUFrQixFQUFFLEtBQVU7UUFDNUMsTUFBTSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQztJQUMxQyxDQUFDO0lBRUQsY0FBYyxDQUFDLE1BQWtCLEVBQUUsS0FBVTtRQUMzQyxNQUFNLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDO0lBQ3pDLENBQUM7SUFFRCxRQUFRLENBQUMsS0FBNEI7UUFDbkMsSUFBSSxLQUFLLEVBQUUsQ0FBQztZQUNWLElBQUksQ0FBQyxLQUFLLEdBQUcsV0FBVyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3ZELElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLElBQUksVUFBVSxDQUFDO2dCQUM5QixJQUFJLEVBQUUsS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJO2dCQUN0QixRQUFRLEVBQUUsS0FBSztnQkFDZixTQUFTLEVBQUUsSUFBSTtnQkFDZixNQUFNLEVBQUUsTUFBTTthQUNmLENBQUMsQ0FBQyxDQUFDO1FBQ04sQ0FBQztJQUNILENBQUM7SUFFRCxXQUFXLENBQUMsVUFBa0I7UUFDNUIsSUFBSSxDQUFDLEtBQU0sQ0FBQyxNQUFNLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRCxZQUFZLENBQUMsTUFBYztRQUN6QixNQUFNLGtCQUFrQixHQUFHLElBQUksQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQUMsS0FBaUIsRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUNwRixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxFQUFFLGFBQWEsRUFBRSxJQUFJLElBQUksQ0FBQyxNQUFPLENBQUMsVUFBVSxDQUFDO1FBQ3ZFLElBQUksQ0FBQyxjQUFjLENBQUMsWUFBWSxDQUFDLE1BQU8sRUFBRSxNQUFNLEVBQUUsa0JBQWtCLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUF1QixFQUFFLEVBQUU7WUFDMUcsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7WUFDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3pDLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzsySEE3RVUsMEJBQTBCO29FQUExQiwwQkFBMEIsd0hBTjFCLENBQUM7b0JBQ1YsT0FBTyxFQUFFLGlCQUFpQjtvQkFDMUIsV0FBVyxFQUFFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQztvQkFDekQsS0FBSyxFQUFFLElBQUk7aUJBQ1osQ0FBQztZQ2xCSiw4QkFBZ0g7WUFBM0IsOEdBQVcsa0JBQWMsSUFBQztZQUM3Ryw0RUFDc0M7WUF3QnRDLHlCQUErRDtZQUU3RCxBQURGLDhCQUE2RCxnQ0FFNkI7WUFBM0MsQUFEckIsNklBQWlCLG9CQUFnQixJQUFDLHdJQUNRLHdCQUFvQixJQUFDO1lBRzNGLEFBREUsQUFERSxpQkFBeUIsRUFDckIsRUFDRjs7WUFoQzRCLG9DQUFzQjtZQUM5QixjQUFVO1lBQVYsbUNBQVU7WUEyQjJCLGVBQWtCO1lBQzNFLEFBRDRFLEFBQW5CLG9DQUFrQiw0QkFBNEIsb0JBQ3hGOzs7aUZEVFIsMEJBQTBCO2NBWHRDLFNBQVM7MkJBQ0UsZ0NBQWdDLG1CQUd6Qix1QkFBdUIsQ0FBQyxNQUFNLGFBQ3BDLENBQUM7d0JBQ1YsT0FBTyxFQUFFLGlCQUFpQjt3QkFDMUIsV0FBVyxFQUFFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsMkJBQTJCLENBQUM7d0JBQ3pELEtBQUssRUFBRSxJQUFJO3FCQUNaLENBQUM7K0VBS08sTUFBTTtrQkFBZCxLQUFLOztrRkFISywwQkFBMEIiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgKi9cbmltcG9ydCB7IENoYW5nZURldGVjdGlvblN0cmF0ZWd5LCBDaGFuZ2VEZXRlY3RvclJlZiwgQ29tcG9uZW50LCBmb3J3YXJkUmVmLCBJbnB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQ29udHJvbFZhbHVlQWNjZXNzb3IsIE5HX1ZBTFVFX0FDQ0VTU09SIH0gZnJvbSAnQGFuZ3VsYXIvZm9ybXMnO1xuaW1wb3J0IHsgZmluZEluZGV4LCBpc1VuZGVmaW5lZCB9IGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBEbmREcm9wRXZlbnQgfSBmcm9tICduZ3gtZHJhZy1kcm9wJztcbmltcG9ydCB7IEVudGl0eSB9IGZyb20gXCJzaGFyZWRcIlxuaW1wb3J0IHsgVXRpbGl0eVNlcnZpY2UgfSBmcm9tIFwic2hhcmVkXCJcbmltcG9ydCB7IFNlYXJjaGFibGVJdGVtIH0gZnJvbSBcInNoYXJlZFwiXG5pbXBvcnQgeyBHcmlkQ29sdW1uIH0gZnJvbSAnLi4vLi4vLi4vc2VydmljZXMvZ3JpZC1jb2x1bW4uc2VydmljZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ3hmLWdyaWQtY29sdW1ucy1lZGl0b3JbZW50aXR5XScsXG4gIHRlbXBsYXRlVXJsOiAnLi9ncmlkLWNvbHVtbnMtZWRpdG9yLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vZ3JpZC1jb2x1bW5zLWVkaXRvci5jb21wb25lbnQuc2NzcyddLFxuICBjaGFuZ2VEZXRlY3Rpb246IENoYW5nZURldGVjdGlvblN0cmF0ZWd5Lk9uUHVzaCxcbiAgcHJvdmlkZXJzOiBbe1xuICAgIHByb3ZpZGU6IE5HX1ZBTFVFX0FDQ0VTU09SLFxuICAgIHVzZUV4aXN0aW5nOiBmb3J3YXJkUmVmKCgpID0+IEdyaWRDb2x1bW5zRWRpdG9yQ29tcG9uZW50KSxcbiAgICBtdWx0aTogdHJ1ZVxuICB9XVxufSlcbmV4cG9ydCBjbGFzcyBHcmlkQ29sdW1uc0VkaXRvckNvbXBvbmVudCBpbXBsZW1lbnRzIENvbnRyb2xWYWx1ZUFjY2Vzc29yIHtcblxuICB2YWx1ZTogR3JpZENvbHVtbltdID0gW107XG4gIEBJbnB1dCgpIGVudGl0eT86IEVudGl0eTtcbiAgaXRlbXM6IFNlYXJjaGFibGVJdGVtW10gPSBbXTtcbiAgb25DaGFuZ2UgPSAoXzogYW55KSA9PiB7IH07XG4gIG9uVG91Y2hlZCA9ICgpID0+IHsgfTtcbiAgY29sdW1uOiBTZWFyY2hhYmxlSXRlbSB8IG51bGwgPSBudWxsO1xuXG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSB1dGlsaXR5U2VydmljZTogVXRpbGl0eVNlcnZpY2UsXG4gICAgcHJpdmF0ZSBjaGFuZ2VEZXRlY3RvclJlZjogQ2hhbmdlRGV0ZWN0b3JSZWZcbiAgKSB7XG5cbiAgfVxuXG5cbiAgcHVibGljIHdyaXRlVmFsdWUodmFsdWU6IEdyaWRDb2x1bW5bXSk6IHZvaWQge1xuICAgIHRoaXMudmFsdWUgPSB2YWx1ZTtcbiAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgfVxuXG5cbiAgcHVibGljIHJlZ2lzdGVyT25DaGFuZ2UoZm46ICh2YWx1ZTogc3RyaW5nKSA9PiB2b2lkKTogdm9pZCB7XG4gICAgdGhpcy5vbkNoYW5nZSA9IGZuO1xuICB9XG5cbiAgcHVibGljIHJlZ2lzdGVyT25Ub3VjaGVkKGZuOiAoKSA9PiB2b2lkKTogdm9pZCB7XG4gICAgdGhpcy5vblRvdWNoZWQgPSBmbjtcbiAgfVxuXG4gIG9uRHJvcChldmVudDogRG5kRHJvcEV2ZW50KSB7XG4gICAgY29uc3QgZm91bmRJbmRleCA9IGZpbmRJbmRleCh0aGlzLnZhbHVlLCB7XG4gICAgICBuYW1lOiBldmVudC5kYXRhLm5hbWVcbiAgICB9KTtcblxuICAgIGlmIChmb3VuZEluZGV4ID4gLTEpIHtcbiAgICAgIGxldCBkcmFnQ29sdW1uID0gdGhpcy52YWx1ZSFbZm91bmRJbmRleF07XG4gICAgICB0aGlzLnZhbHVlIS5zcGxpY2UoZm91bmRJbmRleCwgMSk7XG4gICAgICBpZiAoZHJhZ0NvbHVtbikge1xuICAgICAgICB0aGlzLnZhbHVlIS5zcGxpY2UoZXZlbnQuaW5kZXghLCAwLCBkcmFnQ29sdW1uKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBjaGFuZ2VSZXNpemFibGUoY29sdW1uOiBHcmlkQ29sdW1uLCBldmVudDogYW55KSB7XG4gICAgY29sdW1uLnJlc2l6YWJsZSA9IGV2ZW50LnRhcmdldC5jaGVja2VkO1xuICB9XG5cbiAgY2hhbmdlRWRpdGFibGUoY29sdW1uOiBHcmlkQ29sdW1uLCBldmVudDogYW55KSB7XG4gICAgY29sdW1uLmVkaXRhYmxlID0gZXZlbnQudGFyZ2V0LmNoZWNrZWQ7XG4gIH1cblxuICBhZGRGaWVsZChldmVudDogU2VhcmNoYWJsZUl0ZW0gfCBudWxsKSB7XG4gICAgaWYgKGV2ZW50KSB7XG4gICAgICB0aGlzLnZhbHVlID0gaXNVbmRlZmluZWQodGhpcy52YWx1ZSkgPyBbXSA6IHRoaXMudmFsdWU7XG4gICAgICB0aGlzLnZhbHVlPy5wdXNoKG5ldyBHcmlkQ29sdW1uKHtcbiAgICAgICAgbmFtZTogZXZlbnQudmFsdWUubmFtZSxcbiAgICAgICAgZWRpdGFibGU6IGZhbHNlLFxuICAgICAgICByZXNpemFibGU6IHRydWUsXG4gICAgICAgIHN0aWNreTogJ05PTkUnXG4gICAgICB9KSk7XG4gICAgfVxuICB9XG5cbiAgcmVtb3ZlRmllbGQoZmllbGRJbmRleDogbnVtYmVyKSB7XG4gICAgdGhpcy52YWx1ZSEuc3BsaWNlKGZpZWxkSW5kZXgsIDEpO1xuICB9XG5cbiAgZmlsdGVyRmllbGRzKHNlYXJjaDogc3RyaW5nKSB7XG4gICAgY29uc3QgZmllbGRzQWxyZWFkeUFkZGVkID0gdGhpcy52YWx1ZT8ubWFwKChmaWVsZDogR3JpZENvbHVtbikgPT4gZmllbGQubmFtZSkgfHwgW107XG4gICAgY29uc3QgZmllbGRzID0gdGhpcy5lbnRpdHk/LmdldEZvcm1GaWVsZHMoKSB8fCB0aGlzLmVudGl0eSEuYXR0cmlidXRlcztcbiAgICB0aGlzLnV0aWxpdHlTZXJ2aWNlLmZpbHRlckZpZWxkcyhmaWVsZHMhLCBzZWFyY2gsIGZpZWxkc0FscmVhZHlBZGRlZCkuc3Vic2NyaWJlKChpdGVtczogU2VhcmNoYWJsZUl0ZW1bXSkgPT4ge1xuICAgICAgdGhpcy5pdGVtcyA9IGl0ZW1zO1xuICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgfSk7XG4gIH1cblxufVxuIiwiPCEtLSBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgLS0+XG48ZGl2IGNsYXNzPVwiY29sIHBiLTJcIiBkbmREcm9wem9uZSBbZG5kSG9yaXpvbnRhbF09XCJ0cnVlXCIgZG5kRWZmZWN0QWxsb3dlZD1cImNvcHlNb3ZlXCIgKGRuZERyb3ApPVwib25Ecm9wKCRldmVudClcIj5cbiAgPGRpdiAqbmdGb3I9XCJsZXQgY29sdW1uIG9mIHZhbHVlOyBsZXQgZmllbGRJbmRleCA9IGluZGV4XCIgW2RuZERyYWdnYWJsZV09XCJjb2x1bW5cIiBkbmRFZmZlY3RBbGxvd2VkPVwibW92ZVwiXG4gICAgY2xhc3M9XCJjYXJkIGQtaW5saW5lLWJsb2NrIHAtMiBtLTJcIj5cbiAgICA8ZGl2IGNsYXNzPVwiY2FyZC10aXRsZSBtLTAgZC1mbGV4XCI+XG4gICAgICA8c3BhbiBjbGFzcz1cImZsZXgtZ3Jvdy0xXCI+XG4gICAgICAgIDxpIGNsYXNzPVwiY3Vyc29yLW1vdmUgZmEgZmEtYXJyb3dzLWFsdCBmYS1saWdodCBtZS0yXCIgZG5kSGFuZGxlPjwvaT57eyBlbnRpdHkhLmZpZWxkc1tjb2x1bW4ubmFtZV0gP1xuICAgICAgICBlbnRpdHkhLmZpZWxkc1tjb2x1bW4ubmFtZV0udGl0bGUgOiBjb2x1bW4ubmFtZSB9fVxuICAgICAgPC9zcGFuPlxuICAgICAgPHNwYW4gY2xhc3M9XCJtcy0zXCI+XG4gICAgICAgIDwhLS0gZWRpdGFibGUgb3B0aW9ucyAtLT5cbiAgICAgICAgPHNwYW4gY2xhc3M9XCJtZS0yIHAtMSBib3JkZXItZ3JleVwiPlxuICAgICAgICAgIDxpbnB1dCB0eXBlPVwiY2hlY2tib3hcIiBjbGFzcz1cIm1lLTJcIiBbY2hlY2tlZF09XCJjb2x1bW4uZWRpdGFibGVcIiAoY2hhbmdlKT1cImNoYW5nZUVkaXRhYmxlKGNvbHVtbiwgJGV2ZW50KVwiXG4gICAgICAgICAgICBbZGlzYWJsZWRdPVwiZW50aXR5IS5maWVsZHNbY29sdW1uLm5hbWVdID8gIWVudGl0eSEuZmllbGRzW2NvbHVtbi5uYW1lXS53cml0ZWFibGUgOiBmYWxzZVwiPlxuICAgICAgICAgIDxpIGNsYXNzPVwiZmEgZmEtbGlnaHQgZmEtZWRpdCBtYXJnaW4tdG9wLTRweFwiIHJvbGU9XCJidXR0b25cIj48L2k+XG4gICAgICAgIDwvc3Bhbj5cbiAgICAgICAgPHNwYW4gY2xhc3M9XCJwLTEgYm9yZGVyLWdyZXlcIj5cbiAgICAgICAgICA8aW5wdXQgdHlwZT1cImNoZWNrYm94XCIgY2xhc3M9XCJtZS0yXCIgW2NoZWNrZWRdPVwiY29sdW1uLnJlc2l6YWJsZVwiIChjaGFuZ2UpPVwiY2hhbmdlUmVzaXphYmxlKGNvbHVtbiwgJGV2ZW50KVwiPlxuICAgICAgICAgIDxpIGNsYXNzPVwiZmEgZmEtbGlnaHQgZmEtbGVmdC1yaWdodCBtYXJnaW4tdG9wLTRweFwiIHJvbGU9XCJidXR0b25cIj48L2k+XG4gICAgICAgIDwvc3Bhbj5cblxuICAgICAgICA8aSBjbGFzcz1cImZhIGZhLWxpZ2h0IGZhLWNsb3NlIG1hcmdpbi10b3AtNHB4IHRleHQtZGFuZ2VyIG1zLTNcIiByb2xlPVwiYnV0dG9uXCJcbiAgICAgICAgICAoY2xpY2spPVwicmVtb3ZlRmllbGQoZmllbGRJbmRleClcIj48L2k+XG4gICAgICA8L3NwYW4+XG4gICAgPC9kaXY+XG5cbiAgPC9kaXY+XG4gIDxkaXYgY2xhc3M9XCJjYXJkIGRuZC1wbGFjZWhvbGRlciBtdC0yXCIgZG5kUGxhY2Vob2xkZXJSZWY+PC9kaXY+XG4gIDxkaXYgY2xhc3M9XCJkLWZsZXggZmxleC1yb3cganVzdGlmeS1jb250ZW50LWxlZnQgZ2FwLTIgbXQtMlwiPlxuICAgIDx4Zi1zZWFyY2hhYmxlLWRyb3Bkb3duIChuZ01vZGVsQ2hhbmdlKT1cImFkZEZpZWxkKCRldmVudClcIiBbbmdNb2RlbF09XCJjb2x1bW5cIiBbY2xlYXJWYWx1ZU9uU2VsZWN0XT1cInRydWVcIlxuICAgICAgW2l0ZW1zXT1cIml0ZW1zXCIgcGxhY2Vob2xkZXI9XCIrIEFkZCBDb2x1bW5cIiAoc2VhcmNoUXVlcnlDaGFuZ2UpPVwiZmlsdGVyRmllbGRzKCRldmVudClcIj5cbiAgICA8L3hmLXNlYXJjaGFibGUtZHJvcGRvd24+XG4gIDwvZGl2PlxuPC9kaXY+XG4iXX0=