/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, Input } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import _, { isUndefined } from 'lodash-es';
import { findIndex } from 'lodash-es';
import { combineLatest, concatMap, map, of } from 'rxjs';
import { Entity, Query, SearchableItem } from "shared";
import { AbstractWidgetEditComponent } from 'shared/view-templates';
import { GridColumn } from '../../../services/grid-column.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/router";
import * as i4 from "../../../services/grid-column.service";
import * as i5 from "@angular/common";
import * as i6 from "ngx-drag-drop";
import * as i7 from "../default-sort/default-sort.component";
import * as i8 from "../grid-columns-editor/grid-columns-editor.component";
function GridEditComponent_div_3_option_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 22);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const module_r1 = ctx.$implicit;
    i0.ɵɵproperty("value", module_r1.type);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(module_r1.descriptions.plural);
} }
function GridEditComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Data Source");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 19)(4, "option", 20);
    i0.ɵɵtext(5, "Select a module");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, GridEditComponent_div_3_option_6_Template, 2, 2, "option", 21);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngValue", null);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.formGroup.controls.onlyRelated.value ? ctx_r1.relatedModules : ctx_r1.modules);
} }
function GridEditComponent_div_4_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 23);
    i0.ɵɵtext(2, " Records to Include ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 24)(4, "option", 20);
    i0.ɵɵtext(5, "Related Records");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(6, "option", 20);
    i0.ɵɵtext(7, "All Records");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngValue", true);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngValue", false);
} }
function GridEditComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, GridEditComponent_div_4_div_1_Template, 8, 2, "div", 3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.formGroup.controls.onlyRelated);
} }
function GridEditComponent_div_16_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Select Columns");
    i0.ɵɵelementEnd();
    i0.ɵɵelement(3, "xf-grid-columns-editor", 25);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("entity", ctx_r1.selectedEntity);
} }
function GridEditComponent_div_18_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 31)(1, "div", 32)(2, "span", 33);
    i0.ɵɵelement(3, "i", 34);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "span", 35)(6, "i", 36);
    i0.ɵɵlistener("click", function GridEditComponent_div_18_div_6_Template_i_click_6_listener() { const pbIndex_r5 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.removeActionPlaybook(pbIndex_r5)); });
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const playbook_r6 = ctx.$implicit;
    i0.ɵɵproperty("dndDraggable", playbook_r6);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", playbook_r6.name, " ");
} }
function GridEditComponent_div_18_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 5)(1, "label", 16);
    i0.ɵɵtext(2, "Actions");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 26)(4, "xf-searchable-dropdown", 27);
    i0.ɵɵlistener("ngModelChange", function GridEditComponent_div_18_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.addActionPlaybook($event)); })("searchQueryChange", function GridEditComponent_div_18_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.filterActionPlaybooks($event)); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "div", 28);
    i0.ɵɵlistener("dndDrop", function GridEditComponent_div_18_Template_div_dndDrop_5_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onActionsDrop($event)); });
    i0.ɵɵtemplate(6, GridEditComponent_div_18_div_6_Template, 7, 2, "div", 29);
    i0.ɵɵelement(7, "div", 30);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngModel", ctx_r1.actionPlaybook)("clearValueOnSelect", true)("required", false)("items", ctx_r1.actionPlaybookList);
    i0.ɵɵadvance();
    i0.ɵɵproperty("dndHorizontal", true);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.widgetConfig.configuration.actionPlaybooks);
} }
function GridEditComponent_div_33_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "small", 37);
    i0.ɵɵtext(2, "Select a module above");
    i0.ɵɵelementEnd()();
} }
function GridEditComponent_div_34_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-filter-group", 38);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r1.selectedEntity);
} }
function GridEditComponent_div_35_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵelement(1, "xf-default-sort", 39);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("query", ctx_r1.widgetConfig.configuration.query)("fields", ctx_r1.fields);
} }
export class GridEditComponent extends AbstractWidgetEditComponent {
    constructor(changeDetectorRef, entityService, modelMetadataService, formBuilder, playbookService, router, utilityService, gridColumnService) {
        super(changeDetectorRef, entityService, utilityService);
        this.modelMetadataService = modelMetadataService;
        this.playbookService = playbookService;
        this.router = router;
        this.gridColumnService = gridColumnService;
        this.modules = [];
        this.relatedModules = [];
        this.actionPlaybook = null;
        this.fields = {};
        this.actionPlaybookList = [];
        this.actionPBList = [];
        this.isDetailPage = false;
        this.formGroup = formBuilder.group({
            onlyRelated: [false, Validators.required],
            module: [null, Validators.required],
            onClickState: ['preview', Validators.required],
            rowExpandable: new FormControl(false),
            lightMode: new FormControl(false),
            query: new FormControl({}),
            gridConfig: [null]
        });
        this.isDetailPage = this.router.url.indexOf('/module/') !== -1;
    }
    ngOnInit() {
        this.formGroup.controls.gridConfig.setValue(this.widgetConfig.configuration.columns);
        this.modelMetadataService.getModuleList(false, false).pipe(concatMap((modules) => {
            this.modules = modules;
            if (this.context.module) {
                return this.entityService.build(this.context.module).pipe(concatMap((entity) => {
                    this.entity = entity;
                    return this.initWidgetConfig(this.entity);
                }));
            }
            else {
                return this.initWidgetConfig();
            }
        })).subscribe(() => this.changeDetectorRef.detectChanges());
    }
    moduleChanged(module) {
        this.widgetConfig.configuration.module = module;
        this.entityService.build(module).subscribe((entity) => {
            this.selectedEntity = entity;
            this.widgetConfig.configuration.columns = undefined;
            this.setFields();
            this.changeDetectorRef.detectChanges();
        });
    }
    queryChange(filterGroup) {
        if (!filterGroup) {
            return;
        }
        this.widgetConfig.configuration.query = filterGroup;
    }
    initWidgetConfig(entity) {
        this.widgetConfig.configuration.module = entity ? entity.type : this.widgetConfig.configuration.module;
        let observable$ = of(null);
        if (this.widgetConfig.configuration.module) {
            observable$ = this.entityService.build(this.widgetConfig.configuration.module).pipe(concatMap((entity) => {
                this.selectedEntity = entity;
                this.setFields();
                if (entity) {
                    let relatedModules$ = entity.relationships.map((field) => {
                        if (!field.model) {
                            let entity = new Entity(field.name);
                            entity.descriptions = {
                                singular: field.name,
                                plural: field.name
                            };
                            return of(entity);
                        }
                        return this.entityService.build(field.model);
                    });
                    return combineLatest(relatedModules$).pipe(map((entities) => {
                        this.relatedModules = entities;
                        this.changeDetectorRef.detectChanges();
                    }));
                }
                return of(null);
            }));
        }
        this.widgetConfig.configuration.onClickState = this.widgetConfig.configuration.onClickState || 'preview';
        this.widgetConfig.configuration.query = this.widgetConfig.configuration.query ? plainToInstance(Query, this.widgetConfig.configuration.query) : new Query();
        this.formGroup.controls.onlyRelated.setValue(this.widgetConfig.configuration.onlyRelated);
        this.formGroup.controls.module.setValue(this.widgetConfig.configuration.module || null);
        this.formGroup.controls.onClickState.setValue(this.widgetConfig.configuration.onClickState);
        this.formGroup.controls.query.setValue(this.widgetConfig.configuration.query);
        if (this.isDetailPage) {
            this.formGroup.controls.module.disable();
        }
        this.formGroup.controls.onlyRelated.valueChanges.subscribe((value) => {
            this.widgetConfig.configuration.onlyRelated = value;
            if (value) {
                const foundRelatedModule = this.relatedModules.find((relatedModule) => relatedModule.type === this.widgetConfig.configuration.module);
                if (this.formGroup.controls.module.value !== foundRelatedModule?.type) {
                    this.formGroup.controls.module.setValue(foundRelatedModule?.type || null);
                }
            }
        });
        this.formGroup.controls.module.valueChanges.subscribe((value) => {
            if (value === null) {
                this.selectedEntity = undefined;
            }
            else {
                this.moduleChanged(value);
            }
        });
        this.formGroup.controls.onClickState.valueChanges.subscribe((value) => {
            this.widgetConfig.configuration.onClickState = value;
        });
        this.formGroup.controls.query.valueChanges.subscribe((value) => this.queryChange(value));
        // this.changeDetectorRef.detectChanges();
        return observable$;
    }
    rowExpansionChange(event) {
        this.widgetConfig.configuration.rowExpandable = event.target.checked;
    }
    lightModeChange(event) {
        this.widgetConfig.configuration.lightMode = event.target.checked;
    }
    setFields() {
        let fields = this.selectedEntity?.getFormFields();
        this.fields = _.keyBy(fields, 'name');
        this.getActionPlaybooks();
        this.setColumns();
    }
    setColumns() {
        if (isUndefined(this.widgetConfig.configuration.columns) || this.widgetConfig.configuration.columns.length === 0) {
            const gridColumns = this.gridColumnService.create(this.fields, new Query());
            const visibleColumns = gridColumns.filter((column) => !column.hide);
            this.widgetConfig.configuration.columns = [];
            visibleColumns?.forEach((column) => {
                this.widgetConfig.configuration.columns?.push(new GridColumn({
                    name: column.field || '',
                    editable: false,
                    resizable: true,
                    sticky: 'NONE'
                }));
            });
        }
    }
    getActionPlaybooks() {
        this.playbookService.getActionPlaybooks(this.selectedEntity, false, []).subscribe((response) => {
            response.forEach((playbook) => {
                const searchablePB = new SearchableItem(playbook.actionTriggerName, playbook['@id'], playbook.uuid);
                this.actionPlaybookList.push(searchablePB);
                this.actionPBList.push(searchablePB);
            });
            this.widgetConfig.configuration.actionPlaybooks = this.widgetConfig.configuration.actionPlaybooks || [];
        });
    }
    onActionsDrop(event) {
        const foundIndex = findIndex(this.widgetConfig.configuration.actionPlaybooks, {
            name: event.data.name
        });
        if (foundIndex > -1) {
            let dragColumn = this.widgetConfig.configuration.actionPlaybooks[foundIndex];
            this.widgetConfig.configuration.actionPlaybooks.splice(foundIndex, 1);
            this.widgetConfig.configuration.actionPlaybooks.splice(event.index, 0, dragColumn);
        }
    }
    addActionPlaybook(event) {
        if (event !== null) {
            this.widgetConfig.configuration.actionPlaybooks?.push({
                name: event?.display,
                id: event?.value
            });
        }
    }
    removeActionPlaybook(index) {
        this.widgetConfig.configuration.actionPlaybooks?.splice(index, 1);
    }
    filterActionPlaybooks(search) {
        of(this.actionPBList).pipe(map((items) => {
            const pbs = this.widgetConfig.configuration.actionPlaybooks?.map(({ id }) => id);
            return items.filter((item) => {
                return pbs.indexOf(item.value) === -1;
            });
        }), map((items) => {
            return items.filter((item) => {
                return item.display.toLowerCase().indexOf(search.toLowerCase()) > -1;
            });
        })).subscribe((items) => {
            this.actionPlaybookList = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function GridEditComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridEditComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i1.ModelMetadataService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i1.PlaybookService), i0.ɵɵdirectiveInject(i3.Router), i0.ɵɵdirectiveInject(i1.UtilityService), i0.ɵɵdirectiveInject(i4.GridColumnService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridEditComponent, selectors: [["xf-grid-edit"]], inputs: { widgetConfig: "widgetConfig" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 36, vars: 10, consts: [[3, "formGroup"], [1, "row", "mt-3"], [1, "col-md-6"], ["class", "form-group", 4, "ngIf"], ["class", "col-md-6", 4, "ngIf"], [1, "form-group"], ["for", "onClickState", 1, "fw-bold", "col-form-label"], ["formControlName", "onClickState", "id", "onClickState", 1, "form-select"], ["value", "preview"], ["value", "module"], ["for", "row-expansion", 1, "fw-bold"], ["type", "checkbox", "name", "row-expansion", "id", "row-expansion", "formcontrolname", "rowExpandable", 1, "form-check-input", 3, "change", "checked"], [1, "form-check-label", "ps-2"], ["for", "light-mode", 1, "fw-bold"], ["type", "checkbox", "name", "light-mode", "id", "light-mode", "formcontrolname", "lightMode", 1, "form-check-input", 3, "change", "checked"], [1, "col-md-12"], [1, "fw-bold"], [4, "ngIf"], ["class", "row mt-3", 4, "ngIf"], ["formControlName", "module", 1, "form-select"], [3, "ngValue"], [3, "value", 4, "ngFor", "ngForOf"], [3, "value"], ["for", "onlyRelated", 1, "fw-bold"], ["formControlName", "onlyRelated", 1, "form-select"], ["formControlName", "gridConfig", 3, "entity"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Select a Manual Trigger Playbook", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "required", "items"], ["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card d-inline-block p-2 m-2", 3, "dndDraggable", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], ["dndEffectAllowed", "move", 1, "card", "d-inline-block", "p-2", "m-2", 3, "dndDraggable"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], [1, "ms-3"], ["role", "button", 1, "fa", "fa-light", "fa-close", "margin-top-4px", "text-danger", "ms-3", 3, "click"], [1, "font-italic"], ["formControlName", "query", 3, "entity"], [1, "col-lg-7", "col-md-8", "col-sm-12", 3, "query", "fields"]], template: function GridEditComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "div", 2);
            i0.ɵɵtemplate(3, GridEditComponent_div_3_Template, 7, 2, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(4, GridEditComponent_div_4_Template, 2, 1, "div", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "div", 1)(6, "div", 2)(7, "div", 5)(8, "label", 6);
            i0.ɵɵtext(9, "Click Action");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(10, "select", 7)(11, "option", 8);
            i0.ɵɵtext(12, "Open in Preview");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(13, "option", 9);
            i0.ɵɵtext(14, "Open in Detail View");
            i0.ɵɵelementEnd()()()()();
            i0.ɵɵelementStart(15, "div", 1);
            i0.ɵɵtemplate(16, GridEditComponent_div_16_Template, 4, 1, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(17, "div", 1);
            i0.ɵɵtemplate(18, GridEditComponent_div_18_Template, 8, 6, "div", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(19, "div", 1)(20, "label", 10)(21, "input", 11);
            i0.ɵɵlistener("change", function GridEditComponent_Template_input_change_21_listener($event) { return ctx.rowExpansionChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(22, "span", 12);
            i0.ɵɵtext(23, "Row Expandable");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(24, "div", 1)(25, "label", 13)(26, "input", 14);
            i0.ɵɵlistener("change", function GridEditComponent_Template_input_change_26_listener($event) { return ctx.lightModeChange($event); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(27, "span", 12);
            i0.ɵɵtext(28, "Enable light mode");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(29, "div", 1)(30, "div", 15)(31, "label", 16);
            i0.ɵɵtext(32, "Filters");
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(33, GridEditComponent_div_33_Template, 3, 0, "div", 17)(34, GridEditComponent_div_34_Template, 2, 1, "div", 17);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(35, GridEditComponent_div_35_Template, 2, 2, "div", 18);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.module);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.entity && !ctx.isDetailPage);
            i0.ɵɵadvance(12);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.gridConfig);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.formGroup.controls.module);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("checked", ctx.widgetConfig.configuration.rowExpandable);
            i0.ɵɵadvance(5);
            i0.ɵɵproperty("checked", ctx.widgetConfig.configuration.lightMode);
            i0.ɵɵadvance(7);
            i0.ɵɵproperty("ngIf", !ctx.selectedEntity);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.selectedEntity);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fields);
        } }, dependencies: [i5.NgForOf, i5.NgIf, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.RequiredValidator, i2.NgModel, i2.FormGroupDirective, i2.FormControlName, i1.FilterGroupComponent, i1.SearchableDropdownComponent, i6.DndDraggableDirective, i6.DndDropzoneDirective, i6.DndHandleDirective, i6.DndPlaceholderRefDirective, i7.DefaultSortComponent, i8.GridColumnsEditorComponent], styles: [".border-grey[_ngcontent-%COMP%]{border:1px solid var(--solid-border-secondary-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridEditComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-edit', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div [formGroup]=\"formGroup\">\n  <div class=\"row mt-3\">\n    <div class=\"col-md-6\">\n      <div class=\"form-group\" *ngIf=\"formGroup.controls.module\">\n        <label class=\"fw-bold\">Data Source</label>\n        <select class=\"form-select\" formControlName=\"module\">\n          <option [ngValue]=\"null\">Select a module</option>\n          <option *ngFor=\"let module of (formGroup.controls.onlyRelated.value ? relatedModules : modules)\"\n            [value]=\"module.type\">{{ module.descriptions.plural }}</option>\n        </select>\n      </div>\n    </div>\n    <div class=\"col-md-6\" *ngIf=\"entity && !isDetailPage\">\n      <div class=\"form-group\" *ngIf=\"formGroup.controls.onlyRelated\">\n        <label class=\"fw-bold\" for=\"onlyRelated\">\n          Records to Include\n        </label>\n        <select class=\"form-select\" formControlName=\"onlyRelated\">\n          <option [ngValue]=\"true\">Related Records</option>\n          <option [ngValue]=\"false\">All Records</option>\n        </select>\n      </div>\n    </div>\n  </div>\n  <div class=\"row mt-3\">\n    <div class=\"col-md-6\">\n      <div class=\"form-group\">\n        <label for=\"onClickState\" class=\"fw-bold col-form-label\">Click Action</label>\n        <select class=\"form-select\" formControlName=\"onClickState\" id=\"onClickState\">\n          <option value=\"preview\">Open in Preview</option>\n          <option value=\"module\">Open in Detail View</option>\n        </select>\n      </div>\n    </div>\n  </div>\n  <!-- Select fields -->\n  <div class=\"row mt-3\">\n    <div class=\"form-group\" *ngIf=\"formGroup.controls.gridConfig\">\n      <label class=\"fw-bold\">Select Columns</label>\n      <xf-grid-columns-editor [entity]=\"selectedEntity\" formControlName=\"gridConfig\"></xf-grid-columns-editor>\n    </div>\n  </div>\n\n  <!-- Select Action Playbooks -->\n  <div class=\"row mt-3\">\n    <div class=\"form-group\" *ngIf=\"formGroup.controls.module\">\n      <label class=\"fw-bold\">Actions</label>\n      <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n        <xf-searchable-dropdown (ngModelChange)=\"addActionPlaybook($event)\" [ngModel]=\"actionPlaybook\" [clearValueOnSelect]=\"true\"\n          [required]=\"false\" [items]=\"actionPlaybookList\" placeholder=\"+ Select a Manual Trigger Playbook\"\n          (searchQueryChange)=\"filterActionPlaybooks($event)\">\n        </xf-searchable-dropdown>\n      </div>\n      <div class=\"col pb-2\" dndDropzone [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\"\n        (dndDrop)=\"onActionsDrop($event)\">\n        <div *ngFor=\"let playbook of widgetConfig.configuration.actionPlaybooks; let pbIndex = index\"\n          [dndDraggable]=\"playbook\" dndEffectAllowed=\"move\" class=\"card d-inline-block p-2 m-2\">\n          <div class=\"card-title m-0 d-flex\">\n            <span class=\"flex-grow-1\">\n              <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ playbook.name }}\n            </span>\n            <span class=\"ms-3\">\n              <i class=\"fa fa-light fa-close margin-top-4px text-danger ms-3\" role=\"button\"\n                (click)=\"removeActionPlaybook(pbIndex)\"></i>\n            </span>\n          </div>\n\n        </div>\n        <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n      </div>\n    </div>\n  </div>\n\n  <!-- Row expansion -->\n  <div class=\"row mt-3\">\n    <label for=\"row-expansion\" class=\"fw-bold\">\n      <input type=\"checkbox\" name=\"row-expansion\" id=\"row-expansion\" formcontrolname=\"rowExpandable\"\n        class=\"form-check-input\" [checked]=\"widgetConfig.configuration.rowExpandable\"\n        (change)=\"rowExpansionChange($event)\">\n      <span class=\"form-check-label ps-2\">Row Expandable</span>\n    </label>\n  </div>\n\n  <!--  Light Mode -->\n  <div class=\"row mt-3\">\n    <label for=\"light-mode\" class=\"fw-bold\">\n      <input type=\"checkbox\" name=\"light-mode\" id=\"light-mode\" formcontrolname=\"lightMode\" class=\"form-check-input\"\n        [checked]=\"widgetConfig.configuration.lightMode\" (change)=\"lightModeChange($event)\">\n      <span class=\"form-check-label ps-2\">Enable light mode</span>\n    </label>\n  </div>\n\n  <!-- Filters -->\n  <div class=\"row mt-3\">\n    <div class=\"col-md-12\">\n      <label class=\"fw-bold\">Filters</label>\n      <div *ngIf=\"!selectedEntity\">\n        <small class=\"font-italic\">Select a module above</small>\n      </div>\n      <div *ngIf=\"selectedEntity\">\n        <xf-filter-group formControlName=\"query\" [entity]=\"selectedEntity\"></xf-filter-group>\n      </div>\n    </div>\n  </div>\n\n  <div class=\"row mt-3\" *ngIf=\"fields\">\n    <xf-default-sort [query]=\"widgetConfig.configuration.query\" [fields]=\"fields!\" class=\"col-lg-7 col-md-8 col-sm-12\">\n    </xf-default-sort>\n  </div>\n\n</div>\n", styles: [".border-grey{border:1px solid var(--solid-border-secondary-color)}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.EntityService }, { type: i1.ModelMetadataService }, { type: i2.FormBuilder }, { type: i1.PlaybookService }, { type: i3.Router }, { type: i1.UtilityService }, { type: i4.GridColumnService }], { widgetConfig: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridEditComponent, { className: "GridEditComponent", filePath: "src/widgets/grid-widget/grid-edit/grid-edit.component.ts", lineNumber: 26 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ3JpZC1lZGl0LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9ncmlkL3NyYy93aWRnZXRzL2dyaWQtd2lkZ2V0L2dyaWQtZWRpdC9ncmlkLWVkaXQuY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL2dyaWQvc3JjL3dpZGdldHMvZ3JpZC13aWRnZXQvZ3JpZC1lZGl0L2dyaWQtZWRpdC5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7OztrQkFJa0I7QUFDbEIsT0FBTyxFQUFFLHVCQUF1QixFQUFxQixTQUFTLEVBQUUsS0FBSyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzdGLE9BQU8sRUFBZSxXQUFXLEVBQWEsVUFBVSxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFHakYsT0FBTyxFQUFFLGVBQWUsRUFBRSxNQUFNLG1CQUFtQixDQUFDO0FBQ3BELE9BQU8sQ0FBQyxFQUFFLEVBQUUsV0FBVyxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQzNDLE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFFdEMsT0FBTyxFQUFjLGFBQWEsRUFBRSxTQUFTLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUNyRSxPQUFPLEVBQUUsTUFBTSxFQUEyRixLQUFLLEVBQUUsY0FBYyxFQUFrQixNQUFNLFFBQVEsQ0FBQztBQUNoSyxPQUFPLEVBQUUsMkJBQTJCLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQztBQUVwRSxPQUFPLEVBQUUsVUFBVSxFQUFxQixNQUFNLHVDQUF1QyxDQUFDOzs7Ozs7Ozs7OztJQ0w1RSxrQ0FDd0I7SUFBQSxZQUFnQztJQUFBLGlCQUFTOzs7SUFBL0Qsc0NBQXFCO0lBQUMsY0FBZ0M7SUFBaEMsbURBQWdDOzs7SUFKMUQsQUFERiw4QkFBMEQsZ0JBQ2pDO0lBQUEsMkJBQVc7SUFBQSxpQkFBUTtJQUV4QyxBQURGLGtDQUFxRCxpQkFDMUI7SUFBQSwrQkFBZTtJQUFBLGlCQUFTO0lBQ2pELCtFQUN3QjtJQUU1QixBQURFLGlCQUFTLEVBQ0w7OztJQUpNLGVBQWdCO0lBQWhCLDhCQUFnQjtJQUNHLGVBQW9FO0lBQXBFLDhHQUFvRTs7O0lBT2pHLEFBREYsOEJBQStELGdCQUNwQjtJQUN2QyxvQ0FDRjtJQUFBLGlCQUFRO0lBRU4sQUFERixrQ0FBMEQsaUJBQy9CO0lBQUEsK0JBQWU7SUFBQSxpQkFBUztJQUNqRCxrQ0FBMEI7SUFBQSwyQkFBVztJQUV6QyxBQURFLEFBRHVDLGlCQUFTLEVBQ3ZDLEVBQ0w7O0lBSE0sZUFBZ0I7SUFBaEIsOEJBQWdCO0lBQ2hCLGVBQWlCO0lBQWpCLCtCQUFpQjs7O0lBUC9CLDhCQUFzRDtJQUNwRCx3RUFBK0Q7SUFTakUsaUJBQU07OztJQVRxQixjQUFvQztJQUFwQyw0REFBb0M7OztJQXlCN0QsQUFERiw4QkFBOEQsZ0JBQ3JDO0lBQUEsOEJBQWM7SUFBQSxpQkFBUTtJQUM3Qyw2Q0FBd0c7SUFDMUcsaUJBQU07OztJQURvQixlQUF5QjtJQUF6Qiw4Q0FBeUI7Ozs7SUFtQjNDLEFBREYsQUFGRiwrQkFDd0YsY0FDbkQsZUFDUDtJQUN4Qix3QkFBb0U7SUFBQSxZQUN0RTtJQUFBLGlCQUFPO0lBRUwsQUFERixnQ0FBbUIsWUFFeUI7SUFBeEMseU1BQVMsdUNBQTZCLEtBQUM7SUFJL0MsQUFGRSxBQURFLEFBRDRDLGlCQUFJLEVBQ3pDLEVBQ0gsRUFFRjs7O0lBWEosMENBQXlCO0lBRytDLGVBQ3RFO0lBRHNFLGdEQUN0RTs7OztJQWROLEFBREYsOEJBQTBELGdCQUNqQztJQUFBLHVCQUFPO0lBQUEsaUJBQVE7SUFFcEMsQUFERiwrQkFBNkQsaUNBR0w7SUFBcEQsQUFGc0Isb05BQWlCLGdDQUF5QixLQUFDLCtNQUU1QyxvQ0FBNkIsS0FBQztJQUV2RCxBQURFLGlCQUF5QixFQUNyQjtJQUNOLCtCQUNvQztJQUFsQyxxTEFBVyw0QkFBcUIsS0FBQztJQUNqQywwRUFDd0Y7SUFZeEYsMEJBQStEO0lBRW5FLEFBREUsaUJBQU0sRUFDRjs7O0lBdEJrRSxlQUEwQjtJQUN6RSxBQUFuQixBQUQ2RixBQUEzQiwrQ0FBMEIsNEJBQTRCLG1CQUN0RyxvQ0FBNkI7SUFJakIsY0FBc0I7SUFBdEIsb0NBQXNCO0lBRTVCLGNBQStDO0lBQS9DLDJFQUErQzs7O0lBMEN6RSxBQURGLDJCQUE2QixnQkFDQTtJQUFBLHFDQUFxQjtJQUNsRCxBQURrRCxpQkFBUSxFQUNwRDs7O0lBQ04sMkJBQTRCO0lBQzFCLHNDQUFxRjtJQUN2RixpQkFBTTs7O0lBRHFDLGNBQXlCO0lBQXpCLDhDQUF5Qjs7O0lBS3hFLDhCQUFxQztJQUNuQyxzQ0FDa0I7SUFDcEIsaUJBQU07OztJQUZhLGNBQTBDO0lBQUMsQUFBM0MsK0RBQTBDLHlCQUFtQjs7QUR0RmxGLE1BQU0sT0FBTyxpQkFBa0IsU0FBUSwyQkFBMkI7SUFjaEUsWUFDRSxpQkFBb0MsRUFDcEMsYUFBNEIsRUFDcEIsb0JBQTBDLEVBQ2xELFdBQXdCLEVBQ2hCLGVBQWdDLEVBQ2hDLE1BQWMsRUFDdEIsY0FBOEIsRUFDdEIsaUJBQW9DO1FBRTVDLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxhQUFhLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFQaEQseUJBQW9CLEdBQXBCLG9CQUFvQixDQUFzQjtRQUUxQyxvQkFBZSxHQUFmLGVBQWUsQ0FBaUI7UUFDaEMsV0FBTSxHQUFOLE1BQU0sQ0FBUTtRQUVkLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBbUI7UUFuQjlDLFlBQU8sR0FBb0IsRUFBRSxDQUFDO1FBQzlCLG1CQUFjLEdBQW9CLEVBQUUsQ0FBQztRQUlyQyxtQkFBYyxHQUEwQixJQUFJLENBQUM7UUFDN0MsV0FBTSxHQUEwQixFQUFFLENBQUM7UUFDbkMsdUJBQWtCLEdBQVUsRUFBRSxDQUFDO1FBQ3ZCLGlCQUFZLEdBQVUsRUFBRSxDQUFDO1FBQ2pDLGlCQUFZLEdBQVksS0FBSyxDQUFDO1FBYTVCLElBQUksQ0FBQyxTQUFTLEdBQUcsV0FBVyxDQUFDLEtBQUssQ0FBQztZQUNqQyxXQUFXLEVBQUUsQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLFFBQVEsQ0FBQztZQUN6QyxNQUFNLEVBQUUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxDQUFDLFFBQVEsQ0FBQztZQUNuQyxZQUFZLEVBQUUsQ0FBQyxTQUFTLEVBQUUsVUFBVSxDQUFDLFFBQVEsQ0FBQztZQUM5QyxhQUFhLEVBQUUsSUFBSSxXQUFXLENBQUMsS0FBSyxDQUFDO1lBQ3JDLFNBQVMsRUFBRSxJQUFJLFdBQVcsQ0FBQyxLQUFLLENBQUM7WUFDakMsS0FBSyxFQUFFLElBQUksV0FBVyxDQUFDLEVBQUUsQ0FBQztZQUMxQixVQUFVLEVBQUUsQ0FBQyxJQUFJLENBQUM7U0FDbkIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDakUsQ0FBQztJQUVELFFBQVE7UUFDTixJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxhQUFhLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDLElBQUksQ0FDeEQsU0FBUyxDQUFDLENBQUMsT0FBd0IsRUFBRSxFQUFFO1lBQ3JDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1lBQ3ZCLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDeEIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FDdkQsU0FBUyxDQUFDLENBQUMsTUFBYyxFQUFFLEVBQUU7b0JBQzNCLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO29CQUNyQixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7Z0JBQzVDLENBQUMsQ0FBQyxDQUNILENBQUM7WUFDSixDQUFDO2lCQUFNLENBQUM7Z0JBQ04sT0FBTyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztZQUNqQyxDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQ0gsQ0FBQyxTQUFTLENBQUMsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDLENBQUM7SUFFNUQsQ0FBQztJQUVELGFBQWEsQ0FBQyxNQUFjO1FBQzFCLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7UUFDaEQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUMsTUFBYyxFQUFFLEVBQUU7WUFDNUQsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUM7WUFDN0IsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUNwRCxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDakIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3pDLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELFdBQVcsQ0FBQyxXQUErQjtRQUN6QyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7WUFDakIsT0FBTztRQUNULENBQUM7UUFDRCxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxLQUFLLEdBQUcsV0FBb0IsQ0FBQztJQUMvRCxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsTUFBZTtRQUM5QixJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUM7UUFDdkcsSUFBSSxXQUFXLEdBQW9CLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM1QyxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLE1BQU0sRUFBRSxDQUFDO1lBQzNDLFdBQVcsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLENBQ2pGLFNBQVMsQ0FBQyxDQUFDLE1BQWMsRUFBRSxFQUFFO2dCQUMzQixJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQztnQkFDN0IsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO2dCQUNqQixJQUFJLE1BQU0sRUFBRSxDQUFDO29CQUNYLElBQUksZUFBZSxHQUF5QixNQUFNLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEtBQVksRUFBRSxFQUFFO3dCQUNwRixJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDOzRCQUNqQixJQUFJLE1BQU0sR0FBRyxJQUFJLE1BQU0sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7NEJBQ3BDLE1BQU0sQ0FBQyxZQUFZLEdBQUc7Z0NBQ3BCLFFBQVEsRUFBRSxLQUFLLENBQUMsSUFBSTtnQ0FDcEIsTUFBTSxFQUFFLEtBQUssQ0FBQyxJQUFJOzZCQUNuQixDQUFDOzRCQUNGLE9BQU8sRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDO3dCQUNwQixDQUFDO3dCQUNELE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMvQyxDQUFDLENBQUMsQ0FBQztvQkFDSCxPQUFPLGFBQWEsQ0FBQyxlQUFlLENBQUMsQ0FBQyxJQUFJLENBQ3hDLEdBQUcsQ0FBQyxDQUFDLFFBQWtCLEVBQUUsRUFBRTt3QkFDekIsSUFBSSxDQUFDLGNBQWMsR0FBRyxRQUFRLENBQUM7d0JBQy9CLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQztvQkFDekMsQ0FBQyxDQUFDLENBQ0gsQ0FBQTtnQkFDSCxDQUFDO2dCQUNELE9BQU8sRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQ2xCLENBQUMsQ0FBQyxDQUNILENBQUM7UUFDSixDQUFDO1FBQ0QsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLFlBQVksSUFBSSxTQUFTLENBQUM7UUFDekcsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxLQUFLLEVBQUUsQ0FBQztRQUU1SixJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzFGLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxDQUFDO1FBQ3hGLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDNUYsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM5RSxJQUFJLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUN0QixJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDM0MsQ0FBQztRQUNELElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBYyxFQUFFLEVBQUU7WUFDNUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztZQUNwRCxJQUFJLEtBQUssRUFBRSxDQUFDO2dCQUNWLE1BQU0sa0JBQWtCLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxhQUE0QixFQUFFLEVBQUUsQ0FBQyxhQUFhLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFDO2dCQUNySixJQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEtBQUssa0JBQWtCLEVBQUUsSUFBSSxFQUFFLENBQUM7b0JBQ3RFLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsa0JBQWtCLEVBQUUsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDO2dCQUM1RSxDQUFDO1lBQ0gsQ0FBQztRQUNILENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUFvQixFQUFFLEVBQUU7WUFDN0UsSUFBSSxLQUFLLEtBQUssSUFBSSxFQUFFLENBQUM7Z0JBQ25CLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO1lBQ2xDLENBQUM7aUJBQU0sQ0FBQztnQkFDTixJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQzVCLENBQUM7UUFDSCxDQUFDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBMkIsRUFBRSxFQUFFO1lBQzFGLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7UUFDdkQsQ0FBQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEtBQVUsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQzlGLDBDQUEwQztRQUMxQyxPQUFPLFdBQVcsQ0FBQztJQUNyQixDQUFDO0lBSUQsa0JBQWtCLENBQUMsS0FBVTtRQUMzQixJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUM7SUFDdkUsQ0FBQztJQUVELGVBQWUsQ0FBQyxLQUFVO1FBQ3hCLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQztJQUNuRSxDQUFDO0lBRU8sU0FBUztRQUNmLElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxjQUFjLEVBQUUsYUFBYSxFQUFFLENBQUM7UUFDbEQsSUFBSSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztRQUN0QyxJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztRQUMxQixJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7SUFDcEIsQ0FBQztJQUVPLFVBQVU7UUFDaEIsSUFBSSxXQUFXLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLElBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUNqSCxNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1lBQzVFLE1BQU0sY0FBYyxHQUFHLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFjLEVBQUUsRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQzVFLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUM7WUFDN0MsY0FBYyxFQUFFLE9BQU8sQ0FBQyxDQUFDLE1BQWMsRUFBRSxFQUFFO2dCQUN6QyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLElBQUksVUFBVSxDQUFDO29CQUMzRCxJQUFJLEVBQUUsTUFBTSxDQUFDLEtBQUssSUFBSSxFQUFFO29CQUN4QixRQUFRLEVBQUUsS0FBSztvQkFDZixTQUFTLEVBQUUsSUFBSTtvQkFDZixNQUFNLEVBQUUsTUFBTTtpQkFDZixDQUFDLENBQUMsQ0FBQTtZQUNMLENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQztJQUNILENBQUM7SUFFTyxrQkFBa0I7UUFDeEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsY0FBZSxFQUFFLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxRQUFhLEVBQUUsRUFBRTtZQUNuRyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsUUFBYSxFQUFFLEVBQUU7Z0JBQ2pDLE1BQU0sWUFBWSxHQUFHLElBQUksY0FBYyxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLEVBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO2dCQUNwRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO2dCQUMzQyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUN2QyxDQUFDLENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxlQUFlLElBQUksRUFBRSxDQUFDO1FBQzFHLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUlELGFBQWEsQ0FBQyxLQUFtQjtRQUMvQixNQUFNLFVBQVUsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsZUFBZSxFQUFFO1lBQzVFLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUk7U0FDdEIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxVQUFVLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQztZQUNwQixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxlQUFnQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQzlFLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLGVBQWdCLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUN2RSxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxlQUFnQixDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsS0FBTSxFQUFFLENBQUMsRUFBRSxVQUFVLENBQUMsQ0FBQztRQUN2RixDQUFDO0lBQ0gsQ0FBQztJQUVELGlCQUFpQixDQUFDLEtBQTRCO1FBQzVDLElBQUksS0FBSyxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ25CLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLGVBQWUsRUFBRSxJQUFJLENBQUM7Z0JBQ3BELElBQUksRUFBRSxLQUFLLEVBQUUsT0FBTztnQkFDcEIsRUFBRSxFQUFFLEtBQUssRUFBRSxLQUFLO2FBQ2pCLENBQUMsQ0FBQztRQUNMLENBQUM7SUFDSCxDQUFDO0lBRUQsb0JBQW9CLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxlQUFlLEVBQUUsTUFBTSxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBRUQscUJBQXFCLENBQUMsTUFBYztRQUNsQyxFQUFFLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDLElBQUksQ0FDeEIsR0FBRyxDQUFDLENBQUMsS0FBdUIsRUFBRSxFQUFFO1lBQzlCLE1BQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUNqRixPQUFPLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFvQixFQUFFLEVBQUU7Z0JBQzNDLE9BQU8sR0FBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7WUFDekMsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDLENBQUMsRUFDRixHQUFHLENBQUMsQ0FBQyxLQUF1QixFQUFFLEVBQUU7WUFDOUIsT0FBTyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsSUFBb0IsRUFBRSxFQUFFO2dCQUMzQyxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxXQUFXLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQ3ZFLENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQyxDQUFDLENBQ0gsQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUF1QixFQUFFLEVBQUU7WUFDdEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztZQUNoQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDekMsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO2tIQXBPVSxpQkFBaUI7b0VBQWpCLGlCQUFpQjtZQ2xCMUIsQUFERixBQURGLDhCQUE2QixhQUNMLGFBQ0U7WUFDcEIsa0VBQTBEO1lBUTVELGlCQUFNO1lBQ04sa0VBQXNEO1lBV3hELGlCQUFNO1lBSUEsQUFERixBQURGLEFBREYsOEJBQXNCLGFBQ0UsYUFDSSxlQUNtQztZQUFBLDRCQUFZO1lBQUEsaUJBQVE7WUFFM0UsQUFERixrQ0FBNkUsaUJBQ25EO1lBQUEsZ0NBQWU7WUFBQSxpQkFBUztZQUNoRCxrQ0FBdUI7WUFBQSxvQ0FBbUI7WUFJbEQsQUFERSxBQURFLEFBREUsQUFENEMsaUJBQVMsRUFDNUMsRUFDTCxFQUNGLEVBQ0Y7WUFFTiwrQkFBc0I7WUFDcEIsb0VBQThEO1lBSWhFLGlCQUFNO1lBR04sK0JBQXNCO1lBQ3BCLG9FQUEwRDtZQTBCNUQsaUJBQU07WUFLRixBQURGLEFBREYsK0JBQXNCLGlCQUN1QixpQkFHRDtZQUF0QyxzR0FBVSw4QkFBMEIsSUFBQztZQUZ2QyxpQkFFd0M7WUFDeEMsaUNBQW9DO1lBQUEsK0JBQWM7WUFFdEQsQUFERSxBQURvRCxpQkFBTyxFQUNuRCxFQUNKO1lBS0YsQUFERixBQURGLCtCQUFzQixpQkFDb0IsaUJBRWdEO1lBQW5DLHNHQUFVLDJCQUF1QixJQUFDO1lBRHJGLGlCQUNzRjtZQUN0RixpQ0FBb0M7WUFBQSxrQ0FBaUI7WUFFekQsQUFERSxBQUR1RCxpQkFBTyxFQUN0RCxFQUNKO1lBS0YsQUFERixBQURGLCtCQUFzQixlQUNHLGlCQUNFO1lBQUEsd0JBQU87WUFBQSxpQkFBUTtZQUl0QyxBQUhBLHFFQUE2Qix3REFHRDtZQUloQyxBQURFLGlCQUFNLEVBQ0Y7WUFFTixxRUFBcUM7WUFLdkMsaUJBQU07O1lBOUdELHlDQUF1QjtZQUdHLGVBQStCO1lBQS9CLG9EQUErQjtZQVNuQyxjQUE2QjtZQUE3QixzREFBNkI7WUF5QjNCLGdCQUFtQztZQUFuQyx3REFBbUM7WUFRbkMsZUFBK0I7WUFBL0Isb0RBQStCO1lBZ0MzQixlQUFvRDtZQUFwRCxzRUFBb0Q7WUFVN0UsZUFBZ0Q7WUFBaEQsa0VBQWdEO1lBUzVDLGVBQXFCO1lBQXJCLDBDQUFxQjtZQUdyQixjQUFvQjtZQUFwQix5Q0FBb0I7WUFNUCxjQUFZO1lBQVosaUNBQVk7OztpRkRyRnhCLGlCQUFpQjtjQU43QixTQUFTOzJCQUNFLGNBQWMsbUJBR1AsdUJBQXVCLENBQUMsTUFBTTsyUEFJdEMsWUFBWTtrQkFBcEIsS0FBSzs7a0ZBRkssaUJBQWlCIiwic291cmNlc0NvbnRlbnQiOlsiLyogQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kICovXG5pbXBvcnQgeyBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneSwgQ2hhbmdlRGV0ZWN0b3JSZWYsIENvbXBvbmVudCwgSW5wdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEZvcm1CdWlsZGVyLCBGb3JtQ29udHJvbCwgRm9ybUdyb3VwLCBWYWxpZGF0b3JzIH0gZnJvbSAnQGFuZ3VsYXIvZm9ybXMnO1xuaW1wb3J0IHsgUm91dGVyIH0gZnJvbSAnQGFuZ3VsYXIvcm91dGVyJztcbmltcG9ydCB7IENvbERlZiB9IGZyb20gJ2FnLWdyaWQtY29tbXVuaXR5JztcbmltcG9ydCB7IHBsYWluVG9JbnN0YW5jZSB9IGZyb20gJ2NsYXNzLXRyYW5zZm9ybWVyJztcbmltcG9ydCBfLCB7IGlzVW5kZWZpbmVkIH0gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IGZpbmRJbmRleCB9IGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBEbmREcm9wRXZlbnQgfSBmcm9tICduZ3gtZHJhZy1kcm9wJztcbmltcG9ydCB7IE9ic2VydmFibGUsIGNvbWJpbmVMYXRlc3QsIGNvbmNhdE1hcCwgbWFwLCBvZiB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgRW50aXR5LCBFbnRpdHlTZXJ2aWNlLCBGaWVsZCwgRmlsdGVyR3JvdXAsIE1vZGVsTWV0YWRhdGEsIE1vZGVsTWV0YWRhdGFTZXJ2aWNlLCBQbGF5Ym9va1NlcnZpY2UsIFF1ZXJ5LCBTZWFyY2hhYmxlSXRlbSwgVXRpbGl0eVNlcnZpY2UgfSBmcm9tIFwic2hhcmVkXCI7XG5pbXBvcnQgeyBBYnN0cmFjdFdpZGdldEVkaXRDb21wb25lbnQgfSBmcm9tICdzaGFyZWQvdmlldy10ZW1wbGF0ZXMnO1xuaW1wb3J0IHsgR3JpZENvbmZpZyB9IGZyb20gJy4uL2dyaWQtY29uZmlnJztcbmltcG9ydCB7IEdyaWRDb2x1bW4sIEdyaWRDb2x1bW5TZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vc2VydmljZXMvZ3JpZC1jb2x1bW4uc2VydmljZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ3hmLWdyaWQtZWRpdCcsXG4gIHRlbXBsYXRlVXJsOiAnLi9ncmlkLWVkaXQuY29tcG9uZW50Lmh0bWwnLFxuICBzdHlsZVVybHM6IFsnLi9ncmlkLWVkaXQuY29tcG9uZW50LnNjc3MnXSxcbiAgY2hhbmdlRGV0ZWN0aW9uOiBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneS5PblB1c2hcbn0pXG5leHBvcnQgY2xhc3MgR3JpZEVkaXRDb21wb25lbnQgZXh0ZW5kcyBBYnN0cmFjdFdpZGdldEVkaXRDb21wb25lbnQge1xuXG4gIEBJbnB1dCgpIHdpZGdldENvbmZpZyE6IEdyaWRDb25maWc7XG4gIG1vZHVsZXM6IE1vZGVsTWV0YWRhdGFbXSA9IFtdO1xuICByZWxhdGVkTW9kdWxlczogTW9kZWxNZXRhZGF0YVtdID0gW107XG4gIHNlbGVjdGVkRW50aXR5PzogRW50aXR5O1xuICBmb3JtR3JvdXA6IEZvcm1Hcm91cDtcbiAgcXVlcnkhOiBRdWVyeTtcbiAgYWN0aW9uUGxheWJvb2s6IFNlYXJjaGFibGVJdGVtIHwgbnVsbCA9IG51bGw7XG4gIGZpZWxkczogUmVjb3JkPHN0cmluZywgRmllbGQ+ID0ge307XG4gIGFjdGlvblBsYXlib29rTGlzdDogYW55W10gPSBbXTtcbiAgcHJpdmF0ZSBhY3Rpb25QQkxpc3Q6IGFueVtdID0gW107XG4gIGlzRGV0YWlsUGFnZTogYm9vbGVhbiA9IGZhbHNlO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIGNoYW5nZURldGVjdG9yUmVmOiBDaGFuZ2VEZXRlY3RvclJlZixcbiAgICBlbnRpdHlTZXJ2aWNlOiBFbnRpdHlTZXJ2aWNlLFxuICAgIHByaXZhdGUgbW9kZWxNZXRhZGF0YVNlcnZpY2U6IE1vZGVsTWV0YWRhdGFTZXJ2aWNlLFxuICAgIGZvcm1CdWlsZGVyOiBGb3JtQnVpbGRlcixcbiAgICBwcml2YXRlIHBsYXlib29rU2VydmljZTogUGxheWJvb2tTZXJ2aWNlLFxuICAgIHByaXZhdGUgcm91dGVyOiBSb3V0ZXIsXG4gICAgdXRpbGl0eVNlcnZpY2U6IFV0aWxpdHlTZXJ2aWNlLFxuICAgIHByaXZhdGUgZ3JpZENvbHVtblNlcnZpY2U6IEdyaWRDb2x1bW5TZXJ2aWNlXG4gICkge1xuICAgIHN1cGVyKGNoYW5nZURldGVjdG9yUmVmLCBlbnRpdHlTZXJ2aWNlLCB1dGlsaXR5U2VydmljZSk7XG4gICAgdGhpcy5mb3JtR3JvdXAgPSBmb3JtQnVpbGRlci5ncm91cCh7XG4gICAgICBvbmx5UmVsYXRlZDogW2ZhbHNlLCBWYWxpZGF0b3JzLnJlcXVpcmVkXSxcbiAgICAgIG1vZHVsZTogW251bGwsIFZhbGlkYXRvcnMucmVxdWlyZWRdLFxuICAgICAgb25DbGlja1N0YXRlOiBbJ3ByZXZpZXcnLCBWYWxpZGF0b3JzLnJlcXVpcmVkXSxcbiAgICAgIHJvd0V4cGFuZGFibGU6IG5ldyBGb3JtQ29udHJvbChmYWxzZSksXG4gICAgICBsaWdodE1vZGU6IG5ldyBGb3JtQ29udHJvbChmYWxzZSksXG4gICAgICBxdWVyeTogbmV3IEZvcm1Db250cm9sKHt9KSxcbiAgICAgIGdyaWRDb25maWc6IFtudWxsXVxuICAgIH0pO1xuICAgIHRoaXMuaXNEZXRhaWxQYWdlID0gdGhpcy5yb3V0ZXIudXJsLmluZGV4T2YoJy9tb2R1bGUvJykgIT09IC0xO1xuICB9XG5cbiAgbmdPbkluaXQoKTogdm9pZCB7XG4gICAgdGhpcy5mb3JtR3JvdXAuY29udHJvbHMuZ3JpZENvbmZpZy5zZXRWYWx1ZSh0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmNvbHVtbnMpO1xuICAgIHRoaXMubW9kZWxNZXRhZGF0YVNlcnZpY2UuZ2V0TW9kdWxlTGlzdChmYWxzZSwgZmFsc2UpLnBpcGUoXG4gICAgICBjb25jYXRNYXAoKG1vZHVsZXM6IE1vZGVsTWV0YWRhdGFbXSkgPT4ge1xuICAgICAgICB0aGlzLm1vZHVsZXMgPSBtb2R1bGVzO1xuICAgICAgICBpZiAodGhpcy5jb250ZXh0Lm1vZHVsZSkge1xuICAgICAgICAgIHJldHVybiB0aGlzLmVudGl0eVNlcnZpY2UuYnVpbGQodGhpcy5jb250ZXh0Lm1vZHVsZSkucGlwZShcbiAgICAgICAgICAgIGNvbmNhdE1hcCgoZW50aXR5OiBFbnRpdHkpID0+IHtcbiAgICAgICAgICAgICAgdGhpcy5lbnRpdHkgPSBlbnRpdHk7XG4gICAgICAgICAgICAgIHJldHVybiB0aGlzLmluaXRXaWRnZXRDb25maWcodGhpcy5lbnRpdHkpO1xuICAgICAgICAgICAgfSlcbiAgICAgICAgICApO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHJldHVybiB0aGlzLmluaXRXaWRnZXRDb25maWcoKTtcbiAgICAgICAgfVxuICAgICAgfSlcbiAgICApLnN1YnNjcmliZSgoKSA9PiB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKSk7XG5cbiAgfVxuXG4gIG1vZHVsZUNoYW5nZWQobW9kdWxlOiBzdHJpbmcpIHtcbiAgICB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLm1vZHVsZSA9IG1vZHVsZTtcbiAgICB0aGlzLmVudGl0eVNlcnZpY2UuYnVpbGQobW9kdWxlKS5zdWJzY3JpYmUoKGVudGl0eTogRW50aXR5KSA9PiB7XG4gICAgICB0aGlzLnNlbGVjdGVkRW50aXR5ID0gZW50aXR5O1xuICAgICAgdGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5jb2x1bW5zID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5zZXRGaWVsZHMoKTtcbiAgICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3JSZWYuZGV0ZWN0Q2hhbmdlcygpO1xuICAgIH0pO1xuICB9XG5cbiAgcXVlcnlDaGFuZ2UoZmlsdGVyR3JvdXA6IEZpbHRlckdyb3VwIHwgbnVsbCkge1xuICAgIGlmICghZmlsdGVyR3JvdXApIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgdGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5xdWVyeSA9IGZpbHRlckdyb3VwIGFzIFF1ZXJ5O1xuICB9XG5cbiAgaW5pdFdpZGdldENvbmZpZyhlbnRpdHk/OiBFbnRpdHkpOiBPYnNlcnZhYmxlPGFueT4ge1xuICAgIHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24ubW9kdWxlID0gZW50aXR5ID8gZW50aXR5LnR5cGUgOiB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLm1vZHVsZTtcbiAgICBsZXQgb2JzZXJ2YWJsZSQ6IE9ic2VydmFibGU8YW55PiA9IG9mKG51bGwpO1xuICAgIGlmICh0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLm1vZHVsZSkge1xuICAgICAgb2JzZXJ2YWJsZSQgPSB0aGlzLmVudGl0eVNlcnZpY2UuYnVpbGQodGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5tb2R1bGUpLnBpcGUoXG4gICAgICAgIGNvbmNhdE1hcCgoZW50aXR5OiBFbnRpdHkpID0+IHtcbiAgICAgICAgICB0aGlzLnNlbGVjdGVkRW50aXR5ID0gZW50aXR5O1xuICAgICAgICAgIHRoaXMuc2V0RmllbGRzKCk7XG4gICAgICAgICAgaWYgKGVudGl0eSkge1xuICAgICAgICAgICAgbGV0IHJlbGF0ZWRNb2R1bGVzJDogT2JzZXJ2YWJsZTxFbnRpdHk+W10gPSBlbnRpdHkucmVsYXRpb25zaGlwcy5tYXAoKGZpZWxkOiBGaWVsZCkgPT4ge1xuICAgICAgICAgICAgICBpZiAoIWZpZWxkLm1vZGVsKSB7XG4gICAgICAgICAgICAgICAgbGV0IGVudGl0eSA9IG5ldyBFbnRpdHkoZmllbGQubmFtZSk7XG4gICAgICAgICAgICAgICAgZW50aXR5LmRlc2NyaXB0aW9ucyA9IHtcbiAgICAgICAgICAgICAgICAgIHNpbmd1bGFyOiBmaWVsZC5uYW1lLFxuICAgICAgICAgICAgICAgICAgcGx1cmFsOiBmaWVsZC5uYW1lXG4gICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgICAgICByZXR1cm4gb2YoZW50aXR5KTtcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICByZXR1cm4gdGhpcy5lbnRpdHlTZXJ2aWNlLmJ1aWxkKGZpZWxkLm1vZGVsKTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgcmV0dXJuIGNvbWJpbmVMYXRlc3QocmVsYXRlZE1vZHVsZXMkKS5waXBlKFxuICAgICAgICAgICAgICBtYXAoKGVudGl0aWVzOiBFbnRpdHlbXSkgPT4ge1xuICAgICAgICAgICAgICAgIHRoaXMucmVsYXRlZE1vZHVsZXMgPSBlbnRpdGllcztcbiAgICAgICAgICAgICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIClcbiAgICAgICAgICB9XG4gICAgICAgICAgcmV0dXJuIG9mKG51bGwpO1xuICAgICAgICB9KVxuICAgICAgKTtcbiAgICB9XG4gICAgdGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5vbkNsaWNrU3RhdGUgPSB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLm9uQ2xpY2tTdGF0ZSB8fCAncHJldmlldyc7XG4gICAgdGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5xdWVyeSA9IHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24ucXVlcnkgPyBwbGFpblRvSW5zdGFuY2UoUXVlcnksIHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24ucXVlcnkpIDogbmV3IFF1ZXJ5KCk7XG5cbiAgICB0aGlzLmZvcm1Hcm91cC5jb250cm9scy5vbmx5UmVsYXRlZC5zZXRWYWx1ZSh0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLm9ubHlSZWxhdGVkKTtcbiAgICB0aGlzLmZvcm1Hcm91cC5jb250cm9scy5tb2R1bGUuc2V0VmFsdWUodGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5tb2R1bGUgfHwgbnVsbCk7XG4gICAgdGhpcy5mb3JtR3JvdXAuY29udHJvbHMub25DbGlja1N0YXRlLnNldFZhbHVlKHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24ub25DbGlja1N0YXRlKTtcbiAgICB0aGlzLmZvcm1Hcm91cC5jb250cm9scy5xdWVyeS5zZXRWYWx1ZSh0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLnF1ZXJ5KTtcbiAgICBpZiAodGhpcy5pc0RldGFpbFBhZ2UpIHtcbiAgICAgIHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLm1vZHVsZS5kaXNhYmxlKCk7XG4gICAgfVxuICAgIHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLm9ubHlSZWxhdGVkLnZhbHVlQ2hhbmdlcy5zdWJzY3JpYmUoKHZhbHVlOiBib29sZWFuKSA9PiB7XG4gICAgICB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLm9ubHlSZWxhdGVkID0gdmFsdWU7XG4gICAgICBpZiAodmFsdWUpIHtcbiAgICAgICAgY29uc3QgZm91bmRSZWxhdGVkTW9kdWxlID0gdGhpcy5yZWxhdGVkTW9kdWxlcy5maW5kKChyZWxhdGVkTW9kdWxlOiBNb2RlbE1ldGFkYXRhKSA9PiByZWxhdGVkTW9kdWxlLnR5cGUgPT09IHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24ubW9kdWxlKTtcbiAgICAgICAgaWYgKHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLm1vZHVsZS52YWx1ZSAhPT0gZm91bmRSZWxhdGVkTW9kdWxlPy50eXBlKSB7XG4gICAgICAgICAgdGhpcy5mb3JtR3JvdXAuY29udHJvbHMubW9kdWxlLnNldFZhbHVlKGZvdW5kUmVsYXRlZE1vZHVsZT8udHlwZSB8fCBudWxsKTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pO1xuICAgIHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLm1vZHVsZS52YWx1ZUNoYW5nZXMuc3Vic2NyaWJlKCh2YWx1ZTogc3RyaW5nIHwgbnVsbCkgPT4ge1xuICAgICAgaWYgKHZhbHVlID09PSBudWxsKSB7XG4gICAgICAgIHRoaXMuc2VsZWN0ZWRFbnRpdHkgPSB1bmRlZmluZWQ7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLm1vZHVsZUNoYW5nZWQodmFsdWUpO1xuICAgICAgfVxuICAgIH0pO1xuXG4gICAgdGhpcy5mb3JtR3JvdXAuY29udHJvbHMub25DbGlja1N0YXRlLnZhbHVlQ2hhbmdlcy5zdWJzY3JpYmUoKHZhbHVlOiAnbW9kdWxlJyB8ICdwcmV2aWV3JykgPT4ge1xuICAgICAgdGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5vbkNsaWNrU3RhdGUgPSB2YWx1ZTtcbiAgICB9KTtcbiAgICB0aGlzLmZvcm1Hcm91cC5jb250cm9scy5xdWVyeS52YWx1ZUNoYW5nZXMuc3Vic2NyaWJlKCh2YWx1ZTogYW55KSA9PiB0aGlzLnF1ZXJ5Q2hhbmdlKHZhbHVlKSk7XG4gICAgLy8gdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgcmV0dXJuIG9ic2VydmFibGUkO1xuICB9XG5cblxuXG4gIHJvd0V4cGFuc2lvbkNoYW5nZShldmVudDogYW55KSB7XG4gICAgdGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5yb3dFeHBhbmRhYmxlID0gZXZlbnQudGFyZ2V0LmNoZWNrZWQ7XG4gIH1cblxuICBsaWdodE1vZGVDaGFuZ2UoZXZlbnQ6IGFueSkge1xuICAgIHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24ubGlnaHRNb2RlID0gZXZlbnQudGFyZ2V0LmNoZWNrZWQ7XG4gIH1cblxuICBwcml2YXRlIHNldEZpZWxkcygpIHtcbiAgICBsZXQgZmllbGRzID0gdGhpcy5zZWxlY3RlZEVudGl0eT8uZ2V0Rm9ybUZpZWxkcygpO1xuICAgIHRoaXMuZmllbGRzID0gXy5rZXlCeShmaWVsZHMsICduYW1lJyk7XG4gICAgdGhpcy5nZXRBY3Rpb25QbGF5Ym9va3MoKTtcbiAgICB0aGlzLnNldENvbHVtbnMoKTtcbiAgfVxuXG4gIHByaXZhdGUgc2V0Q29sdW1ucygpIHtcbiAgICBpZiAoaXNVbmRlZmluZWQodGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5jb2x1bW5zKSB8fCB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmNvbHVtbnMubGVuZ3RoID09PSAwKSB7XG4gICAgICBjb25zdCBncmlkQ29sdW1ucyA9IHRoaXMuZ3JpZENvbHVtblNlcnZpY2UuY3JlYXRlKHRoaXMuZmllbGRzLCBuZXcgUXVlcnkoKSk7XG4gICAgICBjb25zdCB2aXNpYmxlQ29sdW1ucyA9IGdyaWRDb2x1bW5zLmZpbHRlcigoY29sdW1uOiBDb2xEZWYpID0+ICFjb2x1bW4uaGlkZSk7XG4gICAgICB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmNvbHVtbnMgPSBbXTtcbiAgICAgIHZpc2libGVDb2x1bW5zPy5mb3JFYWNoKChjb2x1bW46IENvbERlZikgPT4ge1xuICAgICAgICB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmNvbHVtbnM/LnB1c2gobmV3IEdyaWRDb2x1bW4oe1xuICAgICAgICAgIG5hbWU6IGNvbHVtbi5maWVsZCB8fCAnJyxcbiAgICAgICAgICBlZGl0YWJsZTogZmFsc2UsXG4gICAgICAgICAgcmVzaXphYmxlOiB0cnVlLFxuICAgICAgICAgIHN0aWNreTogJ05PTkUnXG4gICAgICAgIH0pKVxuICAgICAgfSk7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBnZXRBY3Rpb25QbGF5Ym9va3MoKSB7XG4gICAgdGhpcy5wbGF5Ym9va1NlcnZpY2UuZ2V0QWN0aW9uUGxheWJvb2tzKHRoaXMuc2VsZWN0ZWRFbnRpdHkhLCBmYWxzZSwgW10pLnN1YnNjcmliZSgocmVzcG9uc2U6IGFueSkgPT4ge1xuICAgICAgcmVzcG9uc2UuZm9yRWFjaCgocGxheWJvb2s6IGFueSkgPT4ge1xuICAgICAgICBjb25zdCBzZWFyY2hhYmxlUEIgPSBuZXcgU2VhcmNoYWJsZUl0ZW0ocGxheWJvb2suYWN0aW9uVHJpZ2dlck5hbWUsIHBsYXlib29rWydAaWQnXSwgcGxheWJvb2sudXVpZCk7XG4gICAgICAgIHRoaXMuYWN0aW9uUGxheWJvb2tMaXN0LnB1c2goc2VhcmNoYWJsZVBCKTtcbiAgICAgICAgdGhpcy5hY3Rpb25QQkxpc3QucHVzaChzZWFyY2hhYmxlUEIpO1xuICAgICAgfSk7XG4gICAgICB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmFjdGlvblBsYXlib29rcyA9IHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24uYWN0aW9uUGxheWJvb2tzIHx8IFtdO1xuICAgIH0pO1xuICB9XG5cblxuXG4gIG9uQWN0aW9uc0Ryb3AoZXZlbnQ6IERuZERyb3BFdmVudCkge1xuICAgIGNvbnN0IGZvdW5kSW5kZXggPSBmaW5kSW5kZXgodGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5hY3Rpb25QbGF5Ym9va3MsIHtcbiAgICAgIG5hbWU6IGV2ZW50LmRhdGEubmFtZVxuICAgIH0pO1xuXG4gICAgaWYgKGZvdW5kSW5kZXggPiAtMSkge1xuICAgICAgbGV0IGRyYWdDb2x1bW4gPSB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmFjdGlvblBsYXlib29rcyFbZm91bmRJbmRleF07XG4gICAgICB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmFjdGlvblBsYXlib29rcyEuc3BsaWNlKGZvdW5kSW5kZXgsIDEpO1xuICAgICAgdGhpcy53aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5hY3Rpb25QbGF5Ym9va3MhLnNwbGljZShldmVudC5pbmRleCEsIDAsIGRyYWdDb2x1bW4pO1xuICAgIH1cbiAgfVxuXG4gIGFkZEFjdGlvblBsYXlib29rKGV2ZW50OiBTZWFyY2hhYmxlSXRlbSB8IG51bGwpIHtcbiAgICBpZiAoZXZlbnQgIT09IG51bGwpIHtcbiAgICAgIHRoaXMud2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24uYWN0aW9uUGxheWJvb2tzPy5wdXNoKHtcbiAgICAgICAgbmFtZTogZXZlbnQ/LmRpc3BsYXksXG4gICAgICAgIGlkOiBldmVudD8udmFsdWVcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxuXG4gIHJlbW92ZUFjdGlvblBsYXlib29rKGluZGV4OiBudW1iZXIpIHtcbiAgICB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmFjdGlvblBsYXlib29rcz8uc3BsaWNlKGluZGV4LCAxKTtcbiAgfVxuXG4gIGZpbHRlckFjdGlvblBsYXlib29rcyhzZWFyY2g6IHN0cmluZykge1xuICAgIG9mKHRoaXMuYWN0aW9uUEJMaXN0KS5waXBlKFxuICAgICAgbWFwKChpdGVtczogU2VhcmNoYWJsZUl0ZW1bXSkgPT4ge1xuICAgICAgICBjb25zdCBwYnMgPSB0aGlzLndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmFjdGlvblBsYXlib29rcz8ubWFwKCh7IGlkIH0pID0+IGlkKTtcbiAgICAgICAgcmV0dXJuIGl0ZW1zLmZpbHRlcigoaXRlbTogU2VhcmNoYWJsZUl0ZW0pID0+IHtcbiAgICAgICAgICByZXR1cm4gcGJzIS5pbmRleE9mKGl0ZW0udmFsdWUpID09PSAtMTtcbiAgICAgICAgfSk7XG4gICAgICB9KSxcbiAgICAgIG1hcCgoaXRlbXM6IFNlYXJjaGFibGVJdGVtW10pID0+IHtcbiAgICAgICAgcmV0dXJuIGl0ZW1zLmZpbHRlcigoaXRlbTogU2VhcmNoYWJsZUl0ZW0pID0+IHtcbiAgICAgICAgICByZXR1cm4gaXRlbS5kaXNwbGF5LnRvTG93ZXJDYXNlKCkuaW5kZXhPZihzZWFyY2gudG9Mb3dlckNhc2UoKSkgPiAtMTtcbiAgICAgICAgfSk7XG4gICAgICB9KVxuICAgICkuc3Vic2NyaWJlKChpdGVtczogU2VhcmNoYWJsZUl0ZW1bXSkgPT4ge1xuICAgICAgdGhpcy5hY3Rpb25QbGF5Ym9va0xpc3QgPSBpdGVtcztcbiAgICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3JSZWYuZGV0ZWN0Q2hhbmdlcygpO1xuICAgIH0pO1xuICB9XG5cbn1cbiIsIjwhLS0gQ29weXJpZ2h0IHN0YXJ0XG4gIENvcHlyaWdodCAoQykgMjAwOCAtIDIwMjUgRm9ydGluZXQgSW5jLlxuICBBbGwgcmlnaHRzIHJlc2VydmVkLlxuICBGT1JUSU5FVCBDT05GSURFTlRJQUwgJiBGT1JUSU5FVCBQUk9QUklFVEFSWSBTT1VSQ0UgQ09ERVxuICBDb3B5cmlnaHQgZW5kIC0tPlxuPGRpdiBbZm9ybUdyb3VwXT1cImZvcm1Hcm91cFwiPlxuICA8ZGl2IGNsYXNzPVwicm93IG10LTNcIj5cbiAgICA8ZGl2IGNsYXNzPVwiY29sLW1kLTZcIj5cbiAgICAgIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCIgKm5nSWY9XCJmb3JtR3JvdXAuY29udHJvbHMubW9kdWxlXCI+XG4gICAgICAgIDxsYWJlbCBjbGFzcz1cImZ3LWJvbGRcIj5EYXRhIFNvdXJjZTwvbGFiZWw+XG4gICAgICAgIDxzZWxlY3QgY2xhc3M9XCJmb3JtLXNlbGVjdFwiIGZvcm1Db250cm9sTmFtZT1cIm1vZHVsZVwiPlxuICAgICAgICAgIDxvcHRpb24gW25nVmFsdWVdPVwibnVsbFwiPlNlbGVjdCBhIG1vZHVsZTwvb3B0aW9uPlxuICAgICAgICAgIDxvcHRpb24gKm5nRm9yPVwibGV0IG1vZHVsZSBvZiAoZm9ybUdyb3VwLmNvbnRyb2xzLm9ubHlSZWxhdGVkLnZhbHVlID8gcmVsYXRlZE1vZHVsZXMgOiBtb2R1bGVzKVwiXG4gICAgICAgICAgICBbdmFsdWVdPVwibW9kdWxlLnR5cGVcIj57eyBtb2R1bGUuZGVzY3JpcHRpb25zLnBsdXJhbCB9fTwvb3B0aW9uPlxuICAgICAgICA8L3NlbGVjdD5cbiAgICAgIDwvZGl2PlxuICAgIDwvZGl2PlxuICAgIDxkaXYgY2xhc3M9XCJjb2wtbWQtNlwiICpuZ0lmPVwiZW50aXR5ICYmICFpc0RldGFpbFBhZ2VcIj5cbiAgICAgIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCIgKm5nSWY9XCJmb3JtR3JvdXAuY29udHJvbHMub25seVJlbGF0ZWRcIj5cbiAgICAgICAgPGxhYmVsIGNsYXNzPVwiZnctYm9sZFwiIGZvcj1cIm9ubHlSZWxhdGVkXCI+XG4gICAgICAgICAgUmVjb3JkcyB0byBJbmNsdWRlXG4gICAgICAgIDwvbGFiZWw+XG4gICAgICAgIDxzZWxlY3QgY2xhc3M9XCJmb3JtLXNlbGVjdFwiIGZvcm1Db250cm9sTmFtZT1cIm9ubHlSZWxhdGVkXCI+XG4gICAgICAgICAgPG9wdGlvbiBbbmdWYWx1ZV09XCJ0cnVlXCI+UmVsYXRlZCBSZWNvcmRzPC9vcHRpb24+XG4gICAgICAgICAgPG9wdGlvbiBbbmdWYWx1ZV09XCJmYWxzZVwiPkFsbCBSZWNvcmRzPC9vcHRpb24+XG4gICAgICAgIDwvc2VsZWN0PlxuICAgICAgPC9kaXY+XG4gICAgPC9kaXY+XG4gIDwvZGl2PlxuICA8ZGl2IGNsYXNzPVwicm93IG10LTNcIj5cbiAgICA8ZGl2IGNsYXNzPVwiY29sLW1kLTZcIj5cbiAgICAgIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCI+XG4gICAgICAgIDxsYWJlbCBmb3I9XCJvbkNsaWNrU3RhdGVcIiBjbGFzcz1cImZ3LWJvbGQgY29sLWZvcm0tbGFiZWxcIj5DbGljayBBY3Rpb248L2xhYmVsPlxuICAgICAgICA8c2VsZWN0IGNsYXNzPVwiZm9ybS1zZWxlY3RcIiBmb3JtQ29udHJvbE5hbWU9XCJvbkNsaWNrU3RhdGVcIiBpZD1cIm9uQ2xpY2tTdGF0ZVwiPlxuICAgICAgICAgIDxvcHRpb24gdmFsdWU9XCJwcmV2aWV3XCI+T3BlbiBpbiBQcmV2aWV3PC9vcHRpb24+XG4gICAgICAgICAgPG9wdGlvbiB2YWx1ZT1cIm1vZHVsZVwiPk9wZW4gaW4gRGV0YWlsIFZpZXc8L29wdGlvbj5cbiAgICAgICAgPC9zZWxlY3Q+XG4gICAgICA8L2Rpdj5cbiAgICA8L2Rpdj5cbiAgPC9kaXY+XG4gIDwhLS0gU2VsZWN0IGZpZWxkcyAtLT5cbiAgPGRpdiBjbGFzcz1cInJvdyBtdC0zXCI+XG4gICAgPGRpdiBjbGFzcz1cImZvcm0tZ3JvdXBcIiAqbmdJZj1cImZvcm1Hcm91cC5jb250cm9scy5ncmlkQ29uZmlnXCI+XG4gICAgICA8bGFiZWwgY2xhc3M9XCJmdy1ib2xkXCI+U2VsZWN0IENvbHVtbnM8L2xhYmVsPlxuICAgICAgPHhmLWdyaWQtY29sdW1ucy1lZGl0b3IgW2VudGl0eV09XCJzZWxlY3RlZEVudGl0eVwiIGZvcm1Db250cm9sTmFtZT1cImdyaWRDb25maWdcIj48L3hmLWdyaWQtY29sdW1ucy1lZGl0b3I+XG4gICAgPC9kaXY+XG4gIDwvZGl2PlxuXG4gIDwhLS0gU2VsZWN0IEFjdGlvbiBQbGF5Ym9va3MgLS0+XG4gIDxkaXYgY2xhc3M9XCJyb3cgbXQtM1wiPlxuICAgIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCIgKm5nSWY9XCJmb3JtR3JvdXAuY29udHJvbHMubW9kdWxlXCI+XG4gICAgICA8bGFiZWwgY2xhc3M9XCJmdy1ib2xkXCI+QWN0aW9uczwvbGFiZWw+XG4gICAgICA8ZGl2IGNsYXNzPVwiZC1mbGV4IGZsZXgtcm93IGp1c3RpZnktY29udGVudC1sZWZ0IGdhcC0yIG10LTJcIj5cbiAgICAgICAgPHhmLXNlYXJjaGFibGUtZHJvcGRvd24gKG5nTW9kZWxDaGFuZ2UpPVwiYWRkQWN0aW9uUGxheWJvb2soJGV2ZW50KVwiIFtuZ01vZGVsXT1cImFjdGlvblBsYXlib29rXCIgW2NsZWFyVmFsdWVPblNlbGVjdF09XCJ0cnVlXCJcbiAgICAgICAgICBbcmVxdWlyZWRdPVwiZmFsc2VcIiBbaXRlbXNdPVwiYWN0aW9uUGxheWJvb2tMaXN0XCIgcGxhY2Vob2xkZXI9XCIrIFNlbGVjdCBhIE1hbnVhbCBUcmlnZ2VyIFBsYXlib29rXCJcbiAgICAgICAgICAoc2VhcmNoUXVlcnlDaGFuZ2UpPVwiZmlsdGVyQWN0aW9uUGxheWJvb2tzKCRldmVudClcIj5cbiAgICAgICAgPC94Zi1zZWFyY2hhYmxlLWRyb3Bkb3duPlxuICAgICAgPC9kaXY+XG4gICAgICA8ZGl2IGNsYXNzPVwiY29sIHBiLTJcIiBkbmREcm9wem9uZSBbZG5kSG9yaXpvbnRhbF09XCJ0cnVlXCIgZG5kRWZmZWN0QWxsb3dlZD1cImNvcHlNb3ZlXCJcbiAgICAgICAgKGRuZERyb3ApPVwib25BY3Rpb25zRHJvcCgkZXZlbnQpXCI+XG4gICAgICAgIDxkaXYgKm5nRm9yPVwibGV0IHBsYXlib29rIG9mIHdpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLmFjdGlvblBsYXlib29rczsgbGV0IHBiSW5kZXggPSBpbmRleFwiXG4gICAgICAgICAgW2RuZERyYWdnYWJsZV09XCJwbGF5Ym9va1wiIGRuZEVmZmVjdEFsbG93ZWQ9XCJtb3ZlXCIgY2xhc3M9XCJjYXJkIGQtaW5saW5lLWJsb2NrIHAtMiBtLTJcIj5cbiAgICAgICAgICA8ZGl2IGNsYXNzPVwiY2FyZC10aXRsZSBtLTAgZC1mbGV4XCI+XG4gICAgICAgICAgICA8c3BhbiBjbGFzcz1cImZsZXgtZ3Jvdy0xXCI+XG4gICAgICAgICAgICAgIDxpIGNsYXNzPVwiY3Vyc29yLW1vdmUgZmEgZmEtYXJyb3dzLWFsdCBmYS1saWdodCBtZS0yXCIgZG5kSGFuZGxlPjwvaT57eyBwbGF5Ym9vay5uYW1lIH19XG4gICAgICAgICAgICA8L3NwYW4+XG4gICAgICAgICAgICA8c3BhbiBjbGFzcz1cIm1zLTNcIj5cbiAgICAgICAgICAgICAgPGkgY2xhc3M9XCJmYSBmYS1saWdodCBmYS1jbG9zZSBtYXJnaW4tdG9wLTRweCB0ZXh0LWRhbmdlciBtcy0zXCIgcm9sZT1cImJ1dHRvblwiXG4gICAgICAgICAgICAgICAgKGNsaWNrKT1cInJlbW92ZUFjdGlvblBsYXlib29rKHBiSW5kZXgpXCI+PC9pPlxuICAgICAgICAgICAgPC9zcGFuPlxuICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8ZGl2IGNsYXNzPVwiY2FyZCBkbmQtcGxhY2Vob2xkZXIgbXQtMlwiIGRuZFBsYWNlaG9sZGVyUmVmPjwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgPC9kaXY+XG4gIDwvZGl2PlxuXG4gIDwhLS0gUm93IGV4cGFuc2lvbiAtLT5cbiAgPGRpdiBjbGFzcz1cInJvdyBtdC0zXCI+XG4gICAgPGxhYmVsIGZvcj1cInJvdy1leHBhbnNpb25cIiBjbGFzcz1cImZ3LWJvbGRcIj5cbiAgICAgIDxpbnB1dCB0eXBlPVwiY2hlY2tib3hcIiBuYW1lPVwicm93LWV4cGFuc2lvblwiIGlkPVwicm93LWV4cGFuc2lvblwiIGZvcm1jb250cm9sbmFtZT1cInJvd0V4cGFuZGFibGVcIlxuICAgICAgICBjbGFzcz1cImZvcm0tY2hlY2staW5wdXRcIiBbY2hlY2tlZF09XCJ3aWRnZXRDb25maWcuY29uZmlndXJhdGlvbi5yb3dFeHBhbmRhYmxlXCJcbiAgICAgICAgKGNoYW5nZSk9XCJyb3dFeHBhbnNpb25DaGFuZ2UoJGV2ZW50KVwiPlxuICAgICAgPHNwYW4gY2xhc3M9XCJmb3JtLWNoZWNrLWxhYmVsIHBzLTJcIj5Sb3cgRXhwYW5kYWJsZTwvc3Bhbj5cbiAgICA8L2xhYmVsPlxuICA8L2Rpdj5cblxuICA8IS0tICBMaWdodCBNb2RlIC0tPlxuICA8ZGl2IGNsYXNzPVwicm93IG10LTNcIj5cbiAgICA8bGFiZWwgZm9yPVwibGlnaHQtbW9kZVwiIGNsYXNzPVwiZnctYm9sZFwiPlxuICAgICAgPGlucHV0IHR5cGU9XCJjaGVja2JveFwiIG5hbWU9XCJsaWdodC1tb2RlXCIgaWQ9XCJsaWdodC1tb2RlXCIgZm9ybWNvbnRyb2xuYW1lPVwibGlnaHRNb2RlXCIgY2xhc3M9XCJmb3JtLWNoZWNrLWlucHV0XCJcbiAgICAgICAgW2NoZWNrZWRdPVwid2lkZ2V0Q29uZmlnLmNvbmZpZ3VyYXRpb24ubGlnaHRNb2RlXCIgKGNoYW5nZSk9XCJsaWdodE1vZGVDaGFuZ2UoJGV2ZW50KVwiPlxuICAgICAgPHNwYW4gY2xhc3M9XCJmb3JtLWNoZWNrLWxhYmVsIHBzLTJcIj5FbmFibGUgbGlnaHQgbW9kZTwvc3Bhbj5cbiAgICA8L2xhYmVsPlxuICA8L2Rpdj5cblxuICA8IS0tIEZpbHRlcnMgLS0+XG4gIDxkaXYgY2xhc3M9XCJyb3cgbXQtM1wiPlxuICAgIDxkaXYgY2xhc3M9XCJjb2wtbWQtMTJcIj5cbiAgICAgIDxsYWJlbCBjbGFzcz1cImZ3LWJvbGRcIj5GaWx0ZXJzPC9sYWJlbD5cbiAgICAgIDxkaXYgKm5nSWY9XCIhc2VsZWN0ZWRFbnRpdHlcIj5cbiAgICAgICAgPHNtYWxsIGNsYXNzPVwiZm9udC1pdGFsaWNcIj5TZWxlY3QgYSBtb2R1bGUgYWJvdmU8L3NtYWxsPlxuICAgICAgPC9kaXY+XG4gICAgICA8ZGl2ICpuZ0lmPVwic2VsZWN0ZWRFbnRpdHlcIj5cbiAgICAgICAgPHhmLWZpbHRlci1ncm91cCBmb3JtQ29udHJvbE5hbWU9XCJxdWVyeVwiIFtlbnRpdHldPVwic2VsZWN0ZWRFbnRpdHlcIj48L3hmLWZpbHRlci1ncm91cD5cbiAgICAgIDwvZGl2PlxuICAgIDwvZGl2PlxuICA8L2Rpdj5cblxuICA8ZGl2IGNsYXNzPVwicm93IG10LTNcIiAqbmdJZj1cImZpZWxkc1wiPlxuICAgIDx4Zi1kZWZhdWx0LXNvcnQgW3F1ZXJ5XT1cIndpZGdldENvbmZpZy5jb25maWd1cmF0aW9uLnF1ZXJ5XCIgW2ZpZWxkc109XCJmaWVsZHMhXCIgY2xhc3M9XCJjb2wtbGctNyBjb2wtbWQtOCBjb2wtc20tMTJcIj5cbiAgICA8L3hmLWRlZmF1bHQtc29ydD5cbiAgPC9kaXY+XG5cbjwvZGl2PlxuIl19