/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, forwardRef, } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import cronstrue from 'cronstrue';
import * as _ from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "../../core/services/license.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "./cron-time-picker/cron-time-picker.component";
const _c0 = a0 => ({ "error": a0 });
const _c1 = a0 => ({ "active-tab": a0 });
const _c2 = a0 => ({ "active": a0 });
function CronEditorComponent_div_24_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const minute_r3 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", minute_r3);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", minute_r3, " ");
} }
function CronEditorComponent_div_24_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 40)(1, "span");
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.state.validation.errorMessage);
} }
function CronEditorComponent_div_24_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 12)(1, "div", 13);
    i0.ɵɵtext(2, " Every ");
    i0.ɵɵelementStart(3, "select", 37);
    i0.ɵɵlistener("change", function CronEditorComponent_div_24_Template_select_change_3_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.regenerateCron()); });
    i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_div_24_Template_select_ngModelChange_3_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r1.state.minutes, $event) || (ctx_r1.state.minutes = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵtemplate(4, CronEditorComponent_div_24_option_4_Template, 2, 2, "option", 15);
    i0.ɵɵelementEnd();
    i0.ɵɵtext(5, " minute(s) ");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(6, CronEditorComponent_div_24_div_6_Template, 3, 1, "div", 38);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(4, _c2, ctx_r1.activeTab === "minutes"));
    i0.ɵɵadvance(3);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.state.minutes);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.selectOptions.minutes);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.state.validation.isValid);
} }
function CronEditorComponent_option_29_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const hour_r4 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", hour_r4);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", hour_r4, " ");
} }
function CronEditorComponent_option_32_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵpipe(2, "number");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const minute_r5 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", minute_r5);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", i0.ɵɵpipeBind2(2, 2, minute_r5, "2.0"), " ");
} }
function CronEditorComponent_option_86_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const monthDaysWithLast_r6 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", monthDaysWithLast_r6);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDayDisplay(monthDaysWithLast_r6), " ");
} }
function CronEditorComponent_option_89_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const month_r7 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", month_r7);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", month_r7, " ");
} }
function CronEditorComponent_option_99_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const month_r8 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", month_r8);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDisplay(month_r8), " ");
} }
function CronEditorComponent_option_102_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const monthDaysWithLast_r9 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", monthDaysWithLast_r9);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDayDisplay(monthDaysWithLast_r9), " ");
} }
function CronEditorComponent_option_111_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const monthWeek_r10 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", monthWeek_r10);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthWeekDisplay(monthWeek_r10), " ");
} }
function CronEditorComponent_option_113_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const day_r11 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", day_r11);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.dayDisplay(day_r11), " ");
} }
function CronEditorComponent_option_116_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 39);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const month_r12 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngValue", month_r12);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.monthDisplay(month_r12), " ");
} }
function CronEditorComponent_div_119_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 44)(1, "span");
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.state.validation.errorMessage);
} }
function CronEditorComponent_div_119_Template(rf, ctx) { if (rf & 1) {
    const _r13 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 41);
    i0.ɵɵtext(1, " Cron Expression ");
    i0.ɵɵelementStart(2, "input", 42);
    i0.ɵɵlistener("keyup", function CronEditorComponent_div_119_Template_input_keyup_2_listener() { i0.ɵɵrestoreView(_r13); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.regenerateCron()); });
    i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_div_119_Template_input_ngModelChange_2_listener($event) { i0.ɵɵrestoreView(_r13); const ctx_r1 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r1.state.advanced.expression, $event) || (ctx_r1.state.advanced.expression = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, CronEditorComponent_div_119_div_3_Template, 3, 1, "div", 43);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(3, _c2, ctx_r1.activeTab === "advanced"));
    i0.ɵɵadvance(2);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.state.advanced.expression);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.state.validation.isValid);
} }
export const Days = {
    'MON': 1,
    'TUE': 2,
    'WED': 3,
    'THU': 4,
    'FRI': 5,
    'SAT': 6,
    'SUN': 7
};
export const DayMap = {
    1: 'MON',
    2: 'TUE',
    3: 'WED',
    4: 'THU',
    5: 'FRI',
    6: 'SAT',
    7: 'SUN'
};
export const DisplayDays = {
    'MON': 'Monday',
    'TUE': 'Tuesday',
    'WED': 'Wednesday',
    'THU': 'Thursday',
    'FRI': 'Friday',
    'SAT': 'Saturday',
    'SUN': 'Sunday'
};
export const MonthWeeks = {
    1: 'First',
    2: 'Second',
    3: 'Third',
    4: 'Fourth',
    5: 'Fifth'
};
export var Months;
(function (Months) {
    Months[Months["January"] = 1] = "January";
    Months[Months["February"] = 2] = "February";
    Months[Months["March"] = 3] = "March";
    Months[Months["April"] = 4] = "April";
    Months[Months["May"] = 5] = "May";
    Months[Months["June"] = 6] = "June";
    Months[Months["July"] = 7] = "July";
    Months[Months["August"] = 8] = "August";
    Months[Months["September"] = 9] = "September";
    Months[Months["October"] = 10] = "October";
    Months[Months["November"] = 11] = "November";
    Months[Months["December"] = 12] = "December";
})(Months || (Months = {}));
export class CronEditorComponent {
    constructor(changeDetectorRef, licenseService) {
        this.changeDetectorRef = changeDetectorRef;
        this.licenseService = licenseService;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.selectOptions = {
            months: this.getRange(1, 12),
            monthWeeks: [1, 2, 3, 4, 5],
            days: ['MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT', 'SUN'],
            minutes: this.getRange(0, 59),
            fullMinutes: this.getRange(0, 59),
            hours: this.getRange(1, 23),
            monthDays: this.getRange(1, 31),
            monthDaysWithLasts: [...this.getRange(1, 31).map(String), 'L'],
            hourType: ['AM', 'PM']
        };
        this.defaultHours = 10;
        this.defaultHourType = 'PM';
        this.defaultMinutes = 0;
        this.state = {
            minutes: this.defaultMinutes,
            hourly: {
                hours: this.defaultHours,
                minutes: this.defaultMinutes
            },
            daily: {
                subTab: 'everyDays',
                everyDays: {
                    days: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                },
                everyWeekDay: {
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                }
            },
            weekly: {
                MON: true,
                TUE: false,
                WED: false,
                THU: false,
                FRI: false,
                SAT: false,
                SUN: false,
                hours: this.defaultHours,
                minutes: this.defaultMinutes,
                hourType: this.defaultHourType
            },
            monthly: {
                subTab: 'specificDay',
                runOnWeekday: false,
                specificDay: {
                    day: '1',
                    months: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                },
                specificWeekDay: {
                    monthWeek: 1,
                    day: 'MON',
                    startMonth: 1,
                    months: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHourType
                }
            },
            yearly: {
                subTab: 'specificMonthDay',
                runOnWeekday: false,
                specificMonthDay: {
                    month: 1,
                    day: '1',
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHours
                },
                specificMonthWeek: {
                    monthWeek: 1,
                    day: 'MON',
                    month: 1,
                    hours: this.defaultHours,
                    minutes: this.defaultMinutes,
                    hourType: this.defaultHours
                }
            },
            advanced: {
                expression: '0 0 * * *'
            },
            validation: {
                isValid: true,
                errorMessage: ''
            },
            formRadioClass: null
        };
        this.regenCallBacks = {
            'minutes': () => this.regenerateMinutes(),
            'hourly': () => this.regenerateHourly(),
            'daily': () => this.regenerateDaily(),
            'weekly': () => this.regenerateWeekly(),
            'monthly': () => this.regenerateMonthly(),
            'yearly': () => this.regenerateYearly()
        };
        this.licenseService.getLicenseDetails().subscribe((result) => {
            this.eventFreq = +result.info.polling_frequency;
        });
    }
    validate(control) {
        if (!this.state.validation.isValid) {
            return {
                error: {
                    message: this.state.validation.errorMessage
                }
            };
        }
        return null;
    }
    writeValue(value) {
        if (value) {
            this.cron = value;
        }
        else {
            this.cron = {
                minute: `*/${this.eventFreq}`,
                hour: '*',
                day_of_month: '*',
                day_of_week: '*',
                month_of_year: '*',
                timezone: ''
            };
        }
        this.setInitCron(this.cron);
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnInit() {
        if (this.cron) {
            this.setInitCron(this.cron);
        }
    }
    setActiveTab(tab) {
        this.activeTab = tab;
        this.regenerateCron();
    }
    setInitCron(cron) {
        const monthlySpecificDayReg = /^\*\/(1[0-2]|[1-9])$/;
        // Minutes
        if (cron.hour === '*' && cron.day_of_month === '*' && cron.month_of_year === '*' && cron.day_of_week === '*') {
            this.activeTab = 'minutes';
            this.state.minutes = +cron.minute.split('/')[1];
            if (this.checkIsAdvanced(this.state.minutes)) {
                this.setAdvancedTab(cron);
            }
        }
        // Hourly
        else if (cron.hour.indexOf('*/') > -1 && cron.day_of_month === '*' && cron.month_of_year === '*' && cron.day_of_week === '*') {
            this.activeTab = 'hourly';
            this.state.hourly.minutes = Number(cron.minute);
            this.state.hourly.hours = +cron.hour.split('/')[1];
            if (this.checkIsAdvanced(this.state.hourly)) {
                this.setAdvancedTab(cron);
            }
        }
        // Daily - everyDays
        else if (cron.month_of_year === '*' && cron.day_of_week === '*') {
            this.activeTab = 'daily';
            this.state.daily.subTab = 'everyDays';
            this.state.daily.everyDays.days = cron.day_of_month === '*' ? 1 : Number(cron.day_of_month.substring(2));
            const parsedHours = Number(cron.hour);
            this.state.daily.everyDays.hours = parsedHours;
            this.state.daily.everyDays.hourType = this.getHourType(parsedHours);
            this.state.daily.everyDays.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.daily)) {
                this.setAdvancedTab(cron);
            }
        }
        // Daily - everyWeekDay
        else if (cron.day_of_month === '*' && cron.month_of_year === '*' && cron.day_of_week === '1-5') {
            this.activeTab = 'daily';
            this.state.daily.subTab = 'everyWeekDay';
            const parsedHours = Number(cron.hour);
            this.state.daily.everyWeekDay.hours = parsedHours;
            this.state.daily.everyWeekDay.hourType = this.getHourType(parsedHours);
            this.state.daily.everyWeekDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.daily)) {
                this.setAdvancedTab(cron);
            }
        }
        // Weekly
        else if (cron.day_of_month === '*' && cron.month_of_year === '*' && _.every(cron.day_of_week.split(','), item => _.includes(['1', '2', '3', '4', '5', '6', '7'], item))) {
            this.activeTab = 'weekly';
            this.selectOptions.days.forEach(weekDay => this.state.weekly[weekDay] = false);
            cron.day_of_week.split(',').forEach(weekDay => this.state.weekly[DayMap[weekDay]] = true);
            const parsedHours = Number(cron.hour);
            this.state.weekly.hours = parsedHours;
            this.state.weekly.hourType = this.getHourType(parsedHours);
            this.state.weekly.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.weekly[this.state.weekly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Monthly - specificDay
        else if (cron.day_of_week === '*' && monthlySpecificDayReg.test(cron.month_of_year)) {
            // SAME AS BELOW
            this.activeTab = 'monthly';
            this.state.monthly.subTab = 'specificDay';
            if (cron.day_of_month.indexOf('W') !== -1) {
                this.state.monthly.specificDay.day = cron.day_of_month.charAt(0);
                this.state.monthly.runOnWeekday = true;
            }
            else {
                this.state.monthly.specificDay.day = cron.day_of_month;
            }
            this.state.monthly.specificDay.months = Number(cron.month_of_year.substring(2));
            const parsedHours = Number(cron.hour);
            this.state.monthly.specificDay.hours = parsedHours;
            this.state.monthly.specificDay.hourType = this.getHourType(parsedHours);
            this.state.monthly.specificDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.monthly[this.state.monthly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Monthly - specificWeekDay
        else if (cron.day_of_week === '*' && cron.month_of_year === '1/1' && cron.day_of_month === '*') {
            //SAME AS ABOVE
            this.activeTab = 'monthly';
            this.state.monthly.subTab = 'specificWeekDay';
            const day = cron.day_of_week.substr(0, 3);
            const monthWeek = cron.day_of_week.substr(3);
            this.state.monthly.specificWeekDay.monthWeek = monthWeek;
            this.state.monthly.specificWeekDay.day = day;
            if (cron.month_of_year.indexOf('/') !== -1) {
                const [startMonth, months] = cron.month_of_year.split('/').map(Number);
                this.state.monthly.specificWeekDay.months = months;
                this.state.monthly.specificWeekDay.startMonth = startMonth;
            }
            const parsedHours = Number(cron.hour);
            this.state.monthly.specificWeekDay.hours = parsedHours;
            this.state.monthly.specificWeekDay.hourType = this.getHourType(parsedHours);
            this.state.monthly.specificWeekDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.monthly[this.state.monthly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Yearly - specificMonthDay
        else if (cron.day_of_week === '*' && cron.month_of_year in this.selectOptions.months) {
            // SAME AS ABOVE
            this.activeTab = 'yearly';
            this.state.yearly.subTab = 'specificMonthDay';
            this.state.yearly.specificMonthDay.month = Number(cron.month_of_year);
            if (cron.month_of_year.indexOf('W') !== -1) {
                this.state.yearly.specificMonthDay.day = cron.day_of_month.charAt(0);
                this.state.yearly.runOnWeekday = true;
            }
            else {
                this.state.yearly.specificMonthDay.day = cron.day_of_month;
            }
            const parsedHours = Number(cron.hour);
            this.state.yearly.specificMonthDay.hours = parsedHours;
            this.state.yearly.specificMonthDay.hourType = this.getHourType(parsedHours);
            this.state.yearly.specificMonthDay.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.yearly[this.state.yearly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        // Yearly - specificMonthWeek
        else if (cron.day_of_month.indexOf('-') > -1) {
            // SAME AS ABOVE
            this.activeTab = 'yearly';
            this.state.yearly.subTab = 'specificMonthWeek';
            // Convert 8-14 to 2
            const monthWeek = (Number(cron.day_of_month.split('-')[0]) + 6) / 7;
            this.state.yearly.specificMonthWeek.monthWeek = monthWeek;
            this.state.yearly.specificMonthWeek.day = cron.day_of_week;
            this.state.yearly.specificMonthWeek.month = Number(cron.month_of_year);
            const parsedHours = Number(cron.hour);
            this.state.yearly.specificMonthWeek.hours = parsedHours;
            this.state.yearly.specificMonthWeek.hourType = this.getHourType(parsedHours);
            this.state.yearly.specificMonthWeek.minutes = Number(cron.minute);
            if (this.checkIsAdvanced(this.state.yearly[this.state.yearly.subTab])) {
                this.setAdvancedTab(cron);
            }
        }
        else {
            this.setAdvancedTab(cron);
        }
        this.regenerateCron(false);
    }
    setAdvancedTab(cron) {
        this.activeTab = 'advanced';
        this.state.advanced.expression = this.cronJsonToString(cron);
    }
    checkIsAdvanced(obj) {
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                const value = obj[key];
                if (typeof value === 'number' && isNaN(value)) {
                    return true;
                }
            }
        }
        return false;
    }
    // Regenerate Cron
    regenerateMinutes() {
        // Keeping the commented code in case of decision to emit expression
        // this.cron = `0/${this.state.minutes.minutes} * 1/1 * ?`;
        this.cron = {
            minute: `*/${this.state.minutes}`,
            hour: '*',
            day_of_month: '*',
            month_of_year: '*',
            day_of_week: '*',
            timezone: ''
        };
    }
    regenerateHourly() {
        // Keeping the commented code in case of decision to emit expression
        // this.cron = `${this.state.hourly.minutes} 0/${this.state.hourly.hours} 1/1 * ?`;
        this.cron = {
            minute: this.state.hourly.minutes,
            hour: `*/${this.state.hourly.hours}`,
            day_of_month: '*',
            month_of_year: '*',
            day_of_week: '*',
            timezone: ''
        };
    }
    regenerateDaily() {
        switch (this.state.daily.subTab) {
            case 'everyDays':
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.daily.everyDays.minutes} ${this.hourToCron(this.state.daily.everyDays.hours, this.state.daily.everyDays.hourType)} 1/${this.state.daily.everyDays.days} * ?`;
                this.cron = {
                    minute: this.state.daily.everyDays.minutes,
                    hour: this.hourToCron(this.state.daily.everyDays.hours, this.state.daily.everyDays.hourType) + '',
                    day_of_month: `*/${this.state.daily.everyDays.days}`,
                    month_of_year: '*',
                    day_of_week: '*',
                    timezone: ''
                };
                break;
            case 'everyWeekDay':
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.daily.everyWeekDay.minutes} ${this.hourToCron(this.state.daily.everyWeekDay.hours, this.state.daily.everyWeekDay.hourType)} ? * MON-FRI`;
                this.cron = {
                    minute: this.state.daily.everyDays.minutes,
                    hour: this.hourToCron(this.state.daily.everyWeekDay.hours, this.state.daily.everyWeekDay.hourType) + '',
                    day_of_month: '*',
                    month_of_year: '*',
                    day_of_week: '1-5',
                    timezone: ''
                };
                break;
            default:
                throw new Error('Invalid cron daily subtab selection');
        }
    }
    regenerateWeekly() {
        // Keeping the commented code in case of decision to emit expression
        // this.cron = `${this.state.weekly.minutes} ${this.hourToCron(this.state.weekly.hours, this.state.weekly.hourType)} ? * ${days}`;
        const days = this.selectOptions.days
            .reduce((acc, day) => this.state.weekly[day] ? acc.concat(Days[day]) : acc, [])
            .join(',');
        this.cron = {
            minute: this.state.weekly.minutes,
            hour: this.hourToCron(this.state.weekly.hours, this.state.weekly.hourType) + '',
            day_of_month: '*',
            month_of_year: '*',
            day_of_week: days,
            timezone: ''
        };
    }
    regenerateMonthly() {
        switch (this.state.monthly.subTab) {
            case 'specificDay':
                const day = this.state.monthly.runOnWeekday ? `${this.state.monthly.specificDay.day}W` : this.state.monthly.specificDay.day;
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.monthly.specificDay.minutes} ${this.hourToCron(this.state.monthly.specificDay.hours, this.state.monthly.specificDay.hourType)} ${day} 1/${this.state.monthly.specificDay.months} ?`;
                this.cron = {
                    minute: this.state.monthly.specificDay.minutes,
                    hour: this.hourToCron(this.state.monthly.specificDay.hours, this.state.monthly.specificDay.hourType) + '',
                    day_of_month: day,
                    month_of_year: `*/${this.state.monthly.specificDay.months}`,
                    day_of_week: '*',
                    timezone: ''
                };
                break;
            case 'specificWeekDay':
                // this.cron = `${this.state.monthly.specificWeekDay.minutes}
                // ${this.hourToCron(this.state.monthly.specificWeekDay.hours, this.state.monthly.specificWeekDay.hourType)}
                // ?
                //${this.state.monthly.specificWeekDay.startMonth}/${this.state.monthly.specificWeekDay.months}
                //${this.state.monthly.specificWeekDay.day}${this.state.monthly.specificWeekDay.monthWeek}`;
                this.cron = {
                    minute: this.state.monthly.specificWeekDay.minutes,
                    hour: this.hourToCron(this.state.monthly.specificWeekDay.hours, this.state.monthly.specificWeekDay.hourType) + '',
                    day_of_month: `${this.state.monthly.specificWeekDay.monthWeek * 7 - 6}-${Math.min(this.state.monthly.specificWeekDay.monthWeek * 7, 31)}`,
                    month_of_year: `${this.state.monthly.specificWeekDay.startMonth}/${this.state.monthly.specificWeekDay.months}`,
                    day_of_week: `${this.state.monthly.specificWeekDay.day}`,
                    timezone: ''
                };
                break;
            default:
                throw new Error('Invalid cron');
        }
    }
    regenerateYearly() {
        switch (this.state.yearly.subTab) {
            case 'specificMonthDay':
                const day = this.state.yearly.runOnWeekday ? `${this.state.yearly.specificMonthDay.day}W` : this.state.yearly.specificMonthDay.day;
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.yearly.specificMonthDay.minutes} ${this.hourToCron(this.state.yearly.specificMonthDay.hours, this.state.yearly.specificMonthDay.hourType)} ${day} ${this.state.yearly.specificMonthDay.month} ?`;
                this.cron = {
                    minute: this.state.yearly.specificMonthDay.minutes,
                    hour: this.hourToCron(this.state.yearly.specificMonthDay.hours, this.state.yearly.specificMonthDay.hourType) + '',
                    day_of_month: day,
                    month_of_year: this.state.yearly.specificMonthDay.month + '',
                    day_of_week: '*',
                    timezone: ''
                };
                break;
            case 'specificMonthWeek':
                // Keeping the commented code in case of decision to emit expression
                // this.cron = `${this.state.yearly.specificMonthWeek.minutes} ${this.hourToCron(this.state.yearly.specificMonthWeek.hours, this.state.yearly.specificMonthWeek.hourType)} ? ${this.state.yearly.specificMonthWeek.month} ${this.state.yearly.specificMonthWeek.day}${this.state.yearly.specificMonthWeek.monthWeek}`;
                this.cron = {
                    minute: this.state.yearly.specificMonthWeek.minutes,
                    hour: this.hourToCron(this.state.yearly.specificMonthWeek.hours, this.state.yearly.specificMonthWeek.hourType) + '',
                    day_of_month: `${this.state.yearly.specificMonthWeek.monthWeek * 7 - 6}-${Math.min(this.state.yearly.specificMonthWeek.monthWeek * 7, 31)}`,
                    month_of_year: this.state.yearly.specificMonthWeek.month,
                    day_of_week: this.state.yearly.specificMonthWeek.day,
                    timezone: ''
                };
                break;
            default:
                throw new Error('Invalid cron yearly subtab selection');
        }
    }
    regenerateCron(regenerate = true) {
        if (this.activeTab !== 'advanced') {
            if (regenerate) {
                this.regenCallBacks[this.activeTab]();
            }
            this._validate(this.cronJsonToString(this.cron));
            if (this.state.validation.isValid) {
                this.cronDescriber = cronstrue.toString(`${this.cron.minute} ${this.cron.hour} ${this.cron.day_of_month} ${this.cron.month_of_year} ${this.cron.day_of_week}`);
                this.state.advanced.expression = this.cronJsonToString(this.cron);
            }
            this.changeDetectorRef.detectChanges();
        }
        if (this.activeTab === 'advanced') {
            this.onTouched();
            this.cronDescriber = '';
            this._validate(this.state.advanced.expression);
            if (this.state.validation.isValid) {
                this.cronStringToJson(this.state.advanced.expression);
                try {
                    this.cronDescriber = cronstrue.toString(`${this.cron.minute} ${this.cron.hour} ${this.cron.day_of_month} ${this.cron.month_of_year} ${this.cron.day_of_week}`);
                }
                catch (error) {
                    this.state.validation.isValid = false;
                    this.state.validation.errorMessage = error;
                }
            }
            this.changeDetectorRef.detectChanges();
        }
    }
    hourToCron(hour, hourType) {
        return hourType === 'AM' ? (hour === 12 ? 0 : hour) : (hour >= 12 ? hour : hour + 12);
    }
    dayDisplay(day) {
        return DisplayDays[day];
    }
    monthWeekDisplay(monthWeekNumber) {
        return MonthWeeks[monthWeekNumber];
    }
    monthDisplay(month) {
        return Months[month];
    }
    getHourType(hour) {
        return hour >= 12 ? 'PM' : 'AM';
    }
    monthDayDisplay(month) {
        if (month === 'L') {
            return 'Last Day';
        }
        else if (month === 'LW') {
            return 'Last Weekday';
        }
        else if (month === '1W') {
            return 'First Weekday';
        }
        else {
            return `${month}${this.getOrdinalSuffix(month)} day`;
        }
    }
    getOrdinalSuffix(value) {
        if (value.length > 1) {
            const secondToLastDigit = value.charAt(value.length - 2);
            if (secondToLastDigit === '1') {
                return 'th';
            }
        }
        const lastDigit = value.charAt(value.length - 1);
        switch (lastDigit) {
            case '1':
                return 'st';
            case '2':
                return 'nd';
            case '3':
                return 'rd';
            default:
                return 'th';
        }
    }
    cronStringToJson(cronSeven) {
        const [minutes, hours, day_of_month, month_of_year, day_of_week] = cronSeven.split(' ');
        return this.cron = {
            minute: minutes,
            hour: hours,
            day_of_month: day_of_month,
            month_of_year: month_of_year,
            day_of_week: day_of_week,
            timezone: ''
        };
    }
    cronJsonToString(cronJson) {
        return `${cronJson.minute} ${cronJson.hour} ${cronJson.day_of_month} ${cronJson.month_of_year} ${cronJson.day_of_week}`;
    }
    _validate(cron) {
        this.state.validation.isValid = false;
        this.state.validation.errorMessage = '';
        let cronJson = this.cronStringToJson(cron);
        if (!cron) {
            this.state.validation.errorMessage = 'Cron expression cannot be null';
            this.onChange(null);
            return;
        }
        const cronParts = cron.split(' ');
        let expected = 5;
        if (cronParts.length !== expected && this.activeTab === 'advanced') {
            this.state.validation.errorMessage = `Invalid cron expression, there must be ${expected} segments`;
            this.onChange(null);
            return;
        }
        if (cronJson.hour === '*' && cronJson.day_of_month === '*' && cronJson.month_of_year === '*' && cronJson.day_of_week === '*') {
            let minFreq = +cronJson.minute.split('/')[1];
            if (minFreq < this.eventFreq) {
                this.state.validation.errorMessage = `As per your entitlement, the schedule frequency must be greater than ${this.eventFreq} minutes`;
                this.cronDescriber = '';
                this.onChange(null);
                return;
            }
        }
        this.state.validation.isValid = true;
        this.onChange(this.cron);
    }
    getRange(startFrom, until) {
        return Array.from({ length: (until + 1 - startFrom) }, (_, k) => k + startFrom);
    }
    static { this.ɵfac = function CronEditorComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CronEditorComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.LicenseService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: CronEditorComponent, selectors: [["xf-cron-editor"]], features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => CronEditorComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => CronEditorComponent),
                    multi: true
                }])], decls: 123, vars: 82, consts: [[1, "cron-editor", 3, "ngClass"], ["role", "tablist", 1, "tabs-container"], [1, "tab", 3, "click", "ngClass"], ["aria-controls", "minutes", "role", "tab", "data-toggle", "tab"], ["aria-controls", "hourly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "daily", "role", "tab", "data-toggle", "tab"], ["aria-controls", "weekly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "monthly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "yearly", "role", "tab", "data-toggle", "tab"], ["aria-controls", "advanced", "role", "tab", "data-toggle", "tab"], [1, "tab-content"], ["class", "tab-pane", 3, "ngClass", 4, "ngIf"], [1, "tab-pane", 3, "ngClass"], [1, "well", "well-small"], [1, "cron-input", 3, "change", "ngModelChange", "ngModel"], [3, "ngValue", 4, "ngFor", "ngForOf"], ["for", "daily-subtab"], ["type", "radio", "name", "daily-radio", "value", "everyDays", "id", "daily-subtab", "checked", "checked", 3, "change", "ngModelChange", "ngModel", "ngClass"], ["type", "number", "min", "1", "max", "31", 1, "form-control", "form-control-sm", "w-auto", "d-inline-block", "mx-1", 3, "change", "ngModelChange", "ngModel"], [3, "change", "time"], [1, "well", "well-small", "mt-3"], ["for", "everyWeekDay"], ["type", "radio", "name", "daily-radio", "value", "everyWeekDay", "id", "everyWeekDay", 3, "change", "ngModelChange", "ngModel", "ngClass"], [1, "row"], [1, "col-sm-3"], [1, "advanced-cron-editor-label"], ["type", "checkbox", 3, "change", "ngModelChange", "ngModel"], [1, "row", "mt-3"], [1, "col-sm-6"], ["for", "specificDay"], ["for", "yearly-specificMonthDay"], ["type", "radio", "name", "yearly-radio", "value", "specificMonthDay", "id", "yearly-specificMonthDay", 3, "change", "ngModelChange", "ngModel", "ngClass"], [1, "well", "well-small", "mt-4"], ["for", "yearly-specificMonthWeek"], ["type", "radio", "name", "yearly-radio", "value", "specificMonthWeek", "id", "yearly-specificMonthWeek", 3, "change", "ngModelChange", "ngModel", "ngClass"], [3, "ngClass", 4, "ngIf"], [1, "evaluated-cron"], [1, "cron-input", "ms-2", 3, "change", "ngModelChange", "ngModel"], ["class", "text-danger mt-2", 4, "ngIf"], [3, "ngValue"], [1, "text-danger", "mt-2"], [3, "ngClass"], ["type", "text", "ng-disabled", "disabled || activeTab !== 'advanced'", 1, "cron-input", "form-control", 3, "keyup", "ngModelChange", "ngModel"], ["class", "text-danger", 4, "ngIf"], [1, "text-danger"]], template: function CronEditorComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "ul", 1)(2, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_2_listener() { return ctx.setActiveTab("minutes"); });
            i0.ɵɵelementStart(3, "a", 3);
            i0.ɵɵtext(4, " Minutes ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_5_listener() { return ctx.setActiveTab("hourly"); });
            i0.ɵɵelementStart(6, "a", 4);
            i0.ɵɵtext(7, " Hourly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(8, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_8_listener() { return ctx.setActiveTab("daily"); });
            i0.ɵɵelementStart(9, "a", 5);
            i0.ɵɵtext(10, " Daily ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(11, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_11_listener() { return ctx.setActiveTab("weekly"); });
            i0.ɵɵelementStart(12, "a", 6);
            i0.ɵɵtext(13, " Weekly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(14, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_14_listener() { return ctx.setActiveTab("monthly"); });
            i0.ɵɵelementStart(15, "a", 7);
            i0.ɵɵtext(16, " Monthly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(17, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_17_listener() { return ctx.setActiveTab("yearly"); });
            i0.ɵɵelementStart(18, "a", 8);
            i0.ɵɵtext(19, " Yearly ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(20, "li", 2);
            i0.ɵɵlistener("click", function CronEditorComponent_Template_li_click_20_listener() { return ctx.setActiveTab("advanced"); });
            i0.ɵɵelementStart(21, "a", 9);
            i0.ɵɵtext(22, " Advanced ");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(23, "div", 10);
            i0.ɵɵtemplate(24, CronEditorComponent_div_24_Template, 7, 6, "div", 11);
            i0.ɵɵelementStart(25, "div", 12)(26, "div", 13);
            i0.ɵɵtext(27, " Every ");
            i0.ɵɵelementStart(28, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_28_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_28_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.hourly.hours, $event) || (ctx.state.hourly.hours = $event); return $event; });
            i0.ɵɵtemplate(29, CronEditorComponent_option_29_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(30, " hour(s) on minute ");
            i0.ɵɵelementStart(31, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_31_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_31_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.hourly.minutes, $event) || (ctx.state.hourly.minutes = $event); return $event; });
            i0.ɵɵtemplate(32, CronEditorComponent_option_32_Template, 3, 5, "option", 15);
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(33, "div", 12)(34, "div", 13)(35, "label", 16)(36, "input", 17);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_36_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_36_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.daily.subTab, $event) || (ctx.state.daily.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(37, " Every ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(38, "input", 18);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_38_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_38_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.daily.everyDays.days, $event) || (ctx.state.daily.everyDays.days = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(39, " day(s) at ");
            i0.ɵɵelementStart(40, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_40_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(41, "div", 20)(42, "label", 21)(43, "input", 22);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_43_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_43_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.daily.subTab, $event) || (ctx.state.daily.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(44, " Every working day at ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(45, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_45_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(46, "div", 12)(47, "div", 13)(48, "div", 23)(49, "div", 24)(50, "label", 25)(51, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_51_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_51_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.MON, $event) || (ctx.state.weekly.MON = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(52, " Monday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(53, "div", 24)(54, "label", 25)(55, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_55_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_55_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.TUE, $event) || (ctx.state.weekly.TUE = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(56, " Tuesday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(57, "div", 24)(58, "label", 25)(59, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_59_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_59_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.WED, $event) || (ctx.state.weekly.WED = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(60, " Wednesday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(61, "div", 24)(62, "label", 25)(63, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_63_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_63_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.THU, $event) || (ctx.state.weekly.THU = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(64, " Thursday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(65, "div", 24)(66, "label", 25)(67, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_67_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_67_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.FRI, $event) || (ctx.state.weekly.FRI = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(68, " Friday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(69, "div", 24)(70, "label", 25)(71, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_71_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_71_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.SAT, $event) || (ctx.state.weekly.SAT = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(72, " Saturday");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(73, "div", 24)(74, "label", 25)(75, "input", 26);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_75_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_75_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.weekly.SUN, $event) || (ctx.state.weekly.SUN = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(76, " Sunday");
            i0.ɵɵelementEnd()()();
            i0.ɵɵelementStart(77, "div", 27)(78, "div", 28);
            i0.ɵɵtext(79, " at ");
            i0.ɵɵelementStart(80, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_80_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()()()()();
            i0.ɵɵelementStart(81, "div", 12)(82, "div", 13)(83, "label", 29);
            i0.ɵɵtext(84, " On the ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(85, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_85_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_85_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.monthly.specificDay.day, $event) || (ctx.state.monthly.specificDay.day = $event); return $event; });
            i0.ɵɵtemplate(86, CronEditorComponent_option_86_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(87, " of every ");
            i0.ɵɵelementStart(88, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_88_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_88_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.monthly.specificDay.months, $event) || (ctx.state.monthly.specificDay.months = $event); return $event; });
            i0.ɵɵtemplate(89, CronEditorComponent_option_89_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(90, " month(s) at ");
            i0.ɵɵelementStart(91, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_91_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(92, "\u00A0 ");
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(93, "div", 12)(94, "div", 13)(95, "label", 30)(96, "input", 31);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_96_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_96_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.subTab, $event) || (ctx.state.yearly.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(97, " Every ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(98, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_98_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_98_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthDay.month, $event) || (ctx.state.yearly.specificMonthDay.month = $event); return $event; });
            i0.ɵɵtemplate(99, CronEditorComponent_option_99_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(100, " on the ");
            i0.ɵɵelementStart(101, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_101_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_101_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthDay.day, $event) || (ctx.state.yearly.specificMonthDay.day = $event); return $event; });
            i0.ɵɵtemplate(102, CronEditorComponent_option_102_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(103, " at ");
            i0.ɵɵelementStart(104, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_104_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(105, "\u00A0 ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(106, "div", 32)(107, "label", 33)(108, "input", 34);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_input_change_108_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_input_ngModelChange_108_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.subTab, $event) || (ctx.state.yearly.subTab = $event); return $event; });
            i0.ɵɵelementEnd();
            i0.ɵɵtext(109, " On the ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(110, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_110_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_110_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthWeek.monthWeek, $event) || (ctx.state.yearly.specificMonthWeek.monthWeek = $event); return $event; });
            i0.ɵɵtemplate(111, CronEditorComponent_option_111_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(112, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_112_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_112_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthWeek.day, $event) || (ctx.state.yearly.specificMonthWeek.day = $event); return $event; });
            i0.ɵɵtemplate(113, CronEditorComponent_option_113_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(114, " of ");
            i0.ɵɵelementStart(115, "select", 14);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_select_change_115_listener() { return ctx.regenerateCron(); });
            i0.ɵɵtwoWayListener("ngModelChange", function CronEditorComponent_Template_select_ngModelChange_115_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.state.yearly.specificMonthWeek.month, $event) || (ctx.state.yearly.specificMonthWeek.month = $event); return $event; });
            i0.ɵɵtemplate(116, CronEditorComponent_option_116_Template, 2, 2, "option", 15);
            i0.ɵɵelementEnd();
            i0.ɵɵtext(117, " at ");
            i0.ɵɵelementStart(118, "xf-cron-time-picker", 19);
            i0.ɵɵlistener("change", function CronEditorComponent_Template_xf_cron_time_picker_change_118_listener() { return ctx.regenerateCron(); });
            i0.ɵɵelementEnd()()();
            i0.ɵɵtemplate(119, CronEditorComponent_div_119_Template, 4, 5, "div", 35);
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(120, "div")(121, "span", 36);
            i0.ɵɵtext(122);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(56, _c0, !ctx.state.validation.isValid));
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(58, _c1, ctx.activeTab === "minutes"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(60, _c1, ctx.activeTab === "hourly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(62, _c1, ctx.activeTab === "daily"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(64, _c1, ctx.activeTab === "weekly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(66, _c1, ctx.activeTab === "monthly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(68, _c1, ctx.activeTab === "yearly"));
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(70, _c1, ctx.activeTab === "advanced"));
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("ngIf", ctx.activeTab === "minutes");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(72, _c2, ctx.activeTab === "hourly"));
            i0.ɵɵadvance(3);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.hourly.hours);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.hours);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.hourly.minutes);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.fullMinutes);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(74, _c2, ctx.activeTab === "daily"));
            i0.ɵɵadvance(3);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.daily.subTab);
            i0.ɵɵproperty("ngClass", ctx.state.formRadioClass);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.daily.everyDays.days);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("time", ctx.state.daily.everyDays);
            i0.ɵɵadvance(3);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.daily.subTab);
            i0.ɵɵproperty("ngClass", ctx.state.formRadioClass);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("time", ctx.state.daily.everyWeekDay);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(76, _c2, ctx.activeTab === "weekly"));
            i0.ɵɵadvance(5);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.MON);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.TUE);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.WED);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.THU);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.FRI);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.SAT);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.weekly.SUN);
            i0.ɵɵadvance(5);
            i0.ɵɵproperty("time", ctx.state.weekly);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(78, _c2, ctx.activeTab === "monthly"));
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.monthly.specificDay.day);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.monthDaysWithLasts);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.monthly.specificDay.months);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.months);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("time", ctx.state.monthly.specificDay);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(80, _c2, ctx.activeTab === "yearly"));
            i0.ɵɵadvance(3);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.yearly.subTab);
            i0.ɵɵproperty("ngClass", ctx.state.formRadioClass);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.yearly.specificMonthDay.month);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.months);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.yearly.specificMonthDay.day);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.monthDaysWithLasts);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("time", ctx.state.yearly.specificMonthDay);
            i0.ɵɵadvance(4);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.yearly.subTab);
            i0.ɵɵproperty("ngClass", ctx.state.formRadioClass);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.yearly.specificMonthWeek.monthWeek);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.monthWeeks);
            i0.ɵɵadvance();
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.yearly.specificMonthWeek.day);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.days);
            i0.ɵɵadvance(2);
            i0.ɵɵtwoWayProperty("ngModel", ctx.state.yearly.specificMonthWeek.month);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.selectOptions.months);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("time", ctx.state.yearly.specificMonthWeek);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.activeTab === "advanced");
            i0.ɵɵadvance(3);
            i0.ɵɵtextInterpolate(ctx.cronDescriber);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i3.NgSelectOption, i3.ɵNgSelectMultipleOption, i3.DefaultValueAccessor, i3.NumberValueAccessor, i3.CheckboxControlValueAccessor, i3.SelectControlValueAccessor, i3.RadioControlValueAccessor, i3.NgControlStatus, i3.MinValidator, i3.MaxValidator, i3.NgModel, i4.CronTimePickerComponent, i2.DecimalPipe], styles: [".cron-editor[_ngcontent-%COMP%]{border:2px solid var(--element-default-border-color);padding:10px;font-size:12px;border-radius:4px}.cron-editor.error[_ngcontent-%COMP%]{border:1px solid red}.cron-editor[_ngcontent-%COMP%]   .tabs-container[_ngcontent-%COMP%]{display:flex;list-style-type:none;padding:0 0 10px;overflow-x:auto}.cron-editor[_ngcontent-%COMP%]   .tabs-container[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]{cursor:pointer;padding:8px 12px;border:1px solid var(--element-default-border-color);background-color:var(--element-primary-bg-color)}.cron-editor[_ngcontent-%COMP%]   .tabs-container[_ngcontent-%COMP%]   .tab.active-tab[_ngcontent-%COMP%]{background-color:var(--highlight-active-color)}.cron-editor[_ngcontent-%COMP%]   .tabs-container[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]:first-child{border-radius:3px 0 0 3px}.cron-editor[_ngcontent-%COMP%]   .tabs-container[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]:last-child{border-radius:0 3px 3px 0}.cron-editor[_ngcontent-%COMP%]   .tab-content[_ngcontent-%COMP%]{margin-left:10px}.cron-editor[_ngcontent-%COMP%]   .tab-content[_ngcontent-%COMP%]   .cron-input[_ngcontent-%COMP%]{margin-left:10px;border:1px solid rgba(0,0,0,.15);background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.evaluated-cron[_ngcontent-%COMP%]{font-size:.8em;font-style:italic}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CronEditorComponent, [{
        type: Component,
        args: [{ selector: 'xf-cron-editor', changeDetection: ChangeDetectionStrategy.Default, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => CronEditorComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => CronEditorComponent),
                        multi: true
                    }], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n  <div class=\"cron-editor\" [ngClass]=\"{'error': !state.validation.isValid}\">\n    <!-- Tabs -->\n    <ul class=\"tabs-container\" role=\"tablist\">\n      <li class=\"tab\" [ngClass]=\"{'active-tab': activeTab === 'minutes'}\" (click)=\"setActiveTab('minutes')\">\n        <a aria-controls=\"minutes\" role=\"tab\" data-toggle=\"tab\">\n          Minutes\n        </a>\n      </li>\n\n      <li class=\"tab\" [ngClass]=\"{'active-tab': activeTab === 'hourly'}\" (click)=\"setActiveTab('hourly')\">\n        <a aria-controls=\"hourly\" role=\"tab\" data-toggle=\"tab\">\n          Hourly\n        </a>\n      </li>\n\n      <li class=\"tab\" [ngClass]=\"{'active-tab': activeTab === 'daily'}\" (click)=\"setActiveTab('daily')\">\n        <a aria-controls=\"daily\" role=\"tab\" data-toggle=\"tab\">\n          Daily\n        </a>\n      </li>\n\n      <li class=\"tab\" [ngClass]=\"{'active-tab': activeTab === 'weekly'}\" (click)=\"setActiveTab('weekly')\">\n        <a aria-controls=\"weekly\" role=\"tab\" data-toggle=\"tab\">\n          Weekly\n        </a>\n      </li>\n\n      <li class=\"tab\" [ngClass]=\"{'active-tab': activeTab === 'monthly'}\" (click)=\"setActiveTab('monthly')\">\n        <a aria-controls=\"monthly\" role=\"tab\" data-toggle=\"tab\">\n          Monthly\n        </a>\n      </li>\n\n      <li class=\"tab\" [ngClass]=\"{'active-tab': activeTab === 'yearly'}\" (click)=\"setActiveTab('yearly')\">\n        <a aria-controls=\"yearly\" role=\"tab\" data-toggle=\"tab\">\n          Yearly\n        </a>\n      </li>\n\n      <li class=\"tab\" [ngClass]=\"{'active-tab': activeTab === 'advanced'}\" (click)=\"setActiveTab('advanced')\">\n        <a aria-controls=\"advanced\" role=\"tab\" data-toggle=\"tab\">\n          Advanced\n        </a>\n      </li>\n    </ul>\n    <!-- Tab  Content -->\n    <div class=\"tab-content\">\n      <!-- Minutes-->\n      <div class=\"tab-pane\" *ngIf=\"activeTab === 'minutes'\" [ngClass]=\"{'active': activeTab === 'minutes'}\">\n        <div class=\"well well-small\">\n          Every\n          <select class=\"cron-input ms-2\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.minutes\">\n            <option *ngFor=\"let minute of selectOptions.minutes\" [ngValue]=\"minute\">\n              {{minute}}\n            </option>\n          </select> minute(s)\n        </div>\n        <div *ngIf=\"!state.validation.isValid\" class=\"text-danger mt-2\">\n          <span>{{state.validation.errorMessage}}</span>\n        </div>\n      </div>\n      <!-- Hourly-->\n      <div class=\"tab-pane\" [ngClass]=\"{'active': activeTab === 'hourly'}\">\n        <div class=\"well well-small\">\n          Every\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.hourly.hours\">\n            <option *ngFor=\"let hour of selectOptions.hours\" [ngValue]=\"hour\">\n              {{hour}}\n            </option>\n          </select> hour(s) on minute\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.hourly.minutes\">\n            <option *ngFor=\"let minute of selectOptions.fullMinutes\" [ngValue]=\"minute\">\n              {{minute | number: '2.0'}}\n            </option>\n          </select>\n        </div>\n      </div>\n      <!-- Daily-->\n      <div class=\"tab-pane\" [ngClass]=\"{'active': activeTab === 'daily'}\">\n        <!-- Every Day -->\n        <div class=\"well well-small\">\n          <label for=\"daily-subtab\">\n            <input type=\"radio\" name=\"daily-radio\" value=\"everyDays\" (change)=\"regenerateCron()\" id=\"daily-subtab\"\n              [(ngModel)]=\"state.daily.subTab\" [ngClass]=\"state.formRadioClass\" checked=\"checked\">\n            Every\n          </label>\n            <input type=\"number\" min=\"1\" max=\"31\" class=\"form-control form-control-sm w-auto d-inline-block mx-1\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.daily.everyDays.days\"> day(s) at\n          <xf-cron-time-picker (change)=\"regenerateCron()\" [time]=\"state.daily.everyDays\"></xf-cron-time-picker>\n        </div>\n        <!-- Every Working Day -->\n        <div class=\"well well-small mt-3\">\n          <label for=\"everyWeekDay\">\n            <input type=\"radio\" name=\"daily-radio\" value=\"everyWeekDay\" id=\"everyWeekDay\" (change)=\"regenerateCron()\"\n            [(ngModel)]=\"state.daily.subTab\" [ngClass]=\"state.formRadioClass\"> Every working day at\n          </label>\n          <xf-cron-time-picker (change)=\"regenerateCron()\" [time]=\"state.daily.everyWeekDay\"></xf-cron-time-picker>\n        </div>\n      </div>\n      <!-- Weekly-->\n      <div class=\"tab-pane\" [ngClass]=\"{'active': activeTab === 'weekly'}\">\n        <div class=\"well well-small\">\n          <div class=\"row\">\n            <div class=\"col-sm-3\">\n              <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n                  [(ngModel)]=\"state.weekly.MON\">\n                Monday</label>\n            </div>\n            <div class=\"col-sm-3\">\n              <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n                  [(ngModel)]=\"state.weekly.TUE\">\n                Tuesday</label>\n            </div>\n            <div class=\"col-sm-3\">\n              <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n                  [(ngModel)]=\"state.weekly.WED\">\n                Wednesday</label>\n            </div>\n            <div class=\"col-sm-3\">\n              <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n                  [(ngModel)]=\"state.weekly.THU\">\n                Thursday</label>\n            </div>\n            <div class=\"col-sm-3\">\n              <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n                  [(ngModel)]=\"state.weekly.FRI\">\n                Friday</label>\n            </div>\n            <div class=\"col-sm-3\">\n              <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n                  [(ngModel)]=\"state.weekly.SAT\">\n                Saturday</label>\n            </div>\n            <div class=\"col-sm-3\">\n              <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n                  [(ngModel)]=\"state.weekly.SUN\">\n                Sunday</label>\n            </div>\n          </div>\n          <div class=\"row mt-3\">\n            <div class=\"col-sm-6\">\n              at\n              <xf-cron-time-picker (change)=\"regenerateCron()\" [time]=\"state.weekly\"></xf-cron-time-picker>\n            </div>\n          </div>\n        </div>\n      </div>\n      <!-- Monthly -->\n      <div class=\"tab-pane\" [ngClass]=\"{'active': activeTab === 'monthly'}\">\n        <div class=\"well well-small\">\n          <label for=\"specificDay\">\n            <!-- <input type=\"radio\" name=\"monthly-radio\" value=\"specificDay\" id=\"specificDay\" (change)=\"regenerateCron()\"\n            [(ngModel)]=\"state.monthly.subTab\" [ngClass]=\"state.formRadioClass\"> -->\n            On the\n          </label>\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.monthly.specificDay.day\">\n            <option *ngFor=\"let monthDaysWithLast of selectOptions.monthDaysWithLasts\" [ngValue]=\"monthDaysWithLast\">\n              {{monthDayDisplay(monthDaysWithLast)}}\n            </option>\n          </select> of every\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.monthly.specificDay.months\">\n            <option *ngFor=\"let month of selectOptions.months\" [ngValue]=\"month\">\n              {{month}}\n            </option>\n          </select> month(s) at\n          <xf-cron-time-picker (change)=\"regenerateCron()\"\n            [time]=\"state.monthly.specificDay\"></xf-cron-time-picker>&nbsp;\n          <!-- <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n              [(ngModel)]=\"state.monthly.runOnWeekday\">\n            during the nearest weekday</label> -->\n        </div>\n        <!-- <div class=\"well well-small mt-4\">\n          <label for=\"specificWeekDay\">\n            <input type=\"radio\" name=\"monthly-radio\" value=\"specificWeekDay\" id=\"specificWeekDay\" (change)=\"regenerateCron()\"\n              [(ngModel)]=\"state.monthly.subTab\" [ngClass]=\"state.formRadioClass\">\n            On the\n          </label>\n          <select class=\"cron-input me-2\" (change)=\"regenerateCron()\"\n            [(ngModel)]=\"state.monthly.specificWeekDay.monthWeek\">\n            <option *ngFor=\"let monthWeek of selectOptions.monthWeeks\" [ngValue]=\"monthWeek\">\n              {{monthWeekDisplay(monthWeek)}}\n            </option>\n          </select>\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.monthly.specificWeekDay.day\">\n            <option *ngFor=\"let day of selectOptions.days\" [ngValue]=\"day\">\n              {{dayDisplay(day)}}\n            </option>\n          </select> of every\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.monthly.specificWeekDay.months\">\n            <option *ngFor=\"let month of selectOptions.months\" [ngValue]=\"month\">\n              {{month}}\n            </option>\n          </select> month(s) starting in\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.monthly.specificWeekDay.startMonth\">\n            <option *ngFor=\"let month of selectOptions.months\" [ngValue]=\"month\">\n              {{monthDisplay(month)}}\n            </option>\n          </select>\n\n          at\n          <xf-cron-time-picker (change)=\"regenerateCron()\" [time]=\"state.monthly.specificWeekDay\">\n          </xf-cron-time-picker>\n        </div> -->\n      </div>\n      <!-- Yearly -->\n      <div class=\"tab-pane\" [ngClass]=\"{'active': activeTab === 'yearly'}\">\n        <div class=\"well well-small\">\n          <label for=\"yearly-specificMonthDay\">\n            <input type=\"radio\" name=\"yearly-radio\" value=\"specificMonthDay\" (change)=\"regenerateCron()\"\n              [(ngModel)]=\"state.yearly.subTab\" [ngClass]=\"state.formRadioClass\" id=\"yearly-specificMonthDay\">\n            Every\n          </label>\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.yearly.specificMonthDay.month\">\n            <option *ngFor=\"let month of selectOptions.months\" [ngValue]=\"month\">\n              {{monthDisplay(month)}}\n            </option>\n          </select> on the\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.yearly.specificMonthDay.day\">\n            <option *ngFor=\"let monthDaysWithLast of selectOptions.monthDaysWithLasts\" [ngValue]=\"monthDaysWithLast\">\n              {{monthDayDisplay(monthDaysWithLast)}}\n            </option>\n          </select> at\n          <xf-cron-time-picker (change)=\"regenerateCron()\" [time]=\"state.yearly.specificMonthDay\">\n          </xf-cron-time-picker>&nbsp;\n          <!-- <label class=\"advanced-cron-editor-label\"><input type=\"checkbox\" (change)=\"regenerateCron()\"\n              [(ngModel)]=\"state.yearly.runOnWeekday\"> during the nearest\n            weekday</label> -->\n        </div>\n        <div class=\"well well-small mt-4\">\n          <label for=\"yearly-specificMonthWeek\">\n            <input type=\"radio\" name=\"yearly-radio\" value=\"specificMonthWeek\" (change)=\"regenerateCron()\"\n              [(ngModel)]=\"state.yearly.subTab\" [ngClass]=\"state.formRadioClass\" id=\"yearly-specificMonthWeek\">\n            On the\n          </label>\n\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.yearly.specificMonthWeek.monthWeek\">\n            <option *ngFor=\"let monthWeek of selectOptions.monthWeeks\" [ngValue]=\"monthWeek\">\n              {{monthWeekDisplay(monthWeek)}}\n            </option>\n          </select>\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.yearly.specificMonthWeek.day\">\n            <option *ngFor=\"let day of selectOptions.days\" [ngValue]=\"day\">\n              {{dayDisplay(day)}}\n            </option>\n          </select> of\n          <select class=\"cron-input\" (change)=\"regenerateCron()\" [(ngModel)]=\"state.yearly.specificMonthWeek.month\">\n            <option *ngFor=\"let month of selectOptions.months\" [ngValue]=\"month\">\n              {{monthDisplay(month)}}\n            </option>\n          </select> at\n          <xf-cron-time-picker (change)=\"regenerateCron()\"\n            [time]=\"state.yearly.specificMonthWeek\"></xf-cron-time-picker>\n        </div>\n      </div>\n      <!-- Advanced-->\n      <div *ngIf=\"activeTab === 'advanced'\" [ngClass]=\"{'active': activeTab === 'advanced'}\">\n        Cron Expression\n        <input type=\"text\" class=\"cron-input form-control\" ng-disabled=\"disabled || activeTab !== 'advanced'\"\n          (keyup)=\"regenerateCron()\" [(ngModel)]=\"state.advanced.expression\">\n        <div *ngIf=\"!state.validation.isValid\" class=\"text-danger\">\n          <span>{{state.validation.errorMessage}}</span>\n        </div>\n      </div>\n    </div>\n  </div>\n  <div>\n    <span class=\"evaluated-cron\">{{cronDescriber}}</span>\n  </div>\n", styles: [".cron-editor{border:2px solid var(--element-default-border-color);padding:10px;font-size:12px;border-radius:4px}.cron-editor.error{border:1px solid red}.cron-editor .tabs-container{display:flex;list-style-type:none;padding:0 0 10px;overflow-x:auto}.cron-editor .tabs-container .tab{cursor:pointer;padding:8px 12px;border:1px solid var(--element-default-border-color);background-color:var(--element-primary-bg-color)}.cron-editor .tabs-container .tab.active-tab{background-color:var(--highlight-active-color)}.cron-editor .tabs-container .tab:first-child{border-radius:3px 0 0 3px}.cron-editor .tabs-container .tab:last-child{border-radius:0 3px 3px 0}.cron-editor .tab-content{margin-left:10px}.cron-editor .tab-content .cron-input{margin-left:10px;border:1px solid rgba(0,0,0,.15);background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.evaluated-cron{font-size:.8em;font-style:italic}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.LicenseService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(CronEditorComponent, { className: "CronEditorComponent", filePath: "lib/components/cron-editor/cron-editor.component.ts", lineNumber: 80 }); })();
//# sourceMappingURL=data:application/json;base64,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