/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, HostBinding, HostListener, Input, Output, inject } from '@angular/core';
import { TranslocoService } from '@jsverse/transloco';
import { ToastrService } from 'ngx-toastr';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
function FileUploadComponent_div_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9)(1, "span", 10);
    i0.ɵɵtext(2, "Supported file types: ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "span", 11);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(ctx_r1.acceptTypes);
} }
export class FileUploadComponent {
    constructor() {
        this.files = [];
        this.acceptTypes = [];
        this.showSupportedFileType = false;
        this.fileDropped = new EventEmitter();
        this.toaster = inject(ToastrService);
        this.translocoService = inject(TranslocoService);
    }
    onFileDropped($event) {
        this.fileBrowseHandler($event);
    }
    fileBrowseHandler(event) {
        if (event.files.length > 0 && this.areValidFiles(event.files)) {
            this.fileDropped.emit(event.files);
        }
    }
    // Dragover listener
    onDragOver(event) {
        event.preventDefault();
        event.stopPropagation();
        this.fileOver = true;
    }
    // Dragleave listener
    onDragLeave(event) {
        event.preventDefault();
        event.stopPropagation();
        this.fileOver = false;
    }
    // Drop listener
    ondrop(event) {
        event.preventDefault();
        event.stopPropagation();
        this.fileOver = false;
        let files = event.dataTransfer.files;
        if (files.length > 0 && this.areValidFiles(files)) {
            this.fileDropped.emit(files);
        }
    }
    areValidFiles(files) {
        if (this.acceptTypes.length > 0) {
            const invalidFiles = Array.from(files).filter((file) => this.acceptTypes.indexOf(file.type) === -1);
            if (invalidFiles.length > 0) {
                this.toaster.error(this.translocoService.translate('components.fileUpload.invalidFileType', {
                    acceptTypes: this.acceptTypes.join(', ')
                }), 'Error');
                return false;
            }
        }
        return true;
    }
    static { this.ɵfac = function FileUploadComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FileUploadComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FileUploadComponent, selectors: [["xf-file-upload"]], hostVars: 2, hostBindings: function FileUploadComponent_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("dragover", function FileUploadComponent_dragover_HostBindingHandler($event) { return ctx.onDragOver($event); })("dragleave", function FileUploadComponent_dragleave_HostBindingHandler($event) { return ctx.onDragLeave($event); })("drop", function FileUploadComponent_drop_HostBindingHandler($event) { return ctx.ondrop($event); });
        } if (rf & 2) {
            i0.ɵɵclassProp("fileover", ctx.fileOver);
        } }, inputs: { acceptTypes: "acceptTypes", showSupportedFileType: "showSupportedFileType" }, outputs: { fileDropped: "fileDropped" }, decls: 11, vars: 2, consts: [["fileDropRef", ""], [1, "container", "rounded-8px", "cursor-pointer", 3, "fileDropped"], ["type", "file", "id", "fileDropRef", "multiple", "", 1, "cursor-pointer", 3, "change", "accept"], [1, "align-items-center", "d-flex", "h-100", "justify-content-center"], [1, "img-responsive", "d-info-image", "w-100", "h-200px", "file-upload-image"], [1, "label-font", "fw-normal", "margin-top-16px"], [1, "fw-semibold", "text-highlight"], [1, "muted-40"], ["class", "d-flex justify-content-center", 4, "ngIf"], [1, "d-flex", "justify-content-center"], [1, "font-size-10px", "text-warning"], [1, "font-size-10px", "margin-left-4px", "muted-40", "text-capitalize"]], template: function FileUploadComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1);
            i0.ɵɵlistener("fileDropped", function FileUploadComponent_Template_div_fileDropped_0_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.onFileDropped($event)); });
            i0.ɵɵelementStart(1, "input", 2, 0);
            i0.ɵɵlistener("change", function FileUploadComponent_Template_input_change_1_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.fileBrowseHandler($event.target)); });
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(3, "div", 3);
            i0.ɵɵelement(4, "div", 4);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(5, "h3", 5)(6, "span", 6);
            i0.ɵɵtext(7, "Click to upload");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(8, "span", 7);
            i0.ɵɵtext(9, " or drag and drop");
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(10, FileUploadComponent_div_10_Template, 5, 1, "div", 8);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("accept", ctx.acceptTypes.join(","));
            i0.ɵɵadvance(9);
            i0.ɵɵproperty("ngIf", ctx.showSupportedFileType);
        } }, dependencies: [i1.NgIf], styles: [".container[_ngcontent-%COMP%]{width:100%;padding:50px;text-align:center;border:dashed 2px var(--file-upload-border);position:relative;margin:0 auto}.container[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]{opacity:0;position:absolute;z-index:2;width:100%;height:100%;top:0;left:0}.fileover[_ngcontent-%COMP%]{animation:shake 1s;animation-iteration-count:infinite}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileUploadComponent, [{
        type: Component,
        args: [{ selector: 'xf-file-upload', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"container rounded-8px cursor-pointer\" (fileDropped)=\"onFileDropped($event)\">\n  <input type=\"file\" class=\"cursor-pointer\" #fileDropRef id=\"fileDropRef\" multiple\n    (change)=\"fileBrowseHandler($event.target)\" [accept]=\"acceptTypes.join(',')\" />\n  <div class=\"align-items-center d-flex h-100 justify-content-center\">\n    <div class=\"img-responsive d-info-image w-100 h-200px file-upload-image\"></div>\n  </div>\n  <!-- <button type=\"button\" class=\"btn btn-primary\" (click)=\"fileBrowseHandler($event.target)\"></button> -->\n  <h3 class=\"label-font fw-normal margin-top-16px\"><span class=\"fw-semibold text-highlight\">Click to\n      upload</span><span class=\"muted-40\"> or drag and drop</span></h3>\n  <div *ngIf=\"showSupportedFileType\" class=\"d-flex justify-content-center\">\n    <span class=\"font-size-10px text-warning\">Supported file types: </span>\n    <span class=\"font-size-10px margin-left-4px muted-40 text-capitalize\">{{acceptTypes}}</span>\n  </div>\n</div>\n", styles: [".container{width:100%;padding:50px;text-align:center;border:dashed 2px var(--file-upload-border);position:relative;margin:0 auto}.container input{opacity:0;position:absolute;z-index:2;width:100%;height:100%;top:0;left:0}.fileover{animation:shake 1s;animation-iteration-count:infinite}\n"] }]
    }], null, { acceptTypes: [{
            type: Input
        }], showSupportedFileType: [{
            type: Input
        }], fileOver: [{
            type: HostBinding,
            args: ['class.fileover']
        }], fileDropped: [{
            type: Output
        }], onDragOver: [{
            type: HostListener,
            args: ['dragover', ['$event']]
        }], onDragLeave: [{
            type: HostListener,
            args: ['dragleave', ['$event']]
        }], ondrop: [{
            type: HostListener,
            args: ['drop', ['$event']]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FileUploadComponent, { className: "FileUploadComponent", filePath: "lib/components/file-upload/file-upload.component.ts", lineNumber: 15 }); })();
//# sourceMappingURL=data:application/json;base64,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