import { Component, Input } from '@angular/core';
import { concatMap, of } from 'rxjs';
import { API } from '../../../core/constants';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/common/http";
import * as i3 from "../../../core/services/modal.service";
import * as i4 from "@angular/common";
import * as i5 from "@angular/forms";
import * as i6 from "@jsverse/transloco";
import * as i7 from "../../../query-filters/filter-group/filter-group.component";
function BulkDeleteModalComponent_form_0_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "xf-filter-group", 11);
    i0.ɵɵtwoWayListener("ngModelChange", function BulkDeleteModalComponent_form_0_ng_container_9_Template_xf_filter_group_ngModelChange_1_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); i0.ɵɵtwoWayBindingSet(ctx_r1.filterGroup, $event) || (ctx_r1.filterGroup = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵlistener("ngModelChange", function BulkDeleteModalComponent_form_0_ng_container_9_Template_xf_filter_group_ngModelChange_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.filterGroupChange()); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.filterGroup);
    i0.ɵɵproperty("entity", ctx_r1.entity);
} }
function BulkDeleteModalComponent_form_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "form", 2, 0);
    i0.ɵɵlistener("ngSubmit", function BulkDeleteModalComponent_form_0_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.runDelete()); });
    i0.ɵɵelementStart(2, "div", 3)(3, "h4", 4);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "button", 5);
    i0.ɵɵlistener("click", function BulkDeleteModalComponent_form_0_Template_button_click_5_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div", 6)(7, "p");
    i0.ɵɵtext(8);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(9, BulkDeleteModalComponent_form_0_ng_container_9_Template, 2, 2, "ng-container", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(10, "div", 8)(11, "button", 9);
    i0.ɵɵlistener("click", function BulkDeleteModalComponent_form_0_Template_button_click_11_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵtext(12, "Cancel");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(13, "button", 10);
    i0.ɵɵtext(14, "Delete");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("Delete ", ctx_r1.entity.descriptions.plural, " By Condition");
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", ctx_r1.entity.descriptions.plural, " that match the following filters will be deleted:");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.filterGroup && ctx_r1.entity);
} }
export class BulkDeleteModalComponent {
    constructor(activeModal, http, modalService) {
        this.activeModal = activeModal;
        this.http = http;
        this.modalService = modalService;
        this.filterGroup = null;
    }
    ngOnInit() {
        this.filterGroup = this.query;
    }
    filterGroupChange() {
        if (!this.filterGroup) {
            return;
        }
        this.query = this.filterGroup;
    }
    runDelete() {
        const data = this.query.getQueryObject();
        this.http.post(API.QUERY + this.entity.type, data, {
            params: {
                $limit: 1
            }
        }).pipe(concatMap((response) => {
            return this.modalService.confirm('Are you sure you want to delete ' + response['hydra:totalItems'] + ' ' + this.entity.descriptions.plural + '?')
                .pipe(concatMap((result) => {
                if (!result) {
                    return of();
                }
                return this.http.request('delete', API.DELETE_WITH_QUERY + this.entity.type, { body: data });
            }));
        })).subscribe(() => {
            this.activeModal.close();
        });
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function BulkDeleteModalComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || BulkDeleteModalComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveModal), i0.ɵɵdirectiveInject(i2.HttpClient), i0.ɵɵdirectiveInject(i3.ModalService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BulkDeleteModalComponent, selectors: [["xf-bulk-delete-modal"]], inputs: { entity: "entity", query: "query" }, decls: 1, vars: 0, consts: [["formElement", ""], ["name", "generate-shifts", "novalidate", "", 3, "ngSubmit", 4, "transloco"], ["name", "generate-shifts", "novalidate", "", 3, "ngSubmit"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body", "px-3", "pb-5"], [4, "ngIf"], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-danger"], ["name", "filterGroup", 3, "ngModelChange", "ngModel", "entity"]], template: function BulkDeleteModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, BulkDeleteModalComponent_form_0_Template, 15, 3, "form", 1);
        } }, dependencies: [i4.NgIf, i5.ɵNgNoValidate, i5.NgControlStatus, i5.NgControlStatusGroup, i5.NgModel, i5.NgForm, i6.TranslocoDirective, i7.FilterGroupComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BulkDeleteModalComponent, [{
        type: Component,
        args: [{ selector: 'xf-bulk-delete-modal', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<form name=\"generate-shifts\" (ngSubmit)=\"runDelete()\" novalidate #formElement *transloco=\"let t\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Delete {{ entity.descriptions.plural }} By Condition</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body px-3 pb-5\">\n    <p>{{ entity.descriptions.plural }} that match the following filters will be deleted:</p>\n    <ng-container *ngIf=\"filterGroup && entity\">\n      <xf-filter-group [(ngModel)]=\"filterGroup\" (ngModelChange)=\"filterGroupChange()\" name=\"filterGroup\" [entity]=\"entity\">\n      </xf-filter-group>\n    </ng-container>\n\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-danger\">Delete</button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i1.NgbActiveModal }, { type: i2.HttpClient }, { type: i3.ModalService }], { entity: [{
            type: Input
        }], query: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(BulkDeleteModalComponent, { className: "BulkDeleteModalComponent", filePath: "lib/components/modals/bulk-delete-modal/bulk-delete-modal.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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