/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { ChangeDetectionStrategy, Component, ElementRef, EventEmitter, forwardRef, Input, Output, ViewChild, ViewChildren } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR, Validators } from '@angular/forms';
import { NgbDropdown, NgbDropdownItem } from '@ng-bootstrap/ng-bootstrap';
import { fromEvent } from 'rxjs';
import { debounceTime, distinctUntilChanged, map, startWith, tap } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/common";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "@jsverse/transloco";
import * as i5 from "../../utility/pipes/highlight.pipe";
const _c0 = ["searchInput"];
const _c1 = ["inputField"];
const _c2 = a0 => ({ "d-inline-block": a0 });
const _c3 = (a0, a1, a2) => ({ "btn-select d-flex form-select": a0, "btn-link p-0": a1, "is-invalid": a2 });
const _c4 = a0 => ({ "active": a0 });
function SearchableDropdownComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function SearchableDropdownComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.selectItem(null)); })("keydown.arrowup", function SearchableDropdownComponent_div_0_div_7_button_1_Template_button_keydown_arrowup_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.dropdownItems.last.nativeElement.previousElementSibling.previousElementSibling.focus()); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(2, _c4, !ctx_r1.value));
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(ctx_r1.clearText);
} }
function SearchableDropdownComponent_div_0_div_7_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 14);
} }
function SearchableDropdownComponent_div_0_div_7_button_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 15);
    i0.ɵɵpipe(1, "highlight");
    i0.ɵɵlistener("click", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_click_0_listener() { const item_r5 = i0.ɵɵrestoreView(_r4).$implicit; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.selectItem(item_r5)); })("keydown.arrowup", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_keydown_arrowup_0_listener() { const i_r6 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r6 - 1)); })("keydown.arrowdown", function SearchableDropdownComponent_div_0_div_7_button_3_Template_button_keydown_arrowdown_0_listener() { const i_r6 = i0.ɵɵrestoreView(_r4).index; const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.focusOnItem(i_r6 + 1)); });
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const item_r5 = ctx.$implicit;
    const t_r7 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c4, ctx_r1.value && item_r5.value.uuid === ctx_r1.value.uuid))("innerHTML", i0.ɵɵpipeBind2(1, 3, t_r7(item_r5.display) + "", ctx_r1.searchText), i0.ɵɵsanitizeHtml)("title", t_r7(item_r5.display));
} }
function SearchableDropdownComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 9);
    i0.ɵɵtemplate(1, SearchableDropdownComponent_div_0_div_7_button_1_Template, 2, 4, "button", 10)(2, SearchableDropdownComponent_div_0_div_7_div_2_Template, 1, 0, "div", 11)(3, SearchableDropdownComponent_div_0_div_7_button_3_Template, 2, 8, "button", 12);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r1.items);
} }
function SearchableDropdownComponent_div_0_div_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵelement(1, "div", 17)(2, "div", 17)(3, "div", 17);
    i0.ɵɵelementEnd();
} }
function SearchableDropdownComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵlistener("openChange", function SearchableDropdownComponent_div_0_Template_div_openChange_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.firstLoad()); });
    i0.ɵɵelementStart(1, "button", 4, 0);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "div", 5)(5, "input", 6, 1);
    i0.ɵɵlistener("keyup.arrowdown", function SearchableDropdownComponent_div_0_Template_input_keyup_arrowdown_5_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.focusOnItem(0)); });
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, SearchableDropdownComponent_div_0_div_7_Template, 4, 3, "div", 7)(8, SearchableDropdownComponent_div_0_div_8_Template, 4, 0, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r7 = ctx.$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(7, _c2, ctx_r1.buttonStyle !== "select"))("container", ctx_r1.container);
    i0.ɵɵadvance();
    i0.ɵɵproperty("disabled", ctx_r1.disabled)("ngClass", i0.ɵɵpureFunction3(9, _c3, ctx_r1.buttonStyle === "select", ctx_r1.buttonStyle !== "select", ctx_r1.touched && ctx_r1.invalid));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate(ctx_r1.value ? t_r7(ctx_r1.value.display) : t_r7(ctx_r1.placeholder) || "Select");
    i0.ɵɵadvance(4);
    i0.ɵɵproperty("ngIf", !ctx_r1.loading);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.loading);
} }
export class SearchableDropdownComponent {
    constructor(_formBuilder, changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.onChange = null;
        this.onTouched = null;
        this.buttonStyle = 'button';
        this.searchQueryChange = new EventEmitter();
        this.required = false;
        this.invalid = false;
        this.touched = false;
        this.clearValueOnSelect = false;
        this.placeholder = 'Choose';
        this.clearText = 'None';
        this.container = null;
        this.disabled = false;
        this.searchText = '';
        this.loading = true;
    }
    ngOnChanges(changes) {
        if (changes.items) {
            this.loading = false;
        }
    }
    ngDoCheck() {
        if (this.touched) {
            return;
        }
        if (this.control?.touched) {
            this.touched = true;
            this.changeDetectorRef.detectChanges();
        }
    }
    focusOnSearchInput() {
        setTimeout(() => {
            this.searchInput.nativeElement.focus();
            this.searchInput.nativeElement.select();
        });
    }
    focusOnItem(index) {
        if (index === -1) {
            this.focusOnSearchInput();
        }
        this.dropdownItems.get(index)?.nativeElement.focus();
    }
    firstLoad() {
        if (!this.dropdown.isOpen()) {
            this.searchInput.nativeElement.value = '';
            return;
        }
        this.setTouched();
        this.loading = true;
        if (this.keyupSubscription) {
            this.keyupSubscription.unsubscribe();
        }
        //this.searchQueryChange.next('');
        this.keyupSubscription = fromEvent(this.searchInput.nativeElement, 'keyup')
            .pipe(map(event => event.target.value), startWith(''), debounceTime(300), distinctUntilChanged(), tap((search) => this.searchText = search))
            .subscribe((search) => this.searchQueryChange.next(search));
        setTimeout(() => {
            this.focusOnSearchInput();
        });
    }
    selectItem(item) {
        if (!this.clearValueOnSelect) {
            this.value = item;
        }
        if (this.onChange) {
            this.onChange(item);
        }
        this.dropdown.close();
    }
    open() {
        this.dropdown.open();
    }
    focus() {
        this.inputField.nativeElement.focus();
    }
    setTouched() {
        this.touched = true;
        this.control?.markAsTouched();
        this.changeDetectorRef.detectChanges();
    }
    writeValue(value) {
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    validate(control) {
        this.control = control;
        this.required = control.hasValidator(Validators.required);
        if (this.required && !this.value) {
            this.invalid = true;
            return {
                required: true
            };
        }
        this.invalid = false;
        return null;
    }
    static { this.ɵfac = function SearchableDropdownComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SearchableDropdownComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: SearchableDropdownComponent, selectors: [["xf-searchable-dropdown"]], viewQuery: function SearchableDropdownComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(_c1, 5);
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(NgbDropdownItem, 5, ElementRef);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.inputField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownItems = _t);
        } }, inputs: { items: "items", buttonStyle: "buttonStyle", clearValueOnSelect: "clearValueOnSelect", placeholder: "placeholder", clearText: "clearText", container: "container", disabled: "disabled" }, outputs: { searchQueryChange: "searchQueryChange" }, features: [i0.ɵɵProvidersFeature([
                {
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => SearchableDropdownComponent),
                    multi: true,
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => SearchableDropdownComponent),
                    multi: true
                }
            ]), i0.ɵɵNgOnChangesFeature], decls: 1, vars: 0, consts: [["inputField", ""], ["searchInput", ""], ["ngbDropdown", "", 3, "ngClass", "container", "openChange", 4, "transloco"], ["ngbDropdown", "", 3, "openChange", "ngClass", "container"], ["type", "button", "id", "dropdownForm1", "ngbDropdownToggle", "", 1, "btn", "btn-sm", 3, "disabled", "ngClass"], ["ngbDropdownMenu", "", "aria-labelledby", "dropdownForm1", 1, "dropdown-menu-wide"], ["type", "text", "id", "searchDropdown", "placeholder", "Search", "autocomplete", "off", 1, "form-control", "form-control-sm", "lookup-search", 3, "keyup.arrowdown"], ["class", "dropdown-items", 4, "ngIf"], ["class", "p-3", 4, "ngIf"], [1, "dropdown-items"], ["type", "button", "ngbDropdownItem", "", 3, "ngClass", "click", "keydown.arrowup", 4, "ngIf"], ["class", "dropdown-divider", 4, "ngIf"], ["type", "button", "ngbDropdownItem", "", 3, "ngClass", "innerHTML", "title", "click", "keydown.arrowup", "keydown.arrowdown", 4, "ngFor", "ngForOf"], ["type", "button", "ngbDropdownItem", "", 3, "click", "keydown.arrowup", "ngClass"], [1, "dropdown-divider"], ["type", "button", "ngbDropdownItem", "", 3, "click", "keydown.arrowup", "keydown.arrowdown", "ngClass", "innerHTML", "title"], [1, "p-3"], [1, "bg-shimmer", "content-line"]], template: function SearchableDropdownComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, SearchableDropdownComponent_div_0_Template, 9, 13, "div", 2);
        } }, dependencies: [i2.NgClass, i2.NgForOf, i2.NgIf, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem, i3.NgbDropdownButtonItem, i4.TranslocoDirective, i5.HighlightPipe], styles: [".max-width-200[_ngcontent-%COMP%]{width:100%;max-width:200px}.lookup-search[_ngcontent-%COMP%]{width:calc(100% - 30px);margin:5px 15px 10px}.dropdown-toggle[_ngcontent-%COMP%]:after{display:none}.dropdown-menu-wide[_ngcontent-%COMP%]{width:100%;font-size:12px}.dropdown-menu-wide[_ngcontent-%COMP%]   .dropdown-items[_ngcontent-%COMP%]{max-height:300px;overflow:auto}.dropdown-menu-wide[_ngcontent-%COMP%]   .dropdown-items[_ngcontent-%COMP%]   .dropdown-item[_ngcontent-%COMP%]{padding:8px 25px;font-size:12px;white-space:normal;max-width:500px}.btn-select[_ngcontent-%COMP%]{width:100%;border:1px solid var(--form-default-border-color);background-color:var(--form-default-bg-color);border-radius:3px;text-align:left;color:var(--btn-select-color)}.btn-select.btn-sm[_ngcontent-%COMP%]{padding:8.25px 10px}.btn-select.btn-sm[_ngcontent-%COMP%]:disabled{cursor:not-allowed;pointer-events:auto}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SearchableDropdownComponent, [{
        type: Component,
        args: [{ selector: 'xf-searchable-dropdown', changeDetection: ChangeDetectionStrategy.OnPush, providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => SearchableDropdownComponent),
                        multi: true,
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => SearchableDropdownComponent),
                        multi: true
                    }
                ], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div ngbDropdown [ngClass]=\"{'d-inline-block': buttonStyle !== 'select'}\" (openChange)=\"firstLoad()\" *transloco=\"let t\"\n  [container]=\"container\">\n  <button type=\"button\" class=\"btn btn-sm\" [disabled]=\"disabled\"\n    [ngClass]=\"{'btn-select d-flex form-select': buttonStyle === 'select', 'btn-link p-0': buttonStyle !== 'select', 'is-invalid': touched && invalid}\"\n    id=\"dropdownForm1\" ngbDropdownToggle #inputField>{{ value ? t(value.display) : t(placeholder) || 'Select' }}</button>\n  <div ngbDropdownMenu aria-labelledby=\"dropdownForm1\" class=\"dropdown-menu-wide\">\n    <input type=\"text\" class=\"form-control form-control-sm lookup-search\" id=\"searchDropdown\" #searchInput\n      placeholder=\"Search\" (keyup.arrowdown)=\"focusOnItem(0)\" autocomplete=\"off\">\n    <div *ngIf=\"!loading\" class=\"dropdown-items\">\n      <button type=\"button\" ngbDropdownItem *ngIf=\"!required\" (click)=\"selectItem(null)\"\n        (keydown.arrowup)=\"dropdownItems.last.nativeElement.previousElementSibling.previousElementSibling.focus()\"\n        [ngClass]=\"{'active': !value}\">{{ clearText }}</button>\n      <div class=\"dropdown-divider\" *ngIf=\"!required\"></div>\n      <button type=\"button\" ngbDropdownItem *ngFor=\"let item of items; let i = index\" (click)=\"selectItem(item)\"\n        (keydown.arrowup)=\"focusOnItem(i - 1)\" (keydown.arrowdown)=\"focusOnItem(i + 1)\"\n        [ngClass]=\"{'active': value && item.value.uuid === value.uuid}\" [innerHTML]=\"(t(item.display) + '') | highlight: searchText\" [title]=\"t(item.display)\"></button>\n    </div>\n    <div class=\"p-3\" *ngIf=\"loading\">\n      <div class=\"bg-shimmer content-line\"></div>\n      <div class=\"bg-shimmer content-line\"></div>\n      <div class=\"bg-shimmer content-line\"></div>\n    </div>\n  </div>\n</div>\n", styles: [".max-width-200{width:100%;max-width:200px}.lookup-search{width:calc(100% - 30px);margin:5px 15px 10px}.dropdown-toggle:after{display:none}.dropdown-menu-wide{width:100%;font-size:12px}.dropdown-menu-wide .dropdown-items{max-height:300px;overflow:auto}.dropdown-menu-wide .dropdown-items .dropdown-item{padding:8px 25px;font-size:12px;white-space:normal;max-width:500px}.btn-select{width:100%;border:1px solid var(--form-default-border-color);background-color:var(--form-default-bg-color);border-radius:3px;text-align:left;color:var(--btn-select-color)}.btn-select.btn-sm{padding:8.25px 10px}.btn-select.btn-sm:disabled{cursor:not-allowed;pointer-events:auto}\n"] }]
    }], () => [{ type: i1.FormBuilder }, { type: i0.ChangeDetectorRef }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], inputField: [{
            type: ViewChild,
            args: ['inputField']
        }], dropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], dropdownItems: [{
            type: ViewChildren,
            args: [NgbDropdownItem, { read: ElementRef }]
        }], items: [{
            type: Input
        }], buttonStyle: [{
            type: Input
        }], searchQueryChange: [{
            type: Output
        }], clearValueOnSelect: [{
            type: Input
        }], placeholder: [{
            type: Input
        }], clearText: [{
            type: Input
        }], container: [{
            type: Input
        }], disabled: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(SearchableDropdownComponent, { className: "SearchableDropdownComponent", filePath: "lib/components/searchable-dropdown/searchable-dropdown.component.ts", lineNumber: 30 }); })();
//# sourceMappingURL=data:application/json;base64,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