/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { CommonModule } from '@angular/common';
import { ChangeDetectorRef, Component, ElementRef, Input, ViewChild, ViewChildren, forwardRef, inject } from '@angular/core';
import { NG_VALUE_ACCESSOR, ReactiveFormsModule } from '@angular/forms';
import { RouterModule } from '@angular/router';
import { NgbDropdown, NgbDropdownItem, NgbDropdownModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslocoModule } from '@jsverse/transloco';
import { concatMap, debounceTime, map, of } from 'rxjs';
import { Tag } from '../../core/models/tag';
import { ApiService } from '../../core/services/api.service';
import { EntityService } from '../../core/services/entity.service';
import { FIXED_MODULE } from '../../core/constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "@angular/common";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "@jsverse/transloco";
const _c0 = ["searchInput"];
const _c1 = ["tagsBaseUrl", ""];
const _c2 = (a0, a1) => ({ "form-control-sm": a0, "form-control-xs": a1 });
const _c3 = a0 => ({ "invisible": a0 });
function TagsInputComponent_span_2_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "span", 5);
    i0.ɵɵtext(1);
    i0.ɵɵelementStart(2, "button", 6);
    i0.ɵɵlistener("click", function TagsInputComponent_span_2_Template_button_click_2_listener() { const tag_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.removeTag(tag_r2)); });
    i0.ɵɵtext(3, "\u00D7");
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const tag_r2 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", tag_r2, " ");
} }
function TagsInputComponent_div_3_li_4_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li")(1, "a", 12);
    i0.ɵɵlistener("click", function TagsInputComponent_div_3_li_4_Template_a_click_1_listener() { const tag_r6 = i0.ɵɵrestoreView(_r5).$implicit; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.addTag(tag_r6)); })("keydown.enter", function TagsInputComponent_div_3_li_4_Template_a_keydown_enter_1_listener() { const tag_r6 = i0.ɵɵrestoreView(_r5).$implicit; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.addTag(tag_r6)); })("keydown.arrowup", function TagsInputComponent_div_3_li_4_Template_a_keydown_arrowup_1_listener() { const i_r7 = i0.ɵɵrestoreView(_r5).index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.focusOnItem(i_r7 - 1)); })("keydown.arrowdown", function TagsInputComponent_div_3_li_4_Template_a_keydown_arrowdown_1_listener() { const i_r7 = i0.ɵɵrestoreView(_r5).index; const ctx_r2 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r2.focusOnItem(i_r7 + 1)); });
    i0.ɵɵtext(2);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const tag_r6 = ctx.$implicit;
    const t_r8 = i0.ɵɵnextContext().$implicit;
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", t_r8(tag_r6), " ");
} }
function TagsInputComponent_div_3_li_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "li");
    i0.ɵɵelement(1, "div", 13);
    i0.ɵɵelementEnd();
} }
function TagsInputComponent_div_3_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 7)(1, "input", 8, 0);
    i0.ɵɵlistener("keyup.arrowdown", function TagsInputComponent_div_3_Template_input_keyup_arrowdown_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.focusOnItem(0)); })("keydown.tab", function TagsInputComponent_div_3_Template_input_keydown_tab_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onTab()); })("keydown.enter", function TagsInputComponent_div_3_Template_input_keydown_enter_1_listener($event) { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onEnter($event)); })("keydown.backspace", function TagsInputComponent_div_3_Template_input_keydown_backspace_1_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.onBackspace()); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 9);
    i0.ɵɵtemplate(4, TagsInputComponent_div_3_li_4_Template, 3, 1, "li", 10)(5, TagsInputComponent_div_3_li_5_Template, 2, 0, "li", 11);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(5, _c2, ctx_r2.size === "sm", ctx_r2.size === "xs"))("placeholder", ctx_r2.placeholder || "Press Tab to add a tag");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(8, _c3, !ctx_r2.filteredTags.length));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.filteredTags);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.loading);
} }
export class TagsInputComponent {
    constructor(formBuilder) {
        this.loading = false;
        this.placeholder = '';
        this.size = 'sm';
        this.filteredTags = [];
        this.apiService = inject(ApiService);
        this.entityService = inject(EntityService);
        this.changeDetectorRef = inject(ChangeDetectorRef);
        this.tags = [];
        this.formGroup = formBuilder.group({
            searchText: ['']
        });
    }
    // Register change handler
    registerOnChange(fn) {
        this.onChange = fn;
    }
    // Register touched handler
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    // Write value
    writeValue(value) {
        if (Array.isArray(value)) {
            this.tags = value;
        }
    }
    ngOnInit() {
        this.formGroup.valueChanges.pipe(debounceTime(300), concatMap((values) => {
            if (values.searchText) {
                return this.applySearch(values.searchText);
            }
            return of();
        })).subscribe();
    }
    applySearch(searchText) {
        this.loading = true;
        return this.entityService.build(FIXED_MODULE.TAGS).pipe(concatMap((tagsEntity) => {
            tagsEntity.baseUrl = this.tagsBaseUrl;
            return this.apiService.getList(tagsEntity, Tag, {
                search: searchText
            }).pipe(map((tags) => {
                this.filteredTags = tags.map((tagObject) => tagObject.name).filter((tag) => this.tags.indexOf(tag) === -1);
                this.loading = false;
                this.dropdown.open(); // Ensure it is open
                this.changeDetectorRef.detectChanges();
            }));
        }));
    }
    onTab() {
        this.addTag(this.formGroup.get('searchText')?.value);
    }
    onEnter(event) {
        event.preventDefault();
        this.addTag(this.formGroup.get('searchText')?.value);
    }
    addTag(tag) {
        if (!tag) {
            return;
        }
        if (this.tags.indexOf(tag) === -1) {
            this.tags.push(tag);
        }
        this.formGroup.get('searchText')?.setValue('');
        if (this.onChange) {
            this.onChange(this.tags);
        }
        this.focusOnSearchInput();
        this.filteredTags = [];
        if (this.onTouched) {
            this.onTouched();
        }
    }
    focusOnSearchInput() {
        setTimeout(() => {
            this.searchInput.nativeElement.focus();
            this.searchInput.nativeElement.select();
        });
    }
    focusOnItem(index) {
        if (index === -1) {
            this.focusOnSearchInput();
        }
        this.dropdownItems.get(index)?.nativeElement.focus();
    }
    onBackspace() {
        if (!this.formGroup.get('searchText')?.value) {
            this.removeTag(this.tags[this.tags.length - 1]);
        }
    }
    removeTag(tag) {
        const index = this.tags.indexOf(tag);
        if (index !== -1) {
            this.tags.splice(index, 1);
        }
        if (this.onChange) {
            this.onChange(this.tags);
        }
        if (this.onTouched) {
            this.onTouched();
        }
    }
    static { this.ɵfac = function TagsInputComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || TagsInputComponent)(i0.ɵɵdirectiveInject(i1.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: TagsInputComponent, selectors: [["xf-tags-input", "tagsBaseUrl", ""]], viewQuery: function TagsInputComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(NgbDropdownItem, 5, ElementRef);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdownItems = _t);
        } }, inputs: { placeholder: "placeholder", size: "size", tagsBaseUrl: "tagsBaseUrl" }, standalone: true, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => TagsInputComponent),
                    multi: true
                }]), i0.ɵɵStandaloneFeature], attrs: _c1, decls: 4, vars: 6, consts: [["searchInput", ""], [1, "form-control", "padding-0px", 3, "click", "ngClass", "formGroup"], [1, "d-inline-block"], ["class", "tag-chip", 4, "ngFor", "ngForOf"], ["ngbDropdown", "", "container", "body", "class", "d-inline-block", 4, "transloco"], [1, "tag-chip"], ["type", "button", 1, "close", 3, "click"], ["ngbDropdown", "", "container", "body", 1, "d-inline-block"], ["type", "text", "id", "searchDropdown", "formControlName", "searchText", "ngbDropdownToggle", "", "autocomplete", "off", 1, "lookup-search", "border-0", "shadow-none", "form-control", 3, "keyup.arrowdown", "keydown.tab", "keydown.enter", "keydown.backspace", "ngClass", "placeholder"], ["ngbDropdownMenu", "", "aria-labelledby", "tags", 1, "dropdown-menu", "mx-0", "border-0", "shadow", 3, "ngClass"], [4, "ngFor", "ngForOf"], [4, "ngIf"], ["ngbDropdownItem", "", "id", "clone-collection-btn", 1, "cursor-pointer", 3, "click", "keydown.enter", "keydown.arrowup", "keydown.arrowdown"], [1, "bg-shimmer", "content-line"]], template: function TagsInputComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 1);
            i0.ɵɵlistener("click", function TagsInputComponent_Template_div_click_0_listener() { return ctx.focusOnItem(-1); });
            i0.ɵɵelementStart(1, "div", 2);
            i0.ɵɵtemplate(2, TagsInputComponent_span_2_Template, 4, 1, "span", 3);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(3, TagsInputComponent_div_3_Template, 6, 10, "div", 4);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(3, _c2, ctx.size === "sm", ctx.size === "xs"))("formGroup", ctx.formGroup);
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngForOf", ctx.tags);
        } }, dependencies: [RouterModule, CommonModule, i2.NgClass, i2.NgForOf, i2.NgIf, ReactiveFormsModule, i1.DefaultValueAccessor, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, NgbDropdownModule, i3.NgbDropdown, i3.NgbDropdownToggle, i3.NgbDropdownMenu, i3.NgbDropdownItem, TranslocoModule, i4.TranslocoDirective], styles: [".close[_ngcontent-%COMP%]{cursor:pointer;background:none;border:none;color:rgb(var(--bs-danger-rgb))}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(TagsInputComponent, [{
        type: Component,
        args: [{ selector: 'xf-tags-input[tagsBaseUrl]', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => TagsInputComponent),
                        multi: true
                    }], standalone: true, imports: [RouterModule, CommonModule, ReactiveFormsModule, NgbDropdownModule, TranslocoModule], template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div class=\"form-control padding-0px\" [ngClass]=\"{'form-control-sm': size === 'sm', 'form-control-xs': size === 'xs'}\" [formGroup]=\"formGroup\" (click)=\"focusOnItem(-1)\">\n  <div class=\"d-inline-block\">\n    <span *ngFor=\"let tag of tags\" class=\"tag-chip\">\n      {{ tag }}\n      <button type=\"button\" class=\"close\" (click)=\"removeTag(tag)\">&times;</button>\n    </span>\n  </div>\n  <div ngbDropdown *transloco=\"let t\" container=\"body\" class=\"d-inline-block\">\n    <input type=\"text\" class=\"lookup-search border-0 shadow-none form-control\" [ngClass]=\"{'form-control-sm': size === 'sm', 'form-control-xs': size === 'xs'}\" id=\"searchDropdown\" #searchInput\n      formControlName=\"searchText\" [placeholder]=\"placeholder || 'Press Tab to add a tag'\" ngbDropdownToggle (keyup.arrowdown)=\"focusOnItem(0)\"\n      autocomplete=\"off\" (keydown.tab)=\"onTab()\" (keydown.enter)=\"onEnter($event)\" (keydown.backspace)=\"onBackspace()\">\n    <div ngbDropdownMenu class=\"dropdown-menu mx-0 border-0 shadow\" [ngClass]=\"{'invisible': !filteredTags.length}\"\n      aria-labelledby=\"tags\">\n      <li *ngFor=\"let tag of filteredTags; let i = index\">\n        <a ngbDropdownItem id=\"clone-collection-btn\" class=\"cursor-pointer\" (click)=\"addTag(tag)\"\n          (keydown.enter)=\"addTag(tag)\" (keydown.arrowup)=\"focusOnItem(i - 1)\" (keydown.arrowdown)=\"focusOnItem(i + 1)\">\n          {{ t(tag) }}\n        </a>\n      </li>\n      <li *ngIf=\"loading\">\n        <div class=\"bg-shimmer content-line\"></div>\n      </li>\n    </div>\n  </div>\n\n</div>\n", styles: [".close{cursor:pointer;background:none;border:none;color:rgb(var(--bs-danger-rgb))}\n"] }]
    }], () => [{ type: i1.FormBuilder }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], dropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], dropdownItems: [{
            type: ViewChildren,
            args: [NgbDropdownItem, { read: ElementRef }]
        }], placeholder: [{
            type: Input
        }], size: [{
            type: Input
        }], tagsBaseUrl: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(TagsInputComponent, { className: "TagsInputComponent", filePath: "lib/components/tags-input/tags-input.component.ts", lineNumber: 31 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGFncy1pbnB1dC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9jb21wb25lbnRzL3RhZ3MtaW5wdXQvdGFncy1pbnB1dC5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9jb21wb25lbnRzL3RhZ3MtaW5wdXQvdGFncy1pbnB1dC5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7OztrQkFJa0I7QUFDbEIsT0FBTyxFQUFFLFlBQVksRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBQy9DLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxTQUFTLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBcUIsU0FBUyxFQUFFLFlBQVksRUFBRSxVQUFVLEVBQUUsTUFBTSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQ2hKLE9BQU8sRUFBZ0QsaUJBQWlCLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUN0SCxPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0saUJBQWlCLENBQUM7QUFDL0MsT0FBTyxFQUFFLFdBQVcsRUFBRSxlQUFlLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQztBQUM3RixPQUFPLEVBQUUsZUFBZSxFQUFFLE1BQU0sb0JBQW9CLENBQUM7QUFDckQsT0FBTyxFQUFFLFNBQVMsRUFBRSxZQUFZLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUV4RCxPQUFPLEVBQUUsR0FBRyxFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFDNUMsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGlDQUFpQyxDQUFDO0FBQzdELE9BQU8sRUFBRSxhQUFhLEVBQUUsTUFBTSxvQ0FBb0MsQ0FBQztBQUNuRSxPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0sc0JBQXNCLENBQUM7Ozs7Ozs7Ozs7OztJQ1RoRCwrQkFBZ0Q7SUFDOUMsWUFDQTtJQUFBLGlDQUE2RDtJQUF6Qix3TUFBUyx3QkFBYyxLQUFDO0lBQUMsc0JBQU87SUFDdEUsQUFEc0UsaUJBQVMsRUFDeEU7OztJQUZMLGNBQ0E7SUFEQSx1Q0FDQTs7OztJQVVFLEFBREYsMEJBQW9ELFlBRThEO0lBQXpDLEFBQXZDLEFBQTlCLEFBRGtFLHdNQUFTLHFCQUFXLEtBQUMsMk1BQ3RFLHFCQUFXLEtBQUMseU1BQW9CLDBCQUFnQixDQUFDLENBQUMsS0FBQyw2TUFBc0IsMEJBQWdCLENBQUMsQ0FBQyxLQUFDO0lBQzdHLFlBQ0Y7SUFDRixBQURFLGlCQUFJLEVBQ0Q7Ozs7SUFGRCxlQUNGO0lBREUsNkNBQ0Y7OztJQUVGLDBCQUFvQjtJQUNsQiwwQkFBMkM7SUFDN0MsaUJBQUs7Ozs7SUFiUCxBQURGLDhCQUE0RSxrQkFHeUM7SUFBcEMsQUFBbEMsQUFBeEIsQUFEb0YsaU1BQW1CLG1CQUFZLENBQUMsQ0FBQyxLQUFDLDRLQUN2RyxjQUFPLEtBQUMsc0xBQWtCLHNCQUFlLEtBQUMsd0xBQXNCLG9CQUFhLEtBQUM7SUFGbEgsaUJBRW1IO0lBQ25ILDhCQUN5QjtJQU92QixBQU5BLHdFQUFvRCwyREFNaEM7SUFJeEIsQUFERSxpQkFBTSxFQUNGOzs7SUFmdUUsY0FBZ0Y7SUFDNUgsQUFENEMsZ0dBQWdGLCtEQUNyRTtJQUV0QixlQUErQztJQUEvQyxpRkFBK0M7SUFFekYsY0FBaUI7SUFBakIsNkNBQWlCO0lBTWhDLGNBQWE7SUFBYixxQ0FBYTs7QURNeEIsTUFBTSxPQUFPLGtCQUFrQjtJQWtCN0IsWUFDRSxXQUF3QjtRQWQxQixZQUFPLEdBQUcsS0FBSyxDQUFDO1FBQ1AsZ0JBQVcsR0FBVyxFQUFFLENBQUM7UUFDekIsU0FBSSxHQUFXLElBQUksQ0FBQztRQUU3QixpQkFBWSxHQUFhLEVBQUUsQ0FBQztRQUM1QixlQUFVLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ2hDLGtCQUFhLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3RDLHNCQUFpQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBYzlDLFNBQUksR0FBYSxFQUFFLENBQUM7UUFMbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxXQUFXLENBQUMsS0FBSyxDQUFDO1lBQ2pDLFVBQVUsRUFBRSxDQUFDLEVBQUUsQ0FBQztTQUNqQixDQUFDLENBQUM7SUFDTCxDQUFDO0lBSUQsMEJBQTBCO0lBQzFCLGdCQUFnQixDQUFDLEVBQXdCO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsRUFBRSxDQUFDO0lBQ3JCLENBQUM7SUFFRCwyQkFBMkI7SUFDM0IsaUJBQWlCLENBQUMsRUFBYztRQUM5QixJQUFJLENBQUMsU0FBUyxHQUFHLEVBQUUsQ0FBQztJQUN0QixDQUFDO0lBRUQsY0FBYztJQUNkLFVBQVUsQ0FBQyxLQUFVO1FBQ25CLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO1lBQ3pCLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDO1FBQ3BCLENBQUM7SUFDSCxDQUFDO0lBRUQsUUFBUTtRQUNOLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDLElBQUksQ0FDOUIsWUFBWSxDQUFDLEdBQUcsQ0FBQyxFQUNqQixTQUFTLENBQUMsQ0FBQyxNQUFXLEVBQUUsRUFBRTtZQUN4QixJQUFJLE1BQU0sQ0FBQyxVQUFVLEVBQUUsQ0FBQztnQkFDdEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUM3QyxDQUFDO1lBQ0QsT0FBTyxFQUFFLEVBQUUsQ0FBQztRQUNkLENBQUMsQ0FBQyxDQUNILENBQUMsU0FBUyxFQUFFLENBQUM7SUFDaEIsQ0FBQztJQUVELFdBQVcsQ0FBQyxVQUFrQjtRQUM1QixJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQztRQUNwQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQ3JELFNBQVMsQ0FBQyxDQUFDLFVBQWtCLEVBQUUsRUFBRTtZQUMvQixVQUFVLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUM7WUFDdEMsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUUsR0FBRyxFQUFFO2dCQUM5QyxNQUFNLEVBQUUsVUFBVTthQUNuQixDQUFDLENBQUMsSUFBSSxDQUNMLEdBQUcsQ0FBQyxDQUFDLElBQVcsRUFBRSxFQUFFO2dCQUNsQixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxTQUF5QixFQUFFLEVBQUUsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBVyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNuSSxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztnQkFDckIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDLG9CQUFvQjtnQkFDMUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQ3pDLENBQUMsQ0FBQyxDQUNILENBQUM7UUFDSixDQUFDLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELEtBQUs7UUFDSCxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFFRCxPQUFPLENBQUMsS0FBWTtRQUNsQixLQUFLLENBQUMsY0FBYyxFQUFFLENBQUM7UUFDdkIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQsTUFBTSxDQUFDLEdBQVc7UUFDaEIsSUFBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQ1IsT0FBTztRQUNULENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUM7WUFDbEMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDdEIsQ0FBQztRQUNELElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxFQUFFLFFBQVEsQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUMvQyxJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUNsQixJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMzQixDQUFDO1FBQ0QsSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUM7UUFDMUIsSUFBSSxDQUFDLFlBQVksR0FBRyxFQUFFLENBQUM7UUFDdkIsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDbkIsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBQ25CLENBQUM7SUFDSCxDQUFDO0lBRUQsa0JBQWtCO1FBQ2hCLFVBQVUsQ0FBQyxHQUFHLEVBQUU7WUFDZCxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUN2QyxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWEsQ0FBQyxNQUFNLEVBQUUsQ0FBQztRQUMxQyxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxXQUFXLENBQUMsS0FBYTtRQUN2QixJQUFJLEtBQUssS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDO1lBQ2pCLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1FBQzVCLENBQUM7UUFDRCxJQUFJLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxhQUFhLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDdkQsQ0FBQztJQUVELFdBQVc7UUFDVCxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUM7WUFDN0MsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDbEQsQ0FBQztJQUNILENBQUM7SUFFRCxTQUFTLENBQUMsR0FBVztRQUNuQixNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNyQyxJQUFJLEtBQUssS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDO1lBQ2pCLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQUM3QixDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDbEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDM0IsQ0FBQztRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ25CLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUNuQixDQUFDO0lBQ0gsQ0FBQzttSEF0SVUsa0JBQWtCO29FQUFsQixrQkFBa0I7OzJCQUVsQixXQUFXOzJCQUNSLGVBQWUsS0FBUyxVQUFVOzs7Ozs7a0pBWHJDLENBQUM7b0JBQ1YsT0FBTyxFQUFFLGlCQUFpQjtvQkFDMUIsV0FBVyxFQUFFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQztvQkFDakQsS0FBSyxFQUFFLElBQUk7aUJBQ1osQ0FBQztZQ3JCSiw4QkFBeUs7WUFBMUIsNEZBQVMsaUJBQWEsQ0FBQyxDQUFDLElBQUM7WUFDdEssOEJBQTRCO1lBQzFCLHFFQUFnRDtZQUlsRCxpQkFBTTtZQUNOLG9FQUE0RTtZQWtCOUUsaUJBQU07O1lBekJpSCxBQUFqRiwwRkFBZ0YsNEJBQXdCO1lBRXBILGVBQU87WUFBUCxrQ0FBTzs0QkRxQnJCLFlBQVksRUFBRSxZQUFZLG1DQUFFLG1CQUFtQixtSEFBRSxpQkFBaUIsZ0ZBQUUsZUFBZTs7aUZBRWxGLGtCQUFrQjtjQVo5QixTQUFTOzJCQUNFLDRCQUE0QixhQUczQixDQUFDO3dCQUNWLE9BQU8sRUFBRSxpQkFBaUI7d0JBQzFCLFdBQVcsRUFBRSxVQUFVLENBQUMsR0FBRyxFQUFFLG1CQUFtQixDQUFDO3dCQUNqRCxLQUFLLEVBQUUsSUFBSTtxQkFDWixDQUFDLGNBQ1UsSUFBSSxXQUNQLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxtQkFBbUIsRUFBRSxpQkFBaUIsRUFBRSxlQUFlLENBQUM7NENBR3BFLFdBQVc7a0JBQXBDLFNBQVM7bUJBQUMsYUFBYTtZQUNBLFFBQVE7a0JBQS9CLFNBQVM7bUJBQUMsV0FBVztZQUM2QixhQUFhO2tCQUEvRCxZQUFZO21CQUFDLGVBQWUsRUFBRSxFQUFDLElBQUksRUFBRSxVQUFVLEVBQUM7WUFHeEMsV0FBVztrQkFBbkIsS0FBSztZQUNHLElBQUk7a0JBQVosS0FBSztZQUNHLFdBQVc7a0JBQW5CLEtBQUs7O2tGQVJLLGtCQUFrQiIsInNvdXJjZXNDb250ZW50IjpbIi8qIENvcHlyaWdodCBzdGFydFxuICBDb3B5cmlnaHQgKEMpIDIwMDggLSAyMDI1IEZvcnRpbmV0IEluYy5cbiAgQWxsIHJpZ2h0cyByZXNlcnZlZC5cbiAgRk9SVElORVQgQ09ORklERU5USUFMICYgRk9SVElORVQgUFJPUFJJRVRBUlkgU09VUkNFIENPREVcbiAgQ29weXJpZ2h0IGVuZCAqL1xuaW1wb3J0IHsgQ29tbW9uTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uJztcbmltcG9ydCB7IENoYW5nZURldGVjdG9yUmVmLCBDb21wb25lbnQsIEVsZW1lbnRSZWYsIElucHV0LCBPbkluaXQsIFF1ZXJ5TGlzdCwgVmlld0NoaWxkLCBWaWV3Q2hpbGRyZW4sIGZvcndhcmRSZWYsIGluamVjdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQ29udHJvbFZhbHVlQWNjZXNzb3IsIEZvcm1CdWlsZGVyLCBGb3JtR3JvdXAsIE5HX1ZBTFVFX0FDQ0VTU09SLCBSZWFjdGl2ZUZvcm1zTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvZm9ybXMnO1xuaW1wb3J0IHsgUm91dGVyTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvcm91dGVyJztcbmltcG9ydCB7IE5nYkRyb3Bkb3duLCBOZ2JEcm9wZG93bkl0ZW0sIE5nYkRyb3Bkb3duTW9kdWxlIH0gZnJvbSAnQG5nLWJvb3RzdHJhcC9uZy1ib290c3RyYXAnO1xuaW1wb3J0IHsgVHJhbnNsb2NvTW9kdWxlIH0gZnJvbSAnQGpzdmVyc2UvdHJhbnNsb2NvJztcbmltcG9ydCB7IGNvbmNhdE1hcCwgZGVib3VuY2VUaW1lLCBtYXAsIG9mIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBFbnRpdHkgfSBmcm9tICcuLi8uLi9jb3JlL21vZGVscy9lbnRpdHknO1xuaW1wb3J0IHsgVGFnIH0gZnJvbSAnLi4vLi4vY29yZS9tb2RlbHMvdGFnJztcbmltcG9ydCB7IEFwaVNlcnZpY2UgfSBmcm9tICcuLi8uLi9jb3JlL3NlcnZpY2VzL2FwaS5zZXJ2aWNlJztcbmltcG9ydCB7IEVudGl0eVNlcnZpY2UgfSBmcm9tICcuLi8uLi9jb3JlL3NlcnZpY2VzL2VudGl0eS5zZXJ2aWNlJztcbmltcG9ydCB7IEZJWEVEX01PRFVMRSB9IGZyb20gJy4uLy4uL2NvcmUvY29uc3RhbnRzJztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAneGYtdGFncy1pbnB1dFt0YWdzQmFzZVVybF0nLFxuICB0ZW1wbGF0ZVVybDogJy4vdGFncy1pbnB1dC5jb21wb25lbnQuaHRtbCcsXG4gIHN0eWxlVXJsczogWycuL3RhZ3MtaW5wdXQuY29tcG9uZW50LnNjc3MnXSxcbiAgcHJvdmlkZXJzOiBbe1xuICAgIHByb3ZpZGU6IE5HX1ZBTFVFX0FDQ0VTU09SLFxuICAgIHVzZUV4aXN0aW5nOiBmb3J3YXJkUmVmKCgpID0+IFRhZ3NJbnB1dENvbXBvbmVudCksXG4gICAgbXVsdGk6IHRydWVcbiAgfV0sXG4gIHN0YW5kYWxvbmU6IHRydWUsXG4gIGltcG9ydHM6IFtSb3V0ZXJNb2R1bGUsIENvbW1vbk1vZHVsZSwgUmVhY3RpdmVGb3Jtc01vZHVsZSwgTmdiRHJvcGRvd25Nb2R1bGUsIFRyYW5zbG9jb01vZHVsZV1cbn0pXG5leHBvcnQgY2xhc3MgVGFnc0lucHV0Q29tcG9uZW50IGltcGxlbWVudHMgQ29udHJvbFZhbHVlQWNjZXNzb3IsIE9uSW5pdCB7XG4gIEBWaWV3Q2hpbGQoJ3NlYXJjaElucHV0Jykgc2VhcmNoSW5wdXQhOiBFbGVtZW50UmVmO1xuICBAVmlld0NoaWxkKE5nYkRyb3Bkb3duKSBkcm9wZG93biE6IE5nYkRyb3Bkb3duO1xuICBAVmlld0NoaWxkcmVuKE5nYkRyb3Bkb3duSXRlbSwge3JlYWQ6IEVsZW1lbnRSZWZ9KSBkcm9wZG93bkl0ZW1zITogUXVlcnlMaXN0PEVsZW1lbnRSZWY+O1xuICBmb3JtR3JvdXA6IEZvcm1Hcm91cDtcbiAgbG9hZGluZyA9IGZhbHNlO1xuICBASW5wdXQoKSBwbGFjZWhvbGRlcjogc3RyaW5nID0gJyc7XG4gIEBJbnB1dCgpIHNpemU6IHN0cmluZyA9ICdzbSc7XG4gIEBJbnB1dCgpIHRhZ3NCYXNlVXJsITogc3RyaW5nO1xuICBmaWx0ZXJlZFRhZ3M6IHN0cmluZ1tdID0gW107XG4gIGFwaVNlcnZpY2UgPSBpbmplY3QoQXBpU2VydmljZSk7XG4gIGVudGl0eVNlcnZpY2UgPSBpbmplY3QoRW50aXR5U2VydmljZSk7XG4gIGNoYW5nZURldGVjdG9yUmVmID0gaW5qZWN0KENoYW5nZURldGVjdG9yUmVmKTtcblxuICBwcml2YXRlIG9uQ2hhbmdlPzogKHZhbHVlOiBhbnkpID0+IHZvaWQ7XG4gIHByaXZhdGUgb25Ub3VjaGVkPzogKCkgPT4gdm9pZDtcblxuXG4gIGNvbnN0cnVjdG9yKFxuICAgIGZvcm1CdWlsZGVyOiBGb3JtQnVpbGRlclxuICApIHtcbiAgICB0aGlzLmZvcm1Hcm91cCA9IGZvcm1CdWlsZGVyLmdyb3VwKHtcbiAgICAgIHNlYXJjaFRleHQ6IFsnJ11cbiAgICB9KTtcbiAgfVxuXG4gIHRhZ3M6IHN0cmluZ1tdID0gW107XG5cbiAgLy8gUmVnaXN0ZXIgY2hhbmdlIGhhbmRsZXJcbiAgcmVnaXN0ZXJPbkNoYW5nZShmbjogKHZhbHVlOiBhbnkpID0+IHZvaWQpOiB2b2lkIHtcbiAgICB0aGlzLm9uQ2hhbmdlID0gZm47XG4gIH1cblxuICAvLyBSZWdpc3RlciB0b3VjaGVkIGhhbmRsZXJcbiAgcmVnaXN0ZXJPblRvdWNoZWQoZm46ICgpID0+IHZvaWQpOiB2b2lkIHtcbiAgICB0aGlzLm9uVG91Y2hlZCA9IGZuO1xuICB9XG5cbiAgLy8gV3JpdGUgdmFsdWVcbiAgd3JpdGVWYWx1ZSh2YWx1ZTogYW55KTogdm9pZCB7XG4gICAgaWYgKEFycmF5LmlzQXJyYXkodmFsdWUpKSB7XG4gICAgICB0aGlzLnRhZ3MgPSB2YWx1ZTtcbiAgICB9XG4gIH1cblxuICBuZ09uSW5pdCgpIHtcbiAgICB0aGlzLmZvcm1Hcm91cC52YWx1ZUNoYW5nZXMucGlwZShcbiAgICAgIGRlYm91bmNlVGltZSgzMDApLFxuICAgICAgY29uY2F0TWFwKCh2YWx1ZXM6IGFueSkgPT4ge1xuICAgICAgICBpZiAodmFsdWVzLnNlYXJjaFRleHQpIHtcbiAgICAgICAgICByZXR1cm4gdGhpcy5hcHBseVNlYXJjaCh2YWx1ZXMuc2VhcmNoVGV4dCk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG9mKCk7XG4gICAgICB9KVxuICAgICkuc3Vic2NyaWJlKCk7XG4gIH1cblxuICBhcHBseVNlYXJjaChzZWFyY2hUZXh0OiBzdHJpbmcpIHtcbiAgICB0aGlzLmxvYWRpbmcgPSB0cnVlO1xuICAgIHJldHVybiB0aGlzLmVudGl0eVNlcnZpY2UuYnVpbGQoRklYRURfTU9EVUxFLlRBR1MpLnBpcGUoXG4gICAgICBjb25jYXRNYXAoKHRhZ3NFbnRpdHk6IEVudGl0eSkgPT4ge1xuICAgICAgICB0YWdzRW50aXR5LmJhc2VVcmwgPSB0aGlzLnRhZ3NCYXNlVXJsO1xuICAgICAgICByZXR1cm4gdGhpcy5hcGlTZXJ2aWNlLmdldExpc3QodGFnc0VudGl0eSwgVGFnLCB7XG4gICAgICAgICAgc2VhcmNoOiBzZWFyY2hUZXh0XG4gICAgICAgIH0pLnBpcGUoXG4gICAgICAgICAgbWFwKCh0YWdzOiBUYWdbXSkgPT4ge1xuICAgICAgICAgICAgdGhpcy5maWx0ZXJlZFRhZ3MgPSB0YWdzLm1hcCgodGFnT2JqZWN0OiB7bmFtZTogc3RyaW5nfSkgPT4gdGFnT2JqZWN0Lm5hbWUpLmZpbHRlcigodGFnOiBzdHJpbmcpID0+IHRoaXMudGFncy5pbmRleE9mKHRhZykgPT09IC0xKTtcbiAgICAgICAgICAgIHRoaXMubG9hZGluZyA9IGZhbHNlO1xuICAgICAgICAgICAgdGhpcy5kcm9wZG93bi5vcGVuKCk7IC8vIEVuc3VyZSBpdCBpcyBvcGVuXG4gICAgICAgICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgICAgICAgICB9KVxuICAgICAgICApO1xuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgb25UYWIoKSB7XG4gICAgdGhpcy5hZGRUYWcodGhpcy5mb3JtR3JvdXAuZ2V0KCdzZWFyY2hUZXh0Jyk/LnZhbHVlKTtcbiAgfVxuXG4gIG9uRW50ZXIoZXZlbnQ6IEV2ZW50KSB7XG4gICAgZXZlbnQucHJldmVudERlZmF1bHQoKTtcbiAgICB0aGlzLmFkZFRhZyh0aGlzLmZvcm1Hcm91cC5nZXQoJ3NlYXJjaFRleHQnKT8udmFsdWUpO1xuICB9XG5cbiAgYWRkVGFnKHRhZzogc3RyaW5nKSB7XG4gICAgaWYoIXRhZykge1xuICAgICAgcmV0dXJuO1xuICAgIH1cbiAgICBpZiAodGhpcy50YWdzLmluZGV4T2YodGFnKSA9PT0gLTEpIHtcbiAgICAgIHRoaXMudGFncy5wdXNoKHRhZyk7XG4gICAgfVxuICAgIHRoaXMuZm9ybUdyb3VwLmdldCgnc2VhcmNoVGV4dCcpPy5zZXRWYWx1ZSgnJyk7XG4gICAgaWYgKHRoaXMub25DaGFuZ2UpIHtcbiAgICAgIHRoaXMub25DaGFuZ2UodGhpcy50YWdzKTtcbiAgICB9XG4gICAgdGhpcy5mb2N1c09uU2VhcmNoSW5wdXQoKTtcbiAgICB0aGlzLmZpbHRlcmVkVGFncyA9IFtdO1xuICAgIGlmICh0aGlzLm9uVG91Y2hlZCkge1xuICAgICAgdGhpcy5vblRvdWNoZWQoKTtcbiAgICB9XG4gIH1cblxuICBmb2N1c09uU2VhcmNoSW5wdXQoKSB7XG4gICAgc2V0VGltZW91dCgoKSA9PiB7XG4gICAgICB0aGlzLnNlYXJjaElucHV0Lm5hdGl2ZUVsZW1lbnQuZm9jdXMoKTtcbiAgICAgIHRoaXMuc2VhcmNoSW5wdXQubmF0aXZlRWxlbWVudC5zZWxlY3QoKTtcbiAgICB9KTtcbiAgfVxuXG4gIGZvY3VzT25JdGVtKGluZGV4OiBudW1iZXIpIHtcbiAgICBpZiAoaW5kZXggPT09IC0xKSB7XG4gICAgICB0aGlzLmZvY3VzT25TZWFyY2hJbnB1dCgpO1xuICAgIH1cbiAgICB0aGlzLmRyb3Bkb3duSXRlbXMuZ2V0KGluZGV4KT8ubmF0aXZlRWxlbWVudC5mb2N1cygpO1xuICB9XG5cbiAgb25CYWNrc3BhY2UoKSB7XG4gICAgaWYgKCF0aGlzLmZvcm1Hcm91cC5nZXQoJ3NlYXJjaFRleHQnKT8udmFsdWUpIHtcbiAgICAgIHRoaXMucmVtb3ZlVGFnKHRoaXMudGFnc1t0aGlzLnRhZ3MubGVuZ3RoIC0gMV0pO1xuICAgIH1cbiAgfVxuXG4gIHJlbW92ZVRhZyh0YWc6IHN0cmluZyk6IHZvaWQge1xuICAgIGNvbnN0IGluZGV4ID0gdGhpcy50YWdzLmluZGV4T2YodGFnKTtcbiAgICBpZiAoaW5kZXggIT09IC0xKSB7XG4gICAgICB0aGlzLnRhZ3Muc3BsaWNlKGluZGV4LCAxKTtcbiAgICB9XG4gICAgaWYgKHRoaXMub25DaGFuZ2UpIHtcbiAgICAgIHRoaXMub25DaGFuZ2UodGhpcy50YWdzKTtcbiAgICB9XG4gICAgaWYgKHRoaXMub25Ub3VjaGVkKSB7XG4gICAgICB0aGlzLm9uVG91Y2hlZCgpO1xuICAgIH1cbiAgfVxuXG5cblxufVxuIiwiPCEtLSBDb3B5cmlnaHQgc3RhcnRcbiAgQ29weXJpZ2h0IChDKSAyMDA4IC0gMjAyNSBGb3J0aW5ldCBJbmMuXG4gIEFsbCByaWdodHMgcmVzZXJ2ZWQuXG4gIEZPUlRJTkVUIENPTkZJREVOVElBTCAmIEZPUlRJTkVUIFBST1BSSUVUQVJZIFNPVVJDRSBDT0RFXG4gIENvcHlyaWdodCBlbmQgLS0+XG48ZGl2IGNsYXNzPVwiZm9ybS1jb250cm9sIHBhZGRpbmctMHB4XCIgW25nQ2xhc3NdPVwieydmb3JtLWNvbnRyb2wtc20nOiBzaXplID09PSAnc20nLCAnZm9ybS1jb250cm9sLXhzJzogc2l6ZSA9PT0gJ3hzJ31cIiBbZm9ybUdyb3VwXT1cImZvcm1Hcm91cFwiIChjbGljayk9XCJmb2N1c09uSXRlbSgtMSlcIj5cbiAgPGRpdiBjbGFzcz1cImQtaW5saW5lLWJsb2NrXCI+XG4gICAgPHNwYW4gKm5nRm9yPVwibGV0IHRhZyBvZiB0YWdzXCIgY2xhc3M9XCJ0YWctY2hpcFwiPlxuICAgICAge3sgdGFnIH19XG4gICAgICA8YnV0dG9uIHR5cGU9XCJidXR0b25cIiBjbGFzcz1cImNsb3NlXCIgKGNsaWNrKT1cInJlbW92ZVRhZyh0YWcpXCI+JnRpbWVzOzwvYnV0dG9uPlxuICAgIDwvc3Bhbj5cbiAgPC9kaXY+XG4gIDxkaXYgbmdiRHJvcGRvd24gKnRyYW5zbG9jbz1cImxldCB0XCIgY29udGFpbmVyPVwiYm9keVwiIGNsYXNzPVwiZC1pbmxpbmUtYmxvY2tcIj5cbiAgICA8aW5wdXQgdHlwZT1cInRleHRcIiBjbGFzcz1cImxvb2t1cC1zZWFyY2ggYm9yZGVyLTAgc2hhZG93LW5vbmUgZm9ybS1jb250cm9sXCIgW25nQ2xhc3NdPVwieydmb3JtLWNvbnRyb2wtc20nOiBzaXplID09PSAnc20nLCAnZm9ybS1jb250cm9sLXhzJzogc2l6ZSA9PT0gJ3hzJ31cIiBpZD1cInNlYXJjaERyb3Bkb3duXCIgI3NlYXJjaElucHV0XG4gICAgICBmb3JtQ29udHJvbE5hbWU9XCJzZWFyY2hUZXh0XCIgW3BsYWNlaG9sZGVyXT1cInBsYWNlaG9sZGVyIHx8ICdQcmVzcyBUYWIgdG8gYWRkIGEgdGFnJ1wiIG5nYkRyb3Bkb3duVG9nZ2xlIChrZXl1cC5hcnJvd2Rvd24pPVwiZm9jdXNPbkl0ZW0oMClcIlxuICAgICAgYXV0b2NvbXBsZXRlPVwib2ZmXCIgKGtleWRvd24udGFiKT1cIm9uVGFiKClcIiAoa2V5ZG93bi5lbnRlcik9XCJvbkVudGVyKCRldmVudClcIiAoa2V5ZG93bi5iYWNrc3BhY2UpPVwib25CYWNrc3BhY2UoKVwiPlxuICAgIDxkaXYgbmdiRHJvcGRvd25NZW51IGNsYXNzPVwiZHJvcGRvd24tbWVudSBteC0wIGJvcmRlci0wIHNoYWRvd1wiIFtuZ0NsYXNzXT1cInsnaW52aXNpYmxlJzogIWZpbHRlcmVkVGFncy5sZW5ndGh9XCJcbiAgICAgIGFyaWEtbGFiZWxsZWRieT1cInRhZ3NcIj5cbiAgICAgIDxsaSAqbmdGb3I9XCJsZXQgdGFnIG9mIGZpbHRlcmVkVGFnczsgbGV0IGkgPSBpbmRleFwiPlxuICAgICAgICA8YSBuZ2JEcm9wZG93bkl0ZW0gaWQ9XCJjbG9uZS1jb2xsZWN0aW9uLWJ0blwiIGNsYXNzPVwiY3Vyc29yLXBvaW50ZXJcIiAoY2xpY2spPVwiYWRkVGFnKHRhZylcIlxuICAgICAgICAgIChrZXlkb3duLmVudGVyKT1cImFkZFRhZyh0YWcpXCIgKGtleWRvd24uYXJyb3d1cCk9XCJmb2N1c09uSXRlbShpIC0gMSlcIiAoa2V5ZG93bi5hcnJvd2Rvd24pPVwiZm9jdXNPbkl0ZW0oaSArIDEpXCI+XG4gICAgICAgICAge3sgdCh0YWcpIH19XG4gICAgICAgIDwvYT5cbiAgICAgIDwvbGk+XG4gICAgICA8bGkgKm5nSWY9XCJsb2FkaW5nXCI+XG4gICAgICAgIDxkaXYgY2xhc3M9XCJiZy1zaGltbWVyIGNvbnRlbnQtbGluZVwiPjwvZGl2PlxuICAgICAgPC9saT5cbiAgICA8L2Rpdj5cbiAgPC9kaXY+XG5cbjwvZGl2PlxuIl19