/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { isArray, isNumber, isString } from "lodash-es";
export class Bitmask {
    constructor(value, padding = 8) {
        this.padding = padding;
        if (isNumber(value) || isString(value)) {
            this.integer = parseInt(value, padding);
            this.bits = this.integerToArray(this.integer, padding);
        }
        else if (isArray(value)) {
            this.bits = value.map((el) => { return parseInt(el) & 1; });
            this.integer = this.arrayToInteger(this.bits);
        }
        else {
            throw "Constructor needs either a number or an array o bits";
        }
    }
    getInteger() {
        return this.integer;
    }
    getBits() {
        return this.bits;
    }
    hasBit(bit) {
        return this.bits[bit] & 1;
    }
    setBit(bit, status) {
        status = status === true ? 1 : 0;
        this.bits[bit] = status;
        this.integer = this.arrayToInteger(this.bits);
    }
    toggleBit(bit) {
        let status = !(this.hasBit(bit));
        this.setBit(bit, status);
    }
    rShift(positions) {
        positions = positions || 1;
        this.integer = this.integer >> positions;
        this.bits = this.integerToArray(this.integer, this.padding);
    }
    lShift(positions) {
        positions = positions || 1;
        this.integer = this.integer << positions;
        this.bits = this.integerToArray(this.integer, this.padding);
    }
    integerToArray(integer, padding) {
        let bits = [];
        while (integer !== 0) {
            bits.push(integer & 1);
            integer = integer >> 1;
            padding--;
        }
        while (padding-- > 0) {
            bits.push(0);
        }
        return bits;
    }
    arrayToInteger(array) {
        return array.reduce((p, c, i) => { return p + Math.pow(2, i) * c; });
    }
}
//# sourceMappingURL=data:application/json;base64,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