import { __decorate } from "tslib";
/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Expose, Transform } from "class-transformer";
import { forEach } from "lodash-es";
export class ConnectorFieldRendererParameter {
    constructor(name, type, renderer_type) {
        this.title = '';
        this.description = '';
        this.tooltip = '';
        this.apiOperation = '';
        this.visible = true;
        this.editable = false;
        this.required = false;
        this.placeholder = '';
        this.options = [];
        this.onchange = {};
        this.name = name;
        this.formType = renderer_type || type;
    }
}
__decorate([
    Expose({ name: 'type' })
], ConnectorFieldRendererParameter.prototype, "formType", void 0);
__decorate([
    Transform(({ value }) => {
        let values = [];
        if (typeof value[0] === 'string') {
            forEach(value, (option) => {
                values.push({ label: option, value: option });
            });
            return values;
        }
        return value;
    }, { toClassOnly: true })
], ConnectorFieldRendererParameter.prototype, "options", void 0);
export class ConnectorActionRendererField extends ConnectorFieldRendererParameter {
    constructor() {
        super(...arguments);
        this._jinjaEnabled = false;
        this.parameters = [];
    }
}
//# sourceMappingURL=data:application/json;base64,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