import { plainToInstance } from "class-transformer";
import { InputFieldComponent } from "../../form-fields/field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../../form-fields/field-renderers/built-ins/input/input-view.component";
import { Filter } from "../../query-filters/models/filter";
import { Operator } from "../../query-filters/models/operator";
import { Query } from "../../query-filters/models/query";
import { SearchableItem } from "../../components/searchable-dropdown/searchable-item";
import { DatetimeFieldComponent } from "../../form-fields/field-renderers/built-ins/datetime/datetime-field/datetime-field.component";
import { CheckboxFieldComponent } from "../../form-fields/field-renderers/built-ins/checkbox/checkbox-field.component";
export class Field {
    get visibility() {
        return this._visibility;
    }
    set visibility(value) {
        if (Array.isArray(value)) {
            value = value[0];
        }
        this._visibility = plainToInstance(Query, value);
    }
    getFlatValue(value, operator) {
        return value;
    }
    getViewValue(value) {
        return value;
    }
    static { this.listOperators = [
        new Operator('in', 'Is In List', null, this.evaluateIsInList),
        new Operator('nin', 'Is Not In List', null, this.evaluateIsNotInList),
    ]; }
    static { this.nullOperator = [
        new Operator('isnull', 'Is Null', CheckboxFieldComponent, this.evaluateIsNull),
    ]; }
    static { this.equalOperators = [
        new Operator('eq', 'Equals', InputFieldComponent, this.evaluateEqual),
        new Operator('neq', 'Not Equals', InputFieldComponent, this.evaluateNotEqual),
    ]; }
    static { this.greaterThanLessThanOperators = [
        new Operator('lt', 'Before', DatetimeFieldComponent, this.evaluateBefore),
        new Operator('lte', 'On or Before', DatetimeFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'After', DatetimeFieldComponent, this.evaluateAfter),
        new Operator('gte', 'On or After', DatetimeFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.numericGreaterThanLessThanOperators = [
        new Operator('lt', 'Less Than', InputFieldComponent, this.evaluateBefore),
        new Operator('lte', 'Less Than or Equal To', InputFieldComponent, this.evaluateOnOrBefore),
        new Operator('gt', 'Greater Than', InputFieldComponent, this.evaluateAfter),
        new Operator('gte', 'Greater Than or Equal To', InputFieldComponent, this.evaluateOnOrAfter),
    ]; }
    static { this.operators = this.equalOperators; }
    getOperator(operatorId) {
        return this.operators.find((op) => {
            return op.id === operatorId;
        });
    }
    get operators() {
        return Object.getPrototypeOf(this).constructor.operators;
    }
    constructor(name, formType) {
        this.defaultValue = '';
        this.blankDisplay = '';
        this.title = '';
        this.type = '';
        this.encrypted = false;
        this.gridColumn = false;
        this.orderIndex = 0;
        this.peerReplicable = false;
        this.htmlEscape = false;
        this.inversedField = null;
        this.ownsRelationship = false;
        this.recommend = false;
        this.searchable = false;
        this.system = false;
        this.tooltip = '';
        this.subtitle = '';
        this.validation = {
            required: false
        };
        this._visibility = true;
        this.writeable = true;
        this.visible = true;
        this.required = false;
        this.isFormField = false;
        this.isRelationship = false;
        this.displayTemplate = '';
        this.readOnly = false;
        this.trackable = false;
        this.placeholder = '';
        this.OPERATOR_KEY = '$';
        this.fieldContainerClass = ''; //for field container class like specific width (w-50, w-70) or col-md-6
        this.orphanRemoval = false;
        this.allowJinjaToggle = false;
        this.alwaysJinja = false;
        this.filter = Filter; //ArrayFilter|ObjectFilter
        this.params = {};
        this.mapping = {};
        //private _relationshipFields = ['manyToMany', 'oneToMany'];
        this.alwaysEditMode = false;
        this.name = name;
        this.formType = formType;
        this.descriptions = {
            singular: ''
        };
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    get descriptions() {
        return this._descriptions;
    }
    set descriptions(value) {
        this._descriptions = value;
        if (this._descriptions) {
            this.title = this._descriptions.singular || this.name;
        }
        else {
            this.title = this.title || this.name;
        }
    }
    get dataSource() {
        return this._dataSource;
    }
    set dataSource(value) {
        this._dataSource = value;
    }
    setMode(mode) {
        this.visibility = mode === 'archived' ? true : this.visibility;
        if (mode === 'archived') {
            this.visible = true;
            this.validation.required = false;
        }
        else {
            //this.evaluateRequired();
            //this.evaluateVisible();
        }
    }
    static evaluateIsInList(field, value) {
        return false;
    }
    static evaluateIsNotInList(field, value) {
        return false;
    }
    static evaluateIsNull(field, value) {
        return false;
    }
    ;
    static evaluateEqual(field, value) {
        return false;
    }
    static evaluateNotEqual(field, value) {
        return false;
    }
    static evaluateBefore(field, value) {
        return false;
    }
    static evaluateOnOrBefore(field, value) {
        return false;
    }
    static evaluateAfter(field, value) {
        return false;
    }
    static evaluateOnOrAfter(field, value) {
        return false;
    }
    asSearchableItem() {
        return new SearchableItem(this.title, this, this.name);
    }
    buildSort(order) {
        const sort = [];
        if (this.name === '@id') {
            sort.push({
                field: 'id',
                direction: order,
                _fieldName: this.name
            });
        }
        else if (!this.model) {
            sort.push({
                field: this.name,
                direction: order,
                _fieldName: this.name
            });
            return sort;
        }
        else if (this.defaultSort) {
            this.defaultSort.forEach((sortItem) => {
                sort.push({
                    field: this.name + '.' + sortItem.field,
                    direction: order,
                    _fieldName: this.name
                });
            });
        }
        return sort;
    }
    ;
    getURLQueryValue(value, operator) {
        let query = {};
        let _operator = operator.id === 'like_pattern' ? 'like' : operator.id;
        _operator = operator.id === 'notlike_pattern' ? 'notlike' : operator.id;
        query[`${this.name}${this.OPERATOR_KEY}${_operator}`] = this.getFlatValue(value, operator);
        return query;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: -1
        };
    }
}
(function (Field) {
    let BuiltInType;
    (function (BuiltInType) {
        BuiltInType["TEXT"] = "text";
        BuiltInType["PASSWORD"] = "password";
        BuiltInType["INTEGER"] = "integer";
        BuiltInType["DECIMAL"] = "decimal";
        BuiltInType["CHECKBOX"] = "checkbox";
        BuiltInType["EMAIL"] = "email";
        BuiltInType["DATETIME"] = "datetime";
        BuiltInType["LOOKUP"] = "lookup";
        BuiltInType["MULTISELECT_PICKLIST"] = "multiselectpicklist";
        BuiltInType["PICKLIST"] = "picklist";
        BuiltInType["MANY_TO_MANY"] = "manyToMany";
        BuiltInType["ONE_TO_MANY"] = "oneToMany";
        BuiltInType["FILE"] = "file";
        BuiltInType["JSON"] = "json";
        BuiltInType["JINJA"] = "jinja";
        BuiltInType["ARRAY"] = "array";
        BuiltInType["PHONE"] = "phone";
        BuiltInType["DOMAIN"] = "domain";
        BuiltInType["FILEHASH"] = "fileHash";
        BuiltInType["IPv4"] = "ipv4";
        BuiltInType["IPv6"] = "ipv6";
        BuiltInType["RICHTEXTHTML"] = "html";
        BuiltInType["RICHTEXTMARKDOWN"] = "richtext";
        BuiltInType["TEXTAREA"] = "textarea";
        BuiltInType["URL"] = "url";
        BuiltInType["TAGS"] = "tags";
        BuiltInType["SELECT"] = "select";
        BuiltInType["MULTISELECT"] = "multiselect";
        BuiltInType["RADIO"] = "radio";
        BuiltInType["TOGGLE"] = "toggle";
        BuiltInType["MULTISELECTCHECKBOXDROPDOWN"] = "multiSelectCheckboxDropdown";
        BuiltInType["TOGGLEDROPDOWN"] = "toggleDropdown";
        BuiltInType["CERTIFICATE"] = "certificate";
    })(BuiltInType = Field.BuiltInType || (Field.BuiltInType = {}));
})(Field || (Field = {}));
//# sourceMappingURL=data:application/json;base64,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