import { __decorate } from "tslib";
/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Expose, Type } from "class-transformer";
import { API, FIXED_MODULE } from "../constants";
import { RecordTypeRule } from "./record-type-rule";
export class Rule {
    constructor(name) {
        this.recordTypeRules = [];
        this.recordTypes = [];
        this.isActive = false;
        this.eventSource = 'workflow';
        this.modules = '';
        this.actions = [];
        this.name = name;
    }
    get iri() {
        return `${API.RULE_ENGINE}${FIXED_MODULE.RULE}/${this.uuid}/`;
    }
    asSaved() {
        return {
            uuid: this.uuid,
            name: this.name,
            entity_type: this.entityType,
            event_type: this.eventType,
            trigger_condition: this.triggerCondition,
            actions: this.actions,
            is_active: this.isActive,
            event_source: this.eventSource
        };
    }
}
__decorate([
    Type(() => RecordTypeRule)
], Rule.prototype, "recordTypeRules", void 0);
__decorate([
    Expose({ name: 'entity_type' })
], Rule.prototype, "entityType", void 0);
__decorate([
    Expose({ name: 'event_type' })
], Rule.prototype, "eventType", void 0);
__decorate([
    Expose({ name: 'trigger_condition' })
], Rule.prototype, "triggerCondition", void 0);
__decorate([
    Expose({ name: 'is_active' })
], Rule.prototype, "isActive", void 0);
__decorate([
    Expose({ name: 'event_source' })
], Rule.prototype, "eventSource", void 0);
//# sourceMappingURL=data:application/json;base64,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