/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import { difference, intersection, keys } from 'lodash-es';
import { BehaviorSubject, concatMap, filter, of, tap } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "./entity.service";
import * as i2 from "./websocket.service";
export class DataProviderService {
    constructor(entityService, websocketService) {
        this.entityService = entityService;
        this.websocketService = websocketService;
        this.topics$ = {};
        this.websocketTopics$ = {};
    }
    clear() {
        Object.keys(this.topics$).forEach((topic) => {
            if (this.topics$[topic]) {
                this.topics$[topic].complete();
                delete this.topics$[topic];
            }
        });
        Object.keys(this.websocketTopics$).forEach((topic) => {
            if (this.websocketTopics$[topic]) {
                this.websocketTopics$[topic].unsubscribe();
                delete this.websocketTopics$[topic];
            }
        });
    }
    observe(entity, uuid, relatedField, queryObject) {
        let topic = `${entity.type}${uuid ? '/' + uuid : ''}${relatedField ? '/' + relatedField : ''}`;
        if (!this.websocketTopics$[topic]) {
            this.websocketTopics$[topic] = this.websocketService.websocketSubscribe('/topic/' + topic).pipe(concatMap((message) => this.handleWebsocketUpdates(message, topic))).subscribe();
        }
        let selectedFields = queryObject?.selectedFields || ['uuid'];
        if (!this.topics$[topic]) {
            this.topics$[topic] = new BehaviorSubject({
                entity: entity,
                changedFields: selectedFields,
                sourceId: 'entityCache'
            });
        }
        entity = this.topics$[topic].value.entity;
        let newFields = difference(selectedFields ? selectedFields : [], keys(entity.values || {}));
        entity.uuid = uuid;
        return this.getData(topic, entity, newFields).pipe(concatMap(() => this.topics$[topic].pipe(filter((entityChange) => !queryObject?.selectedFields || intersection(entityChange.changedFields, queryObject?.selectedFields).length > 0))));
    }
    save(entityChange) {
        let topic = `${entityChange.entity.type}${entityChange.entity.uuid ? '/' + entityChange.entity.uuid : ''}`;
        return this.entityService.save(entityChange.entity, entityChange.changedFields).pipe(tap((entity) => {
            this.topics$[topic].next({
                entity: entity,
                changedFields: entityChange.changedFields,
                sourceId: 'entityCache'
            });
        }));
    }
    handleWebsocketUpdates(message, topic) {
        if (message.websocketSessionID !== this.websocketService.websocketSessionID && this.topics$[topic].value) {
            let entity = this.topics$[topic].value?.entity;
            let interestedFields = intersection(keys(this.topics$[topic].value?.entity.values || {}), message.data[0].changedata);
            if (interestedFields.length > 0) {
                return this.getData(topic, entity, interestedFields);
            }
        }
        return of(null);
    }
    getData(topic, entity, selectedFields = []) {
        if (!selectedFields.length) {
            return of(entity);
        }
        return this.entityService.hydrate(entity, selectedFields).pipe(tap((updatedEntity) => {
            this.topics$[topic].next({
                entity: updatedEntity,
                changedFields: selectedFields,
                sourceId: 'entityCache'
            });
        }));
    }
    static { this.ɵfac = function DataProviderService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DataProviderService)(i0.ɵɵinject(i1.EntityService), i0.ɵɵinject(i2.WebsocketService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DataProviderService, factory: DataProviderService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DataProviderService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.EntityService }, { type: i2.WebsocketService }], null); })();
//# sourceMappingURL=data:application/json;base64,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