/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import { Filter } from '../../query-filters/models/filter';
import { FilterGroup } from '../../query-filters/models/filter-group';
import * as i0 from "@angular/core";
export class DateService {
    constructor() { }
    buildDateFilterGroup(datetimeFilter, fieldName) {
        let filters = [];
        const currentDate = new Date();
        let date1 = new Date();
        let date2 = new Date();
        switch (datetimeFilter.differenceType) {
            case 'years':
                let startOfYear = new Date(currentDate.getFullYear() + datetimeFilter.differenceValue, 0, 1);
                let endOfYear = new Date(currentDate.getFullYear() + datetimeFilter.differenceValue, 11, 31);
                date1 = startOfYear;
                date2 = endOfYear;
                break;
            case 'months':
                let startOfMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + datetimeFilter.differenceValue, 1);
                let endOfMonth = new Date(currentDate.getFullYear(), currentDate.getMonth() + datetimeFilter.differenceValue + 1, 0);
                let exactTimeAgo = new Date(currentDate);
                exactTimeAgo.setMonth(currentDate.getMonth() + datetimeFilter.differenceValue);
                if (datetimeFilter.differenceValue <= 0) {
                    date1 = datetimeFilter.lastDate ? startOfMonth : exactTimeAgo;
                    date2 = datetimeFilter.lastDate ? endOfMonth : currentDate;
                }
                else {
                    date1 = datetimeFilter.lastDate ? startOfMonth : currentDate;
                    date2 = datetimeFilter.lastDate ? endOfMonth : exactTimeAgo;
                }
                break;
            case 'days':
                if (datetimeFilter.differenceValue <= 0) {
                    date1 = new Date(currentDate);
                    date1.setDate(currentDate.getDate() + datetimeFilter.differenceValue);
                    date1.setHours(0);
                    date1.setMinutes(0);
                    date1.setSeconds(0);
                    date1.setMilliseconds(0);
                    date2 = new Date(currentDate);
                }
                else {
                    date1 = new Date(currentDate);
                    date2 = new Date(currentDate);
                    date2.setDate(currentDate.getDate() + datetimeFilter.differenceValue);
                    date1.setHours(23);
                    date1.setMinutes(59);
                    date1.setSeconds(59);
                    date1.setMilliseconds(999);
                }
                break;
            case 'hours':
                if (datetimeFilter.differenceValue < 0) {
                    date1 = new Date(currentDate);
                    date1.setHours(currentDate.getHours() + datetimeFilter.differenceValue);
                    date2 = new Date(currentDate);
                }
                else {
                    date1 = new Date(currentDate);
                    date2 = new Date(currentDate);
                    date2.setHours(currentDate.getHours() + datetimeFilter.differenceValue);
                }
                break;
            case 'mins':
                if (datetimeFilter.differenceValue < 0) {
                    date1 = new Date(currentDate);
                    date1.setMinutes(currentDate.getMinutes() + datetimeFilter.differenceValue);
                    date2 = new Date(currentDate);
                }
                else {
                    date1 = new Date(currentDate);
                    date2 = new Date(currentDate);
                    date2.setMinutes(currentDate.getMinutes() + datetimeFilter.differenceValue);
                }
                break;
            default:
                console.log('wrong difference type selected');
        }
        filters = [
            new Filter(fieldName, 'gte', date1.toISOString()),
            new Filter(fieldName, 'lte', date2.toISOString())
        ];
        return new FilterGroup(filters);
    }
    static { this.ɵfac = function DateService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DateService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: DateService, factory: DateService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DateService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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