/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import { from, of } from 'rxjs';
import { catchError, concatMap, map } from 'rxjs/operators';
import { DynamicContent } from '../models/dynamic-content';
import { ALL_RECORDS_SIZE, API, FIXED_MODULE } from '../constants';
import { Validators } from '@angular/forms';
import { loadRemoteModule } from '@angular-architects/native-federation';
import * as i0 from "@angular/core";
export class FieldService {
    constructor() {
        this.customFields = {};
        this.http = inject(HttpClient);
    }
    loadDynamicContent(name, type) {
        return of(null); // Dynamic content is not implemented yet in XF
        return this.http.get(API.BASE + FIXED_MODULE.DYNAMIC_CONTENT, {
            params: {
                limit: ALL_RECORDS_SIZE,
                type: type,
                name: name
            }
        }).pipe(map((response) => {
            if (!response['hydra:member'].length) {
                return null;
            }
            return plainToInstance(DynamicContent, response['hydra:member'][0]);
        }));
    }
    getFieldRenderer(name) {
        if (this.customFields[name]) {
            return of(this.customFields[name]);
        }
        return this.loadDynamicContent(name, 'field-renderer').pipe(concatMap((fieldRenderer) => {
            if (!fieldRenderer?.className) {
                return of(null);
            }
            const options = {
                remoteEntry: '/widget/' + fieldRenderer.name + '/remoteEntry.json',
                exposedModule: fieldRenderer.exposedModule || './Config',
                className: fieldRenderer.className
            };
            const component$ = from(loadRemoteModule(options)).pipe(catchError((error) => {
                console.error(error);
                return of(null);
            }), map((exposedModules) => {
                const widgetConfigType = exposedModules[options.className];
                this.customFields[fieldRenderer.name] = widgetConfigType;
                return widgetConfigType;
            }));
            return component$;
        }));
    }
    getValidators(field) {
        let validators = [];
        if (field.validation.minLength) {
            validators.push(Validators.minLength(field.validation.minLength));
        }
        if (field.validation.maxLength) {
            validators.push(Validators.maxLength(field.validation.maxLength));
        }
        if (field.validation.pattern) {
            validators.push(Validators.pattern(field.validation.pattern));
        }
        if (field.validation.custom) {
            validators.push(field.validation.custom);
        }
        if (field.validation.min) { // in case of integer field
            validators.push(Validators.min(field.validation.min));
        }
        if (field.validation.max) { // in case of integer field
            validators.push(Validators.max(field.validation.max));
        }
        if (field.formType == 'email') {
            validators.push(Validators.email);
        }
        if (field.validation.required) {
            validators.push(Validators.required);
        }
        return validators;
    }
    static { this.ɵfac = function FieldService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FieldService, factory: FieldService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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