import { Injectable } from '@angular/core';
import { cloneDeep, forEach, isArray, isString, isUndefined } from 'lodash-es';
import { forkJoin, of } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "./subscription-queue.service";
import * as i2 from "@angular/common/http";
import * as i3 from "../../utility/pipes/get-end-path-name.pipe";
import * as i4 from "../../form-fields/field-renderers/built-ins/picklist/picklist.service";
import * as i5 from "./model-metadata.service";
import * as i6 from "../../utility/pipes/interpolate.pipe";
import * as i7 from "./system-settings.service";
export class FilterCollectionService {
    constructor(subscriptionService, http, getEndPathNamePipe, picklistService, modelMetadatasService, interpolate, settingsService) {
        this.subscriptionService = subscriptionService;
        this.http = http;
        this.getEndPathNamePipe = getEndPathNamePipe;
        this.picklistService = picklistService;
        this.modelMetadatasService = modelMetadatasService;
        this.interpolate = interpolate;
        this.settingsService = settingsService;
    }
    load(type) {
        let KEY = `queries_${type}`;
        let _subscription = this.subscriptionService.get(KEY);
        if (isUndefined(_subscription)) {
            _subscription = this.http.get(`${API.API_3_BASE}queries?$limit=${ALL_RECORDS_SIZE}&$relationships=true&models__type=${type}`);
            this.subscriptionService.set(KEY, _subscription);
        }
        return _subscription.pipe(map((response) => {
            return response['hydra:member'];
        }));
    }
    saveUserQuery(query) {
        return this.save(query, 'user_queries');
    }
    saveSystemQuery(query) {
        return this.save(query, 'system_queries');
    }
    save(query, queryType) {
        if (isUndefined(queryType)) {
            queryType = query['@type'] === 'UserQuery' ? 'user_queries' : 'system_queries';
        }
        let queryToSave = cloneDeep(query);
        queryToSave.models = isArray(queryToSave.models) ? queryToSave.models[0] : null;
        let _subscription;
        if (query['@id']) {
            _subscription = this.http.put(`${API.API_3_BASE}${queryType}/${this.getEndPathNamePipe.transform(query['@id'])}?$relationships=true`, queryToSave);
        }
        else {
            _subscription = this.http.post(`${API.API_3_BASE}${queryType}?$relationships=true`, queryToSave);
        }
        return _subscription.pipe(map((response) => {
            return response.data;
        }));
    }
    deleteQuery(query) {
        let module = query['@type'] === 'UserQuery' ? 'user_queries' : 'system_queries';
        return this.http.delete(`${API.API_3_BASE}${module}/${this.getEndPathNamePipe.transform(query['@id'])}`);
    }
    loadQueryFilterValues(query) {
        let filters = query ? query.query.filters : [];
        let _subscriptions = [];
        forEach(filters, (filter) => {
            if (filter.value && filter.type) {
                if (filter.type === 'object' && isString(filter.value)) {
                    let _subscription = this._loadResource(filter.value).subscribe((data) => {
                        filter.value = data;
                    });
                    _subscriptions.push(_subscription);
                }
                else if (filter.type === 'array') {
                    forEach(filter.value, (item, index) => {
                        if (isString(item)) {
                            let _subscription = this._loadResource(item).subscribe((data) => {
                                filter.value[index] = data;
                            });
                            _subscriptions.push(_subscription);
                        }
                    });
                }
            }
        });
        if (_subscriptions.length) {
            return forkJoin(_subscriptions);
        }
        else {
            return of(filters);
        }
    }
    _loadResource(iri) {
        let _subscription = this.subscriptionService.get(iri);
        if (!_subscription) {
            if (iri.indexOf('picklist') >= 0) {
                _subscription = this.picklistService.getPicklistByIri(iri);
            }
            else {
                //_subscription = this.http.get(CommonUtils.getIriApiPath(iri)).get({})
                _subscription = this.http.get(iri);
            }
            this.subscriptionService.set(iri, _subscription);
        }
        return _subscription.pipe(map((data) => {
            let type = data['@type'];
            if (type !== 'Picklist') {
                var classMetaData = this.modelMetadatasService.getMetadataByModuleType(type);
                data.display = classMetaData ? this.interpolate.transform(classMetaData.displayName, data) : '';
            }
            return data;
        }));
    }
    static { this.ɵfac = function FilterCollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterCollectionService)(i0.ɵɵinject(i1.SubscriptionQueueService), i0.ɵɵinject(i2.HttpClient), i0.ɵɵinject(i3.GetEndPathNamePipe), i0.ɵɵinject(i4.PicklistService), i0.ɵɵinject(i5.ModelMetadataService), i0.ɵɵinject(i6.InterpolatePipe), i0.ɵɵinject(i7.SystemSettingsService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FilterCollectionService, factory: FilterCollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterCollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.SubscriptionQueueService }, { type: i2.HttpClient }, { type: i3.GetEndPathNamePipe }, { type: i4.PicklistService }, { type: i5.ModelMetadataService }, { type: i6.InterpolatePipe }, { type: i7.SystemSettingsService }], null); })();
//# sourceMappingURL=data:application/json;base64,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