/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "./theme.service";
export class HtmlEditorService {
    constructor(platformLocation, themeService) {
        this.platformLocation = platformLocation;
        this.themeService = themeService;
    }
    getDefaultConfig(toolbarSelector, theme) {
        return {
            debounce: true,
            inline: true,
            toolbar_mode: 'wrap',
            fixed_toolbar_container: toolbarSelector,
            browser_spellcheck: true,
            plugins: 'advlist lists code image link  media table fullscreen',
            height: 350,
            max_height: 600,
            menubar: false,
            toolbar: 'bold italic underline strikethrough superscript | blocks | removeformat | fontsize | forecolor backcolor | table bullist numlist | link image media | alignleft aligncenter alignright alignjustify | code fullscreen | dynamicValueButton',
            paste_data_images: true,
            extended_valid_elements: 'svg[*],defs[*],pattern[*],desc[*],metadata[*],g[*],mask[*],path[*],line[*],marker[*],rect[*],circle[*],ellipse[*],polygon[*],polyline[*],linearGradient[*],radialGradient[*],stop[*],image[*],view[*],text[*],textPath[*],title[*],tspan[*],glyph[*],symbol[*],switch[*],use[*]',
            autocompleteEnterKeyEvent: false,
            skin: false,
            base_url: `${this.platformLocation.getBaseHrefFromDOM()}tinymce/`,
        };
    }
    getBasicConfig(toolbarSelector, theme) {
        return {
            debounce: true,
            inline: true,
            toolbar_mode: 'wrap',
            fixed_toolbar_container: toolbarSelector,
            browser_spellcheck: true,
            allow_script_urls: true,
            plugins: 'advlist lists code fullscreen table',
            height: 350,
            max_height: 600,
            menubar: false,
            toolbar: 'bold italic underline strikethrough table code fullscreen',
            toolbar_items_size: 'small',
            paste_data_images: true,
            autocompleteEnterKeyEvent: false,
            skin: false,
            base_url: `${this.platformLocation.getBaseHrefFromDOM()}tinymce/`,
        };
    }
    static { this.ɵfac = function HtmlEditorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HtmlEditorService)(i0.ɵɵinject(i1.PlatformLocation), i0.ɵɵinject(i2.ThemeService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: HtmlEditorService, factory: HtmlEditorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HtmlEditorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.PlatformLocation }, { type: i2.ThemeService }], null); })();
//# sourceMappingURL=data:application/json;base64,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