import { Injectable } from '@angular/core';
import { map, of } from 'rxjs';
import { API, STORAGE_KEYS } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./storage.service";
export class LicenseService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
        this.license = null;
    }
    getLicenseDetails() {
        let licenseDetails = this.storageService.getItem(STORAGE_KEYS.LICENSE_DETAILS);
        if (licenseDetails) {
            return of(licenseDetails);
        }
        else {
            return this.setLicense();
        }
    }
    setLicense() {
        return this.http.get(API.AUTH + 'licenses/').pipe(map((response) => {
            this.storageService.setItem(STORAGE_KEYS.LICENSE_DETAILS, response['hydra:member'][0]);
            return response['hydra:member'][0];
        }));
    }
    getWorkflowMetrics() {
        return this.http.get(API.WORKFLOW + 'workflows/license/metrics/?format=json');
    }
    set licenseType(type) {
        this.license_type = type;
    }
    get licenseType() {
        return this.license_type;
    }
    static { this.ɵfac = function LicenseService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LicenseService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: LicenseService, factory: LicenseService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LicenseService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }], null); })();
//# sourceMappingURL=data:application/json;base64,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