/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { AlertModalComponent } from '../../components/modals/alert-modal/alert-modal.component';
import { ConfirmationModalComponent } from '../../components/modals/confirmation-modal/confirmation-modal.component';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
export class ModalService {
    constructor(ngbModalService) {
        this.ngbModalService = ngbModalService;
    }
    confirm(message, modalTitle, modalClass = 'default') {
        let modalRef = this.ngbModalService.open(ConfirmationModalComponent, {
            backdrop: 'static'
        });
        modalRef.componentInstance.message = message;
        if (modalTitle) {
            modalRef.componentInstance.modalTitle = modalTitle;
        }
        let response$ = new Subject();
        modalRef.result.then((response) => {
            if (response) {
                response$.next(response);
                response$.complete();
            }
            else {
                response$.error(false);
            }
        }, () => {
            response$.error(false);
        });
        return response$.asObservable();
    }
    alert(message, modalTitle) {
        let modalRef = this.ngbModalService.open(AlertModalComponent, {
            backdrop: 'static'
        });
        modalRef.componentInstance.message = message;
        if (modalTitle) {
            modalRef.componentInstance.modalTitle = modalTitle;
        }
        return modalRef.closed;
    }
    static { this.ɵfac = function ModalService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ModalService)(i0.ɵɵinject(i1.NgbModal)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ModalService, factory: ModalService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ModalService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.NgbModal }], null); })();
//# sourceMappingURL=data:application/json;base64,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