/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { catchError, map, of, throwError } from 'rxjs';
import { API } from '../constants';
import * as i0 from "@angular/core";
export class PendingDecisionService {
    constructor() {
        this.http = inject(HttpClient);
    }
    getPendingDecision(manaulInputId, owners, allowUnauthenticated = true, is_approval = false) {
        let unauthenticatedInputClause = '';
        if (!allowUnauthenticated) {
            unauthenticatedInputClause = '&unauthenticated_input=false';
        }
        let payload = {
            ...owners, ...{
                is_approval: is_approval
            }
        };
        return this.http.post(`${API.SEALAB}manual-wf-input/${manaulInputId}/retrieve_wfinput/?${unauthenticatedInputClause}`, payload).pipe(map((response) => {
            return response;
        }), catchError((error) => {
            if (error.status === 404) {
                return of({});
            }
            if (error.status === 403) {
                //     toaster.error({
                //       body: 'You do not have permission to resume a pending input. Contact your system administrator to add the \'Workflow-execute\' permission to your user role.'
                //     });
            }
            else if (error.status !== 401) {
                // toaster.error({
                //   body: 'Error in opening Pending Input dialog.'
                // });
            }
            return throwError(() => error);
        }));
    }
    resumeAwaitingPlaybook(payload, workflowId) {
        return this.http.post(`${API.SEALAB}workflows/${workflowId}/wfinput_resume/`, payload);
    }
    deleteManualInput(id) {
        return this.http.delete(`${API.WORKFLOW}manual-wf-input/${id}/`);
    }
    static { this.ɵfac = function PendingDecisionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PendingDecisionService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PendingDecisionService, factory: PendingDecisionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PendingDecisionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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