/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable, inject } from '@angular/core';
import { RoleService } from '../models/role-service';
import { API, FIXED_MODULE, STORAGE_KEYS } from '../constants';
import { HttpClient } from '@angular/common/http';
import { concatMap, map } from 'rxjs';
import { plainToInstance } from 'class-transformer';
import { RoleEntity } from '../models/role-entity';
import { RolePermission } from '../models/role-permission';
import { StorageService } from './storage.service';
import { keys } from 'lodash-es';
import * as i0 from "@angular/core";
export class PermissionService {
    constructor() {
        this.http = inject(HttpClient);
        this.storageService = inject(StorageService);
    }
    getPermission(entity) {
        let permissions = this.storageService.getItem(STORAGE_KEYS.CURRENT_PERMISSIONS);
        return permissions[entity] ? permissions[entity].map((permission) => permission.name) : [];
    }
    getPermissions(entities) {
        let entityMap = {};
        entities.forEach((entity) => {
            entityMap[entity] = this.getPermission(entity);
        });
        return entityMap;
    }
    getAllFlatPermissions() {
        let flatPermissions = [];
        let permissions = this.storageService.getItem(STORAGE_KEYS.CURRENT_PERMISSIONS);
        keys(permissions).forEach((entity) => {
            let permission = this.getPermission(entity);
            permission.forEach((permissionAction) => {
                flatPermissions.push(`${entity}.${permissionAction}`);
            });
        });
        return flatPermissions;
    }
    isAdmin() {
        return true;
    }
    availablePermission(entity, permission) {
        // TODO: implement
        return true;
    }
    availableFieldPermission(entity, fieldName, permission) {
        return true;
    }
    loadServices() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_SERVICES + '/', {
            params: {
                limit: 1000
            }
        }).pipe(map((response) => {
            return plainToInstance(RoleService, response['hydra:member']);
        }));
    }
    loadEntities() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_ENTITIES + '/', {
            params: {
                limit: 1000
            }
        }).pipe(map((response) => {
            return plainToInstance(RoleEntity, response['hydra:member']);
        }));
    }
    loadServicesAndEntities() {
        return this.loadServices().pipe(concatMap((services) => {
            return this.loadEntities().pipe(map((entities) => {
                services.forEach((service) => {
                    service.entities = entities.filter((entity) => entity.service === service.uuid && entity.visible);
                });
                return services;
            }));
        }));
    }
    loadPermissions() {
        return this.http.get(API.AUTH + FIXED_MODULE.ROLE_PERMISSIONS + '/').pipe(map((response) => {
            return plainToInstance(RolePermission, response['hydra:member']);
        }));
    }
    static { this.ɵfac = function PermissionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PermissionService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PermissionService, factory: PermissionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PermissionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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