/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { HttpParams } from '@angular/common/http';
import { Injectable } from '@angular/core';
import * as _ from 'lodash-es';
import { cloneDeep, forEach, isUndefined } from 'lodash-es';
import { Subject, map } from 'rxjs';
import { API, FIXED_MODULE, MAX_PLAYBOOK_RECORDS } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./permission.service";
import * as i3 from "./collection.service";
import * as i4 from "./export.service";
export class PlaybookService {
    constructor(http, permission, collectionService, exportService) {
        this.http = http;
        this.permission = permission;
        this.collectionService = collectionService;
        this.exportService = exportService;
    }
    getActionPlaybooks(entity, useConditions, rows) {
        let workflowsExecutePermission = this.permission.availablePermission(FIXED_MODULE.PLAYBOOK, 'update');
        let actionPBSub = new Subject();
        if (workflowsExecutePermission === true) {
            // if (service.loadedPlaybookActions.hasOwnProperty(entity.module)) {
            //   if (useConditions) {
            //     return filterPlaybooks(service.loadedPlaybookActions[entity.module], rows, entity);
            //   } else {
            //     defer.resolve(service.loadedPlaybookActions[entity.module].playbooks);
            //     return defer.promise;
            //   }
            // }
            this.collectionService.getCollectionNames().subscribe((collectionNames) => {
                let queryParams = new HttpParams({
                    fromObject: {
                        type: entity.module || entity.type,
                        isActive: true,
                        $relationships: true,
                        $triggerOnly: true,
                        $limit: MAX_PLAYBOOK_RECORDS
                    }
                });
                this.http.get(API.WORKFLOW_ACTION, { params: queryParams }).subscribe({
                    next: (response) => {
                        response['hydra:member'].forEach((playbook) => {
                            playbook.collectionName = collectionNames[playbook.collection];
                            if (!isUndefined(playbook.steps[0].arguments.title) && playbook.steps[0].arguments.title !== '') {
                                playbook.actionTriggerName = playbook.steps[0].arguments.title;
                            }
                            else {
                                playbook.actionTriggerName = playbook.name;
                            }
                        });
                        let playbookData = {
                            playbooks: response['hydra:member'],
                            selectedFields: this.loadFieldsFromPlaybookConditions(response['hydra:member'])
                        };
                        //service.loadedPlaybookActions[entity.module] = playbookData;
                        if (useConditions) {
                            this.filterPlaybooks(playbookData, rows, entity).subscribe();
                        }
                        else {
                            actionPBSub.next(response['hydra:member']);
                            actionPBSub.complete();
                        }
                    }, error: (error) => {
                        //statusCodeService(response);
                        actionPBSub.error(error);
                    }
                });
            });
        }
        else {
            actionPBSub.next([]);
        }
        return actionPBSub;
    }
    loadFieldsFromPlaybookConditions(playbooks) {
        var selectFields = ['uuid'];
        playbooks.forEach((playbook) => {
            var triggerstep = this.getTriggerStep(playbook);
            if (!isUndefined(triggerstep)) {
                var fieldsFromFilters = this.extractFieldsFromFilters(triggerstep.arguments.displayConditions);
                selectFields = selectFields.concat(fieldsFromFilters);
            }
        });
        return _.uniq(selectFields);
    }
    getTriggerStep(playbook) {
        return _.find(playbook.steps, (step) => {
            return step.uuid === playbook.triggerstep;
        });
    }
    extractFieldsFromFilters(filters) {
        let fields = [];
        forEach(filters, (filter) => {
            if (filter.filters) {
                fields = fields.concat(this.extractFieldsFromFilters(filter.filters));
                return;
            }
            let field = filter.field || filter._field;
            fields.push(field);
        });
        return _.uniq(fields);
    }
    filterPlaybooks(playbookData, rows = [], entity) {
        let playbooks = playbookData.playbooks;
        let filteredPlaybooks = [];
        let selectedFields = playbookData.selectedFields;
        return this.exportService.loadRowsForExport(rows, entity.type, selectedFields, true).pipe(map((response) => {
            let fullRows = response;
            let entityRows = [];
            //build entity
            fullRows.forEach((row) => {
                let rowEntity = cloneDeep(entity);
                //entityFieldsService.applyValues(rowEntity.fields, row);
                entityRows.push(rowEntity);
            });
            //   angular.forEach(playbooks, function (playbook) {
            //     var triggerstep = service.getTriggerStep(playbook);
            //     if (!angular.isUndefined(triggerstep)) {
            //       if (triggerstep.arguments.displayConditions && (entity.id || rows.length > 0) && !triggerstep.arguments.noRecordExecution) {
            //         playbook._hide = false;
            //         var displayConditions = new Query(triggerstep.arguments.displayConditions[entity.module]);
            //         if (rows.length > 0) {
            //           $q.all(promises).then(function () {
            //             angular.forEach(entityRows, function (rowEntity) {
            //               var result = rowEntity.evaluate(displayConditions);
            //               playbook._hide = playbook._hide || !result;
            //             });
            //           });
            //         } else {
            //           var result = entity.evaluate(displayConditions);
            //           playbook._hide = !result;
            //         }
            //       }
            //       if (((entity.id || rows.length > 0) && !triggerstep.arguments.noRecordExecution) || (!entity.id && rows.length === 0 && triggerstep.arguments.noRecordExecution)) {
            //         filteredPlaybooks.push(playbook);
            //       }
            //     }
            //   });
            return filteredPlaybooks;
        }));
    }
    static { this.ɵfac = function PlaybookService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PlaybookService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.PermissionService), i0.ɵɵinject(i3.CollectionService), i0.ɵɵinject(i4.ExportService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PlaybookService, factory: PlaybookService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PlaybookService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.PermissionService }, { type: i3.CollectionService }, { type: i4.ExportService }], null); })();
//# sourceMappingURL=data:application/json;base64,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