/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import { API, FIXED_MODULE, IGNORE_ERRORS, OPERATOR_MAPPINGS } from '../constants';
import { HttpContext } from '@angular/common/http';
import { Schedule } from '../models/schedule';
import { plainToInstance } from 'class-transformer';
import { map } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class ScheduleService {
    constructor(http) {
        this.http = http;
        // TODO: use schedule model instead of Observable<any>
        this.scheduleListApi = `${API.SCHEDULE}?format=json&task=workflow.tasks.periodic_task`;
    }
    // Schedule Detail
    create(schedule) {
        schedule.interval = null; //TODO : Do not hardcode
        schedule.task = 'workflow.tasks.periodic_task'; // TODO: is this a static value?
        return this.http.post(`${API.SCHEDULE}`, schedule);
    }
    update(schedule) {
        schedule.interval = null; //TODO : Do not hardcode
        schedule.task = schedule.task || 'workflow.tasks.periodic_task';
        return this.http.put(`${API.SCHEDULE}${schedule.id}/?format=json`, schedule);
    }
    getById(id) {
        let api = `${API.SCHEDULE}${id}/?format=json`;
        return this.http.get(api, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        }).pipe(map((result) => {
            return plainToInstance(Schedule, result);
        }));
    }
    getByTaskName(taskName) {
        let api = `${API.SCHEDULE}?format=json&task=${taskName}`;
        return this.http.get(api, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        }).pipe(map((result) => {
            return plainToInstance(Schedule, result['hydra:member'][0]);
        }));
    }
    getByName(name) {
        let api = `${API.WORKFLOW}${API.QUERY_PART}${FIXED_MODULE.SCHEDULES}/?format=json`;
        return this.http.post(api, {
            filters: [{
                    field: 'name',
                    operator: OPERATOR_MAPPINGS.startsWith,
                    value: name
                }]
        }, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        }).pipe(map((result) => {
            if (!result['hydra:member'].length) {
                throw new Error('Not found');
            }
            return plainToInstance(Schedule, result['hydra:member'][0]);
        }));
    }
    delete(id) {
        return this.http.delete(`${API.SCHEDULE}${id}/?format=json`);
    }
    trigger(id) {
        return this.http.post(`${API.SCHEDULE}trigger-now/`, { 'id': id });
    }
    static { this.ɵfac = function ScheduleService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ScheduleService, factory: ScheduleService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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