/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Injectable } from '@angular/core';
import { STORAGE_KEYS } from '../constants';
import * as i0 from "@angular/core";
export class StorageService {
    constructor() { }
    /**
     *
     * @param {string} key The key of Storage Entry
     * @param {any} value The value to store
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    setItem(key, value, persist) {
        let storageKey = this._getStorageKey(key, persist);
        localStorage.setItem(storageKey, JSON.stringify(value));
    }
    /**
     * Clean up all non-persisted storage entries post user session timeout.
     */
    clearAll() {
        for (let key in localStorage) {
            const length = STORAGE_KEYS.LOCAL_STORAGE_PREFIX.length;
            if (key.substring(0, length) == STORAGE_KEYS.LOCAL_STORAGE_PREFIX) {
                localStorage.removeItem(key);
            }
        }
    }
    /**
     * Retrive the storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {any} the value
     */
    getItem(key, persist) {
        let storageKey = this._getStorageKey(key, persist);
        let result = localStorage.getItem(storageKey);
        try {
            return result ? JSON.parse(result) : null;
        }
        catch (error) {
            return result;
        }
    }
    /**
     * Remove the specified storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    removeItem(key, persist) {
        let storageKey = this._getStorageKey(key, persist);
        localStorage.removeItem(storageKey);
    }
    /**
     * Build the key string of the storgae entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {string} key string
     */
    _getStorageKey(key, persist) {
        return persist ? STORAGE_KEYS.LOCAL_STORAGE_PERSIST_PREFIX + key : STORAGE_KEYS.LOCAL_STORAGE_PREFIX + key;
    }
    static { this.ɵfac = function StorageService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || StorageService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: StorageService, factory: StorageService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(StorageService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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