import { Injectable } from '@angular/core';
import { map, of } from 'rxjs';
import { API, FIXED_MODULE, STORAGE_KEYS } from '../constants';
import { extend } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./storage.service";
export class SystemSettingsService {
    constructor(http, storageService) {
        this.http = http;
        this.storageService = storageService;
    }
    getSSOStatus() {
        return this.http.get(`${API.PUBLIC}saml/login`);
    }
    get() {
        return this.storageService.getItem(STORAGE_KEYS.SYSTEM_SETTINGS);
    }
    load() {
        return this.http.get(`${API.API_APPMANAGER}${FIXED_MODULE.SYSTEM_SETTINGS}/`).pipe(map((result) => {
            this.storageService.setItem(STORAGE_KEYS.SYSTEM_SETTINGS, result['hydra:member'][0]);
            return result['hydra:member'][0];
        }));
    }
    save(systemSettings) {
        return this.http.put(`${API.API_APPMANAGER}${FIXED_MODULE.SYSTEM_SETTINGS}/${systemSettings.uuid}/`, systemSettings).pipe(map((result) => {
            this.storageService.setItem(STORAGE_KEYS.SYSTEM_SETTINGS, result);
            return result;
        }));
    }
    saveUserPreferences(settings) {
        let userPreferences = this.storageService.getItem(STORAGE_KEYS.USER_PREFERENCES, true) || {};
        userPreferences = extend(userPreferences, settings);
        this.storageService.setItem(STORAGE_KEYS.USER_PREFERENCES, userPreferences, false);
        return of(userPreferences);
    }
    getUserPreferences() {
        return this.storageService.getItem(STORAGE_KEYS.USER_PREFERENCES, false) || {};
    }
    getDateFormats() {
        return this.http.get('assets/settings/dateFormat.json').pipe(map((response) => {
            return {
                dateFormat: this.getDateFormat(response),
                dateTimeFormat: this.getdateTimeFormat(response)
            };
        }));
    }
    getdateTimeFormat(data) {
        let dateTimeFormatOptions = data
            .filter((date) => date.type === 'datetime')
            .map((date) => {
            date.label = date.value;
            delete date.type;
            return date;
        });
        return dateTimeFormatOptions;
    }
    getDateFormat(data) {
        let dateFormatOptions = data
            .filter((date) => date.type === 'date')
            .map((date) => {
            date.label = date.value;
            delete date.type;
            return date;
        });
        return dateFormatOptions;
    }
    static { this.ɵfac = function SystemSettingsService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || SystemSettingsService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: SystemSettingsService, factory: SystemSettingsService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(SystemSettingsService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }], null); })();
//# sourceMappingURL=data:application/json;base64,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