/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { DOCUMENT } from '@angular/common';
import { Inject, Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { THEMES } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "./system-settings.service";
export class ThemeService {
    constructor(systemSettingsService, document) {
        this.systemSettingsService = systemSettingsService;
        this.document = document;
        this.theme = THEMES.DEFAULT;
        this.themeChanged = new Subject();
    }
    getTheme() {
        let userPreferences = this.systemSettingsService.getUserPreferences();
        if (userPreferences.theme) {
            return userPreferences.theme;
        }
        let systemSettings = this.systemSettingsService.get();
        return systemSettings.preferences.theme || 'dark';
    }
    applyTheme(theme, customThemeLink = null) {
        const head = this.document.getElementsByTagName('head')[0];
        theme = theme ?? this.theme;
        this.theme = theme;
        const href = `${theme}.css`;
        this.themeChanged.next(this.theme);
        let themeLink = this.document.getElementById('client-theme');
        if (themeLink) {
            themeLink.href = href;
        }
        else {
            const style = this.document.createElement('link');
            style.id = 'client-theme';
            style.rel = 'stylesheet';
            style.href = href;
            head.appendChild(style);
        }
        if (customThemeLink) {
            this.applyCustomTheme(customThemeLink);
        }
    }
    applyCustomTheme(customThemeLink) {
        const head = this.document.getElementsByTagName('head')[0];
        let themeLink = this.document.getElementById('custom-theme');
        if (themeLink) {
            themeLink.href = customThemeLink;
        }
        else {
            const style = this.document.createElement('link');
            style.id = 'custom-theme';
            style.rel = 'stylesheet';
            style.href = customThemeLink;
            head.appendChild(style);
        }
    }
    static { this.ɵfac = function ThemeService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ThemeService)(i0.ɵɵinject(i1.SystemSettingsService), i0.ɵɵinject(DOCUMENT)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ThemeService, factory: ThemeService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ThemeService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.SystemSettingsService }, { type: Document, decorators: [{
                type: Inject,
                args: [DOCUMENT]
            }] }], null); })();
//# sourceMappingURL=data:application/json;base64,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