/* Copyright start
  Copyright (C) 2008 - 2025 Fortinet Inc.
  All rights reserved.
  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE
  Copyright end */
import { Component, EventEmitter, Input, Output, ViewChildren } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import _ from 'lodash-es';
import { forEach, isArray, isUndefined } from 'lodash-es';
import { ModuleAttributeMap } from '../../core/models/attribute-map';
import { ConnectorFieldRendererParameter } from '../../core/models/connector-field-renderer-parameter';
import { Field } from '../../core/models/field';
import { FormFieldComponent } from '../field-renderers/built-ins/form-field/form-field.component';
import { debounceTime } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "../field-renderers/built-ins/form-field/form-field.component";
const _c0 = a0 => ({ "margin-bottom-lg": a0 });
function FieldRendererComponent_div_0_div_1_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-field-renderer", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("parameters", actionField_r1.parameters)("fieldValues", ctx_r1.fieldValues)("enableRecordFields", ctx_r1.enableRecordFields)("ignoreRequired", ctx_r1.ignoreRequired)("enableJinja", ctx_r1.enableJinja)("connectorFormGroup", ctx_r1.connectorFormGroup);
} }
function FieldRendererComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "div")(2, "form", 4);
    i0.ɵɵelement(3, "xf-form-field", 5, 0);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, FieldRendererComponent_div_0_div_1_div_5_Template, 2, 6, "div", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c0, actionField_r1.field.formType === ctx_r1.checkbox));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("formGroup", ctx_r1.connectorFormGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", actionField_r1.field)("formControlName", actionField_r1.field.name)("fieldClass", "form-control-sm margin-bottom-8px w-100");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", actionField_r1.parameters.length > 0);
} }
function FieldRendererComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, FieldRendererComponent_div_0_div_1_Template, 6, 8, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", actionField_r1.visible);
} }
export class FieldRendererComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.fieldValues = {};
        this.parameters = [];
        //@Input() fieldForm: FormGroup = new FormGroup({});
        this.formMode = 'add';
        this.ignoreRequired = false;
        this.enableJinja = false;
        //@Input() focusMethod: any;
        //@Input() fieldModifyFunc: any;
        this.onFieldChange = new EventEmitter();
        this.actionFields = [];
        this.actionFieldsToRender = [];
        this.checkbox = Field.BuiltInType.SELECT;
        this.deletedParams = [];
        this.emitted = false;
        this.error = false;
        this.formControlNames = [];
    }
    ngOnChanges(changes) {
        if ((changes.parameters && !changes.parameters.firstChange) || (changes.fieldValues && !changes.fieldValues.firstChange)) {
            this.transformFields();
        }
    }
    ngOnInit() {
        this.connectorFormGroup = this.connectorFormGroup || new FormGroup({});
        this.transformFields();
    }
    ngOnDestroy() {
        this.removeExistingFormControls();
    }
    transformFields() {
        this.actionFields = plainToInstance(ConnectorFieldRendererParameter, this.parameters || []);
        this.actionFieldsToRender = [];
        this.removeExistingFormControls();
        this.changeDetectorRef.detectChanges();
        this.actionFields.forEach((actionField, index) => {
            let field = this.createField(actionField);
            let parameters = [];
            if (isUndefined(this.fieldValues[actionField.name]) && !isUndefined(actionField.value)) {
                this.fieldValues[actionField.name] = actionField.value;
            }
            this.fieldValues[actionField.name] = isUndefined(this.fieldValues[actionField.name]) ? (actionField.formType === Field.BuiltInType.CHECKBOX ? false : '') : this.fieldValues[actionField.name];
            if (Object.keys(actionField.onchange).length > 0) {
                let value = isUndefined(this.fieldValues[actionField.name]) ? actionField.value : this.fieldValues[actionField.name];
                if (actionField.formType === Field.BuiltInType.MULTISELECT && isArray(value)) {
                    value.forEach((selected) => {
                        if (actionField.onchange[selected]) {
                            parameters = parameters.concat(actionField.onchange[selected] || []);
                        }
                    });
                }
                else {
                    parameters = !isUndefined(value) && actionField.onchange[value] ? actionField.onchange[value] : [];
                }
            }
            let value = isUndefined(this.fieldValues[actionField.name]) ? (actionField.value || '') : this.fieldValues[actionField.name];
            let validators = actionField.required ? [Validators.required] : [];
            let formControl = new FormControl(value, validators);
            this.connectorFormGroup.addControl(actionField.name, formControl);
            this.formControlNames.push(actionField.name);
            this.parameters[index].value = value;
            this.connectorFormGroup.controls[actionField.name].valueChanges.pipe(debounceTime(300)).subscribe((value) => {
                this.parameters[index].value = value;
                this.setOnValuechanges(value, actionField, this.actionFieldsToRender[index]);
            });
            this.fetchOperationData(actionField);
            let obj = _.merge(actionField, { field: field, parameters: parameters });
            this.actionFieldsToRender.push(obj);
        });
    }
    //TODO: Need to implement for apiOperation
    fetchOperationData(field) {
        // if(field.apiOperation && (CommonUtils.isUndefined(field.processing) || field.processing === false)){
        //   field.processing = true;
        //   var argument = angular.copy(scope.connectorData);
        //   argument.targetField = field.name;
        //   argument.operation = field.apiOperation;
        //   argument.params = scope.params;
        //   scope.error = undefined;
        //   connectorService.getFieldData(argument).then(function(data) {
        //      if(data.id){
        //          websocketService.subscribe(data.id, function (result) {
        //            processOnApiChangeData(result, field);
        //            if (actionTimeout) {
        //              $timeout.cancel(actionTimeout);
        //            }
        //            actionSubscription = undefined;
        //            field.processing = false;
        //          }).then(function (sub) {
        //            actionSubscription = sub;
        //            setActionTimeout(field);
        //          }, function (error) {
        //              scope.error = error.data.message;
        //              field.processing = false;
        //          });
        //      }else{
        //        field.processing = false;
        //        processOnApiChangeData(data, field);
        //      }
        //     }, function (error) {
        //       field.processing = false;
        //       scope.error = error.data.message;
        //     });
        // }else{
        //   if(!CommonUtils.isUndefined(field.value) && field.value!==''){
        //    scope.onChange(field.value,field, true);
        //   }
        // }
        // if(scope.fieldModifyFunc){
        //   scope.fieldModifyFunc(field);
        // }
    }
    //TODO: Need to implment for apiOperation
    processOnApiChangeData(processeData, field) {
        // var dataTemplate = {};
        // if (field.apiOnchange) {
        //   dataTemplate = processeData.data;
        //   for (var key in dataTemplate) {
        //     if (key !== 'value') {
        //       field[key] = dataTemplate[key];
        //     }
        //   }
        // }
        // else {
        //   field.options = processeData.data;
        // }
        // if (!CommonUtils.isUndefined(field.value) && field.value !== '') {
        //   scope.onChange(field.value, field);
        // }
    }
    createField(action) {
        let field = new ModuleAttributeMap[action.formType].field(action.name);
        field.title = action.title;
        field.descriptions.singular = action.description;
        field.tooltip = action.tooltip;
        field.visible = action.visible;
        field.editable = action.editable;
        field.enableJinja = this.enableJinja;
        field.placeholder = action.placeholder;
        field.validation.required = this.ignoreRequired ? false : action.required;
        if (action.formType === Field.BuiltInType.SELECT || action.formType === Field.BuiltInType.MULTISELECT) {
            field.options = action.options;
        }
        if (action.formType === Field.BuiltInType.JSON) {
            field.modes = ['code', 'view'];
        }
        return field;
    }
    setOnValuechanges(value, actionField, renderField) {
        let parameters = [];
        if (Object.keys(actionField.onchange).length > 0) {
            this.deletedParams = [];
            this.deleteFieldParameters(renderField);
            if (actionField.formType === Field.BuiltInType.MULTISELECT && isArray(value)) {
                value.forEach((selected) => {
                    if (actionField.onchange[selected]) {
                        parameters = parameters.concat(actionField.onchange[selected] || []);
                    }
                });
            }
            else {
                parameters = actionField.onchange[value] || [];
            }
            renderField.parameters = parameters;
            this.changeDetectorRef.detectChanges();
        }
        this.fieldValues[actionField.name] = value;
        this.onFieldChange.emit(this.fieldValues);
    }
    deleteFieldParameters(field) {
        forEach(field.parameters, (param) => {
            if (param.onchange) {
                if (param.parameters) {
                    this.deleteFieldParameters(param);
                }
                else if (param.value) {
                    let tempField = {
                        parameters: param.onchange[param.value] || []
                    };
                    this.deleteFieldParameters(tempField);
                }
            }
            this.deletedParams.push(param.name);
            delete this.fieldValues[param.name];
        });
        return this.deletedParams;
    }
    removeExistingFormControls() {
        this.formControlNames.forEach((key) => {
            this.connectorFormGroup.removeControl(key, { emitEvent: false });
        });
        this.formControlNames = [];
    }
    focusOnFirstInvalidInput() {
        this.connectorFormGroup.markAllAsTouched();
        for (let formField of this.formFields) {
            if (!formField.valid) {
                formField.focus();
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function FieldRendererComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldRendererComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldRendererComponent, selectors: [["xf-field-renderer"]], viewQuery: function FieldRendererComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, inputs: { fieldValues: "fieldValues", parameters: "parameters", formMode: "formMode", ignoreRequired: "ignoreRequired", enableJinja: "enableJinja", enableRecordFields: "enableRecordFields", connectorFormGroup: "connectorFormGroup" }, outputs: { onFieldChange: "onFieldChange" }, features: [i0.ɵɵNgOnChangesFeature], decls: 1, vars: 1, consts: [["formField", ""], [4, "ngFor", "ngForOf"], ["class", "form-group margin-top-10px", 3, "ngClass", 4, "ngIf"], [1, "form-group", "margin-top-10px", 3, "ngClass"], [3, "formGroup"], [3, "field", "formControlName", "fieldClass"], [4, "ngIf"], [3, "parameters", "fieldValues", "enableRecordFields", "ignoreRequired", "enableJinja", "connectorFormGroup"]], template: function FieldRendererComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FieldRendererComponent_div_0_Template, 2, 1, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngForOf", ctx.actionFieldsToRender);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.FormFieldComponent, FieldRendererComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldRendererComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-renderer', template: "<!-- Copyright start\n  Copyright (C) 2008 - 2025 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n<div *ngFor=\"let actionField of actionFieldsToRender;\">\n  <div class=\"form-group margin-top-10px\" *ngIf=\"actionField.visible\"\n    [ngClass]=\"{'margin-bottom-lg': actionField.field.formType === checkbox}\">\n    <div>\n      <form [formGroup]=\"connectorFormGroup\">\n        <xf-form-field [field]=\"actionField.field\" #formField [formControlName]=\"actionField.field.name\"\n          [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\"></xf-form-field>\n      </form>\n      <!-- <span class='fa fa-refresh fa-spin margin-left-8px active-color' *ngIf=\"field.processing\"></span> -->\n    </div>\n    <div *ngIf=\"actionField.parameters.length > 0\">\n      <xf-field-renderer [parameters]=\"actionField.parameters\" [fieldValues]=\"fieldValues\"\n        [enableRecordFields]=\"enableRecordFields\" [ignoreRequired]=\"ignoreRequired\"\n        [enableJinja]=\"enableJinja\" [connectorFormGroup]=\"connectorFormGroup\"></xf-field-renderer>\n    </div>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }], { fieldValues: [{
            type: Input
        }], parameters: [{
            type: Input
        }], formMode: [{
            type: Input
        }], ignoreRequired: [{
            type: Input
        }], enableJinja: [{
            type: Input
        }], enableRecordFields: [{
            type: Input
        }], onFieldChange: [{
            type: Output
        }], formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }], connectorFormGroup: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldRendererComponent, { className: "FieldRendererComponent", filePath: "lib/form-fields/field-renderer/field-renderer.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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